/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Frustum;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Octree;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.math.collision.Ray;
import com.badlogic.gdx.utils.ObjectSet;
import org.junit.Assert;
import org.junit.Test;

public class OctreeTest {
    @Test
    public void testInsert() {
        int maxDepth = 2;
        int maxItemsPerNode = 1;
        Vector3 min = new Vector3(-5.0f, -5.0f, -5.0f);
        Vector3 max = new Vector3(5.0f, 5.0f, 5.0f);
        Octree<BoundingBox> octree = new Octree<BoundingBox>(min, max, maxDepth, maxItemsPerNode, new Octree.Collider<BoundingBox>(){
            final Vector3 tmp = new Vector3();

            @Override
            public boolean intersects(BoundingBox nodeBounds, BoundingBox geometry) {
                return nodeBounds.intersects(geometry);
            }

            @Override
            public boolean intersects(Frustum frustum, BoundingBox geometry) {
                return false;
            }

            @Override
            public float intersects(Ray ray, BoundingBox geometry) {
                if (!Intersector.intersectRayBounds(ray, geometry, this.tmp)) {
                    return this.tmp.dst2(ray.origin);
                }
                return Float.POSITIVE_INFINITY;
            }
        });
        Assert.assertTrue((boolean)octree.root.isLeaf());
        BoundingBox box1 = new BoundingBox(new Vector3(0.0f, 0.0f, 0.0f), new Vector3(1.0f, 1.0f, 1.0f));
        octree.add(box1);
        BoundingBox box2 = new BoundingBox(new Vector3(2.0f, 2.0f, 2.0f), new Vector3(3.0f, 3.0f, 3.0f));
        octree.add(box2);
        Assert.assertFalse((boolean)octree.root.isLeaf());
        ObjectSet<BoundingBox> result = new ObjectSet<BoundingBox>();
        octree.getAll(result);
        Assert.assertTrue((boolean)result.contains(box1));
        Assert.assertTrue((boolean)result.contains(box2));
        Assert.assertEquals((long)2L, (long)result.size);
        octree.remove(box2);
        result.clear();
        octree.getAll(result);
        Assert.assertEquals((long)1L, (long)result.size);
        Assert.assertTrue((boolean)result.contains(box1));
    }
}

