/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class JsonReader
implements BaseJsonReader {
    private static final byte[] _json_actions = JsonReader.init__json_actions_0();
    private static final short[] _json_key_offsets = JsonReader.init__json_key_offsets_0();
    private static final char[] _json_trans_keys = JsonReader.init__json_trans_keys_0();
    private static final byte[] _json_single_lengths = JsonReader.init__json_single_lengths_0();
    private static final byte[] _json_range_lengths = JsonReader.init__json_range_lengths_0();
    private static final short[] _json_index_offsets = JsonReader.init__json_index_offsets_0();
    private static final byte[] _json_indicies = JsonReader.init__json_indicies_0();
    private static final byte[] _json_trans_targs = JsonReader.init__json_trans_targs_0();
    private static final byte[] _json_trans_actions = JsonReader.init__json_trans_actions_0();
    private static final byte[] _json_eof_actions = JsonReader.init__json_eof_actions_0();
    static final int json_start = 1;
    static final int json_first_final = 35;
    static final int json_error = 0;
    static final int json_en_object = 5;
    static final int json_en_array = 23;
    static final int json_en_main = 1;
    private final Array<JsonValue> elements = new Array(8);
    private final Array<JsonValue> lastChild = new Array(8);
    private JsonValue root;
    private JsonValue current;

    public JsonValue parse(String json) {
        char[] data = json.toCharArray();
        return this.parse(data, 0, data.length);
    }

    public JsonValue parse(Reader reader) {
        char[] data = new char[1024];
        int offset = 0;
        try {
            try {
                int length;
                while ((length = reader.read(data, offset, data.length - offset)) != -1) {
                    if (length == 0) {
                        char[] newData = new char[data.length * 2];
                        System.arraycopy(data, 0, newData, 0, data.length);
                        data = newData;
                        continue;
                    }
                    offset += length;
                }
            }
            catch (IOException ex) {
                throw new SerializationException("Error reading input.", ex);
            }
        }
        finally {
            StreamUtils.closeQuietly(reader);
        }
        return this.parse(data, 0, offset);
    }

    @Override
    public JsonValue parse(InputStream input) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(input, "UTF-8");
        }
        catch (Exception ex) {
            throw new SerializationException("Error reading stream.", ex);
        }
        return this.parse(reader);
    }

    @Override
    public JsonValue parse(FileHandle file) {
        Reader reader;
        try {
            reader = file.reader("UTF-8");
        }
        catch (Exception ex) {
            throw new SerializationException("Error reading file: " + file, ex);
        }
        try {
            return this.parse(reader);
        }
        catch (Exception ex) {
            throw new SerializationException("Error parsing file: " + file, ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    public JsonValue parse(char[] data, int offset, int length) {
        block105: {
            p = offset;
            eof = pe = length;
            top = 0;
            stack = new int[4];
            s = 0;
            names = new Array<String>(8);
            needsUnescape = false;
            stringIsName = false;
            stringIsUnquoted = false;
            parseRuntimeEx = null;
            debug = false;
            if (debug) {
                System.out.println();
            }
            try {
                cs = 1;
                top = 0;
                _trans = 0;
                _goto_targ = 0;
                block52: while (true) {
                    switch (_goto_targ) {
                        case 0: {
                            if (p == pe) {
                                _goto_targ = 4;
                                continue block52;
                            }
                            if (cs == 0) {
                                _goto_targ = 5;
                                continue block52;
                            }
                        }
                        case 1: {
                            _keys = JsonReader._json_key_offsets[cs];
                            _trans = JsonReader._json_index_offsets[cs];
                            _klen = JsonReader._json_single_lengths[cs];
                            if (_klen <= 0) ** GOTO lbl47
                            _lower = _keys;
                            _upper = _keys + _klen - 1;
                            while (_upper >= _lower) {
                                _mid = _lower + (_upper - _lower >> 1);
                                if (data[p] < JsonReader._json_trans_keys[_mid]) {
                                    _upper = _mid - 1;
                                    continue;
                                }
                                if (data[p] > JsonReader._json_trans_keys[_mid]) {
                                    _lower = _mid + 1;
                                    continue;
                                }
                                _trans += _mid - _keys;
                                ** GOTO lbl61
                            }
                            _keys += _klen;
                            _trans += _klen;
lbl47:
                            // 2 sources

                            if ((_klen = JsonReader._json_range_lengths[cs]) > 0) {
                                _lower = _keys;
                                _upper = _keys + (_klen << 1) - 2;
                                while (_upper >= _lower) {
                                    _mid = _lower + (_upper - _lower >> 1 & -2);
                                    if (data[p] < JsonReader._json_trans_keys[_mid]) {
                                        _upper = _mid - 2;
                                        continue;
                                    }
                                    if (data[p] > JsonReader._json_trans_keys[_mid + 1]) {
                                        _lower = _mid + 2;
                                        continue;
                                    }
                                    _trans += _mid - _keys >> 1;
                                    ** GOTO lbl61
                                }
                                _trans += _klen;
                            }
lbl61:
                            // 5 sources

                            _trans = JsonReader._json_indicies[_trans];
                            cs = JsonReader._json_trans_targs[_trans];
                            if (JsonReader._json_trans_actions[_trans] == 0) ** GOTO lbl253
                            _acts = JsonReader._json_trans_actions[_trans];
                            _nacts = JsonReader._json_actions[_acts++];
                            block55: while (_nacts-- > 0) {
                                switch (JsonReader._json_actions[_acts++]) {
                                    case 0: {
                                        stringIsName = true;
                                        break;
                                    }
                                    case 1: {
                                        value = new String(data, s, p - s);
                                        if (needsUnescape) {
                                            value = this.unescape(value);
                                        }
                                        if (!stringIsName) ** GOTO lbl81
                                        stringIsName = false;
                                        if (debug) {
                                            System.out.println("name: " + value);
                                        }
                                        names.add(value);
                                        ** GOTO lbl132
lbl81:
                                        // 1 sources

                                        v0 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (!stringIsUnquoted) ** GOTO lbl129
                                        if (!value.equals("true")) ** GOTO lbl88
                                        if (debug) {
                                            System.out.println("boolean: " + name + "=true");
                                        }
                                        this.bool(name, true);
                                        ** GOTO lbl132
lbl88:
                                        // 1 sources

                                        if (!value.equals("false")) ** GOTO lbl93
                                        if (debug) {
                                            System.out.println("boolean: " + name + "=false");
                                        }
                                        this.bool(name, false);
                                        ** GOTO lbl132
lbl93:
                                        // 1 sources

                                        if (!value.equals("null")) ** GOTO lbl96
                                        this.string(name, null);
                                        ** GOTO lbl132
lbl96:
                                        // 1 sources

                                        couldBeDouble = false;
                                        couldBeLong = true;
                                        i = s;
                                        block56: while (i < p) {
                                            switch (data[i]) {
                                                case '+': 
                                                case '-': 
                                                case '0': 
                                                case '1': 
                                                case '2': 
                                                case '3': 
                                                case '4': 
                                                case '5': 
                                                case '6': 
                                                case '7': 
                                                case '8': 
                                                case '9': {
                                                    break;
                                                }
                                                case '.': 
                                                case 'E': 
                                                case 'e': {
                                                    couldBeDouble = true;
                                                    couldBeLong = false;
                                                    break;
                                                }
                                                default: {
                                                    couldBeDouble = false;
                                                    couldBeLong = false;
                                                    break block56;
                                                }
                                            }
                                            ++i;
                                        }
                                        if (!couldBeDouble) ** GOTO lbl121
                                        try {
                                            if (debug) {
                                                System.out.println("double: " + name + "=" + Double.parseDouble(value));
                                            }
                                            this.number(name, Double.parseDouble(value), value);
                                            ** GOTO lbl132
                                        }
                                        catch (NumberFormatException i) {
                                            ** GOTO lbl129
                                        }
lbl121:
                                        // 1 sources

                                        if (!couldBeLong) ** GOTO lbl129
                                        if (debug) {
                                            System.out.println("double: " + name + "=" + Double.parseDouble(value));
                                        }
                                        try {
                                            this.number(name, Long.parseLong(value), value);
                                            ** GOTO lbl132
                                        }
                                        catch (NumberFormatException i) {
                                            // empty catch block
                                        }
lbl129:
                                        // 4 sources

                                        if (debug) {
                                            System.out.println("string: " + name + "=" + value);
                                        }
                                        this.string(name, value);
lbl132:
                                        // 7 sources

                                        stringIsUnquoted = false;
                                        s = p;
                                        break;
                                    }
                                    case 2: {
                                        v1 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("startObject: " + name);
                                        }
                                        this.startObject(name);
                                        if (top == stack.length) {
                                            newStack = new int[stack.length * 2];
                                            System.arraycopy(stack, 0, newStack, 0, stack.length);
                                            stack = newStack;
                                        }
                                        stack[top++] = cs;
                                        cs = 5;
                                        _goto_targ = 2;
                                        continue block52;
                                    }
                                    case 3: {
                                        if (debug) {
                                            System.out.println("endObject");
                                        }
                                        this.pop();
                                        cs = stack[--top];
                                        _goto_targ = 2;
                                        continue block52;
                                    }
                                    case 4: {
                                        v2 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("startArray: " + name);
                                        }
                                        this.startArray(name);
                                        if (top == stack.length) {
                                            newStack = new int[stack.length * 2];
                                            System.arraycopy(stack, 0, newStack, 0, stack.length);
                                            stack = newStack;
                                        }
                                        stack[top++] = cs;
                                        cs = 23;
                                        _goto_targ = 2;
                                        continue block52;
                                    }
                                    case 5: {
                                        if (debug) {
                                            System.out.println("endArray");
                                        }
                                        this.pop();
                                        cs = stack[--top];
                                        _goto_targ = 2;
                                        continue block52;
                                    }
                                    case 6: {
                                        start = p - 1;
                                        if (data[p++] != '/') ** GOTO lbl184
                                        while (p != eof && data[p] != '\n') {
                                            ++p;
                                        }
                                        --p;
                                        ** GOTO lbl186
lbl-1000:
                                        // 1 sources

                                        {
                                            ++p;
lbl184:
                                            // 2 sources

                                            ** while (p + 1 < eof && data[p] != '*' || data[p + 1] != '/')
                                        }
lbl185:
                                        // 1 sources

                                        ++p;
lbl186:
                                        // 2 sources

                                        if (!debug) break;
                                        System.out.println("comment " + new String(data, start, p - start));
                                        break;
                                    }
                                    case 7: {
                                        if (debug) {
                                            System.out.println("unquotedChars");
                                        }
                                        s = p;
                                        needsUnescape = false;
                                        stringIsUnquoted = true;
                                        if (!stringIsName) ** GOTO lbl216
                                        block59: while (true) {
                                            switch (data[p]) {
                                                case '\\': {
                                                    needsUnescape = true;
                                                    ** GOTO lbl210
                                                }
                                                case '/': {
                                                    if (p + 1 == eof) ** GOTO lbl210
                                                    c = data[p + 1];
                                                    if (c == '/') ** GOTO lbl231
                                                    if (c == '*') {
                                                        break block59;
                                                    }
                                                    ** GOTO lbl210
                                                }
                                                case '\n': 
                                                case '\r': 
                                                case ':': {
                                                    break block59;
                                                }
lbl210:
                                                // 4 sources

                                                default: {
                                                    if (!debug) continue block59;
                                                    System.out.println("unquotedChar (name): '" + data[p] + "'");
                                                    if (++p != eof) continue block59;
                                                    break block59;
                                                }
                                            }
                                            break;
                                        }
                                        ** GOTO lbl231
lbl216:
                                        // 1 sources

                                        block60: while (true) {
                                            switch (data[p]) {
                                                case '\\': {
                                                    needsUnescape = true;
                                                    ** GOTO lbl227
                                                }
                                                case '/': {
                                                    if (p + 1 != eof && ((c = data[p + 1]) == '/' || c == '*')) {
                                                        break block60;
                                                    }
                                                    ** GOTO lbl227
                                                }
                                                case '\n': 
                                                case '\r': 
                                                case ',': 
                                                case ']': 
                                                case '}': {
                                                    break block60;
                                                }
lbl227:
                                                // 3 sources

                                                default: {
                                                    if (!debug) continue block60;
                                                    System.out.println("unquotedChar (value): '" + data[p] + "'");
                                                    if (++p != eof) continue block60;
                                                }
                                            }
                                            break;
                                        }
lbl231:
                                        // 5 sources

                                        --p;
                                        while (Character.isSpace(data[p])) {
                                            --p;
                                        }
                                        continue block55;
                                    }
                                    case 8: {
                                        if (debug) {
                                            System.out.println("quotedChars");
                                        }
                                        s = ++p;
                                        needsUnescape = false;
                                        block62: while (true) {
                                            switch (data[p]) {
                                                case '\\': {
                                                    needsUnescape = true;
                                                    ++p;
                                                    ** GOTO lbl249
                                                }
                                                case '\"': {
                                                    break block62;
                                                }
lbl249:
                                                // 2 sources

                                                default: {
                                                    if (++p != eof) continue block62;
                                                }
                                            }
                                            break;
                                        }
                                        --p;
                                    }
                                }
                            }
                        }
lbl253:
                        // 3 sources

                        case 2: {
                            if (cs == 0) {
                                _goto_targ = 5;
                                continue block52;
                            }
                            if (++p != pe) {
                                _goto_targ = 1;
                                continue block52;
                            }
                        }
                        case 4: {
                            if (p != eof) break block105;
                            __acts = JsonReader._json_eof_actions[cs];
                            __nacts = JsonReader._json_actions[__acts++];
                            while (__nacts-- > 0) {
                                switch (JsonReader._json_actions[__acts++]) {
                                    case 1: {
                                        value = new String(data, s, p - s);
                                        if (needsUnescape) {
                                            value = this.unescape(value);
                                        }
                                        if (!stringIsName) ** GOTO lbl276
                                        stringIsName = false;
                                        if (debug) {
                                            System.out.println("name: " + value);
                                        }
                                        names.add(value);
                                        ** GOTO lbl327
lbl276:
                                        // 1 sources

                                        v3 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (!stringIsUnquoted) ** GOTO lbl324
                                        if (!value.equals("true")) ** GOTO lbl283
                                        if (debug) {
                                            System.out.println("boolean: " + name + "=true");
                                        }
                                        this.bool(name, true);
                                        ** GOTO lbl327
lbl283:
                                        // 1 sources

                                        if (!value.equals("false")) ** GOTO lbl288
                                        if (debug) {
                                            System.out.println("boolean: " + name + "=false");
                                        }
                                        this.bool(name, false);
                                        ** GOTO lbl327
lbl288:
                                        // 1 sources

                                        if (!value.equals("null")) ** GOTO lbl291
                                        this.string(name, null);
                                        ** GOTO lbl327
lbl291:
                                        // 1 sources

                                        couldBeDouble = false;
                                        couldBeLong = true;
                                        i = s;
                                        block64: while (i < p) {
                                            switch (data[i]) {
                                                case '+': 
                                                case '-': 
                                                case '0': 
                                                case '1': 
                                                case '2': 
                                                case '3': 
                                                case '4': 
                                                case '5': 
                                                case '6': 
                                                case '7': 
                                                case '8': 
                                                case '9': {
                                                    break;
                                                }
                                                case '.': 
                                                case 'E': 
                                                case 'e': {
                                                    couldBeDouble = true;
                                                    couldBeLong = false;
                                                    break;
                                                }
                                                default: {
                                                    couldBeDouble = false;
                                                    couldBeLong = false;
                                                    break block64;
                                                }
                                            }
                                            ++i;
                                        }
                                        if (!couldBeDouble) ** GOTO lbl316
                                        try {
                                            if (debug) {
                                                System.out.println("double: " + name + "=" + Double.parseDouble(value));
                                            }
                                            this.number(name, Double.parseDouble(value), value);
                                            ** GOTO lbl327
                                        }
                                        catch (NumberFormatException var29_52) {
                                            ** GOTO lbl324
                                        }
lbl316:
                                        // 1 sources

                                        if (!couldBeLong) ** GOTO lbl324
                                        if (debug) {
                                            System.out.println("double: " + name + "=" + Double.parseDouble(value));
                                        }
                                        try {
                                            this.number(name, Long.parseLong(value), value);
                                            ** GOTO lbl327
                                        }
                                        catch (NumberFormatException var29_53) {
                                            // empty catch block
                                        }
lbl324:
                                        // 4 sources

                                        if (debug) {
                                            System.out.println("string: " + name + "=" + value);
                                        }
                                        this.string(name, value);
lbl327:
                                        // 7 sources

                                        stringIsUnquoted = false;
                                        s = p;
                                    }
                                }
                            }
                            break block52;
                        }
                    }
                    break;
                }
            }
            catch (RuntimeException ex) {
                parseRuntimeEx = ex;
            }
        }
        root = this.root;
        this.root = null;
        this.current = null;
        this.lastChild.clear();
        if (p < pe) {
            lineNumber = 1;
            i = 0;
            while (i < p) {
                if (data[i] == '\n') {
                    ++lineNumber;
                }
                ++i;
            }
            start = Math.max(0, p - 32);
            throw new SerializationException("Error parsing JSON on line " + lineNumber + " near: " + new String(data, start, p - start) + "*ERROR*" + new String(data, p, Math.min(64, pe - p)), parseRuntimeEx);
        }
        if (this.elements.size != 0) {
            element = this.elements.peek();
            this.elements.clear();
            if (element != null && element.isObject()) {
                throw new SerializationException("Error parsing JSON, unmatched brace.");
            }
            throw new SerializationException("Error parsing JSON, unmatched bracket.");
        }
        if (parseRuntimeEx != null) {
            throw new SerializationException("Error parsing JSON: " + new String(data), parseRuntimeEx);
        }
        return root;
    }

    private static byte[] init__json_actions_0() {
        byte[] byArray = new byte[29];
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 2;
        byArray[5] = 1;
        byArray[6] = 3;
        byArray[7] = 1;
        byArray[8] = 4;
        byArray[9] = 1;
        byArray[10] = 5;
        byArray[11] = 1;
        byArray[12] = 6;
        byArray[13] = 1;
        byArray[14] = 7;
        byArray[15] = 1;
        byArray[16] = 8;
        byArray[17] = 2;
        byArray[19] = 7;
        byArray[20] = 2;
        byArray[22] = 8;
        byArray[23] = 2;
        byArray[24] = 1;
        byArray[25] = 3;
        byArray[26] = 2;
        byArray[27] = 1;
        byArray[28] = 5;
        return byArray;
    }

    private static short[] init__json_key_offsets_0() {
        short[] sArray = new short[39];
        sArray[2] = 11;
        sArray[3] = 13;
        sArray[4] = 14;
        sArray[5] = 16;
        sArray[6] = 25;
        sArray[7] = 31;
        sArray[8] = 37;
        sArray[9] = 39;
        sArray[10] = 50;
        sArray[11] = 57;
        sArray[12] = 64;
        sArray[13] = 73;
        sArray[14] = 74;
        sArray[15] = 83;
        sArray[16] = 85;
        sArray[17] = 87;
        sArray[18] = 96;
        sArray[19] = 98;
        sArray[20] = 100;
        sArray[21] = 101;
        sArray[22] = 103;
        sArray[23] = 105;
        sArray[24] = 116;
        sArray[25] = 123;
        sArray[26] = 130;
        sArray[27] = 141;
        sArray[28] = 142;
        sArray[29] = 153;
        sArray[30] = 155;
        sArray[31] = 157;
        sArray[32] = 168;
        sArray[33] = 170;
        sArray[34] = 172;
        sArray[35] = 174;
        sArray[36] = 179;
        sArray[37] = 184;
        sArray[38] = 184;
        return sArray;
    }

    private static char[] init__json_trans_keys_0() {
        char[] cArray = new char[185];
        cArray[0] = 13;
        cArray[1] = 32;
        cArray[2] = 34;
        cArray[3] = 44;
        cArray[4] = 47;
        cArray[5] = 58;
        cArray[6] = 91;
        cArray[7] = 93;
        cArray[8] = 123;
        cArray[9] = 9;
        cArray[10] = 10;
        cArray[11] = 42;
        cArray[12] = 47;
        cArray[13] = 34;
        cArray[14] = 42;
        cArray[15] = 47;
        cArray[16] = 13;
        cArray[17] = 32;
        cArray[18] = 34;
        cArray[19] = 44;
        cArray[20] = 47;
        cArray[21] = 58;
        cArray[22] = 125;
        cArray[23] = 9;
        cArray[24] = 10;
        cArray[25] = 13;
        cArray[26] = 32;
        cArray[27] = 47;
        cArray[28] = 58;
        cArray[29] = 9;
        cArray[30] = 10;
        cArray[31] = 13;
        cArray[32] = 32;
        cArray[33] = 47;
        cArray[34] = 58;
        cArray[35] = 9;
        cArray[36] = 10;
        cArray[37] = 42;
        cArray[38] = 47;
        cArray[39] = 13;
        cArray[40] = 32;
        cArray[41] = 34;
        cArray[42] = 44;
        cArray[43] = 47;
        cArray[44] = 58;
        cArray[45] = 91;
        cArray[46] = 93;
        cArray[47] = 123;
        cArray[48] = 9;
        cArray[49] = 10;
        cArray[50] = 9;
        cArray[51] = 10;
        cArray[52] = 13;
        cArray[53] = 32;
        cArray[54] = 44;
        cArray[55] = 47;
        cArray[56] = 125;
        cArray[57] = 9;
        cArray[58] = 10;
        cArray[59] = 13;
        cArray[60] = 32;
        cArray[61] = 44;
        cArray[62] = 47;
        cArray[63] = 125;
        cArray[64] = 13;
        cArray[65] = 32;
        cArray[66] = 34;
        cArray[67] = 44;
        cArray[68] = 47;
        cArray[69] = 58;
        cArray[70] = 125;
        cArray[71] = 9;
        cArray[72] = 10;
        cArray[73] = 34;
        cArray[74] = 13;
        cArray[75] = 32;
        cArray[76] = 34;
        cArray[77] = 44;
        cArray[78] = 47;
        cArray[79] = 58;
        cArray[80] = 125;
        cArray[81] = 9;
        cArray[82] = 10;
        cArray[83] = 42;
        cArray[84] = 47;
        cArray[85] = 42;
        cArray[86] = 47;
        cArray[87] = 13;
        cArray[88] = 32;
        cArray[89] = 34;
        cArray[90] = 44;
        cArray[91] = 47;
        cArray[92] = 58;
        cArray[93] = 125;
        cArray[94] = 9;
        cArray[95] = 10;
        cArray[96] = 42;
        cArray[97] = 47;
        cArray[98] = 42;
        cArray[99] = 47;
        cArray[100] = 34;
        cArray[101] = 42;
        cArray[102] = 47;
        cArray[103] = 42;
        cArray[104] = 47;
        cArray[105] = 13;
        cArray[106] = 32;
        cArray[107] = 34;
        cArray[108] = 44;
        cArray[109] = 47;
        cArray[110] = 58;
        cArray[111] = 91;
        cArray[112] = 93;
        cArray[113] = 123;
        cArray[114] = 9;
        cArray[115] = 10;
        cArray[116] = 9;
        cArray[117] = 10;
        cArray[118] = 13;
        cArray[119] = 32;
        cArray[120] = 44;
        cArray[121] = 47;
        cArray[122] = 93;
        cArray[123] = 9;
        cArray[124] = 10;
        cArray[125] = 13;
        cArray[126] = 32;
        cArray[127] = 44;
        cArray[128] = 47;
        cArray[129] = 93;
        cArray[130] = 13;
        cArray[131] = 32;
        cArray[132] = 34;
        cArray[133] = 44;
        cArray[134] = 47;
        cArray[135] = 58;
        cArray[136] = 91;
        cArray[137] = 93;
        cArray[138] = 123;
        cArray[139] = 9;
        cArray[140] = 10;
        cArray[141] = 34;
        cArray[142] = 13;
        cArray[143] = 32;
        cArray[144] = 34;
        cArray[145] = 44;
        cArray[146] = 47;
        cArray[147] = 58;
        cArray[148] = 91;
        cArray[149] = 93;
        cArray[150] = 123;
        cArray[151] = 9;
        cArray[152] = 10;
        cArray[153] = 42;
        cArray[154] = 47;
        cArray[155] = 42;
        cArray[156] = 47;
        cArray[157] = 13;
        cArray[158] = 32;
        cArray[159] = 34;
        cArray[160] = 44;
        cArray[161] = 47;
        cArray[162] = 58;
        cArray[163] = 91;
        cArray[164] = 93;
        cArray[165] = 123;
        cArray[166] = 9;
        cArray[167] = 10;
        cArray[168] = 42;
        cArray[169] = 47;
        cArray[170] = 42;
        cArray[171] = 47;
        cArray[172] = 42;
        cArray[173] = 47;
        cArray[174] = 13;
        cArray[175] = 32;
        cArray[176] = 47;
        cArray[177] = 9;
        cArray[178] = 10;
        cArray[179] = 13;
        cArray[180] = 32;
        cArray[181] = 47;
        cArray[182] = 9;
        cArray[183] = 10;
        return cArray;
    }

    private static byte[] init__json_single_lengths_0() {
        byte[] byArray = new byte[39];
        byArray[1] = 9;
        byArray[2] = 2;
        byArray[3] = 1;
        byArray[4] = 2;
        byArray[5] = 7;
        byArray[6] = 4;
        byArray[7] = 4;
        byArray[8] = 2;
        byArray[9] = 9;
        byArray[10] = 7;
        byArray[11] = 7;
        byArray[12] = 7;
        byArray[13] = 1;
        byArray[14] = 7;
        byArray[15] = 2;
        byArray[16] = 2;
        byArray[17] = 7;
        byArray[18] = 2;
        byArray[19] = 2;
        byArray[20] = 1;
        byArray[21] = 2;
        byArray[22] = 2;
        byArray[23] = 9;
        byArray[24] = 7;
        byArray[25] = 7;
        byArray[26] = 9;
        byArray[27] = 1;
        byArray[28] = 9;
        byArray[29] = 2;
        byArray[30] = 2;
        byArray[31] = 9;
        byArray[32] = 2;
        byArray[33] = 2;
        byArray[34] = 2;
        byArray[35] = 3;
        byArray[36] = 3;
        return byArray;
    }

    private static byte[] init__json_range_lengths_0() {
        byte[] byArray = new byte[39];
        byArray[1] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        byArray[7] = 1;
        byArray[9] = 1;
        byArray[12] = 1;
        byArray[14] = 1;
        byArray[17] = 1;
        byArray[23] = 1;
        byArray[26] = 1;
        byArray[28] = 1;
        byArray[31] = 1;
        byArray[35] = 1;
        byArray[36] = 1;
        return byArray;
    }

    private static short[] init__json_index_offsets_0() {
        short[] sArray = new short[39];
        sArray[2] = 11;
        sArray[3] = 14;
        sArray[4] = 16;
        sArray[5] = 19;
        sArray[6] = 28;
        sArray[7] = 34;
        sArray[8] = 40;
        sArray[9] = 43;
        sArray[10] = 54;
        sArray[11] = 62;
        sArray[12] = 70;
        sArray[13] = 79;
        sArray[14] = 81;
        sArray[15] = 90;
        sArray[16] = 93;
        sArray[17] = 96;
        sArray[18] = 105;
        sArray[19] = 108;
        sArray[20] = 111;
        sArray[21] = 113;
        sArray[22] = 116;
        sArray[23] = 119;
        sArray[24] = 130;
        sArray[25] = 138;
        sArray[26] = 146;
        sArray[27] = 157;
        sArray[28] = 159;
        sArray[29] = 170;
        sArray[30] = 173;
        sArray[31] = 176;
        sArray[32] = 187;
        sArray[33] = 190;
        sArray[34] = 193;
        sArray[35] = 196;
        sArray[36] = 201;
        sArray[37] = 206;
        sArray[38] = 207;
        return sArray;
    }

    private static byte[] init__json_indicies_0() {
        byte[] byArray = new byte[209];
        byArray[0] = 1;
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 3;
        byArray[6] = 5;
        byArray[7] = 3;
        byArray[8] = 6;
        byArray[9] = 1;
        byArray[11] = 7;
        byArray[12] = 7;
        byArray[13] = 3;
        byArray[14] = 8;
        byArray[15] = 3;
        byArray[16] = 9;
        byArray[17] = 9;
        byArray[18] = 3;
        byArray[19] = 11;
        byArray[20] = 11;
        byArray[21] = 12;
        byArray[22] = 13;
        byArray[23] = 14;
        byArray[24] = 3;
        byArray[25] = 15;
        byArray[26] = 11;
        byArray[27] = 10;
        byArray[28] = 16;
        byArray[29] = 16;
        byArray[30] = 17;
        byArray[31] = 18;
        byArray[32] = 16;
        byArray[33] = 3;
        byArray[34] = 19;
        byArray[35] = 19;
        byArray[36] = 20;
        byArray[37] = 21;
        byArray[38] = 19;
        byArray[39] = 3;
        byArray[40] = 22;
        byArray[41] = 22;
        byArray[42] = 3;
        byArray[43] = 21;
        byArray[44] = 21;
        byArray[45] = 24;
        byArray[46] = 3;
        byArray[47] = 25;
        byArray[48] = 3;
        byArray[49] = 26;
        byArray[50] = 3;
        byArray[51] = 27;
        byArray[52] = 21;
        byArray[53] = 23;
        byArray[54] = 28;
        byArray[55] = 29;
        byArray[56] = 29;
        byArray[57] = 28;
        byArray[58] = 30;
        byArray[59] = 31;
        byArray[60] = 32;
        byArray[61] = 3;
        byArray[62] = 33;
        byArray[63] = 34;
        byArray[64] = 34;
        byArray[65] = 33;
        byArray[66] = 13;
        byArray[67] = 35;
        byArray[68] = 15;
        byArray[69] = 3;
        byArray[70] = 34;
        byArray[71] = 34;
        byArray[72] = 12;
        byArray[73] = 36;
        byArray[74] = 37;
        byArray[75] = 3;
        byArray[76] = 15;
        byArray[77] = 34;
        byArray[78] = 10;
        byArray[79] = 16;
        byArray[80] = 3;
        byArray[81] = 36;
        byArray[82] = 36;
        byArray[83] = 12;
        byArray[84] = 3;
        byArray[85] = 38;
        byArray[86] = 3;
        byArray[87] = 3;
        byArray[88] = 36;
        byArray[89] = 10;
        byArray[90] = 39;
        byArray[91] = 39;
        byArray[92] = 3;
        byArray[93] = 40;
        byArray[94] = 40;
        byArray[95] = 3;
        byArray[96] = 13;
        byArray[97] = 13;
        byArray[98] = 12;
        byArray[99] = 3;
        byArray[100] = 41;
        byArray[101] = 3;
        byArray[102] = 15;
        byArray[103] = 13;
        byArray[104] = 10;
        byArray[105] = 42;
        byArray[106] = 42;
        byArray[107] = 3;
        byArray[108] = 43;
        byArray[109] = 43;
        byArray[110] = 3;
        byArray[111] = 28;
        byArray[112] = 3;
        byArray[113] = 44;
        byArray[114] = 44;
        byArray[115] = 3;
        byArray[116] = 45;
        byArray[117] = 45;
        byArray[118] = 3;
        byArray[119] = 47;
        byArray[120] = 47;
        byArray[121] = 48;
        byArray[122] = 49;
        byArray[123] = 50;
        byArray[124] = 3;
        byArray[125] = 51;
        byArray[126] = 52;
        byArray[127] = 53;
        byArray[128] = 47;
        byArray[129] = 46;
        byArray[130] = 54;
        byArray[131] = 55;
        byArray[132] = 55;
        byArray[133] = 54;
        byArray[134] = 56;
        byArray[135] = 57;
        byArray[136] = 58;
        byArray[137] = 3;
        byArray[138] = 59;
        byArray[139] = 60;
        byArray[140] = 60;
        byArray[141] = 59;
        byArray[142] = 49;
        byArray[143] = 61;
        byArray[144] = 52;
        byArray[145] = 3;
        byArray[146] = 60;
        byArray[147] = 60;
        byArray[148] = 48;
        byArray[149] = 62;
        byArray[150] = 63;
        byArray[151] = 3;
        byArray[152] = 51;
        byArray[153] = 52;
        byArray[154] = 53;
        byArray[155] = 60;
        byArray[156] = 46;
        byArray[157] = 54;
        byArray[158] = 3;
        byArray[159] = 62;
        byArray[160] = 62;
        byArray[161] = 48;
        byArray[162] = 3;
        byArray[163] = 64;
        byArray[164] = 3;
        byArray[165] = 51;
        byArray[166] = 3;
        byArray[167] = 53;
        byArray[168] = 62;
        byArray[169] = 46;
        byArray[170] = 65;
        byArray[171] = 65;
        byArray[172] = 3;
        byArray[173] = 66;
        byArray[174] = 66;
        byArray[175] = 3;
        byArray[176] = 49;
        byArray[177] = 49;
        byArray[178] = 48;
        byArray[179] = 3;
        byArray[180] = 67;
        byArray[181] = 3;
        byArray[182] = 51;
        byArray[183] = 52;
        byArray[184] = 53;
        byArray[185] = 49;
        byArray[186] = 46;
        byArray[187] = 68;
        byArray[188] = 68;
        byArray[189] = 3;
        byArray[190] = 69;
        byArray[191] = 69;
        byArray[192] = 3;
        byArray[193] = 70;
        byArray[194] = 70;
        byArray[195] = 3;
        byArray[196] = 8;
        byArray[197] = 8;
        byArray[198] = 71;
        byArray[199] = 8;
        byArray[200] = 3;
        byArray[201] = 72;
        byArray[202] = 72;
        byArray[203] = 73;
        byArray[204] = 72;
        byArray[205] = 3;
        byArray[206] = 3;
        byArray[207] = 3;
        return byArray;
    }

    private static byte[] init__json_trans_targs_0() {
        byte[] byArray = new byte[74];
        byArray[0] = 35;
        byArray[1] = 1;
        byArray[2] = 3;
        byArray[4] = 4;
        byArray[5] = 36;
        byArray[6] = 36;
        byArray[7] = 36;
        byArray[8] = 36;
        byArray[9] = 1;
        byArray[10] = 6;
        byArray[11] = 5;
        byArray[12] = 13;
        byArray[13] = 17;
        byArray[14] = 22;
        byArray[15] = 37;
        byArray[16] = 7;
        byArray[17] = 8;
        byArray[18] = 9;
        byArray[19] = 7;
        byArray[20] = 8;
        byArray[21] = 9;
        byArray[22] = 7;
        byArray[23] = 10;
        byArray[24] = 20;
        byArray[25] = 21;
        byArray[26] = 11;
        byArray[27] = 11;
        byArray[28] = 11;
        byArray[29] = 12;
        byArray[30] = 17;
        byArray[31] = 19;
        byArray[32] = 37;
        byArray[33] = 11;
        byArray[34] = 12;
        byArray[35] = 19;
        byArray[36] = 14;
        byArray[37] = 16;
        byArray[38] = 15;
        byArray[39] = 14;
        byArray[40] = 12;
        byArray[41] = 18;
        byArray[42] = 17;
        byArray[43] = 11;
        byArray[44] = 9;
        byArray[45] = 5;
        byArray[46] = 24;
        byArray[47] = 23;
        byArray[48] = 27;
        byArray[49] = 31;
        byArray[50] = 34;
        byArray[51] = 25;
        byArray[52] = 38;
        byArray[53] = 25;
        byArray[54] = 25;
        byArray[55] = 26;
        byArray[56] = 31;
        byArray[57] = 33;
        byArray[58] = 38;
        byArray[59] = 25;
        byArray[60] = 26;
        byArray[61] = 33;
        byArray[62] = 28;
        byArray[63] = 30;
        byArray[64] = 29;
        byArray[65] = 28;
        byArray[66] = 26;
        byArray[67] = 32;
        byArray[68] = 31;
        byArray[69] = 25;
        byArray[70] = 23;
        byArray[71] = 2;
        byArray[72] = 36;
        byArray[73] = 2;
        return byArray;
    }

    private static byte[] init__json_trans_actions_0() {
        byte[] byArray = new byte[74];
        byArray[0] = 13;
        byArray[2] = 15;
        byArray[5] = 7;
        byArray[6] = 3;
        byArray[7] = 11;
        byArray[8] = 1;
        byArray[9] = 11;
        byArray[10] = 17;
        byArray[12] = 20;
        byArray[15] = 5;
        byArray[16] = 1;
        byArray[17] = 1;
        byArray[18] = 1;
        byArray[22] = 11;
        byArray[23] = 13;
        byArray[24] = 15;
        byArray[26] = 7;
        byArray[27] = 3;
        byArray[28] = 1;
        byArray[29] = 1;
        byArray[30] = 1;
        byArray[31] = 1;
        byArray[32] = 23;
        byArray[39] = 11;
        byArray[40] = 11;
        byArray[42] = 11;
        byArray[43] = 11;
        byArray[44] = 11;
        byArray[45] = 11;
        byArray[46] = 13;
        byArray[48] = 15;
        byArray[51] = 7;
        byArray[52] = 9;
        byArray[53] = 3;
        byArray[54] = 1;
        byArray[55] = 1;
        byArray[56] = 1;
        byArray[57] = 1;
        byArray[58] = 26;
        byArray[65] = 11;
        byArray[66] = 11;
        byArray[68] = 11;
        byArray[69] = 11;
        byArray[70] = 11;
        byArray[71] = 1;
        return byArray;
    }

    private static byte[] init__json_eof_actions_0() {
        byte[] byArray = new byte[39];
        byArray[35] = 1;
        return byArray;
    }

    private void addChild(@Null String name, JsonValue child) {
        child.setName(name);
        if (this.current == null) {
            this.current = child;
            this.root = child;
        } else if (this.current.isArray() || this.current.isObject()) {
            child.parent = this.current;
            if (this.current.size == 0) {
                this.current.child = child;
            } else {
                JsonValue last = this.lastChild.pop();
                last.next = child;
                child.prev = last;
            }
            this.lastChild.add(child);
            ++this.current.size;
        } else {
            this.root = this.current;
        }
    }

    protected void startObject(@Null String name) {
        JsonValue value = new JsonValue(JsonValue.ValueType.object);
        if (this.current != null) {
            this.addChild(name, value);
        }
        this.elements.add(value);
        this.current = value;
    }

    protected void startArray(@Null String name) {
        JsonValue value = new JsonValue(JsonValue.ValueType.array);
        if (this.current != null) {
            this.addChild(name, value);
        }
        this.elements.add(value);
        this.current = value;
    }

    protected void pop() {
        this.root = this.elements.pop();
        if (this.current.size > 0) {
            this.lastChild.pop();
        }
        this.current = this.elements.size > 0 ? this.elements.peek() : null;
    }

    protected void string(String name, String value) {
        this.addChild(name, new JsonValue(value));
    }

    protected void number(String name, double value, String stringValue) {
        this.addChild(name, new JsonValue(value, stringValue));
    }

    protected void number(String name, long value, String stringValue) {
        this.addChild(name, new JsonValue(value, stringValue));
    }

    protected void bool(String name, boolean value) {
        this.addChild(name, new JsonValue(value));
    }

    private String unescape(String value) {
        int length = value.length();
        StringBuilder buffer = new StringBuilder(length + 16);
        int i = 0;
        while (i < length) {
            char c;
            if ((c = value.charAt(i++)) != '\\') {
                buffer.append(c);
                continue;
            }
            if (i == length) break;
            if ((c = value.charAt(i++)) == 'u') {
                buffer.append(Character.toChars(Integer.parseInt(value.substring(i, i + 4), 16)));
                i += 4;
                continue;
            }
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    break;
                }
                case 'b': {
                    c = '\b';
                    break;
                }
                case 'f': {
                    c = '\f';
                    break;
                }
                case 'n': {
                    c = '\n';
                    break;
                }
                case 'r': {
                    c = '\r';
                    break;
                }
                case 't': {
                    c = '\t';
                    break;
                }
                default: {
                    throw new SerializationException("Illegal escaped character: \\" + c);
                }
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

