/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.SkeletonAttachment;
import com.esotericsoftware.spine.attachments.SkinnedMeshAttachment;

public class SkeletonRenderer {
    private static final short[] quadTriangles;
    private boolean premultipliedAlpha;

    static {
        short[] sArray = new short[6];
        sArray[1] = 1;
        sArray[2] = 2;
        sArray[3] = 2;
        sArray[4] = 3;
        quadTriangles = sArray;
    }

    public void draw(PolygonSpriteBatch batch, Skeleton skeleton) {
        boolean premultipliedAlpha = this.premultipliedAlpha;
        int srcFunc = premultipliedAlpha ? 1 : 770;
        batch.setBlendFunction(srcFunc, 771);
        boolean additive = false;
        float[] vertices = null;
        short[] triangles = null;
        Array<Slot> drawOrder = skeleton.drawOrder;
        int i = 0;
        int n = drawOrder.size;
        while (i < n) {
            block12: {
                Texture texture;
                Slot slot;
                block9: {
                    Attachment attachment;
                    block11: {
                        Attachment mesh;
                        block10: {
                            block8: {
                                slot = drawOrder.get(i);
                                attachment = slot.attachment;
                                texture = null;
                                if (!(attachment instanceof RegionAttachment)) break block8;
                                RegionAttachment region = (RegionAttachment)attachment;
                                region.updateWorldVertices(slot, premultipliedAlpha);
                                vertices = region.getWorldVertices();
                                triangles = quadTriangles;
                                texture = region.getRegion().getTexture();
                                break block9;
                            }
                            if (!(attachment instanceof MeshAttachment)) break block10;
                            mesh = (MeshAttachment)attachment;
                            ((MeshAttachment)mesh).updateWorldVertices(slot, premultipliedAlpha);
                            vertices = ((MeshAttachment)mesh).getWorldVertices();
                            triangles = ((MeshAttachment)mesh).getTriangles();
                            texture = ((MeshAttachment)mesh).getRegion().getTexture();
                            break block9;
                        }
                        if (!(attachment instanceof SkinnedMeshAttachment)) break block11;
                        mesh = (SkinnedMeshAttachment)attachment;
                        ((SkinnedMeshAttachment)mesh).updateWorldVertices(slot, premultipliedAlpha);
                        vertices = ((SkinnedMeshAttachment)mesh).getWorldVertices();
                        triangles = ((SkinnedMeshAttachment)mesh).getTriangles();
                        texture = ((SkinnedMeshAttachment)mesh).getRegion().getTexture();
                        break block9;
                    }
                    if (!(attachment instanceof SkeletonAttachment)) break block9;
                    Skeleton attachmentSkeleton = ((SkeletonAttachment)attachment).getSkeleton();
                    if (attachmentSkeleton == null) break block12;
                    Bone bone = slot.getBone();
                    Bone rootBone = attachmentSkeleton.getRootBone();
                    float oldScaleX = rootBone.getScaleX();
                    float oldScaleY = rootBone.getScaleY();
                    float oldRotation = rootBone.getRotation();
                    attachmentSkeleton.setPosition(skeleton.getX() + bone.getWorldX(), skeleton.getY() + bone.getWorldY());
                    rootBone.setScaleX(1.0f + bone.getWorldScaleX() - oldScaleX);
                    rootBone.setScaleY(1.0f + bone.getWorldScaleY() - oldScaleY);
                    rootBone.setRotation(oldRotation + bone.getWorldRotation());
                    attachmentSkeleton.updateWorldTransform();
                    this.draw(batch, attachmentSkeleton);
                    attachmentSkeleton.setPosition(0.0f, 0.0f);
                    rootBone.setScaleX(oldScaleX);
                    rootBone.setScaleY(oldScaleY);
                    rootBone.setRotation(oldRotation);
                }
                if (texture != null) {
                    if (slot.data.getAdditiveBlending() != additive) {
                        boolean bl = additive = !additive;
                        if (additive) {
                            batch.setBlendFunction(srcFunc, 1);
                        } else {
                            batch.setBlendFunction(srcFunc, 771);
                        }
                    }
                    batch.draw(texture, vertices, 0, vertices.length, triangles, 0, triangles.length);
                }
            }
            ++i;
        }
    }

    public void draw(Batch batch, Skeleton skeleton) {
        boolean premultipliedAlpha = this.premultipliedAlpha;
        int srcFunc = premultipliedAlpha ? 1 : 770;
        batch.setBlendFunction(srcFunc, 771);
        boolean additive = false;
        Array<Slot> drawOrder = skeleton.drawOrder;
        int i = 0;
        int n = drawOrder.size;
        while (i < n) {
            Slot slot = drawOrder.get(i);
            Attachment attachment = slot.attachment;
            if (attachment instanceof RegionAttachment) {
                RegionAttachment regionAttachment = (RegionAttachment)attachment;
                regionAttachment.updateWorldVertices(slot, premultipliedAlpha);
                float[] vertices = regionAttachment.getWorldVertices();
                if (slot.data.getAdditiveBlending() != additive) {
                    boolean bl = additive = !additive;
                    if (additive) {
                        batch.setBlendFunction(srcFunc, 1);
                    } else {
                        batch.setBlendFunction(srcFunc, 771);
                    }
                }
                batch.draw(regionAttachment.getRegion().getTexture(), vertices, 0, 20);
            } else {
                Skeleton attachmentSkeleton;
                if (attachment instanceof MeshAttachment || attachment instanceof SkinnedMeshAttachment) {
                    throw new RuntimeException("PolygonSpriteBatch is required to render meshes.");
                }
                if (attachment instanceof SkeletonAttachment && (attachmentSkeleton = ((SkeletonAttachment)attachment).getSkeleton()) != null) {
                    Bone bone = slot.getBone();
                    Bone rootBone = attachmentSkeleton.getRootBone();
                    float oldScaleX = rootBone.getScaleX();
                    float oldScaleY = rootBone.getScaleY();
                    float oldRotation = rootBone.getRotation();
                    attachmentSkeleton.setPosition(skeleton.getX() + bone.getWorldX(), skeleton.getY() + bone.getWorldY());
                    rootBone.setScaleX(1.0f + bone.getWorldScaleX() - oldScaleX);
                    rootBone.setScaleY(1.0f + bone.getWorldScaleY() - oldScaleY);
                    rootBone.setRotation(oldRotation + bone.getWorldRotation());
                    attachmentSkeleton.updateWorldTransform();
                    this.draw(batch, attachmentSkeleton);
                    attachmentSkeleton.setX(0.0f);
                    attachmentSkeleton.setY(0.0f);
                    rootBone.setScaleX(oldScaleX);
                    rootBone.setScaleY(oldScaleY);
                    rootBone.setRotation(oldRotation);
                }
            }
            ++i;
        }
    }

    public void setPremultipliedAlpha(boolean premultipliedAlpha) {
        this.premultipliedAlpha = premultipliedAlpha;
    }
}

