/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.attachments.Attachment;

public class BoundingBoxAttachment
extends Attachment {
    private float[] vertices;

    public BoundingBoxAttachment(String name) {
        super(name);
    }

    public void computeWorldVertices(Bone bone, float[] worldVertices) {
        Skeleton skeleton = bone.getSkeleton();
        float x = skeleton.getX() + bone.getWorldX();
        float y = skeleton.getY() + bone.getWorldY();
        float m00 = bone.getM00();
        float m01 = bone.getM01();
        float m10 = bone.getM10();
        float m11 = bone.getM11();
        float[] vertices = this.vertices;
        int i = 0;
        int n = vertices.length;
        while (i < n) {
            float px = vertices[i];
            float py = vertices[i + 1];
            worldVertices[i] = px * m00 + py * m01 + x;
            worldVertices[i + 1] = px * m10 + py * m11 + y;
            i += 2;
        }
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public void setVertices(float[] vertices) {
        this.vertices = vertices;
    }
}

