/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.SkeletonAttachment;

public class SkeletonRenderer<T extends Batch> {
    boolean premultipliedAlpha;

    public void draw(T t, Skeleton skeleton) {
        boolean bl = this.premultipliedAlpha;
        Array<Slot> array = skeleton.drawOrder;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            Slot slot = array.get(i);
            Attachment attachment = slot.attachment;
            if (attachment instanceof RegionAttachment) {
                object3 = (RegionAttachment)attachment;
                object2 = ((RegionAttachment)object3).updateWorldVertices(slot, bl);
                object = slot.data.getBlendMode();
                t.setBlendFunction(((BlendMode)((Object)object)).getSource(bl), ((BlendMode)((Object)object)).getDest());
                t.draw(((RegionAttachment)object3).getRegion().getTexture(), (float[])object2, 0, 20);
                continue;
            }
            if (attachment instanceof MeshAttachment) {
                throw new RuntimeException("SkeletonMeshRenderer is required to render meshes.");
            }
            if (!(attachment instanceof SkeletonAttachment) || (object3 = ((SkeletonAttachment)attachment).getSkeleton()) == null) continue;
            object2 = slot.getBone();
            object = ((Skeleton)object3).getRootBone();
            float f = ((Bone)object).getScaleX();
            float f2 = ((Bone)object).getScaleY();
            float f3 = ((Bone)object).getRotation();
            ((Skeleton)object3).setPosition(((Bone)object2).getWorldX(), ((Bone)object2).getWorldY());
            ((Bone)object).setRotation(f3 + ((Bone)object2).getWorldRotationX());
            ((Skeleton)object3).updateWorldTransform();
            this.draw(t, (Skeleton)object3);
            ((Skeleton)object3).setX(0.0f);
            ((Skeleton)object3).setY(0.0f);
            ((Bone)object).setScaleX(f);
            ((Bone)object).setScaleY(f2);
            ((Bone)object).setRotation(f3);
        }
    }

    public void setPremultipliedAlpha(boolean bl) {
        this.premultipliedAlpha = bl;
    }
}

