/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.NumberUtils;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;

public class RegionAttachment
extends Attachment {
    public static final int BLX = 0;
    public static final int BLY = 1;
    public static final int ULX = 2;
    public static final int ULY = 3;
    public static final int URX = 4;
    public static final int URY = 5;
    public static final int BRX = 6;
    public static final int BRY = 7;
    private TextureRegion region;
    private String path;
    private float x;
    private float y;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float rotation;
    private float width;
    private float height;
    private final float[] vertices = new float[20];
    private final float[] offset = new float[8];
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);

    public RegionAttachment(String string) {
        super(string);
    }

    public void updateOffset() {
        float f = this.getWidth();
        float f2 = this.getHeight();
        float f3 = f / 2.0f;
        float f4 = f2 / 2.0f;
        float f5 = -f3;
        float f6 = -f4;
        if (this.region instanceof TextureAtlas.AtlasRegion) {
            TextureAtlas.AtlasRegion atlasRegion = (TextureAtlas.AtlasRegion)this.region;
            if (atlasRegion.rotate) {
                f5 += atlasRegion.offsetX / (float)atlasRegion.originalWidth * f;
                f6 += atlasRegion.offsetY / (float)atlasRegion.originalHeight * f2;
                f3 -= ((float)atlasRegion.originalWidth - atlasRegion.offsetX - (float)atlasRegion.packedHeight) / (float)atlasRegion.originalWidth * f;
                f4 -= ((float)atlasRegion.originalHeight - atlasRegion.offsetY - (float)atlasRegion.packedWidth) / (float)atlasRegion.originalHeight * f2;
            } else {
                f5 += atlasRegion.offsetX / (float)atlasRegion.originalWidth * f;
                f6 += atlasRegion.offsetY / (float)atlasRegion.originalHeight * f2;
                f3 -= ((float)atlasRegion.originalWidth - atlasRegion.offsetX - (float)atlasRegion.packedWidth) / (float)atlasRegion.originalWidth * f;
                f4 -= ((float)atlasRegion.originalHeight - atlasRegion.offsetY - (float)atlasRegion.packedHeight) / (float)atlasRegion.originalHeight * f2;
            }
        }
        float f7 = this.getScaleX();
        float f8 = this.getScaleY();
        f5 *= f7;
        f6 *= f8;
        f3 *= f7;
        f4 *= f8;
        float f9 = this.getRotation();
        float f10 = (float)Math.cos((float)Math.PI / 180 * f9);
        float f11 = (float)Math.sin((float)Math.PI / 180 * f9);
        float f12 = this.getX();
        float f13 = this.getY();
        float f14 = f5 * f10 + f12;
        float f15 = f5 * f11;
        float f16 = f6 * f10 + f13;
        float f17 = f6 * f11;
        float f18 = f3 * f10 + f12;
        float f19 = f3 * f11;
        float f20 = f4 * f10 + f13;
        float f21 = f4 * f11;
        float[] fArray = this.offset;
        fArray[0] = f14 - f17;
        fArray[1] = f16 + f15;
        fArray[2] = f14 - f21;
        fArray[3] = f20 + f15;
        fArray[4] = f18 - f21;
        fArray[5] = f20 + f19;
        fArray[6] = f18 - f17;
        fArray[7] = f16 + f19;
    }

    public void setRegion(TextureRegion textureRegion) {
        if (textureRegion == null) {
            throw new IllegalArgumentException("region cannot be null.");
        }
        this.region = textureRegion;
        float[] fArray = this.vertices;
        if (textureRegion instanceof TextureAtlas.AtlasRegion && ((TextureAtlas.AtlasRegion)textureRegion).rotate) {
            fArray[13] = textureRegion.getU();
            fArray[14] = textureRegion.getV2();
            fArray[18] = textureRegion.getU();
            fArray[19] = textureRegion.getV();
            fArray[3] = textureRegion.getU2();
            fArray[4] = textureRegion.getV();
            fArray[8] = textureRegion.getU2();
            fArray[9] = textureRegion.getV2();
        } else {
            fArray[8] = textureRegion.getU();
            fArray[9] = textureRegion.getV2();
            fArray[13] = textureRegion.getU();
            fArray[14] = textureRegion.getV();
            fArray[18] = textureRegion.getU2();
            fArray[19] = textureRegion.getV();
            fArray[3] = textureRegion.getU2();
            fArray[4] = textureRegion.getV2();
        }
    }

    public TextureRegion getRegion() {
        if (this.region == null) {
            throw new IllegalStateException("Region has not been set: " + this);
        }
        return this.region;
    }

    public float[] updateWorldVertices(Slot slot, boolean bl) {
        Skeleton skeleton = slot.getSkeleton();
        Color color = skeleton.getColor();
        Color color2 = slot.getColor();
        Color color3 = this.color;
        float f = color.a * color2.a * color3.a * 255.0f;
        float f2 = bl ? f : 255.0f;
        float f3 = NumberUtils.intToFloatColor((int)f << 24 | (int)(color.b * color2.b * color3.b * f2) << 16 | (int)(color.g * color2.g * color3.g * f2) << 8 | (int)(color.r * color2.r * color3.r * f2));
        float[] fArray = this.vertices;
        float[] fArray2 = this.offset;
        Bone bone = slot.getBone();
        float f4 = bone.getWorldX();
        float f5 = bone.getWorldY();
        float f6 = bone.getA();
        float f7 = bone.getB();
        float f8 = bone.getC();
        float f9 = bone.getD();
        float f10 = fArray2[6];
        float f11 = fArray2[7];
        fArray[0] = f10 * f6 + f11 * f7 + f4;
        fArray[1] = f10 * f8 + f11 * f9 + f5;
        fArray[2] = f3;
        f10 = fArray2[0];
        f11 = fArray2[1];
        fArray[5] = f10 * f6 + f11 * f7 + f4;
        fArray[6] = f10 * f8 + f11 * f9 + f5;
        fArray[7] = f3;
        f10 = fArray2[2];
        f11 = fArray2[3];
        fArray[10] = f10 * f6 + f11 * f7 + f4;
        fArray[11] = f10 * f8 + f11 * f9 + f5;
        fArray[12] = f3;
        f10 = fArray2[4];
        f11 = fArray2[5];
        fArray[15] = f10 * f6 + f11 * f7 + f4;
        fArray[16] = f10 * f8 + f11 * f9 + f5;
        fArray[17] = f3;
        return fArray;
    }

    public float[] getWorldVertices() {
        return this.vertices;
    }

    public float[] getOffset() {
        return this.offset;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float f) {
        this.scaleX = f;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float f) {
        this.scaleY = f;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float f) {
        this.rotation = f;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public Color getColor() {
        return this.color;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }
}

