/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.utils;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonRenderer;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.utils.SkeletonActor;

public class SkeletonActorPool
extends Pool<SkeletonActor> {
    private SkeletonRenderer renderer;
    SkeletonData skeletonData;
    AnimationStateData stateData;
    private final Pool<Skeleton> skeletonPool;
    private final Pool<AnimationState> statePool;
    private final Array<SkeletonActor> obtained;

    public SkeletonActorPool(SkeletonRenderer skeletonRenderer, SkeletonData skeletonData, AnimationStateData animationStateData) {
        this(skeletonRenderer, skeletonData, animationStateData, 16, Integer.MAX_VALUE);
    }

    public SkeletonActorPool(SkeletonRenderer skeletonRenderer, SkeletonData skeletonData, AnimationStateData animationStateData, int n, int n2) {
        super(n, n2);
        this.renderer = skeletonRenderer;
        this.skeletonData = skeletonData;
        this.stateData = animationStateData;
        this.obtained = new Array(false, n);
        this.skeletonPool = new Pool<Skeleton>(n, n2){

            @Override
            protected Skeleton newObject() {
                return new Skeleton(SkeletonActorPool.this.skeletonData);
            }

            @Override
            protected void reset(Skeleton skeleton) {
                skeleton.setColor(Color.WHITE);
                skeleton.setFlip(false, false);
                skeleton.setSkin((Skin)null);
                skeleton.setSkin(SkeletonActorPool.this.skeletonData.getDefaultSkin());
                skeleton.setToSetupPose();
            }
        };
        this.statePool = new Pool<AnimationState>(n, n2){

            @Override
            protected AnimationState newObject() {
                return new AnimationState(SkeletonActorPool.this.stateData);
            }

            @Override
            protected void reset(AnimationState animationState) {
                animationState.clearTracks();
                animationState.clearListeners();
            }
        };
    }

    public void freeComplete() {
        Array<SkeletonActor> array = this.obtained;
        block0: for (int i = array.size - 1; i >= 0; --i) {
            SkeletonActor skeletonActor = array.get(i);
            Array<AnimationState.TrackEntry> array2 = skeletonActor.state.getTracks();
            int n = array2.size;
            for (int j = 0; j < n; ++j) {
                if (array2.get(j) != null) continue block0;
            }
            this.free(skeletonActor);
        }
    }

    @Override
    protected SkeletonActor newObject() {
        SkeletonActor skeletonActor = new SkeletonActor();
        skeletonActor.setRenderer(this.renderer);
        return skeletonActor;
    }

    @Override
    public SkeletonActor obtain() {
        SkeletonActor skeletonActor = (SkeletonActor)super.obtain();
        skeletonActor.setSkeleton(this.skeletonPool.obtain());
        skeletonActor.setAnimationState(this.statePool.obtain());
        this.obtained.add(skeletonActor);
        return skeletonActor;
    }

    @Override
    protected void reset(SkeletonActor skeletonActor) {
        skeletonActor.remove();
        this.obtained.removeValue(skeletonActor, true);
        this.skeletonPool.free(skeletonActor.getSkeleton());
        this.statePool.free(skeletonActor.getAnimationState());
    }

    public Array<SkeletonActor> getObtained() {
        return this.obtained;
    }
}

