/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.IntSet;
import com.badlogic.gdx.utils.Pool;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.Skeleton;

public class AnimationState {
    private static final Animation emptyAnimation = new Animation("<empty>", new Array<Animation.Timeline>(0), 0.0f);
    private static final int SUBSEQUENT = 0;
    private static final int FIRST = 1;
    private static final int DIP = 2;
    private static final int DIP_MIX = 3;
    private AnimationStateData data;
    final Array<TrackEntry> tracks = new Array();
    private final Array<Event> events = new Array();
    final Array<AnimationStateListener> listeners = new Array();
    private final EventQueue queue = new EventQueue();
    private final IntSet propertyIDs = new IntSet();
    private final Array<TrackEntry> mixingTo = new Array();
    boolean animationsChanged;
    private float timeScale = 1.0f;
    Pool<TrackEntry> trackEntryPool = new Pool(){

        protected Object newObject() {
            return new TrackEntry();
        }
    };

    public AnimationState() {
    }

    public AnimationState(AnimationStateData animationStateData) {
        if (animationStateData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = animationStateData;
    }

    public void update(float f) {
        f *= this.timeScale;
        int n = this.tracks.size;
        for (int i = 0; i < n; ++i) {
            TrackEntry trackEntry;
            TrackEntry trackEntry2 = this.tracks.get(i);
            if (trackEntry2 == null) continue;
            trackEntry2.animationLast = trackEntry2.nextAnimationLast;
            trackEntry2.trackLast = trackEntry2.nextTrackLast;
            float f2 = f * trackEntry2.timeScale;
            if (trackEntry2.delay > 0.0f) {
                trackEntry2.delay -= f2;
                if (trackEntry2.delay > 0.0f) continue;
                f2 = -trackEntry2.delay;
                trackEntry2.delay = 0.0f;
            }
            if ((trackEntry = trackEntry2.next) != null) {
                float f3 = trackEntry2.trackLast - trackEntry.delay;
                if (f3 >= 0.0f) {
                    trackEntry.delay = 0.0f;
                    trackEntry.trackTime = f3 + f * trackEntry.timeScale;
                    trackEntry2.trackTime += f2;
                    this.setCurrent(i, trackEntry, true);
                    while (trackEntry.mixingFrom != null) {
                        trackEntry.mixTime += f2;
                        trackEntry = trackEntry.mixingFrom;
                    }
                    continue;
                }
            } else if (trackEntry2.trackLast >= trackEntry2.trackEnd && trackEntry2.mixingFrom == null) {
                this.tracks.set(i, null);
                this.queue.end(trackEntry2);
                this.disposeNext(trackEntry2);
                continue;
            }
            if (trackEntry2.mixingFrom != null && this.updateMixingFrom(trackEntry2, f)) {
                TrackEntry trackEntry3 = trackEntry2.mixingFrom;
                trackEntry2.mixingFrom = null;
                while (trackEntry3 != null) {
                    this.queue.end(trackEntry3);
                    trackEntry3 = trackEntry3.mixingFrom;
                }
            }
            trackEntry2.trackTime += f2;
        }
        this.queue.drain();
    }

    private boolean updateMixingFrom(TrackEntry trackEntry, float f) {
        TrackEntry trackEntry2 = trackEntry.mixingFrom;
        if (trackEntry2 == null) {
            return true;
        }
        boolean bl = this.updateMixingFrom(trackEntry2, f);
        trackEntry2.animationLast = trackEntry2.nextAnimationLast;
        trackEntry2.trackLast = trackEntry2.nextTrackLast;
        if (trackEntry.mixTime > 0.0f && (trackEntry.mixTime >= trackEntry.mixDuration || trackEntry.timeScale == 0.0f)) {
            if (trackEntry2.totalAlpha == 0.0f || trackEntry.mixDuration == 0.0f) {
                trackEntry.mixingFrom = trackEntry2.mixingFrom;
                trackEntry.interruptAlpha = trackEntry2.interruptAlpha;
                this.queue.end(trackEntry2);
            }
            return bl;
        }
        trackEntry2.trackTime += f * trackEntry2.timeScale;
        trackEntry.mixTime += f * trackEntry.timeScale;
        return false;
    }

    public boolean apply(Skeleton skeleton) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        if (this.animationsChanged) {
            this.animationsChanged();
        }
        Array<Event> array = this.events;
        boolean bl = false;
        int n = this.tracks.size;
        for (int i = 0; i < n; ++i) {
            TrackEntry trackEntry = this.tracks.get(i);
            if (trackEntry == null || trackEntry.delay > 0.0f) continue;
            bl = true;
            Animation.MixPose mixPose = i == 0 ? Animation.MixPose.current : Animation.MixPose.currentLayered;
            float f = trackEntry.alpha;
            if (trackEntry.mixingFrom != null) {
                f *= this.applyMixingFrom(trackEntry, skeleton, mixPose);
            } else if (trackEntry.trackTime >= trackEntry.trackEnd && trackEntry.next == null) {
                f = 0.0f;
            }
            float f2 = trackEntry.animationLast;
            float f3 = trackEntry.getAnimationTime();
            int n2 = trackEntry.animation.timelines.size;
            T[] TArray = trackEntry.animation.timelines.items;
            if (f == 1.0f) {
                for (int j = 0; j < n2; ++j) {
                    ((Animation.Timeline)TArray[j]).apply(skeleton, f2, f3, array, 1.0f, Animation.MixPose.setup, Animation.MixDirection.in);
                }
            } else {
                boolean bl2;
                int[] nArray = trackEntry.timelineData.items;
                boolean bl3 = bl2 = trackEntry.timelinesRotation.size == 0;
                if (bl2) {
                    trackEntry.timelinesRotation.setSize(n2 << 1);
                }
                float[] fArray = trackEntry.timelinesRotation.items;
                for (int j = 0; j < n2; ++j) {
                    Animation.MixPose mixPose2;
                    Animation.Timeline timeline = (Animation.Timeline)TArray[j];
                    Animation.MixPose mixPose3 = mixPose2 = nArray[j] >= 1 ? Animation.MixPose.setup : mixPose;
                    if (timeline instanceof Animation.RotateTimeline) {
                        this.applyRotateTimeline(timeline, skeleton, f3, f, mixPose2, fArray, j << 1, bl2);
                        continue;
                    }
                    timeline.apply(skeleton, f2, f3, array, f, mixPose2, Animation.MixDirection.in);
                }
            }
            this.queueEvents(trackEntry, f3);
            array.clear();
            trackEntry.nextAnimationLast = f3;
            trackEntry.nextTrackLast = trackEntry.trackTime;
        }
        this.queue.drain();
        return bl;
    }

    private float applyMixingFrom(TrackEntry trackEntry, Skeleton skeleton, Animation.MixPose mixPose) {
        boolean bl;
        float f;
        TrackEntry trackEntry2 = trackEntry.mixingFrom;
        if (trackEntry2.mixingFrom != null) {
            this.applyMixingFrom(trackEntry2, skeleton, mixPose);
        }
        if (trackEntry.mixDuration == 0.0f) {
            f = 1.0f;
            mixPose = Animation.MixPose.setup;
        } else {
            f = trackEntry.mixTime / trackEntry.mixDuration;
            if (f > 1.0f) {
                f = 1.0f;
            }
        }
        Array<Event> array = f < trackEntry2.eventThreshold ? this.events : null;
        boolean bl2 = f < trackEntry2.attachmentThreshold;
        boolean bl3 = f < trackEntry2.drawOrderThreshold;
        float f2 = trackEntry2.animationLast;
        float f3 = trackEntry2.getAnimationTime();
        int n = trackEntry2.animation.timelines.size;
        T[] TArray = trackEntry2.animation.timelines.items;
        int[] nArray = trackEntry2.timelineData.items;
        T[] TArray2 = trackEntry2.timelineDipMix.items;
        boolean bl4 = bl = trackEntry2.timelinesRotation.size == 0;
        if (bl) {
            trackEntry2.timelinesRotation.setSize(n << 1);
        }
        float[] fArray = trackEntry2.timelinesRotation.items;
        float f4 = trackEntry2.alpha * trackEntry.interruptAlpha;
        float f5 = f4 * (1.0f - f);
        trackEntry2.totalAlpha = 0.0f;
        block5: for (int i = 0; i < n; ++i) {
            Animation.MixPose mixPose2;
            Animation.Timeline timeline = (Animation.Timeline)TArray[i];
            float f6 = switch (nArray[i]) {
                case 0 -> {
                    if (!bl2 && timeline instanceof Animation.AttachmentTimeline || !bl3 && timeline instanceof Animation.DrawOrderTimeline) continue block5;
                    mixPose2 = mixPose;
                    yield f5;
                }
                case 1 -> {
                    mixPose2 = Animation.MixPose.setup;
                    yield f5;
                }
                case 2 -> {
                    mixPose2 = Animation.MixPose.setup;
                    yield f4;
                }
                default -> {
                    mixPose2 = Animation.MixPose.setup;
                    TrackEntry var23_23 = (TrackEntry)TArray2[i];
                    yield f4 * Math.max(0.0f, 1.0f - var23_23.mixTime / var23_23.mixDuration);
                }
            };
            trackEntry2.totalAlpha += f6;
            if (timeline instanceof Animation.RotateTimeline) {
                this.applyRotateTimeline(timeline, skeleton, f3, f6, mixPose2, fArray, i << 1, bl);
                continue;
            }
            timeline.apply(skeleton, f2, f3, array, f6, mixPose2, Animation.MixDirection.out);
        }
        if (trackEntry.mixDuration > 0.0f) {
            this.queueEvents(trackEntry2, f3);
        }
        this.events.clear();
        trackEntry2.nextAnimationLast = f3;
        trackEntry2.nextTrackLast = trackEntry2.trackTime;
        return f;
    }

    private void applyRotateTimeline(Animation.Timeline timeline, Skeleton skeleton, float f, float f2, Animation.MixPose mixPose, float[] fArray, int n, boolean bl) {
        float f3;
        float f4;
        float f5;
        float f6;
        if (bl) {
            fArray[n] = 0.0f;
        }
        if (f2 == 1.0f) {
            timeline.apply(skeleton, 0.0f, f, null, 1.0f, mixPose, Animation.MixDirection.in);
            return;
        }
        Animation.RotateTimeline rotateTimeline = (Animation.RotateTimeline)timeline;
        Bone bone = skeleton.bones.get(rotateTimeline.boneIndex);
        float[] fArray2 = rotateTimeline.frames;
        if (f < fArray2[0]) {
            if (mixPose == Animation.MixPose.setup) {
                bone.rotation = bone.data.rotation;
            }
            return;
        }
        if (f >= fArray2[fArray2.length - 2]) {
            f6 = bone.data.rotation + fArray2[fArray2.length + -1];
        } else {
            int n2 = Animation.binarySearch(fArray2, f, 2);
            f5 = fArray2[n2 + -1];
            f4 = fArray2[n2];
            f3 = rotateTimeline.getCurvePercent((n2 >> 1) - 1, 1.0f - (f - f4) / (fArray2[n2 + -2] - f4));
            f6 = fArray2[n2 + 1] - f5;
            f6 -= (float)((16384 - (int)(16384.499999999996 - (double)(f6 / 360.0f))) * 360);
            f6 = f5 + f6 * f3 + bone.data.rotation;
            f6 -= (float)((16384 - (int)(16384.499999999996 - (double)(f6 / 360.0f))) * 360);
        }
        float f7 = mixPose == Animation.MixPose.setup ? bone.data.rotation : bone.rotation;
        f4 = f6 - f7;
        if (f4 == 0.0f) {
            f5 = fArray[n];
        } else {
            boolean bl2;
            float f8;
            f4 -= (float)((16384 - (int)(16384.499999999996 - (double)(f4 / 360.0f))) * 360);
            if (bl) {
                f3 = 0.0f;
                f8 = f4;
            } else {
                f3 = fArray[n];
                f8 = fArray[n + 1];
            }
            boolean bl3 = f4 > 0.0f;
            boolean bl4 = bl2 = f3 >= 0.0f;
            if (Math.signum(f8) != Math.signum(f4) && Math.abs(f8) <= 90.0f) {
                if (Math.abs(f3) > 180.0f) {
                    f3 += 360.0f * Math.signum(f3);
                }
                bl2 = bl3;
            }
            f5 = f4 + f3 - f3 % 360.0f;
            if (bl2 != bl3) {
                f5 += 360.0f * Math.signum(f3);
            }
            fArray[n] = f5;
        }
        fArray[n + 1] = f4;
        bone.rotation = (f7 += f5 * f2) - (float)((16384 - (int)(16384.499999999996 - (double)(f7 / 360.0f))) * 360);
    }

    private void queueEvents(TrackEntry trackEntry, float f) {
        boolean bl;
        int n;
        float f2 = trackEntry.animationStart;
        float f3 = trackEntry.animationEnd;
        float f4 = f3 - f2;
        float f5 = trackEntry.trackLast % f4;
        Array<Event> array = this.events;
        int n2 = array.size;
        for (n = 0; n < n2; ++n) {
            Event event = array.get(n);
            if (event.time < f5) break;
            if (event.time > f3) continue;
            this.queue.event(trackEntry, event);
        }
        if (trackEntry.loop) {
            bl = f4 == 0.0f || f5 > trackEntry.trackTime % f4;
        } else {
            boolean bl2 = bl = f >= f3 && trackEntry.animationLast < f3;
        }
        if (bl) {
            this.queue.complete(trackEntry);
        }
        while (n < n2) {
            Event event = array.get(n);
            if (!(event.time < f2)) {
                this.queue.event(trackEntry, array.get(n));
            }
            ++n;
        }
    }

    public void clearTracks() {
        boolean bl = this.queue.drainDisabled;
        this.queue.drainDisabled = true;
        int n = this.tracks.size;
        for (int i = 0; i < n; ++i) {
            this.clearTrack(i);
        }
        this.tracks.clear();
        this.queue.drainDisabled = bl;
        this.queue.drain();
    }

    public void clearTrack(int n) {
        TrackEntry trackEntry;
        if (n >= this.tracks.size) {
            return;
        }
        TrackEntry trackEntry2 = this.tracks.get(n);
        if (trackEntry2 == null) {
            return;
        }
        this.queue.end(trackEntry2);
        this.disposeNext(trackEntry2);
        TrackEntry trackEntry3 = trackEntry2;
        while ((trackEntry = trackEntry3.mixingFrom) != null) {
            this.queue.end(trackEntry);
            trackEntry3.mixingFrom = null;
            trackEntry3 = trackEntry;
        }
        this.tracks.set(trackEntry2.trackIndex, null);
        this.queue.drain();
    }

    private void setCurrent(int n, TrackEntry trackEntry, boolean bl) {
        TrackEntry trackEntry2 = this.expandToIndex(n);
        this.tracks.set(n, trackEntry);
        if (trackEntry2 != null) {
            if (bl) {
                this.queue.interrupt(trackEntry2);
            }
            trackEntry.mixingFrom = trackEntry2;
            trackEntry.mixTime = 0.0f;
            if (trackEntry2.mixingFrom != null && trackEntry2.mixDuration > 0.0f) {
                trackEntry.interruptAlpha *= Math.min(1.0f, trackEntry2.mixTime / trackEntry2.mixDuration);
            }
            trackEntry2.timelinesRotation.clear();
        }
        this.queue.start(trackEntry);
    }

    public TrackEntry setAnimation(int n, String string, boolean bl) {
        Animation animation = this.data.skeletonData.findAnimation(string);
        if (animation == null) {
            throw new IllegalArgumentException("Animation not found: " + string);
        }
        return this.setAnimation(n, animation, bl);
    }

    public TrackEntry setAnimation(int n, Animation animation, boolean bl) {
        if (animation == null) {
            throw new IllegalArgumentException("animation cannot be null.");
        }
        boolean bl2 = true;
        TrackEntry trackEntry = this.expandToIndex(n);
        if (trackEntry != null) {
            if (trackEntry.nextTrackLast == -1.0f) {
                this.tracks.set(n, trackEntry.mixingFrom);
                this.queue.interrupt(trackEntry);
                this.queue.end(trackEntry);
                this.disposeNext(trackEntry);
                trackEntry = trackEntry.mixingFrom;
                bl2 = false;
            } else {
                this.disposeNext(trackEntry);
            }
        }
        TrackEntry trackEntry2 = this.trackEntry(n, animation, bl, trackEntry);
        this.setCurrent(n, trackEntry2, bl2);
        this.queue.drain();
        return trackEntry2;
    }

    public TrackEntry addAnimation(int n, String string, boolean bl, float f) {
        Animation animation = this.data.skeletonData.findAnimation(string);
        if (animation == null) {
            throw new IllegalArgumentException("Animation not found: " + string);
        }
        return this.addAnimation(n, animation, bl, f);
    }

    public TrackEntry addAnimation(int n, Animation animation, boolean bl, float f) {
        if (animation == null) {
            throw new IllegalArgumentException("animation cannot be null.");
        }
        TrackEntry trackEntry = this.expandToIndex(n);
        if (trackEntry != null) {
            while (trackEntry.next != null) {
                trackEntry = trackEntry.next;
            }
        }
        TrackEntry trackEntry2 = this.trackEntry(n, animation, bl, trackEntry);
        if (trackEntry == null) {
            this.setCurrent(n, trackEntry2, true);
            this.queue.drain();
        } else {
            trackEntry.next = trackEntry2;
            if (f <= 0.0f) {
                float f2 = trackEntry.animationEnd - trackEntry.animationStart;
                if (f2 != 0.0f) {
                    f = trackEntry.loop ? (f += f2 * (float)(1 + (int)(trackEntry.trackTime / f2))) : (f += f2);
                    f -= this.data.getMix(trackEntry.animation, animation);
                } else {
                    f = 0.0f;
                }
            }
        }
        trackEntry2.delay = f;
        return trackEntry2;
    }

    public TrackEntry setEmptyAnimation(int n, float f) {
        TrackEntry trackEntry = this.setAnimation(n, emptyAnimation, false);
        trackEntry.mixDuration = f;
        trackEntry.trackEnd = f;
        return trackEntry;
    }

    public TrackEntry addEmptyAnimation(int n, float f, float f2) {
        if (f2 <= 0.0f) {
            f2 -= f;
        }
        TrackEntry trackEntry = this.addAnimation(n, emptyAnimation, false, f2);
        trackEntry.mixDuration = f;
        trackEntry.trackEnd = f;
        return trackEntry;
    }

    public void setEmptyAnimations(float f) {
        boolean bl = this.queue.drainDisabled;
        this.queue.drainDisabled = true;
        int n = this.tracks.size;
        for (int i = 0; i < n; ++i) {
            TrackEntry trackEntry = this.tracks.get(i);
            if (trackEntry == null) continue;
            this.setEmptyAnimation(trackEntry.trackIndex, f);
        }
        this.queue.drainDisabled = bl;
        this.queue.drain();
    }

    private TrackEntry expandToIndex(int n) {
        if (n < this.tracks.size) {
            return this.tracks.get(n);
        }
        this.tracks.ensureCapacity(n - this.tracks.size + 1);
        this.tracks.size = n + 1;
        return null;
    }

    private TrackEntry trackEntry(int n, Animation animation, boolean bl, TrackEntry trackEntry) {
        TrackEntry trackEntry2 = this.trackEntryPool.obtain();
        trackEntry2.trackIndex = n;
        trackEntry2.animation = animation;
        trackEntry2.loop = bl;
        trackEntry2.eventThreshold = 0.0f;
        trackEntry2.attachmentThreshold = 0.0f;
        trackEntry2.drawOrderThreshold = 0.0f;
        trackEntry2.animationStart = 0.0f;
        trackEntry2.animationEnd = animation.getDuration();
        trackEntry2.animationLast = -1.0f;
        trackEntry2.nextAnimationLast = -1.0f;
        trackEntry2.delay = 0.0f;
        trackEntry2.trackTime = 0.0f;
        trackEntry2.trackLast = -1.0f;
        trackEntry2.nextTrackLast = -1.0f;
        trackEntry2.trackEnd = Float.MAX_VALUE;
        trackEntry2.timeScale = 1.0f;
        trackEntry2.alpha = 1.0f;
        trackEntry2.interruptAlpha = 1.0f;
        trackEntry2.mixTime = 0.0f;
        trackEntry2.mixDuration = trackEntry == null ? 0.0f : this.data.getMix(trackEntry.animation, animation);
        return trackEntry2;
    }

    private void disposeNext(TrackEntry trackEntry) {
        TrackEntry trackEntry2 = trackEntry.next;
        while (trackEntry2 != null) {
            this.queue.dispose(trackEntry2);
            trackEntry2 = trackEntry2.next;
        }
        trackEntry.next = null;
    }

    private void animationsChanged() {
        this.animationsChanged = false;
        IntSet intSet = this.propertyIDs;
        intSet.clear();
        Array<TrackEntry> array = this.mixingTo;
        int n = this.tracks.size;
        for (int i = 0; i < n; ++i) {
            TrackEntry trackEntry = this.tracks.get(i);
            if (trackEntry == null) continue;
            trackEntry.setTimelineData(null, array, intSet);
        }
    }

    public TrackEntry getCurrent(int n) {
        if (n >= this.tracks.size) {
            return null;
        }
        return this.tracks.get(n);
    }

    public void addListener(AnimationStateListener animationStateListener) {
        if (animationStateListener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        this.listeners.add(animationStateListener);
    }

    public void removeListener(AnimationStateListener animationStateListener) {
        this.listeners.removeValue(animationStateListener, true);
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public void clearListenerNotifications() {
        this.queue.clear();
    }

    public float getTimeScale() {
        return this.timeScale;
    }

    public void setTimeScale(float f) {
        this.timeScale = f;
    }

    public AnimationStateData getData() {
        return this.data;
    }

    public void setData(AnimationStateData animationStateData) {
        if (animationStateData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = animationStateData;
    }

    public Array<TrackEntry> getTracks() {
        return this.tracks;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        int n = this.tracks.size;
        for (int i = 0; i < n; ++i) {
            TrackEntry trackEntry = this.tracks.get(i);
            if (trackEntry == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(trackEntry.toString());
        }
        if (stringBuilder.length() == 0) {
            return "<none>";
        }
        return stringBuilder.toString();
    }

    class EventQueue {
        private final Array objects = new Array();
        boolean drainDisabled;

        EventQueue() {
        }

        public void start(TrackEntry trackEntry) {
            this.objects.add(EventType.start);
            this.objects.add(trackEntry);
            AnimationState.this.animationsChanged = true;
        }

        public void interrupt(TrackEntry trackEntry) {
            this.objects.add(EventType.interrupt);
            this.objects.add(trackEntry);
        }

        public void end(TrackEntry trackEntry) {
            this.objects.add(EventType.end);
            this.objects.add(trackEntry);
            AnimationState.this.animationsChanged = true;
        }

        public void dispose(TrackEntry trackEntry) {
            this.objects.add(EventType.dispose);
            this.objects.add(trackEntry);
        }

        public void complete(TrackEntry trackEntry) {
            this.objects.add(EventType.complete);
            this.objects.add(trackEntry);
        }

        public void event(TrackEntry trackEntry, Event event) {
            this.objects.add(EventType.event);
            this.objects.add(trackEntry);
            this.objects.add(event);
        }

        public void drain() {
            if (this.drainDisabled) {
                return;
            }
            this.drainDisabled = true;
            Array array = this.objects;
            Array<AnimationStateListener> array2 = AnimationState.this.listeners;
            block8: for (int i = 0; i < array.size; i += 2) {
                EventType eventType = (EventType)((Object)array.get(i));
                TrackEntry trackEntry = (TrackEntry)array.get(i + 1);
                switch (eventType) {
                    case start: {
                        if (trackEntry.listener != null) {
                            trackEntry.listener.start(trackEntry);
                        }
                        for (int j = 0; j < array2.size; ++j) {
                            array2.get(j).start(trackEntry);
                        }
                        continue block8;
                    }
                    case interrupt: {
                        if (trackEntry.listener != null) {
                            trackEntry.listener.interrupt(trackEntry);
                        }
                        for (int j = 0; j < array2.size; ++j) {
                            array2.get(j).interrupt(trackEntry);
                        }
                        continue block8;
                    }
                    case end: {
                        if (trackEntry.listener != null) {
                            trackEntry.listener.end(trackEntry);
                        }
                        for (int j = 0; j < array2.size; ++j) {
                            array2.get(j).end(trackEntry);
                        }
                    }
                    case dispose: {
                        if (trackEntry.listener != null) {
                            trackEntry.listener.dispose(trackEntry);
                        }
                        for (int j = 0; j < array2.size; ++j) {
                            array2.get(j).dispose(trackEntry);
                        }
                        AnimationState.this.trackEntryPool.free(trackEntry);
                        continue block8;
                    }
                    case complete: {
                        if (trackEntry.listener != null) {
                            trackEntry.listener.complete(trackEntry);
                        }
                        for (int j = 0; j < array2.size; ++j) {
                            array2.get(j).complete(trackEntry);
                        }
                        continue block8;
                    }
                    case event: {
                        Event event = (Event)array.get(i++ + 2);
                        if (trackEntry.listener != null) {
                            trackEntry.listener.event(trackEntry, event);
                        }
                        for (int j = 0; j < array2.size; ++j) {
                            array2.get(j).event(trackEntry, event);
                        }
                        continue block8;
                    }
                }
            }
            this.clear();
            this.drainDisabled = false;
        }

        public void clear() {
            this.objects.clear();
        }
    }

    public static class TrackEntry
    implements Pool.Poolable {
        Animation animation;
        TrackEntry next;
        TrackEntry mixingFrom;
        AnimationStateListener listener;
        int trackIndex;
        boolean loop;
        float eventThreshold;
        float attachmentThreshold;
        float drawOrderThreshold;
        float animationStart;
        float animationEnd;
        float animationLast;
        float nextAnimationLast;
        float delay;
        float trackTime;
        float trackLast;
        float nextTrackLast;
        float trackEnd;
        float timeScale;
        float alpha;
        float mixTime;
        float mixDuration;
        float interruptAlpha;
        float totalAlpha;
        final IntArray timelineData = new IntArray();
        final Array<TrackEntry> timelineDipMix = new Array();
        final FloatArray timelinesRotation = new FloatArray();

        @Override
        public void reset() {
            this.next = null;
            this.mixingFrom = null;
            this.animation = null;
            this.listener = null;
            this.timelineData.clear();
            this.timelineDipMix.clear();
            this.timelinesRotation.clear();
        }

        TrackEntry setTimelineData(TrackEntry trackEntry, Array<TrackEntry> array, IntSet intSet) {
            TrackEntry trackEntry2;
            if (trackEntry != null) {
                array.add(trackEntry);
            }
            TrackEntry trackEntry3 = trackEntry2 = this.mixingFrom != null ? this.mixingFrom.setTimelineData(this, array, intSet) : this;
            if (trackEntry != null) {
                array.pop();
            }
            T[] TArray = array.items;
            int n = array.size - 1;
            T[] TArray2 = this.animation.timelines.items;
            int n2 = this.animation.timelines.size;
            int[] nArray = this.timelineData.setSize(n2);
            this.timelineDipMix.clear();
            TrackEntry[] trackEntryArray = this.timelineDipMix.setSize(n2);
            block0: for (int i = 0; i < n2; ++i) {
                int n3 = ((Animation.Timeline)TArray2[i]).getPropertyId();
                if (!intSet.add(n3)) {
                    nArray[i] = 0;
                    continue;
                }
                if (trackEntry == null || !trackEntry.hasTimeline(n3)) {
                    nArray[i] = 1;
                    continue;
                }
                for (int j = n; j >= 0; --j) {
                    TrackEntry trackEntry4 = (TrackEntry)TArray[j];
                    if (trackEntry4.hasTimeline(n3)) continue;
                    if (!(trackEntry4.mixDuration > 0.0f)) break;
                    nArray[i] = 3;
                    trackEntryArray[i] = trackEntry4;
                    continue block0;
                }
                nArray[i] = 2;
            }
            return trackEntry2;
        }

        private boolean hasTimeline(int n) {
            T[] TArray = this.animation.timelines.items;
            int n2 = this.animation.timelines.size;
            for (int i = 0; i < n2; ++i) {
                if (((Animation.Timeline)TArray[i]).getPropertyId() != n) continue;
                return true;
            }
            return false;
        }

        public int getTrackIndex() {
            return this.trackIndex;
        }

        public Animation getAnimation() {
            return this.animation;
        }

        public void setAnimation(Animation animation) {
            this.animation = animation;
        }

        public boolean getLoop() {
            return this.loop;
        }

        public void setLoop(boolean bl) {
            this.loop = bl;
        }

        public float getDelay() {
            return this.delay;
        }

        public void setDelay(float f) {
            this.delay = f;
        }

        public float getTrackTime() {
            return this.trackTime;
        }

        public void setTrackTime(float f) {
            this.trackTime = f;
        }

        public float getTrackEnd() {
            return this.trackEnd;
        }

        public void setTrackEnd(float f) {
            this.trackEnd = f;
        }

        public float getAnimationStart() {
            return this.animationStart;
        }

        public void setAnimationStart(float f) {
            this.animationStart = f;
        }

        public float getAnimationEnd() {
            return this.animationEnd;
        }

        public void setAnimationEnd(float f) {
            this.animationEnd = f;
        }

        public float getAnimationLast() {
            return this.animationLast;
        }

        public void setAnimationLast(float f) {
            this.animationLast = f;
            this.nextAnimationLast = f;
        }

        public float getAnimationTime() {
            if (this.loop) {
                float f = this.animationEnd - this.animationStart;
                if (f == 0.0f) {
                    return this.animationStart;
                }
                return this.trackTime % f + this.animationStart;
            }
            return Math.min(this.trackTime + this.animationStart, this.animationEnd);
        }

        public float getTimeScale() {
            return this.timeScale;
        }

        public void setTimeScale(float f) {
            this.timeScale = f;
        }

        public AnimationStateListener getListener() {
            return this.listener;
        }

        public void setListener(AnimationStateListener animationStateListener) {
            this.listener = animationStateListener;
        }

        public float getAlpha() {
            return this.alpha;
        }

        public void setAlpha(float f) {
            this.alpha = f;
        }

        public float getEventThreshold() {
            return this.eventThreshold;
        }

        public void setEventThreshold(float f) {
            this.eventThreshold = f;
        }

        public float getAttachmentThreshold() {
            return this.attachmentThreshold;
        }

        public void setAttachmentThreshold(float f) {
            this.attachmentThreshold = f;
        }

        public float getDrawOrderThreshold() {
            return this.drawOrderThreshold;
        }

        public void setDrawOrderThreshold(float f) {
            this.drawOrderThreshold = f;
        }

        public TrackEntry getNext() {
            return this.next;
        }

        public boolean isComplete() {
            return this.trackTime >= this.animationEnd - this.animationStart;
        }

        public float getMixTime() {
            return this.mixTime;
        }

        public void setMixTime(float f) {
            this.mixTime = f;
        }

        public float getMixDuration() {
            return this.mixDuration;
        }

        public void setMixDuration(float f) {
            this.mixDuration = f;
        }

        public TrackEntry getMixingFrom() {
            return this.mixingFrom;
        }

        public void resetRotationDirections() {
            this.timelinesRotation.clear();
        }

        public String toString() {
            return this.animation == null ? "<none>" : this.animation.name;
        }
    }

    public static abstract class AnimationStateAdapter
    implements AnimationStateListener {
        @Override
        public void start(TrackEntry trackEntry) {
        }

        @Override
        public void interrupt(TrackEntry trackEntry) {
        }

        @Override
        public void end(TrackEntry trackEntry) {
        }

        @Override
        public void dispose(TrackEntry trackEntry) {
        }

        @Override
        public void complete(TrackEntry trackEntry) {
        }

        @Override
        public void event(TrackEntry trackEntry, Event event) {
        }
    }

    public static interface AnimationStateListener {
        public void start(TrackEntry var1);

        public void interrupt(TrackEntry var1);

        public void end(TrackEntry var1);

        public void dispose(TrackEntry var1);

        public void complete(TrackEntry var1);

        public void event(TrackEntry var1, Event var2);
    }

    private static enum EventType {
        start,
        interrupt,
        end,
        dispose,
        complete,
        event;

    }
}

