/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CountingInputStream
extends InputStream {
    public int count;
    private final InputStream input;

    public CountingInputStream(InputStream inputStream) {
        this.input = inputStream;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.input.read(byArray);
        if (n > 0) {
            this.count += n;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.input.read(byArray, n, n2);
        if (n3 > 0) {
            this.count += n3;
        }
        return n3;
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        byte[] byArray = this.input.readAllBytes();
        this.count += byArray.length;
        return byArray;
    }

    @Override
    public byte[] readNBytes(int n) throws IOException {
        byte[] byArray = this.input.readNBytes(n);
        this.count += byArray.length;
        return byArray;
    }

    @Override
    public int readNBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.input.readNBytes(byArray, n, n2);
        this.count += n3;
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        l = this.input.skip(l);
        this.count += (int)l;
        return l;
    }

    @Override
    public void skipNBytes(long l) throws IOException {
        this.input.skipNBytes(l);
        this.count += (int)l;
    }

    @Override
    public long transferTo(OutputStream outputStream) throws IOException {
        long l = this.input.transferTo(outputStream);
        this.count += (int)l;
        return l;
    }

    @Override
    public int read() throws IOException {
        int n = this.input.read();
        if (n != -1) {
            ++this.count;
        }
        return n;
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public synchronized void mark(int n) {
        this.input.mark(n);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.input.reset();
    }

    @Override
    public boolean markSupported() {
        return this.input.markSupported();
    }
}

