/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.esotericsoftware.spine.attachments.VertexAttachment;

public class MeshAttachment
extends VertexAttachment {
    private TextureRegion region;
    private String path;
    private float[] regionUVs;
    private float[] uvs;
    private short[] triangles;
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private int hullLength;
    private MeshAttachment parentMesh;
    private boolean inheritDeform;
    private short[] edges;
    private float width;
    private float height;

    public MeshAttachment(String string) {
        super(string);
    }

    public void setRegion(TextureRegion textureRegion) {
        if (textureRegion == null) {
            throw new IllegalArgumentException("region cannot be null.");
        }
        this.region = textureRegion;
    }

    public TextureRegion getRegion() {
        if (this.region == null) {
            throw new IllegalStateException("Region has not been set: " + this);
        }
        return this.region;
    }

    public void updateUVs() {
        float f;
        float f2;
        float f3;
        float f4;
        if (this.region == null) {
            f4 = 0.0f;
            f3 = 0.0f;
            f2 = 1.0f;
            f = 1.0f;
        } else {
            f3 = this.region.getU();
            f4 = this.region.getV();
            f = this.region.getU2() - f3;
            f2 = this.region.getV2() - f4;
        }
        float[] fArray = this.regionUVs;
        if (this.uvs == null || this.uvs.length != fArray.length) {
            this.uvs = new float[fArray.length];
        }
        float[] fArray2 = this.uvs;
        if (this.region instanceof TextureAtlas.AtlasRegion && ((TextureAtlas.AtlasRegion)this.region).rotate) {
            int n = fArray2.length;
            for (int i = 0; i < n; i += 2) {
                fArray2[i] = f3 + fArray[i + 1] * f;
                fArray2[i + 1] = f4 + f2 - fArray[i] * f2;
            }
        } else {
            int n = fArray2.length;
            for (int i = 0; i < n; i += 2) {
                fArray2[i] = f3 + fArray[i] * f;
                fArray2[i + 1] = f4 + fArray[i + 1] * f2;
            }
        }
    }

    @Override
    public boolean applyDeform(VertexAttachment vertexAttachment) {
        return this == vertexAttachment || this.inheritDeform && this.parentMesh == vertexAttachment;
    }

    public short[] getTriangles() {
        return this.triangles;
    }

    public void setTriangles(short[] sArray) {
        this.triangles = sArray;
    }

    public float[] getRegionUVs() {
        return this.regionUVs;
    }

    public void setRegionUVs(float[] fArray) {
        this.regionUVs = fArray;
    }

    public float[] getUVs() {
        return this.uvs;
    }

    public void setUVs(float[] fArray) {
        this.uvs = fArray;
    }

    public Color getColor() {
        return this.color;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public int getHullLength() {
        return this.hullLength;
    }

    public void setHullLength(int n) {
        this.hullLength = n;
    }

    public void setEdges(short[] sArray) {
        this.edges = sArray;
    }

    public short[] getEdges() {
        return this.edges;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public MeshAttachment getParentMesh() {
        return this.parentMesh;
    }

    public void setParentMesh(MeshAttachment meshAttachment) {
        this.parentMesh = meshAttachment;
        if (meshAttachment != null) {
            this.bones = meshAttachment.bones;
            this.vertices = meshAttachment.vertices;
            this.regionUVs = meshAttachment.regionUVs;
            this.triangles = meshAttachment.triangles;
            this.hullLength = meshAttachment.hullLength;
            this.worldVerticesLength = meshAttachment.worldVerticesLength;
            this.edges = meshAttachment.edges;
            this.width = meshAttachment.width;
            this.height = meshAttachment.height;
        }
    }

    public boolean getInheritDeform() {
        return this.inheritDeform;
    }

    public void setInheritDeform(boolean bl) {
        this.inheritDeform = bl;
    }
}

