/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.utils.FloatArray;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;
import java.util.concurrent.atomic.AtomicInteger;

public class VertexAttachment
extends Attachment {
    private static final AtomicInteger nextID = new AtomicInteger();
    private final int id = (nextID.getAndIncrement() & 0xFFFF) << 11;
    int[] bones;
    float[] vertices;
    int worldVerticesLength;

    public VertexAttachment(String string) {
        super(string);
    }

    public void computeWorldVertices(Slot slot, int n, int n2, float[] fArray, int n3, int n4) {
        int n5;
        n2 = n3 + (n2 >> 1) * n4;
        Skeleton skeleton = slot.getSkeleton();
        FloatArray floatArray = slot.getAttachmentVertices();
        float[] fArray2 = this.vertices;
        int[] nArray = this.bones;
        if (nArray == null) {
            if (floatArray.size > 0) {
                fArray2 = floatArray.items;
            }
            Bone bone = slot.getBone();
            float f = bone.getWorldX();
            float f2 = bone.getWorldY();
            float f3 = bone.getA();
            float f4 = bone.getB();
            float f5 = bone.getC();
            float f6 = bone.getD();
            int n6 = n;
            for (int i = n3; i < n2; i += n4) {
                float f7 = fArray2[n6];
                float f8 = fArray2[n6 + 1];
                fArray[i] = f7 * f3 + f8 * f4 + f;
                fArray[i + 1] = f7 * f5 + f8 * f6 + f2;
                n6 += 2;
            }
            return;
        }
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < n; i += 2) {
            n5 = nArray[n7];
            n7 += n5 + 1;
            n8 += n5;
        }
        T[] TArray = skeleton.getBones().items;
        if (floatArray.size == 0) {
            int n9 = n8 * 3;
            for (n5 = n3; n5 < n2; n5 += n4) {
                float f = 0.0f;
                float f9 = 0.0f;
                int n10 = nArray[n7++];
                n10 += n7;
                while (n7 < n10) {
                    Bone bone = (Bone)TArray[nArray[n7]];
                    float f10 = fArray2[n9];
                    float f11 = fArray2[n9 + 1];
                    float f12 = fArray2[n9 + 2];
                    f += (f10 * bone.getA() + f11 * bone.getB() + bone.getWorldX()) * f12;
                    f9 += (f10 * bone.getC() + f11 * bone.getD() + bone.getWorldY()) * f12;
                    ++n7;
                    n9 += 3;
                }
                fArray[n5] = f;
                fArray[n5 + 1] = f9;
            }
        } else {
            float[] fArray3 = floatArray.items;
            int n11 = n8 * 3;
            int n12 = n8 << 1;
            for (int i = n3; i < n2; i += n4) {
                float f = 0.0f;
                float f13 = 0.0f;
                int n13 = nArray[n7++];
                n13 += n7;
                while (n7 < n13) {
                    Bone bone = (Bone)TArray[nArray[n7]];
                    float f14 = fArray2[n11] + fArray3[n12];
                    float f15 = fArray2[n11 + 1] + fArray3[n12 + 1];
                    float f16 = fArray2[n11 + 2];
                    f += (f14 * bone.getA() + f15 * bone.getB() + bone.getWorldX()) * f16;
                    f13 += (f14 * bone.getC() + f15 * bone.getD() + bone.getWorldY()) * f16;
                    ++n7;
                    n11 += 3;
                    n12 += 2;
                }
                fArray[i] = f;
                fArray[i + 1] = f13;
            }
        }
    }

    public boolean applyDeform(VertexAttachment vertexAttachment) {
        return this == vertexAttachment;
    }

    public int[] getBones() {
        return this.bones;
    }

    public void setBones(int[] nArray) {
        this.bones = nArray;
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public void setVertices(float[] fArray) {
        this.vertices = fArray;
    }

    public int getWorldVerticesLength() {
        return this.worldVerticesLength;
    }

    public void setWorldVerticesLength(int n) {
        this.worldVerticesLength = n;
    }

    public int getId() {
        return this.id;
    }
}

