/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g2d.PolygonBatch;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.NumberUtils;

public class TwoColorPolygonBatch
implements PolygonBatch {
    static final int VERTEX_SIZE = 6;
    static final int SPRITE_SIZE = 24;
    private final Mesh mesh;
    private final float[] vertices;
    private final short[] triangles;
    private final Matrix4 transformMatrix = new Matrix4();
    private final Matrix4 projectionMatrix = new Matrix4();
    private final Matrix4 combinedMatrix = new Matrix4();
    private boolean blendingDisabled;
    private final ShaderProgram defaultShader;
    private ShaderProgram shader;
    private int vertexIndex;
    private int triangleIndex;
    private Texture lastTexture;
    private float invTexWidth = 0.0f;
    private float invTexHeight = 0.0f;
    private boolean drawing;
    private int blendSrcFunc = 770;
    private int blendDstFunc = 771;
    private int blendSrcFuncAlpha = 770;
    private int blendDstFuncAlpha = 771;
    private boolean premultipliedAlpha;
    private final Color light = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private final Color dark = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    private float lightPacked = Color.WHITE.toFloatBits();
    private float darkPacked = Color.BLACK.toFloatBits();
    public int totalRenderCalls = 0;

    public TwoColorPolygonBatch() {
        this(2000);
    }

    public TwoColorPolygonBatch(int n) {
        this(n, n * 2);
    }

    public TwoColorPolygonBatch(int n, int n2) {
        if (n > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Can't have more than 32767 vertices per batch: " + n2);
        }
        Mesh.VertexDataType vertexDataType = Mesh.VertexDataType.VertexArray;
        if (Gdx.gl30 != null) {
            vertexDataType = Mesh.VertexDataType.VertexBufferObjectWithVAO;
        }
        this.mesh = new Mesh(vertexDataType, false, n, n2 * 3, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_light"), new VertexAttribute(4, 4, "a_dark"), new VertexAttribute(16, 2, "a_texCoord0"));
        this.vertices = new float[n * 6];
        this.triangles = new short[n2 * 3];
        this.shader = this.defaultShader = this.createDefaultShader();
        this.projectionMatrix.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    @Override
    public void begin() {
        if (this.drawing) {
            throw new IllegalStateException("end must be called before begin.");
        }
        Gdx.gl.glDepthMask(false);
        this.shader.begin();
        this.setupMatrices();
        this.drawing = true;
    }

    @Override
    public void end() {
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before end.");
        }
        if (this.vertexIndex > 0) {
            this.flush();
        }
        this.shader.end();
        Gdx.gl.glDepthMask(true);
        if (this.isBlendingEnabled()) {
            Gdx.gl.glDisable(3042);
        }
        this.lastTexture = null;
        this.drawing = false;
    }

    @Override
    public void setColor(Color color) {
        this.light.set(color);
        this.lightPacked = color.toFloatBits();
    }

    @Override
    public void setColor(float f, float f2, float f3, float f4) {
        this.light.set(f, f2, f3, f4);
        this.lightPacked = this.light.toFloatBits();
    }

    @Override
    public void setPackedColor(float f) {
        Color.rgba8888ToColor(this.light, NumberUtils.floatToIntColor(f));
        this.lightPacked = f;
    }

    @Override
    public Color getColor() {
        return this.light;
    }

    @Override
    public float getPackedColor() {
        return this.lightPacked;
    }

    public void setDarkColor(Color color) {
        this.dark.set(color);
        this.darkPacked = color.toFloatBits();
    }

    public void setDarkColor(float f, float f2, float f3, float f4) {
        this.dark.set(f, f2, f3, f4);
        this.darkPacked = this.dark.toFloatBits();
    }

    public void setPackedDarkColor(float f) {
        Color.rgba8888ToColor(this.dark, NumberUtils.floatToIntColor(f));
        this.darkPacked = f;
    }

    public Color getDarkColor() {
        return this.dark;
    }

    public float getPackedDarkColor() {
        return this.darkPacked;
    }

    @Override
    public void draw(PolygonRegion polygonRegion, float f, float f2) {
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        short[] sArray2 = polygonRegion.getTriangles();
        int n = sArray2.length;
        float[] fArray = polygonRegion.getVertices();
        int n2 = fArray.length;
        Texture texture = polygonRegion.getRegion().getTexture();
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + n > sArray.length || this.vertexIndex + n2 * 6 / 2 > this.vertices.length) {
            this.flush();
        }
        int n3 = this.triangleIndex;
        int n4 = this.vertexIndex;
        int n5 = n4 / 6;
        for (int i = 0; i < n; ++i) {
            sArray[n3++] = (short)(sArray2[i] + n5);
        }
        this.triangleIndex = n3;
        float[] fArray2 = this.vertices;
        float f3 = this.lightPacked;
        float f4 = this.darkPacked;
        float[] fArray3 = polygonRegion.getTextureCoords();
        for (int i = 0; i < n2; i += 2) {
            fArray2[n4++] = fArray[i] + f;
            fArray2[n4++] = fArray[i + 1] + f2;
            fArray2[n4++] = f3;
            fArray2[n4++] = f4;
            fArray2[n4++] = fArray3[i];
            fArray2[n4++] = fArray3[i + 1];
        }
        this.vertexIndex = n4;
    }

    @Override
    public void draw(PolygonRegion polygonRegion, float f, float f2, float f3, float f4) {
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        short[] sArray2 = polygonRegion.getTriangles();
        int n = sArray2.length;
        float[] fArray = polygonRegion.getVertices();
        int n2 = fArray.length;
        TextureRegion textureRegion = polygonRegion.getRegion();
        Texture texture = textureRegion.getTexture();
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + n > sArray.length || this.vertexIndex + n2 * 6 / 2 > this.vertices.length) {
            this.flush();
        }
        int n3 = this.triangleIndex;
        int n4 = this.vertexIndex;
        int n5 = n4 / 6;
        int n6 = sArray2.length;
        for (int i = 0; i < n6; ++i) {
            sArray[n3++] = (short)(sArray2[i] + n5);
        }
        this.triangleIndex = n3;
        float[] fArray2 = this.vertices;
        float f5 = this.lightPacked;
        float f6 = this.darkPacked;
        float[] fArray3 = polygonRegion.getTextureCoords();
        float f7 = f3 / (float)textureRegion.getRegionWidth();
        float f8 = f4 / (float)textureRegion.getRegionHeight();
        for (int i = 0; i < n2; i += 2) {
            fArray2[n4++] = fArray[i] * f7 + f;
            fArray2[n4++] = fArray[i + 1] * f8 + f2;
            fArray2[n4++] = f5;
            fArray2[n4++] = f6;
            fArray2[n4++] = fArray3[i];
            fArray2[n4++] = fArray3[i + 1];
        }
        this.vertexIndex = n4;
    }

    @Override
    public void draw(PolygonRegion polygonRegion, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        short[] sArray2 = polygonRegion.getTriangles();
        int n = sArray2.length;
        float[] fArray = polygonRegion.getVertices();
        int n2 = fArray.length;
        TextureRegion textureRegion = polygonRegion.getRegion();
        Texture texture = textureRegion.getTexture();
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + n > sArray.length || this.vertexIndex + n2 * 6 / 2 > this.vertices.length) {
            this.flush();
        }
        int n3 = this.triangleIndex;
        int n4 = this.vertexIndex;
        int n5 = n4 / 6;
        for (int i = 0; i < n; ++i) {
            sArray[n3++] = (short)(sArray2[i] + n5);
        }
        this.triangleIndex = n3;
        float[] fArray2 = this.vertices;
        float f10 = this.lightPacked;
        float f11 = this.darkPacked;
        float[] fArray3 = polygonRegion.getTextureCoords();
        float f12 = f + f3;
        float f13 = f2 + f4;
        float f14 = f5 / (float)textureRegion.getRegionWidth();
        float f15 = f6 / (float)textureRegion.getRegionHeight();
        float f16 = MathUtils.cosDeg(f9);
        float f17 = MathUtils.sinDeg(f9);
        for (int i = 0; i < n2; i += 2) {
            float f18 = (fArray[i] * f14 - f3) * f7;
            float f19 = (fArray[i + 1] * f15 - f4) * f8;
            fArray2[n4++] = f16 * f18 - f17 * f19 + f12;
            fArray2[n4++] = f17 * f18 + f16 * f19 + f13;
            fArray2[n4++] = f10;
            fArray2[n4++] = f11;
            fArray2[n4++] = fArray3[i];
            fArray2[n4++] = fArray3[i + 1];
        }
        this.vertexIndex = n4;
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        float f19;
        float f20;
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 24 > fArray.length) {
            this.flush();
        }
        int n5 = this.triangleIndex;
        int n6 = this.vertexIndex / 6;
        sArray[n5++] = (short)n6;
        sArray[n5++] = (short)(n6 + 1);
        sArray[n5++] = (short)(n6 + 2);
        sArray[n5++] = (short)(n6 + 2);
        sArray[n5++] = (short)(n6 + 3);
        sArray[n5++] = (short)n6;
        this.triangleIndex = n5;
        float f21 = f + f3;
        float f22 = f2 + f4;
        float f23 = -f3;
        float f24 = -f4;
        float f25 = f5 - f3;
        float f26 = f6 - f4;
        if (f7 != 1.0f || f8 != 1.0f) {
            f23 *= f7;
            f24 *= f8;
            f25 *= f7;
            f26 *= f8;
        }
        float f27 = f23;
        float f28 = f24;
        float f29 = f23;
        float f30 = f26;
        float f31 = f25;
        float f32 = f26;
        float f33 = f25;
        float f34 = f24;
        if (f9 != 0.0f) {
            f20 = MathUtils.cosDeg(f9);
            f19 = MathUtils.sinDeg(f9);
            f18 = f20 * f27 - f19 * f28;
            f17 = f19 * f27 + f20 * f28;
            f16 = f20 * f29 - f19 * f30;
            f15 = f19 * f29 + f20 * f30;
            f14 = f20 * f31 - f19 * f32;
            f13 = f19 * f31 + f20 * f32;
            f12 = f18 + (f14 - f16);
            f11 = f13 - (f15 - f17);
        } else {
            f18 = f27;
            f17 = f28;
            f16 = f29;
            f15 = f30;
            f14 = f31;
            f13 = f32;
            f12 = f33;
            f11 = f34;
        }
        f18 += f21;
        f17 += f22;
        f16 += f21;
        f15 += f22;
        f14 += f21;
        f13 += f22;
        f12 += f21;
        f11 += f22;
        f20 = (float)n * this.invTexWidth;
        f19 = (float)(n2 + n4) * this.invTexHeight;
        float f35 = (float)(n + n3) * this.invTexWidth;
        float f36 = (float)n2 * this.invTexHeight;
        if (bl) {
            f10 = f20;
            f20 = f35;
            f35 = f10;
        }
        if (bl2) {
            f10 = f19;
            f19 = f36;
            f36 = f10;
        }
        f10 = this.lightPacked;
        float f37 = this.darkPacked;
        int n7 = this.vertexIndex;
        fArray[n7++] = f18;
        fArray[n7++] = f17;
        fArray[n7++] = f10;
        fArray[n7++] = f37;
        fArray[n7++] = f20;
        fArray[n7++] = f19;
        fArray[n7++] = f16;
        fArray[n7++] = f15;
        fArray[n7++] = f10;
        fArray[n7++] = f37;
        fArray[n7++] = f20;
        fArray[n7++] = f36;
        fArray[n7++] = f14;
        fArray[n7++] = f13;
        fArray[n7++] = f10;
        fArray[n7++] = f37;
        fArray[n7++] = f35;
        fArray[n7++] = f36;
        fArray[n7++] = f12;
        fArray[n7++] = f11;
        fArray[n7++] = f10;
        fArray[n7++] = f37;
        fArray[n7++] = f35;
        fArray[n7++] = f19;
        this.vertexIndex = n7;
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        float f5;
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 24 > fArray.length) {
            this.flush();
        }
        int n5 = this.triangleIndex;
        int n6 = this.vertexIndex / 6;
        sArray[n5++] = (short)n6;
        sArray[n5++] = (short)(n6 + 1);
        sArray[n5++] = (short)(n6 + 2);
        sArray[n5++] = (short)(n6 + 2);
        sArray[n5++] = (short)(n6 + 3);
        sArray[n5++] = (short)n6;
        this.triangleIndex = n5;
        float f6 = (float)n * this.invTexWidth;
        float f7 = (float)(n2 + n4) * this.invTexHeight;
        float f8 = (float)(n + n3) * this.invTexWidth;
        float f9 = (float)n2 * this.invTexHeight;
        float f10 = f + f3;
        float f11 = f2 + f4;
        if (bl) {
            f5 = f6;
            f6 = f8;
            f8 = f5;
        }
        if (bl2) {
            f5 = f7;
            f7 = f9;
            f9 = f5;
        }
        f5 = this.lightPacked;
        float f12 = this.darkPacked;
        int n7 = this.vertexIndex;
        fArray[n7++] = f;
        fArray[n7++] = f2;
        fArray[n7++] = f5;
        fArray[n7++] = f12;
        fArray[n7++] = f6;
        fArray[n7++] = f7;
        fArray[n7++] = f;
        fArray[n7++] = f11;
        fArray[n7++] = f5;
        fArray[n7++] = f12;
        fArray[n7++] = f6;
        fArray[n7++] = f9;
        fArray[n7++] = f10;
        fArray[n7++] = f11;
        fArray[n7++] = f5;
        fArray[n7++] = f12;
        fArray[n7++] = f8;
        fArray[n7++] = f9;
        fArray[n7++] = f10;
        fArray[n7++] = f2;
        fArray[n7++] = f5;
        fArray[n7++] = f12;
        fArray[n7++] = f8;
        fArray[n7++] = f7;
        this.vertexIndex = n7;
    }

    @Override
    public void draw(Texture texture, float f, float f2, int n, int n2, int n3, int n4) {
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 24 > fArray.length) {
            this.flush();
        }
        int n5 = this.triangleIndex;
        int n6 = this.vertexIndex / 6;
        sArray[n5++] = (short)n6;
        sArray[n5++] = (short)(n6 + 1);
        sArray[n5++] = (short)(n6 + 2);
        sArray[n5++] = (short)(n6 + 2);
        sArray[n5++] = (short)(n6 + 3);
        sArray[n5++] = (short)n6;
        this.triangleIndex = n5;
        float f3 = (float)n * this.invTexWidth;
        float f4 = (float)(n2 + n4) * this.invTexHeight;
        float f5 = (float)(n + n3) * this.invTexWidth;
        float f6 = (float)n2 * this.invTexHeight;
        float f7 = f + (float)n3;
        float f8 = f2 + (float)n4;
        float f9 = this.lightPacked;
        float f10 = this.darkPacked;
        int n7 = this.vertexIndex;
        fArray[n7++] = f;
        fArray[n7++] = f2;
        fArray[n7++] = f9;
        fArray[n7++] = f10;
        fArray[n7++] = f3;
        fArray[n7++] = f4;
        fArray[n7++] = f;
        fArray[n7++] = f8;
        fArray[n7++] = f9;
        fArray[n7++] = f10;
        fArray[n7++] = f3;
        fArray[n7++] = f6;
        fArray[n7++] = f7;
        fArray[n7++] = f8;
        fArray[n7++] = f9;
        fArray[n7++] = f10;
        fArray[n7++] = f5;
        fArray[n7++] = f6;
        fArray[n7++] = f7;
        fArray[n7++] = f2;
        fArray[n7++] = f9;
        fArray[n7++] = f10;
        fArray[n7++] = f5;
        fArray[n7++] = f4;
        this.vertexIndex = n7;
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 24 > fArray.length) {
            this.flush();
        }
        int n = this.triangleIndex;
        int n2 = this.vertexIndex / 6;
        sArray[n++] = (short)n2;
        sArray[n++] = (short)(n2 + 1);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 3);
        sArray[n++] = (short)n2;
        this.triangleIndex = n;
        float f9 = f + f3;
        float f10 = f2 + f4;
        float f11 = this.lightPacked;
        float f12 = this.darkPacked;
        int n3 = this.vertexIndex;
        fArray[n3++] = f;
        fArray[n3++] = f2;
        fArray[n3++] = f11;
        fArray[n3++] = f12;
        fArray[n3++] = f5;
        fArray[n3++] = f6;
        fArray[n3++] = f;
        fArray[n3++] = f10;
        fArray[n3++] = f11;
        fArray[n3++] = f12;
        fArray[n3++] = f5;
        fArray[n3++] = f8;
        fArray[n3++] = f9;
        fArray[n3++] = f10;
        fArray[n3++] = f11;
        fArray[n3++] = f12;
        fArray[n3++] = f7;
        fArray[n3++] = f8;
        fArray[n3++] = f9;
        fArray[n3++] = f2;
        fArray[n3++] = f11;
        fArray[n3++] = f12;
        fArray[n3++] = f7;
        fArray[n3++] = f6;
        this.vertexIndex = n3;
    }

    @Override
    public void draw(Texture texture, float f, float f2) {
        this.draw(texture, f, f2, (float)texture.getWidth(), (float)texture.getHeight());
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4) {
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 24 > fArray.length) {
            this.flush();
        }
        int n = this.triangleIndex;
        int n2 = this.vertexIndex / 6;
        sArray[n++] = (short)n2;
        sArray[n++] = (short)(n2 + 1);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 3);
        sArray[n++] = (short)n2;
        this.triangleIndex = n;
        float f5 = f + f3;
        float f6 = f2 + f4;
        float f7 = this.lightPacked;
        float f8 = this.darkPacked;
        int n3 = this.vertexIndex;
        fArray[n3++] = f;
        fArray[n3++] = f2;
        fArray[n3++] = f7;
        fArray[n3++] = f8;
        fArray[n3++] = 0.0f;
        fArray[n3++] = 1.0f;
        fArray[n3++] = f;
        fArray[n3++] = f6;
        fArray[n3++] = f7;
        fArray[n3++] = f8;
        fArray[n3++] = 0.0f;
        fArray[n3++] = 0.0f;
        fArray[n3++] = f5;
        fArray[n3++] = f6;
        fArray[n3++] = f7;
        fArray[n3++] = f8;
        fArray[n3++] = 1.0f;
        fArray[n3++] = 0.0f;
        fArray[n3++] = f5;
        fArray[n3++] = f2;
        fArray[n3++] = f7;
        fArray[n3++] = f8;
        fArray[n3++] = 1.0f;
        fArray[n3++] = 1.0f;
        this.vertexIndex = n3;
    }

    public void drawTwoColor(Texture texture, float[] fArray, int n, int n2, short[] sArray, int n3, int n4) {
        int n5;
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray2 = this.triangles;
        float[] fArray2 = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + n4 > sArray2.length || this.vertexIndex + n2 > fArray2.length) {
            this.flush();
        }
        int n6 = this.triangleIndex;
        int n7 = this.vertexIndex;
        int n8 = n7 / 6;
        int n9 = n5 + n4;
        for (n5 = n3; n5 < n9; ++n5) {
            sArray2[n6++] = (short)(sArray[n5] + n8);
        }
        this.triangleIndex = n6;
        System.arraycopy(fArray, n, fArray2, n7, n2);
        this.vertexIndex += n2;
    }

    @Override
    public void draw(Texture texture, float[] fArray, int n, int n2, short[] sArray, int n3, int n4) {
        int n5;
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray2 = this.triangles;
        float[] fArray2 = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + n4 > sArray2.length || this.vertexIndex + n2 / 5 * 6 > fArray2.length) {
            this.flush();
        }
        int n6 = this.triangleIndex;
        int n7 = this.vertexIndex;
        int n8 = n7 / 6;
        int n9 = n5 + n4;
        for (n5 = n3; n5 < n9; ++n5) {
            sArray2[n6++] = (short)(sArray[n5] + n8);
        }
        this.triangleIndex = n6;
        n5 = this.vertexIndex;
        int n10 = n + n2;
        for (n9 = n; n9 < n10; n9 += 5) {
            fArray2[n5++] = fArray[n9];
            fArray2[n5++] = fArray[n9 + 1];
            fArray2[n5++] = fArray[n9 + 2];
            fArray2[n5++] = 0.0f;
            fArray2[n5++] = fArray[n9 + 3];
            fArray2[n5++] = fArray[n9 + 4];
        }
        this.vertexIndex = n5;
    }

    public void drawTwoColor(Texture texture, float[] fArray, int n, int n2) {
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray2 = this.vertices;
        int n3 = n2 / 24 * 6;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + n3 > sArray.length || this.vertexIndex + n2 > fArray2.length) {
            this.flush();
        }
        int n4 = this.vertexIndex;
        int n5 = this.triangleIndex;
        short s = (short)(n4 / 6);
        int n6 = n5 + n3;
        while (n5 < n6) {
            sArray[n5] = s;
            sArray[n5 + 1] = (short)(s + 1);
            sArray[n5 + 2] = (short)(s + 2);
            sArray[n5 + 3] = (short)(s + 2);
            sArray[n5 + 4] = (short)(s + 3);
            sArray[n5 + 5] = s;
            n5 += 6;
            s = (short)(s + 4);
        }
        this.triangleIndex = n5;
        System.arraycopy(fArray, n, fArray2, n4, n2);
        this.vertexIndex += n2;
    }

    @Override
    public void draw(Texture texture, float[] fArray, int n, int n2) {
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray2 = this.vertices;
        int n3 = n2 / 20 * 6;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + n3 > sArray.length || this.vertexIndex + n2 / 5 * 6 > fArray2.length) {
            this.flush();
        }
        int n4 = this.vertexIndex;
        int n5 = this.triangleIndex;
        short s = (short)(n4 / 6);
        int n6 = n5 + n3;
        while (n5 < n6) {
            sArray[n5] = s;
            sArray[n5 + 1] = (short)(s + 1);
            sArray[n5 + 2] = (short)(s + 2);
            sArray[n5 + 3] = (short)(s + 2);
            sArray[n5 + 4] = (short)(s + 3);
            sArray[n5 + 5] = s;
            n5 += 6;
            s = (short)(s + 4);
        }
        this.triangleIndex = n5;
        n6 = this.vertexIndex;
        int n7 = n + n2;
        for (int i = n; i < n7; i += 5) {
            fArray2[n6++] = fArray[i];
            fArray2[n6++] = fArray[i + 1];
            fArray2[n6++] = fArray[i + 2];
            fArray2[n6++] = 0.0f;
            fArray2[n6++] = fArray[i + 3];
            fArray2[n6++] = fArray[i + 4];
        }
        this.vertexIndex = n6;
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2) {
        this.draw(textureRegion, f, f2, (float)textureRegion.getRegionWidth(), (float)textureRegion.getRegionHeight());
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, float f3, float f4) {
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        Texture texture = textureRegion.getTexture();
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 24 > fArray.length) {
            this.flush();
        }
        int n = this.triangleIndex;
        int n2 = this.vertexIndex / 6;
        sArray[n++] = (short)n2;
        sArray[n++] = (short)(n2 + 1);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 3);
        sArray[n++] = (short)n2;
        this.triangleIndex = n;
        float f5 = f + f3;
        float f6 = f2 + f4;
        float f7 = textureRegion.getU();
        float f8 = textureRegion.getV2();
        float f9 = textureRegion.getU2();
        float f10 = textureRegion.getV();
        float f11 = this.lightPacked;
        float f12 = this.darkPacked;
        int n3 = this.vertexIndex;
        fArray[n3++] = f;
        fArray[n3++] = f2;
        fArray[n3++] = f11;
        fArray[n3++] = f12;
        fArray[n3++] = f7;
        fArray[n3++] = f8;
        fArray[n3++] = f;
        fArray[n3++] = f6;
        fArray[n3++] = f11;
        fArray[n3++] = f12;
        fArray[n3++] = f7;
        fArray[n3++] = f10;
        fArray[n3++] = f5;
        fArray[n3++] = f6;
        fArray[n3++] = f11;
        fArray[n3++] = f12;
        fArray[n3++] = f9;
        fArray[n3++] = f10;
        fArray[n3++] = f5;
        fArray[n3++] = f2;
        fArray[n3++] = f11;
        fArray[n3++] = f12;
        fArray[n3++] = f9;
        fArray[n3++] = f8;
        this.vertexIndex = n3;
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        float f19;
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        Texture texture = textureRegion.getTexture();
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 24 > fArray.length) {
            this.flush();
        }
        int n = this.triangleIndex;
        int n2 = this.vertexIndex / 6;
        sArray[n++] = (short)n2;
        sArray[n++] = (short)(n2 + 1);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 3);
        sArray[n++] = (short)n2;
        this.triangleIndex = n;
        float f20 = f + f3;
        float f21 = f2 + f4;
        float f22 = -f3;
        float f23 = -f4;
        float f24 = f5 - f3;
        float f25 = f6 - f4;
        if (f7 != 1.0f || f8 != 1.0f) {
            f22 *= f7;
            f23 *= f8;
            f24 *= f7;
            f25 *= f8;
        }
        float f26 = f22;
        float f27 = f23;
        float f28 = f22;
        float f29 = f25;
        float f30 = f24;
        float f31 = f25;
        float f32 = f24;
        float f33 = f23;
        if (f9 != 0.0f) {
            f19 = MathUtils.cosDeg(f9);
            f18 = MathUtils.sinDeg(f9);
            f17 = f19 * f26 - f18 * f27;
            f16 = f18 * f26 + f19 * f27;
            f15 = f19 * f28 - f18 * f29;
            f14 = f18 * f28 + f19 * f29;
            f13 = f19 * f30 - f18 * f31;
            f12 = f18 * f30 + f19 * f31;
            f11 = f17 + (f13 - f15);
            f10 = f12 - (f14 - f16);
        } else {
            f17 = f26;
            f16 = f27;
            f15 = f28;
            f14 = f29;
            f13 = f30;
            f12 = f31;
            f11 = f32;
            f10 = f33;
        }
        f17 += f20;
        f16 += f21;
        f15 += f20;
        f14 += f21;
        f13 += f20;
        f12 += f21;
        f11 += f20;
        f10 += f21;
        f19 = textureRegion.getU();
        f18 = textureRegion.getV2();
        float f34 = textureRegion.getU2();
        float f35 = textureRegion.getV();
        float f36 = this.lightPacked;
        float f37 = this.darkPacked;
        int n3 = this.vertexIndex;
        fArray[n3++] = f17;
        fArray[n3++] = f16;
        fArray[n3++] = f36;
        fArray[n3++] = f37;
        fArray[n3++] = f19;
        fArray[n3++] = f18;
        fArray[n3++] = f15;
        fArray[n3++] = f14;
        fArray[n3++] = f36;
        fArray[n3++] = f37;
        fArray[n3++] = f19;
        fArray[n3++] = f35;
        fArray[n3++] = f13;
        fArray[n3++] = f12;
        fArray[n3++] = f36;
        fArray[n3++] = f37;
        fArray[n3++] = f34;
        fArray[n3++] = f35;
        fArray[n3++] = f11;
        fArray[n3++] = f10;
        fArray[n3++] = f36;
        fArray[n3++] = f37;
        fArray[n3++] = f34;
        fArray[n3++] = f18;
        this.vertexIndex = n3;
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, boolean bl) {
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        float f19;
        float f20;
        float f21;
        float f22;
        float f23;
        float f24;
        float f25;
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        Texture texture = textureRegion.getTexture();
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 24 > fArray.length) {
            this.flush();
        }
        int n = this.triangleIndex;
        int n2 = this.vertexIndex / 6;
        sArray[n++] = (short)n2;
        sArray[n++] = (short)(n2 + 1);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 3);
        sArray[n++] = (short)n2;
        this.triangleIndex = n;
        float f26 = f + f3;
        float f27 = f2 + f4;
        float f28 = -f3;
        float f29 = -f4;
        float f30 = f5 - f3;
        float f31 = f6 - f4;
        if (f7 != 1.0f || f8 != 1.0f) {
            f28 *= f7;
            f29 *= f8;
            f30 *= f7;
            f31 *= f8;
        }
        float f32 = f28;
        float f33 = f29;
        float f34 = f28;
        float f35 = f31;
        float f36 = f30;
        float f37 = f31;
        float f38 = f30;
        float f39 = f29;
        if (f9 != 0.0f) {
            f25 = MathUtils.cosDeg(f9);
            f24 = MathUtils.sinDeg(f9);
            f23 = f25 * f32 - f24 * f33;
            f22 = f24 * f32 + f25 * f33;
            f21 = f25 * f34 - f24 * f35;
            f20 = f24 * f34 + f25 * f35;
            f19 = f25 * f36 - f24 * f37;
            f18 = f24 * f36 + f25 * f37;
            f17 = f23 + (f19 - f21);
            f16 = f18 - (f20 - f22);
        } else {
            f23 = f32;
            f22 = f33;
            f21 = f34;
            f20 = f35;
            f19 = f36;
            f18 = f37;
            f17 = f38;
            f16 = f39;
        }
        f23 += f26;
        f22 += f27;
        f21 += f26;
        f20 += f27;
        f19 += f26;
        f18 += f27;
        f17 += f26;
        f16 += f27;
        if (bl) {
            f25 = textureRegion.getU2();
            f24 = textureRegion.getV2();
            f15 = textureRegion.getU();
            f14 = textureRegion.getV2();
            f13 = textureRegion.getU();
            f12 = textureRegion.getV();
            f11 = textureRegion.getU2();
            f10 = textureRegion.getV();
        } else {
            f25 = textureRegion.getU();
            f24 = textureRegion.getV();
            f15 = textureRegion.getU2();
            f14 = textureRegion.getV();
            f13 = textureRegion.getU2();
            f12 = textureRegion.getV2();
            f11 = textureRegion.getU();
            f10 = textureRegion.getV2();
        }
        float f40 = this.lightPacked;
        float f41 = this.darkPacked;
        int n3 = this.vertexIndex;
        fArray[n3++] = f23;
        fArray[n3++] = f22;
        fArray[n3++] = f40;
        fArray[n3++] = f41;
        fArray[n3++] = f25;
        fArray[n3++] = f24;
        fArray[n3++] = f21;
        fArray[n3++] = f20;
        fArray[n3++] = f40;
        fArray[n3++] = f41;
        fArray[n3++] = f15;
        fArray[n3++] = f14;
        fArray[n3++] = f19;
        fArray[n3++] = f18;
        fArray[n3++] = f40;
        fArray[n3++] = f41;
        fArray[n3++] = f13;
        fArray[n3++] = f12;
        fArray[n3++] = f17;
        fArray[n3++] = f16;
        fArray[n3++] = f40;
        fArray[n3++] = f41;
        fArray[n3++] = f11;
        fArray[n3++] = f10;
        this.vertexIndex = n3;
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, Affine2 affine2) {
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before draw.");
        }
        short[] sArray = this.triangles;
        float[] fArray = this.vertices;
        Texture texture = textureRegion.getTexture();
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 24 > fArray.length) {
            this.flush();
        }
        int n = this.triangleIndex;
        int n2 = this.vertexIndex / 6;
        sArray[n++] = (short)n2;
        sArray[n++] = (short)(n2 + 1);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 3);
        sArray[n++] = (short)n2;
        this.triangleIndex = n;
        float f3 = affine2.m02;
        float f4 = affine2.m12;
        float f5 = affine2.m01 * f2 + affine2.m02;
        float f6 = affine2.m11 * f2 + affine2.m12;
        float f7 = affine2.m00 * f + affine2.m01 * f2 + affine2.m02;
        float f8 = affine2.m10 * f + affine2.m11 * f2 + affine2.m12;
        float f9 = affine2.m00 * f + affine2.m02;
        float f10 = affine2.m10 * f + affine2.m12;
        float f11 = textureRegion.getU();
        float f12 = textureRegion.getV2();
        float f13 = textureRegion.getU2();
        float f14 = textureRegion.getV();
        float f15 = this.lightPacked;
        float f16 = this.darkPacked;
        int n3 = this.vertexIndex;
        fArray[n3++] = f3;
        fArray[n3++] = f4;
        fArray[n3++] = f15;
        fArray[n3++] = f16;
        fArray[n3++] = f11;
        fArray[n3++] = f12;
        fArray[n3++] = f5;
        fArray[n3++] = f6;
        fArray[n3++] = f15;
        fArray[n3++] = f16;
        fArray[n3++] = f11;
        fArray[n3++] = f14;
        fArray[n3++] = f7;
        fArray[n3++] = f8;
        fArray[n3++] = f15;
        fArray[n3++] = f16;
        fArray[n3++] = f13;
        fArray[n3++] = f14;
        fArray[n3++] = f9;
        fArray[n3++] = f10;
        fArray[n3++] = f15;
        fArray[n3++] = f16;
        fArray[n3++] = f13;
        fArray[n3++] = f12;
        this.vertexIndex = n3;
    }

    @Override
    public void flush() {
        if (this.vertexIndex == 0) {
            return;
        }
        ++this.totalRenderCalls;
        this.lastTexture.bind();
        Mesh mesh = this.mesh;
        mesh.setVertices(this.vertices, 0, this.vertexIndex);
        mesh.setIndices(this.triangles, 0, this.triangleIndex);
        Gdx.gl.glEnable(3042);
        if (this.blendSrcFunc != -1) {
            Gdx.gl.glBlendFuncSeparate(this.blendSrcFunc, this.blendDstFunc, this.blendSrcFuncAlpha, this.blendDstFuncAlpha);
        }
        mesh.render(this.shader, 4, 0, this.triangleIndex);
        this.vertexIndex = 0;
        this.triangleIndex = 0;
    }

    @Override
    public void disableBlending() {
        this.flush();
        this.blendingDisabled = true;
    }

    @Override
    public void enableBlending() {
        this.flush();
        this.blendingDisabled = false;
    }

    @Override
    public void dispose() {
        this.mesh.dispose();
        this.shader.dispose();
    }

    @Override
    public Matrix4 getProjectionMatrix() {
        return this.projectionMatrix;
    }

    @Override
    public Matrix4 getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public void setProjectionMatrix(Matrix4 matrix4) {
        if (this.drawing) {
            this.flush();
        }
        this.projectionMatrix.set(matrix4);
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    @Override
    public void setTransformMatrix(Matrix4 matrix4) {
        if (this.drawing) {
            this.flush();
        }
        this.transformMatrix.set(matrix4);
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    public void setPremultipliedAlpha(boolean bl) {
        if (this.premultipliedAlpha == bl) {
            return;
        }
        if (this.drawing) {
            this.flush();
        }
        this.premultipliedAlpha = bl;
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    private void setupMatrices() {
        this.combinedMatrix.set(this.projectionMatrix).mul(this.transformMatrix);
        this.shader.setUniformf("u_pma", this.premultipliedAlpha ? 1.0f : 0.0f);
        this.shader.setUniformMatrix("u_projTrans", this.combinedMatrix);
        this.shader.setUniformi("u_texture", 0);
    }

    private void switchTexture(Texture texture) {
        this.flush();
        this.lastTexture = texture;
        this.invTexWidth = 1.0f / (float)texture.getWidth();
        this.invTexHeight = 1.0f / (float)texture.getHeight();
    }

    @Override
    public void setShader(ShaderProgram shaderProgram) {
        if (this.shader == shaderProgram) {
            return;
        }
        if (this.drawing) {
            this.flush();
            this.shader.end();
        }
        ShaderProgram shaderProgram2 = this.shader = shaderProgram == null ? this.defaultShader : shaderProgram;
        if (this.drawing) {
            this.shader.begin();
            this.setupMatrices();
        }
    }

    @Override
    public ShaderProgram getShader() {
        return this.shader;
    }

    @Override
    public boolean isBlendingEnabled() {
        return !this.blendingDisabled;
    }

    @Override
    public boolean isDrawing() {
        return this.drawing;
    }

    @Override
    public void setBlendFunction(int n, int n2) {
        this.setBlendFunctionSeparate(n, n2, n, n2);
    }

    @Override
    public void setBlendFunctionSeparate(int n, int n2, int n3, int n4) {
        if (this.blendSrcFunc == n && this.blendDstFunc == n2 && this.blendSrcFuncAlpha == n3 && this.blendDstFuncAlpha == n4) {
            return;
        }
        this.flush();
        this.blendSrcFunc = n;
        this.blendDstFunc = n2;
        this.blendSrcFuncAlpha = n3;
        this.blendDstFuncAlpha = n4;
    }

    @Override
    public int getBlendSrcFunc() {
        return this.blendSrcFunc;
    }

    @Override
    public int getBlendDstFunc() {
        return this.blendDstFunc;
    }

    @Override
    public int getBlendSrcFuncAlpha() {
        return this.blendSrcFuncAlpha;
    }

    @Override
    public int getBlendDstFuncAlpha() {
        return this.blendDstFuncAlpha;
    }

    private ShaderProgram createDefaultShader() {
        String string = "attribute vec4 a_position;\nattribute vec4 a_light;\nattribute vec4 a_dark;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_light;\nvarying vec4 v_dark;\nvarying vec2 v_texCoords;\n\nvoid main()\n{\n   v_light = a_light;\n   v_light.a = v_light.a * (255.0/254.0);\n   v_dark = a_dark;\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projTrans * a_position;\n}\n";
        String string2 = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying LOWP vec4 v_light;\nvarying LOWP vec4 v_dark;\nuniform float u_pma;\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nvoid main()\n{\n  vec4 texColor = texture2D(u_texture, v_texCoords);\n  gl_FragColor.a = texColor.a * v_light.a;\n  gl_FragColor.rgb = ((texColor.a - 1.0) * u_pma + 1.0 - texColor.rgb) * v_dark.rgb + texColor.rgb * v_light.rgb;\n}";
        ShaderProgram shaderProgram = new ShaderProgram(string, string2);
        if (!shaderProgram.isCompiled()) {
            throw new IllegalArgumentException("Error compiling shader: " + shaderProgram.getLog());
        }
        return shaderProgram;
    }
}

