/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.AbstractInput;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputEventQueue;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.backends.lwjgl.LwjglInput;
import com.badlogic.gdx.utils.IntSet;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public final class DefaultLwjglInput
extends AbstractInput
implements LwjglInput {
    public static float keyRepeatInitialTime = 0.4f;
    public static float keyRepeatTime = 0.1f;
    final InputEventQueue eventQueue = new InputEventQueue();
    int deltaX;
    int deltaY;
    final boolean[] justPressedButtons = new boolean[5];
    boolean justTouched;
    final IntSet pressedButtons = new IntSet();
    InputProcessor processor;
    char lastKeyCharPressed;
    float keyRepeatTimer;
    float deltaTime;
    long lastTime;

    public DefaultLwjglInput() {
        Keyboard.enableRepeatEvents(false);
        Mouse.setClipMouseCoordinatesToWindow(false);
    }

    @Override
    public int getX() {
        return (int)((float)Mouse.getX() * Display.getPixelScaleFactor());
    }

    @Override
    public int getY() {
        return Gdx.graphics.getHeight() - 1 - (int)((float)Mouse.getY() * Display.getPixelScaleFactor());
    }

    @Override
    public boolean isTouched() {
        boolean button = Mouse.isButtonDown(0) || Mouse.isButtonDown(1) || Mouse.isButtonDown(2);
        return button;
    }

    @Override
    public boolean isTouched(int pointer) {
        if (pointer > 0) {
            return false;
        }
        return this.isTouched();
    }

    @Override
    public void processEvents() {
        this.eventQueue.drain(this.processor);
    }

    public int getGdxKeyCode(int lwjglKeyCode) {
        switch (lwjglKeyCode) {
            case 26: {
                return 71;
            }
            case 27: {
                return 72;
            }
            case 41: {
                return 68;
            }
            case 55: {
                return 155;
            }
            case 197: {
                return 121;
            }
            case 58: {
                return 115;
            }
            case 183: {
                return 120;
            }
            case 70: {
                return 116;
            }
            case 69: {
                return 143;
            }
            case 83: {
                return 158;
            }
            case 181: {
                return 154;
            }
            case 219: {
                return 63;
            }
            case 220: {
                return 63;
            }
            case 141: {
                return 161;
            }
            case 145: {
                return 77;
            }
            case 13: {
                return 70;
            }
            case 179: {
                return 159;
            }
            case 156: {
                return 160;
            }
            case 11: {
                return 7;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 9;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 12;
            }
            case 7: {
                return 13;
            }
            case 8: {
                return 14;
            }
            case 9: {
                return 15;
            }
            case 10: {
                return 16;
            }
            case 30: {
                return 29;
            }
            case 48: {
                return 30;
            }
            case 46: {
                return 31;
            }
            case 32: {
                return 32;
            }
            case 18: {
                return 33;
            }
            case 33: {
                return 34;
            }
            case 34: {
                return 35;
            }
            case 35: {
                return 36;
            }
            case 23: {
                return 37;
            }
            case 36: {
                return 38;
            }
            case 37: {
                return 39;
            }
            case 38: {
                return 40;
            }
            case 50: {
                return 41;
            }
            case 49: {
                return 42;
            }
            case 24: {
                return 43;
            }
            case 25: {
                return 44;
            }
            case 16: {
                return 45;
            }
            case 19: {
                return 46;
            }
            case 31: {
                return 47;
            }
            case 20: {
                return 48;
            }
            case 22: {
                return 49;
            }
            case 47: {
                return 50;
            }
            case 17: {
                return 51;
            }
            case 45: {
                return 52;
            }
            case 21: {
                return 53;
            }
            case 44: {
                return 54;
            }
            case 56: {
                return 57;
            }
            case 184: {
                return 58;
            }
            case 43: {
                return 73;
            }
            case 51: {
                return 55;
            }
            case 211: {
                return 112;
            }
            case 203: {
                return 21;
            }
            case 205: {
                return 22;
            }
            case 200: {
                return 19;
            }
            case 208: {
                return 20;
            }
            case 28: {
                return 66;
            }
            case 199: {
                return 3;
            }
            case 12: {
                return 69;
            }
            case 52: {
                return 56;
            }
            case 78: {
                return 157;
            }
            case 39: {
                return 74;
            }
            case 42: {
                return 59;
            }
            case 54: {
                return 60;
            }
            case 53: {
                return 76;
            }
            case 57: {
                return 62;
            }
            case 15: {
                return 61;
            }
            case 29: {
                return 129;
            }
            case 157: {
                return 130;
            }
            case 209: {
                return 93;
            }
            case 201: {
                return 92;
            }
            case 1: {
                return 111;
            }
            case 207: {
                return 123;
            }
            case 210: {
                return 124;
            }
            case 14: {
                return 67;
            }
            case 74: {
                return 156;
            }
            case 40: {
                return 75;
            }
            case 59: {
                return 131;
            }
            case 60: {
                return 132;
            }
            case 61: {
                return 133;
            }
            case 62: {
                return 134;
            }
            case 63: {
                return 135;
            }
            case 64: {
                return 136;
            }
            case 65: {
                return 137;
            }
            case 66: {
                return 138;
            }
            case 67: {
                return 139;
            }
            case 68: {
                return 140;
            }
            case 87: {
                return 141;
            }
            case 88: {
                return 142;
            }
            case 100: {
                return 183;
            }
            case 101: {
                return 184;
            }
            case 102: {
                return 185;
            }
            case 103: {
                return 186;
            }
            case 104: {
                return 187;
            }
            case 105: {
                return 188;
            }
            case 146: {
                return 243;
            }
            case 82: {
                return 144;
            }
            case 79: {
                return 145;
            }
            case 80: {
                return 146;
            }
            case 81: {
                return 147;
            }
            case 75: {
                return 148;
            }
            case 76: {
                return 149;
            }
            case 77: {
                return 150;
            }
            case 71: {
                return 151;
            }
            case 72: {
                return 152;
            }
            case 73: {
                return 153;
            }
        }
        return 0;
    }

    @Override
    public void update() {
        this.updateTime();
        this.updateMouse();
        this.updateKeyboard();
    }

    private int toGdxButton(int button) {
        if (button == 0) {
            return 0;
        }
        if (button == 1) {
            return 1;
        }
        if (button == 2) {
            return 2;
        }
        if (button == 3) {
            return 3;
        }
        if (button == 4) {
            return 4;
        }
        return -1;
    }

    void updateTime() {
        long thisTime = System.nanoTime();
        this.deltaTime = (float)(thisTime - this.lastTime) / 1.0E9f;
        this.lastTime = thisTime;
    }

    void updateMouse() {
        if (this.justTouched) {
            this.justTouched = false;
            for (int i = 0; i < this.justPressedButtons.length; ++i) {
                this.justPressedButtons[i] = false;
            }
        }
        if (Mouse.isCreated()) {
            int events = 0;
            while (Mouse.next()) {
                ++events;
                int x = (int)((float)Mouse.getEventX() * Display.getPixelScaleFactor());
                int y = Gdx.graphics.getHeight() - (int)((float)Mouse.getEventY() * Display.getPixelScaleFactor()) - 1;
                int button = Mouse.getEventButton();
                int gdxButton = this.toGdxButton(button);
                if (button != -1 && gdxButton == -1) continue;
                long time = Mouse.getEventNanoseconds();
                if (button == -1) {
                    if (Mouse.getEventDWheel() != 0) {
                        this.eventQueue.scrolled(0.0f, (int)(-Math.signum(Mouse.getEventDWheel())), time);
                    } else if (this.pressedButtons.size > 0) {
                        this.eventQueue.touchDragged(x, y, 0, time);
                    } else {
                        this.eventQueue.mouseMoved(x, y, time);
                    }
                } else if (Mouse.getEventButtonState()) {
                    this.eventQueue.touchDown(x, y, 0, gdxButton, time);
                    this.pressedButtons.add(gdxButton);
                    this.justPressedButtons[gdxButton] = true;
                    this.justTouched = true;
                } else {
                    this.eventQueue.touchUp(x, y, 0, gdxButton, time);
                    this.pressedButtons.remove(gdxButton);
                }
                this.deltaX = (int)((float)Mouse.getEventDX() * Display.getPixelScaleFactor());
                this.deltaY = (int)((float)Mouse.getEventDY() * Display.getPixelScaleFactor());
            }
            if (events == 0) {
                this.deltaX = 0;
                this.deltaY = 0;
            } else {
                Gdx.graphics.requestRendering();
            }
        }
    }

    void updateKeyboard() {
        if (this.keyJustPressed) {
            this.keyJustPressed = false;
            for (int i = 0; i < this.justPressedKeys.length; ++i) {
                this.justPressedKeys[i] = false;
            }
        }
        if (this.lastKeyCharPressed != '\u0000') {
            this.keyRepeatTimer -= this.deltaTime;
            if (this.keyRepeatTimer < 0.0f) {
                this.keyRepeatTimer = keyRepeatTime;
                this.eventQueue.keyTyped(this.lastKeyCharPressed, System.nanoTime());
                Gdx.graphics.requestRendering();
            }
        }
        if (Keyboard.isCreated()) {
            while (Keyboard.next()) {
                int keyCode = this.getGdxKeyCode(Keyboard.getEventKey());
                char keyChar = Keyboard.getEventCharacter();
                long time = Keyboard.getEventNanoseconds();
                if (Keyboard.getEventKeyState() || keyCode == 0 && keyChar != '\u0000' && Character.isDefined(keyChar)) {
                    switch (keyCode) {
                        case 67: {
                            keyChar = '\b';
                            break;
                        }
                        case 112: {
                            keyChar = '\u007f';
                        }
                    }
                    if (keyCode != 0) {
                        this.eventQueue.keyDown(keyCode, time);
                        ++this.pressedKeyCount;
                        this.keyJustPressed = true;
                        this.pressedKeys[keyCode] = true;
                        this.justPressedKeys[keyCode] = true;
                        this.lastKeyCharPressed = keyChar;
                        this.keyRepeatTimer = keyRepeatInitialTime;
                    }
                    this.eventQueue.keyTyped(keyChar, time);
                } else {
                    this.eventQueue.keyUp(keyCode, time);
                    --this.pressedKeyCount;
                    this.pressedKeys[keyCode] = false;
                    this.lastKeyCharPressed = '\u0000';
                }
                Gdx.graphics.requestRendering();
            }
        }
    }

    @Override
    public void setInputProcessor(InputProcessor processor) {
        this.processor = processor;
    }

    @Override
    public void setCursorCatched(boolean catched) {
        Mouse.setGrabbed(catched);
    }

    @Override
    public long getCurrentEventTime() {
        return this.eventQueue.getCurrentEventTime();
    }
}

