/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Gdx2DPixmap
implements Disposable {
    long basePtr;
    int width;
    int height;
    int format;
    ByteBuffer pixelPtr;
    long[] nativeData = new long[4];

    public static int toGlFormat(int format) {
        switch (format) {
            case 1: {
                return 6406;
            }
            case 2: {
                return 6410;
            }
            case 3: 
            case 5: {
                return 6407;
            }
            case 4: 
            case 6: {
                return 6408;
            }
        }
        throw new GdxRuntimeException("unknown format: " + format);
    }

    public static int toGlType(int format) {
        switch (format) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 5121;
            }
            case 5: {
                return 33635;
            }
            case 6: {
                return 32819;
            }
        }
        throw new GdxRuntimeException("unknown format: " + format);
    }

    public Gdx2DPixmap(byte[] encodedData, int offset, int len, int requestedFormat) throws IOException {
        this.pixelPtr = Gdx2DPixmap.load(this.nativeData, encodedData, offset, len);
        if (this.pixelPtr == null) {
            throw new IOException("Error loading pixmap: " + Gdx2DPixmap.getFailureReason());
        }
        this.basePtr = this.nativeData[0];
        this.width = (int)this.nativeData[1];
        this.height = (int)this.nativeData[2];
        this.format = (int)this.nativeData[3];
        if (requestedFormat != 0 && requestedFormat != this.format) {
            this.convert(requestedFormat);
        }
    }

    public Gdx2DPixmap(int width, int height, int format) throws GdxRuntimeException {
        this.pixelPtr = Gdx2DPixmap.newPixmap(this.nativeData, width, height, format);
        if (this.pixelPtr == null) {
            throw new GdxRuntimeException("Unable to allocate memory for pixmap: " + width + "x" + height + ", " + Gdx2DPixmap.getFormatString(format));
        }
        this.basePtr = this.nativeData[0];
        this.width = (int)this.nativeData[1];
        this.height = (int)this.nativeData[2];
        this.format = (int)this.nativeData[3];
    }

    private void convert(int requestedFormat) {
        Gdx2DPixmap pixmap = new Gdx2DPixmap(this.width, this.height, requestedFormat);
        pixmap.setBlend(0);
        pixmap.drawPixmap(this, 0, 0, 0, 0, this.width, this.height);
        this.dispose();
        this.basePtr = pixmap.basePtr;
        this.format = pixmap.format;
        this.height = pixmap.height;
        this.nativeData = pixmap.nativeData;
        this.pixelPtr = pixmap.pixelPtr;
        this.width = pixmap.width;
    }

    @Override
    public void dispose() {
        Gdx2DPixmap.free(this.basePtr);
    }

    public void clear(int color) {
        Gdx2DPixmap.clear(this.basePtr, color);
    }

    public void drawPixmap(Gdx2DPixmap src, int srcX, int srcY, int dstX, int dstY, int width, int height) {
        Gdx2DPixmap.drawPixmap(src.basePtr, this.basePtr, srcX, srcY, width, height, dstX, dstY, width, height);
    }

    public void drawPixmap(Gdx2DPixmap src, int srcX, int srcY, int srcWidth, int srcHeight, int dstX, int dstY, int dstWidth, int dstHeight) {
        Gdx2DPixmap.drawPixmap(src.basePtr, this.basePtr, srcX, srcY, srcWidth, srcHeight, dstX, dstY, dstWidth, dstHeight);
    }

    public void setBlend(int blend) {
        Gdx2DPixmap.setBlend(this.basePtr, blend);
    }

    public ByteBuffer getPixels() {
        return this.pixelPtr;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getFormat() {
        return this.format;
    }

    public int getGLInternalFormat() {
        return Gdx2DPixmap.toGlFormat(this.format);
    }

    public int getGLFormat() {
        return this.getGLInternalFormat();
    }

    public int getGLType() {
        return Gdx2DPixmap.toGlType(this.format);
    }

    private static String getFormatString(int format) {
        switch (format) {
            case 1: {
                return "alpha";
            }
            case 2: {
                return "luminance alpha";
            }
            case 3: {
                return "rgb888";
            }
            case 4: {
                return "rgba8888";
            }
            case 5: {
                return "rgb565";
            }
            case 6: {
                return "rgba4444";
            }
        }
        return "unknown";
    }

    private static native ByteBuffer load(long[] var0, byte[] var1, int var2, int var3);

    private static native ByteBuffer newPixmap(long[] var0, int var1, int var2, int var3);

    private static native void free(long var0);

    private static native void clear(long var0, int var2);

    private static native void drawPixmap(long var0, long var2, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    private static native void setBlend(long var0, int var2);

    public static native String getFailureReason();
}

