/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import java.util.NoSuchElementException;

public class OrderedMap<K, V>
extends ObjectMap<K, V> {
    final Array<K> keys;

    public OrderedMap() {
        this.keys = new Array();
    }

    public OrderedMap(int initialCapacity) {
        super(initialCapacity);
        this.keys = new Array(initialCapacity);
    }

    @Override
    public V put(K key, V value) {
        int i = this.locateKey(key);
        if (i >= 0) {
            Object oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return (V)oldValue;
        }
        i = -(i + 1);
        this.keyTable[i] = key;
        this.valueTable[i] = value;
        this.keys.add(key);
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    @Override
    public V remove(K key) {
        this.keys.removeValue(key, false);
        return super.remove(key);
    }

    public V removeIndex(int index) {
        return super.remove(this.keys.removeIndex(index));
    }

    @Override
    public void clear() {
        this.keys.clear();
        super.clear();
    }

    public Array<K> orderedKeys() {
        return this.keys;
    }

    @Override
    public ObjectMap.Entries<K, V> iterator() {
        return this.entries();
    }

    @Override
    public ObjectMap.Entries<K, V> entries() {
        return new OrderedMapEntries(this);
    }

    @Override
    public ObjectMap.Values<V> values() {
        return new OrderedMapValues(this);
    }

    @Override
    public ObjectMap.Keys<K> keys() {
        return new OrderedMapKeys(this);
    }

    @Override
    protected String toString(String separator, boolean braces) {
        if (this.size == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        Array<K> keys = this.keys;
        int n = keys.size;
        for (int i = 0; i < n; ++i) {
            K key = keys.get(i);
            if (i > 0) {
                buffer.append(separator);
            }
            buffer.append((Object)(key == this ? "(this)" : key));
            buffer.append('=');
            Object value = this.get(key);
            buffer.append((Object)(value == this ? "(this)" : value));
        }
        if (braces) {
            buffer.append('}');
        }
        return buffer.toString();
    }

    public static class OrderedMapEntries<K, V>
    extends ObjectMap.Entries<K, V> {
        private Array<K> keys;

        public OrderedMapEntries(OrderedMap<K, V> map) {
            super(map);
            this.keys = map.keys;
        }

        @Override
        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = 0;
            this.hasNext = this.map.size > 0;
        }

        @Override
        public ObjectMap.Entry next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            this.currentIndex = this.nextIndex;
            this.entry.key = this.keys.get(this.nextIndex);
            this.entry.value = this.map.get(this.entry.key);
            ++this.nextIndex;
            this.hasNext = this.nextIndex < this.map.size;
            return this.entry;
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            this.map.remove(this.entry.key);
            --this.nextIndex;
            this.currentIndex = -1;
        }
    }

    public static class OrderedMapValues<V>
    extends ObjectMap.Values<V> {
        private Array keys;

        public OrderedMapValues(OrderedMap<?, V> map) {
            super(map);
            this.keys = map.keys;
        }

        @Override
        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = 0;
            this.hasNext = this.map.size > 0;
        }

        @Override
        public V next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object value = this.map.get(this.keys.get(this.nextIndex));
            this.currentIndex = this.nextIndex++;
            this.hasNext = this.nextIndex < this.map.size;
            return value;
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            ((OrderedMap)this.map).removeIndex(this.currentIndex);
            this.nextIndex = this.currentIndex;
            this.currentIndex = -1;
        }
    }

    public static class OrderedMapKeys<K>
    extends ObjectMap.Keys<K> {
        private Array<K> keys;

        public OrderedMapKeys(OrderedMap<K, ?> map) {
            super(map);
            this.keys = map.keys;
        }

        @Override
        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = 0;
            this.hasNext = this.map.size > 0;
        }

        @Override
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            K key = this.keys.get(this.nextIndex);
            this.currentIndex = this.nextIndex++;
            this.hasNext = this.nextIndex < this.map.size;
            return key;
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            ((OrderedMap)this.map).removeIndex(this.currentIndex);
            this.nextIndex = this.currentIndex;
            this.currentIndex = -1;
        }
    }
}

