/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonBinary;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonJson;
import com.esotericsoftware.spine.SkeletonRenderer;
import com.esotericsoftware.spine.SkeletonRendererDebug;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.utils.TwoColorPolygonBatch;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;

public class SkeletonViewer
extends ApplicationAdapter {
    static float uiScale = 1.0f;
    static String[] dataSuffixes = new String[]{".json", ".skel"};
    static String[] atlasSuffixes = new String[]{".atlas", "-pro.atlas", "-ess.atlas"};
    static String[] extraSuffixes = new String[]{"", ".txt", ".bytes"};
    static String[] args;
    UI ui;
    OrthographicCamera camera;
    TwoColorPolygonBatch batch;
    TextureAtlas atlas;
    SkeletonRenderer renderer;
    SkeletonRendererDebug debugRenderer;
    SkeletonData skeletonData;
    Skeleton skeleton;
    AnimationState state;
    FileHandle skeletonFile;
    long skeletonModified;
    long atlasModified;
    float lastModifiedCheck;
    float reloadTimer;
    StringBuilder status = new StringBuilder();
    Preferences prefs;

    @Override
    public void create() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                throwable.printStackTrace();
                Runtime.getRuntime().halt(0);
            }
        });
        this.prefs = Gdx.app.getPreferences("spine-skeletonviewer");
        this.ui = new UI();
        this.batch = new TwoColorPolygonBatch(3100);
        this.camera = new OrthographicCamera();
        this.renderer = new SkeletonRenderer();
        this.debugRenderer = new SkeletonRendererDebug();
        this.resetCameraPosition();
        this.ui.loadPrefs();
        if (args.length == 0) {
            this.loadSkeleton(Gdx.files.internal(Gdx.app.getPreferences("spine-skeletonviewer").getString("lastFile", "spineboy/spineboy.json")));
        } else {
            this.loadSkeleton(Gdx.files.internal(args[0]));
        }
        this.ui.loadPrefs();
        this.ui.prefsLoaded = true;
    }

    FileHandle atlasFile(FileHandle fileHandle) {
        String string = fileHandle.name();
        for (String string2 : extraSuffixes) {
            for (String string3 : dataSuffixes) {
                FileHandle fileHandle2;
                String string4 = string3 + string2;
                if (!string.endsWith(string4) || (fileHandle2 = this.atlasFile(fileHandle, string.substring(0, string.length() - string4.length()))) == null) continue;
                return fileHandle2;
            }
        }
        return this.atlasFile(fileHandle, string);
    }

    private FileHandle atlasFile(FileHandle fileHandle, String string) {
        for (String string2 : extraSuffixes) {
            for (String string3 : atlasSuffixes) {
                FileHandle fileHandle2 = fileHandle.sibling(string + string3 + string2);
                if (!fileHandle2.exists()) continue;
                return fileHandle2;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void loadSkeleton(final FileHandle fileHandle) {
        Array<String> array;
        if (fileHandle == null) {
            return;
        }
        FileHandle fileHandle2 = this.atlasFile(fileHandle);
        try {
            Object object;
            void var5_8;
            array = new Pixmap(32, 32, Pixmap.Format.RGBA8888);
            ((Pixmap)((Object)array)).setColor(new Color(1.0f, 1.0f, 1.0f, 0.33f));
            ((Pixmap)((Object)array)).fill();
            final TextureAtlas.AtlasRegion atlasRegion = new TextureAtlas.AtlasRegion(new Texture((Pixmap)((Object)array)), 0, 0, 32, 32);
            ((Pixmap)((Object)array)).dispose();
            if (fileHandle2 == null) {
                TextureAtlas.TextureAtlasData object2 = new TextureAtlas.TextureAtlasData();
            } else {
                TextureAtlas.TextureAtlasData textureAtlasData = new TextureAtlas.TextureAtlasData(fileHandle2, fileHandle2.parent(), false);
                boolean bl = true;
                int n = textureAtlasData.getPages().size;
                for (int i = 0; i < n; ++i) {
                    TextureAtlas.TextureAtlasData.Page page = textureAtlasData.getPages().get(i);
                    if (page.minFilter == Texture.TextureFilter.Linear && page.magFilter == Texture.TextureFilter.Linear) continue;
                    bl = false;
                    break;
                }
                this.ui.linearCheckbox.setChecked(bl);
            }
            this.atlas = new TextureAtlas((TextureAtlas.TextureAtlasData)var5_8){

                @Override
                public TextureAtlas.AtlasRegion findRegion(String string) {
                    FileHandle fileHandle2;
                    TextureAtlas.AtlasRegion atlasRegion2 = super.findRegion(string);
                    if (atlasRegion2 == null && (fileHandle2 = fileHandle.sibling(string + ".png")).exists()) {
                        Texture texture = new Texture(fileHandle2);
                        texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                        atlasRegion2 = new TextureAtlas.AtlasRegion(texture, 0, 0, texture.getWidth(), texture.getHeight());
                        atlasRegion2.name = string;
                    }
                    return atlasRegion2 != null ? atlasRegion2 : atlasRegion;
                }
            };
            String string = fileHandle.extension();
            if (string.equalsIgnoreCase("json") || string.equalsIgnoreCase("txt")) {
                object = new SkeletonJson(this.atlas);
                ((SkeletonJson)object).setScale(this.ui.loadScaleSlider.getValue());
                this.skeletonData = ((SkeletonJson)object).readSkeletonData(fileHandle);
            } else {
                object = new SkeletonBinary(this.atlas);
                ((SkeletonBinary)object).setScale(this.ui.loadScaleSlider.getValue());
                this.skeletonData = ((SkeletonBinary)object).readSkeletonData(fileHandle);
                if (this.skeletonData.getBones().size == 0) {
                    throw new Exception("No bones in skeleton data.");
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.ui.toast("Error loading skeleton: " + fileHandle.name());
            this.lastModifiedCheck = 5.0f;
            return;
        }
        this.skeleton = new Skeleton(this.skeletonData);
        this.skeleton.updateWorldTransform();
        this.skeleton.setToSetupPose();
        this.skeleton = new Skeleton(this.skeleton);
        this.skeleton.updateWorldTransform();
        this.state = new AnimationState(new AnimationStateData(this.skeletonData));
        this.state.addListener(new AnimationState.AnimationStateAdapter(){

            @Override
            public void event(AnimationState.TrackEntry trackEntry, Event event) {
                SkeletonViewer.this.ui.toast(event.getData().getName());
            }
        });
        this.skeletonFile = fileHandle;
        this.skeletonModified = fileHandle.lastModified();
        this.atlasModified = fileHandle2 == null ? 0L : fileHandle2.lastModified();
        this.lastModifiedCheck = 0.25f;
        this.prefs.putString("lastFile", fileHandle.path());
        this.prefs.flush();
        this.ui.window.getTitleLabel().setText(fileHandle.name());
        array = new Array();
        for (Skin skin : this.skeletonData.getSkins()) {
            array.add(skin.getName());
        }
        this.ui.skinList.setItems(array);
        array = new Array<String>();
        for (Animation animation : this.skeletonData.getAnimations()) {
            array.add(animation.getName());
        }
        this.ui.animationList.setItems(array);
        this.ui.trackButtons.getButtons().first().setChecked(true);
        if (this.ui.skinList.getSelected() != null) {
            this.skeleton.setSkin(this.ui.skinList.getSelected());
        }
        this.setAnimation();
    }

    void setAnimation() {
        AnimationState.TrackEntry trackEntry;
        if (this.ui.animationList.getSelected() == null) {
            return;
        }
        int n = this.ui.trackButtons.getCheckedIndex();
        AnimationState.TrackEntry trackEntry2 = this.state.getCurrent(n);
        if (trackEntry2 == null) {
            this.state.setEmptyAnimation(n, 0.0f);
            trackEntry = this.state.addAnimation(n, this.ui.animationList.getSelected(), this.ui.loopCheckbox.isChecked(), 0.0f);
            trackEntry.setMixDuration(this.ui.mixSlider.getValue());
        } else {
            trackEntry = this.state.setAnimation(n, this.ui.animationList.getSelected(), this.ui.loopCheckbox.isChecked());
        }
        trackEntry.setMixBlend(this.ui.addCheckbox.isChecked() ? Animation.MixBlend.add : Animation.MixBlend.replace);
        trackEntry.setAlpha(this.ui.alphaSlider.getValue());
    }

    @Override
    public void render() {
        AnimationState.TrackEntry trackEntry;
        float f;
        Gdx.gl.glClearColor(0.4392157f, 0.43529412f, 0.4627451f, 1.0f);
        Gdx.gl.glClear(16384);
        float f2 = Gdx.graphics.getDeltaTime();
        this.camera.update();
        this.batch.getProjectionMatrix().set(this.camera.combined);
        this.debugRenderer.getShapeRenderer().setProjectionMatrix(this.camera.combined);
        ShapeRenderer shapeRenderer = this.debugRenderer.getShapeRenderer();
        if (this.state != null) {
            shapeRenderer.setColor(Color.DARK_GRAY);
            shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            shapeRenderer.line(0.0f, -99999.0f, 0.0f, 99999.0f);
            shapeRenderer.line(-99999.0f, 0.0f, 99999.0f, 0.0f);
            shapeRenderer.end();
        }
        if (this.skeleton != null) {
            if (this.reloadTimer <= 0.0f) {
                this.lastModifiedCheck -= f2;
                if (this.lastModifiedCheck < 0.0f) {
                    FileHandle fileHandle;
                    this.lastModifiedCheck = 0.25f;
                    long l = this.skeletonFile.lastModified();
                    if (l != 0L && this.skeletonModified != l) {
                        this.reloadTimer = 1.0f;
                    }
                    long l2 = l = (fileHandle = this.atlasFile(this.skeletonFile)) == null ? 0L : fileHandle.lastModified();
                    if (l != 0L && this.atlasModified != l) {
                        this.reloadTimer = 1.0f;
                    }
                }
            } else {
                this.reloadTimer -= f2;
                if (this.reloadTimer <= 0.0f) {
                    this.loadSkeleton(this.skeletonFile);
                    this.ui.toast("Reloaded.");
                }
            }
            this.state.getData().setDefaultMix(this.ui.mixSlider.getValue());
            this.renderer.setPremultipliedAlpha(this.ui.premultipliedCheckbox.isChecked());
            this.batch.setPremultipliedAlpha(this.ui.premultipliedCheckbox.isChecked());
            float f3 = this.ui.xScaleSlider.getValue();
            f = this.ui.yScaleSlider.getValue();
            if (this.skeleton.scaleX == 0.0f) {
                this.skeleton.scaleX = 0.01f;
            }
            if (this.skeleton.scaleY == 0.0f) {
                this.skeleton.scaleY = 0.01f;
            }
            this.skeleton.setScale(f3, f);
            f2 = Math.min(f2, 0.032f) * this.ui.speedSlider.getValue();
            this.skeleton.update(f2);
            this.state.update(f2);
            this.state.apply(this.skeleton);
            this.skeleton.updateWorldTransform();
            this.batch.begin();
            this.renderer.draw(this.batch, this.skeleton);
            this.batch.end();
            this.debugRenderer.setBones(this.ui.debugBonesCheckbox.isChecked());
            this.debugRenderer.setRegionAttachments(this.ui.debugRegionsCheckbox.isChecked());
            this.debugRenderer.setBoundingBoxes(this.ui.debugBoundingBoxesCheckbox.isChecked());
            this.debugRenderer.setMeshHull(this.ui.debugMeshHullCheckbox.isChecked());
            this.debugRenderer.setMeshTriangles(this.ui.debugMeshTrianglesCheckbox.isChecked());
            this.debugRenderer.setPaths(this.ui.debugPathsCheckbox.isChecked());
            this.debugRenderer.setPoints(this.ui.debugPointsCheckbox.isChecked());
            this.debugRenderer.setClipping(this.ui.debugClippingCheckbox.isChecked());
            this.debugRenderer.draw(this.skeleton);
        }
        if (this.state != null) {
            this.status.setLength(0);
            for (int i = this.state.getTracks().size - 1; i >= 0; --i) {
                AnimationState.TrackEntry trackEntry2 = this.state.getTracks().get(i);
                if (trackEntry2 == null) continue;
                this.status.append(i);
                this.status.append(": [LIGHT_GRAY]");
                this.status(trackEntry2);
                this.status.append("[WHITE]");
                this.status.append(trackEntry2.animation.name);
                this.status.append('\n');
            }
            this.ui.statusLabel.setText(this.status);
        }
        this.ui.render();
        if (this.state != null && (trackEntry = this.state.getCurrent(0)) != null) {
            shapeRenderer.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            shapeRenderer.updateMatrices();
            shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            f = trackEntry.getAnimationTime() / trackEntry.getAnimationEnd();
            float f4 = this.ui.window.getRight() * uiScale + ((float)Gdx.graphics.getWidth() - this.ui.window.getRight() * uiScale) * f;
            shapeRenderer.setColor(Color.CYAN);
            shapeRenderer.line(f4, 0.0f, f4, 12.0f);
            f = trackEntry.getMixDuration() == 0.0f ? 1.0f : Math.min(1.0f, trackEntry.getMixTime() / trackEntry.getMixDuration());
            f4 = this.ui.window.getRight() * uiScale + ((float)Gdx.graphics.getWidth() - this.ui.window.getRight() * uiScale) * f;
            shapeRenderer.setColor(Color.RED);
            shapeRenderer.line(f4, 0.0f, f4, 12.0f);
            shapeRenderer.end();
        }
    }

    void status(AnimationState.TrackEntry trackEntry) {
        AnimationState.TrackEntry trackEntry2 = trackEntry.mixingFrom;
        if (trackEntry2 == null) {
            return;
        }
        this.status(trackEntry2);
        this.status.append(trackEntry2.animation.name);
        this.status.append(' ');
        this.status.append(Math.min(100, (int)(trackEntry.mixTime / trackEntry.mixDuration * 100.0f)));
        this.status.append("% -> ");
    }

    void resetCameraPosition() {
        this.camera.position.x = -this.ui.window.getWidth() / 2.0f * uiScale;
        this.camera.position.y = Gdx.graphics.getHeight() / 4;
    }

    @Override
    public void resize(int n, int n2) {
        float f = this.camera.position.x;
        float f2 = this.camera.position.y;
        this.camera.setToOrtho(false);
        this.camera.position.set(f, f2, 0.0f);
        ((ScreenViewport)this.ui.stage.getViewport()).setUnitsPerPixel(1.0f / uiScale);
        this.ui.stage.getViewport().update(n, n2, true);
        if (!this.ui.minimizeButton.isChecked()) {
            this.ui.window.setHeight((float)n2 / uiScale + 8.0f);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        args = stringArray;
        String string = System.getProperty("os.name");
        float f = 1.0f;
        if (string.contains("Windows")) {
            f = (float)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0f;
        }
        if (string.contains("OS X") && (object = Toolkit.getDefaultToolkit().getDesktopProperty("apple.awt.contentScaleFactor")) instanceof Float && ((Float)object).intValue() >= 2) {
            f = 2.0f;
        }
        if (f >= 2.0f) {
            uiScale = 2.0f;
        }
        object = new LwjglApplicationConfiguration();
        ((LwjglApplicationConfiguration)object).width = (int)(800.0f * uiScale);
        ((LwjglApplicationConfiguration)object).height = (int)(600.0f * uiScale);
        ((LwjglApplicationConfiguration)object).title = "Skeleton Viewer";
        ((LwjglApplicationConfiguration)object).allowSoftwareMode = true;
        ((LwjglApplicationConfiguration)object).samples = 2;
        new LwjglApplication(new SkeletonViewer(), (LwjglApplicationConfiguration)object);
    }

    class UI {
        boolean prefsLoaded;
        Stage stage = new Stage(new ScreenViewport());
        com.badlogic.gdx.scenes.scene2d.ui.Skin skin = new com.badlogic.gdx.scenes.scene2d.ui.Skin(Gdx.files.internal("skin/skin.json"));
        Window window = new Window("Skeleton", this.skin);
        Table root = new Table(this.skin);
        TextButton openButton = new TextButton("Open", this.skin);
        TextButton minimizeButton = new TextButton("-", this.skin);
        Slider loadScaleSlider = new Slider(0.1f, 3.0f, 0.01f, false, this.skin);
        Label loadScaleLabel = new Label((CharSequence)"100%", this.skin);
        TextButton loadScaleResetButton = new TextButton("Reload", this.skin);
        Slider zoomSlider = new Slider(0.01f, 10.0f, 0.01f, false, this.skin);
        Label zoomLabel = new Label((CharSequence)"100%", this.skin);
        TextButton zoomResetButton = new TextButton("Reset", this.skin);
        Slider xScaleSlider = new Slider(-2.0f, 2.0f, 0.01f, false, this.skin);
        Label xScaleLabel = new Label((CharSequence)"100%", this.skin);
        TextButton xScaleResetButton = new TextButton("Reset", this.skin);
        Slider yScaleSlider = new Slider(-2.0f, 2.0f, 0.01f, false, this.skin);
        Label yScaleLabel = new Label((CharSequence)"100%", this.skin);
        TextButton yScaleResetButton = new TextButton("Reset", this.skin);
        CheckBox debugBonesCheckbox = new CheckBox("Bones", this.skin);
        CheckBox debugRegionsCheckbox = new CheckBox("Regions", this.skin);
        CheckBox debugBoundingBoxesCheckbox = new CheckBox("Bounds", this.skin);
        CheckBox debugMeshHullCheckbox = new CheckBox("Mesh hull", this.skin);
        CheckBox debugMeshTrianglesCheckbox = new CheckBox("Triangles", this.skin);
        CheckBox debugPathsCheckbox = new CheckBox("Paths", this.skin);
        CheckBox debugPointsCheckbox = new CheckBox("Points", this.skin);
        CheckBox debugClippingCheckbox = new CheckBox("Clipping", this.skin);
        CheckBox premultipliedCheckbox = new CheckBox("Premultiplied", this.skin);
        CheckBox linearCheckbox = new CheckBox("Linear", this.skin);
        TextButton bonesSetupPoseButton = new TextButton("Bones", this.skin);
        TextButton slotsSetupPoseButton = new TextButton("Slots", this.skin);
        TextButton setupPoseButton = new TextButton("Both", this.skin);
        List<String> skinList = new List(this.skin);
        ScrollPane skinScroll = new ScrollPane(this.skinList, this.skin, "bg");
        ButtonGroup<TextButton> trackButtons = new ButtonGroup();
        CheckBox loopCheckbox = new CheckBox("Loop", this.skin);
        CheckBox addCheckbox = new CheckBox("Add", this.skin);
        Slider alphaSlider = new Slider(0.0f, 1.0f, 0.01f, false, this.skin);
        Label alphaLabel = new Label((CharSequence)"100%", this.skin);
        List<String> animationList = new List(this.skin);
        ScrollPane animationScroll = new ScrollPane(this.animationList, this.skin, "bg");
        Slider speedSlider = new Slider(0.0f, 3.0f, 0.01f, false, this.skin);
        Label speedLabel = new Label((CharSequence)"1.0x", this.skin);
        TextButton speedResetButton = new TextButton("Reset", this.skin);
        Slider mixSlider = new Slider(0.0f, 4.0f, 0.01f, false, this.skin);
        Label mixLabel = new Label((CharSequence)"0.3s", this.skin);
        Label statusLabel = new Label((CharSequence)"", this.skin);
        WidgetGroup toasts = new WidgetGroup();

        UI() {
            this.initialize();
            this.layout();
            this.events();
        }

        void initialize() {
            this.skin.getFont((String)"default").getData().markupEnabled = true;
            for (int i = 0; i < 6; ++i) {
                this.trackButtons.add(new TextButton(i + "", this.skin, "toggle"));
            }
            this.premultipliedCheckbox.setChecked(true);
            this.linearCheckbox.setChecked(true);
            this.loopCheckbox.setChecked(true);
            this.loadScaleSlider.setValue(1.0f);
            this.loadScaleSlider.setSnapToValues(new float[]{0.5f, 1.0f, 1.5f, 2.0f, 2.5f}, 0.09f);
            this.zoomSlider.setValue(1.0f);
            this.zoomSlider.setSnapToValues(new float[]{1.0f, 2.0f}, 0.3f);
            this.xScaleSlider.setValue(1.0f);
            this.xScaleSlider.setSnapToValues(new float[]{-1.5f, -1.0f, -0.5f, 0.5f, 1.0f, 1.5f}, 0.12f);
            this.yScaleSlider.setValue(1.0f);
            this.yScaleSlider.setSnapToValues(new float[]{-1.5f, -1.0f, -0.5f, 0.5f, 1.0f, 1.5f}, 0.12f);
            this.skinList.getSelection().setRequired(false);
            this.skinList.getSelection().setToggle(true);
            this.animationList.getSelection().setRequired(false);
            this.animationList.getSelection().setToggle(true);
            this.mixSlider.setValue(0.3f);
            this.mixSlider.setSnapToValues(new float[]{1.0f, 1.5f, 2.0f, 2.5f, 3.0f, 3.5f}, 0.12f);
            this.speedSlider.setValue(1.0f);
            this.speedSlider.setSnapToValues(new float[]{0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 2.5f}, 0.09f);
            this.alphaSlider.setValue(1.0f);
            this.alphaSlider.setDisabled(true);
            this.addCheckbox.setDisabled(true);
            this.window.setMovable(false);
            this.window.setResizable(false);
            this.window.setKeepWithinStage(false);
            this.window.setX(-3.0f);
            this.window.setY(-2.0f);
            this.window.getTitleLabel().setColor(new Color(-1040187393));
            this.window.getTitleTable().add(this.openButton).space(3.0f);
            this.window.getTitleTable().add(this.minimizeButton).width(20.0f);
            this.skinScroll.setFadeScrollBars(false);
            this.animationScroll.setFadeScrollBars(false);
        }

        void layout() {
            float f = this.loadScaleResetButton.getPrefWidth();
            this.root.defaults().space(6.0f);
            this.root.columnDefaults(0).top().right().padTop(3.0f);
            this.root.columnDefaults(1).left();
            this.root.add("Load scale:");
            Table table = this.table(new Actor[0]);
            table.add(this.loadScaleLabel).width(29.0f);
            table.add(this.loadScaleSlider).growX();
            table.add(this.loadScaleResetButton).width(f);
            this.root.add(table).fill().row();
            this.root.add("Zoom:");
            table = this.table(new Actor[0]);
            table.add(this.zoomLabel).width(29.0f);
            table.add(this.zoomSlider).growX();
            table.add(this.zoomResetButton).width(f);
            this.root.add(table).fill().row();
            this.root.add("Scale X:");
            table = this.table(new Actor[0]);
            table.add(this.xScaleLabel).width(29.0f);
            table.add(this.xScaleSlider).growX();
            table.add(this.xScaleResetButton).width(f);
            this.root.add(table).fill().row();
            this.root.add("Scale Y:");
            table = this.table(new Actor[0]);
            table.add(this.yScaleLabel).width(29.0f);
            table.add(this.yScaleSlider).growX();
            table.add(this.yScaleResetButton).width(f);
            this.root.add(table).fill().row();
            this.root.add("Debug:");
            this.root.add(this.table(this.debugBonesCheckbox, this.debugRegionsCheckbox, this.debugBoundingBoxesCheckbox)).row();
            this.root.add();
            this.root.add(this.table(this.debugPathsCheckbox, this.debugPointsCheckbox, this.debugClippingCheckbox)).row();
            this.root.add();
            this.root.add(this.table(this.debugMeshHullCheckbox, this.debugMeshTrianglesCheckbox)).row();
            this.root.add("Atlas alpha:");
            table = this.table(new Actor[0]);
            table.add(this.premultipliedCheckbox);
            table.add("Filtering:").growX().getActor().setAlignment(16);
            table.add(this.linearCheckbox);
            this.root.add(table).fill().row();
            this.root.add(new Image(this.skin.newDrawable("white", new Color(0x4E4E4EFF)))).height(1.0f).fillX().colspan(2).pad(-3.0f, 0.0f, 1.0f, 0.0f).row();
            this.root.add("Setup pose:");
            this.root.add(this.table(this.bonesSetupPoseButton, this.slotsSetupPoseButton, this.setupPoseButton)).row();
            this.root.add("Skin:");
            this.root.add(this.skinScroll).grow().minHeight(64.0f).row();
            this.root.add(new Image(this.skin.newDrawable("white", new Color(0x4E4E4EFF)))).height(1.0f).fillX().colspan(2).pad(1.0f, 0.0f, 1.0f, 0.0f).row();
            this.root.add("Track:");
            table = this.table(new Actor[0]);
            for (TextButton textButton : this.trackButtons.getButtons()) {
                table.add(textButton);
            }
            table.add(this.loopCheckbox);
            table.add(this.addCheckbox);
            this.root.add(table).row();
            this.root.add("Entry alpha:");
            table = this.table(new Actor[0]);
            table.add(this.alphaLabel).width(29.0f);
            table.add(this.alphaSlider).growX();
            this.root.add(table).fill().row();
            this.root.add("Animation:");
            this.root.add(this.animationScroll).grow().minHeight(64.0f).row();
            this.root.add("Speed:");
            table = this.table(new Actor[0]);
            table.add(this.speedLabel).width(29.0f);
            table.add(this.speedSlider).growX();
            table.add(this.speedResetButton);
            this.root.add(table).fill().row();
            this.root.add("Default mix:");
            table = this.table(new Actor[0]);
            table.add(this.mixLabel).width(29.0f);
            table.add(this.mixSlider).growX();
            this.root.add(table).fill().row();
            this.window.add(this.root).grow();
            this.window.pack();
            this.stage.addActor(this.window);
            this.stage.addActor(this.statusLabel);
            table = new Table();
            table.setFillParent(true);
            table.setTouchable(Touchable.disabled);
            this.stage.addActor(table);
            table.pad(10.0f, 10.0f, 22.0f, 10.0f).bottom().right();
            table.add(this.toasts);
            table = new Table();
            table.setFillParent(true);
            table.setTouchable(Touchable.disabled);
            this.stage.addActor(table);
            table.pad(10.0f).top().right();
            table.defaults().right();
            table.add(new Label("3.8.99", this.skin, "default", Color.LIGHT_GRAY));
        }

        void events() {
            this.window.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent inputEvent, float f, float f2, int n, int n2) {
                    inputEvent.cancel();
                    return true;
                }
            });
            this.openButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    FileDialog fileDialog = new FileDialog((Frame)null, "Choose skeleton file");
                    fileDialog.setMode(0);
                    fileDialog.setVisible(true);
                    String string = fileDialog.getFile();
                    String string2 = fileDialog.getDirectory();
                    if (string == null || string2 == null) {
                        return;
                    }
                    SkeletonViewer.this.loadSkeleton(new FileHandle(new File(string2, string).getAbsolutePath()));
                    SkeletonViewer.this.ui.toast("Loaded.");
                }
            });
            this.setupPoseButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (SkeletonViewer.this.skeleton != null) {
                        SkeletonViewer.this.skeleton.setToSetupPose();
                    }
                }
            });
            this.bonesSetupPoseButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (SkeletonViewer.this.skeleton != null) {
                        SkeletonViewer.this.skeleton.setBonesToSetupPose();
                    }
                }
            });
            this.slotsSetupPoseButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (SkeletonViewer.this.skeleton != null) {
                        SkeletonViewer.this.skeleton.setSlotsToSetupPose();
                    }
                }
            });
            this.minimizeButton.addListener(new ClickListener(){

                @Override
                public boolean touchDown(InputEvent inputEvent, float f, float f2, int n, int n2) {
                    inputEvent.cancel();
                    return super.touchDown(inputEvent, f, f2, n, n2);
                }

                @Override
                public void clicked(InputEvent inputEvent, float f, float f2) {
                    if (UI.this.minimizeButton.isChecked()) {
                        UI.this.window.getCells().get(0).setActor(null);
                        UI.this.window.setHeight(37.0f);
                        UI.this.minimizeButton.setText("+");
                    } else {
                        UI.this.window.getCells().get(0).setActor(UI.this.root);
                        UI.this.window.setHeight((float)Gdx.graphics.getHeight() / uiScale + 8.0f);
                        UI.this.minimizeButton.setText("-");
                    }
                }
            });
            this.loadScaleSlider.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    UI.this.loadScaleLabel.setText(Integer.toString((int)(UI.this.loadScaleSlider.getValue() * 100.0f)) + "%");
                    if (!UI.this.loadScaleSlider.isDragging()) {
                        SkeletonViewer.this.loadSkeleton(SkeletonViewer.this.skeletonFile);
                        SkeletonViewer.this.ui.toast("Reloaded.");
                    }
                    UI.this.loadScaleResetButton.setText(UI.this.loadScaleSlider.getValue() == 1.0f ? "Reload" : "Reset");
                }
            });
            this.loadScaleResetButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    SkeletonViewer.this.resetCameraPosition();
                    if (UI.this.loadScaleSlider.getValue() == 1.0f) {
                        SkeletonViewer.this.loadSkeleton(SkeletonViewer.this.skeletonFile);
                        SkeletonViewer.this.ui.toast("Reloaded.");
                    } else {
                        UI.this.loadScaleSlider.setValue(1.0f);
                    }
                    UI.this.loadScaleResetButton.setText("Reload");
                }
            });
            this.zoomSlider.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    UI.this.zoomLabel.setText(Integer.toString((int)(UI.this.zoomSlider.getValue() * 100.0f)) + "%");
                    float f = 1.0f / UI.this.zoomSlider.getValue();
                    SkeletonViewer.this.camera.position.x -= UI.this.window.getWidth() / 2.0f * (f - SkeletonViewer.this.camera.zoom);
                    SkeletonViewer.this.camera.zoom = f;
                }
            });
            this.zoomResetButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    SkeletonViewer.this.resetCameraPosition();
                    float f = SkeletonViewer.this.camera.position.x;
                    UI.this.zoomSlider.setValue(1.0f);
                    SkeletonViewer.this.camera.position.x = f;
                }
            });
            this.xScaleSlider.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (UI.this.xScaleSlider.getValue() == 0.0f) {
                        UI.this.xScaleSlider.setValue(0.01f);
                    }
                    UI.this.xScaleLabel.setText(Integer.toString((int)(UI.this.xScaleSlider.getValue() * 100.0f)) + "%");
                }
            });
            this.xScaleResetButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    UI.this.xScaleSlider.setValue(1.0f);
                }
            });
            this.yScaleSlider.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (UI.this.yScaleSlider.getValue() == 0.0f) {
                        UI.this.yScaleSlider.setValue(0.01f);
                    }
                    UI.this.yScaleLabel.setText(Integer.toString((int)(UI.this.yScaleSlider.getValue() * 100.0f)) + "%");
                }
            });
            this.yScaleResetButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    UI.this.yScaleSlider.setValue(1.0f);
                }
            });
            this.speedSlider.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    UI.this.speedLabel.setText(Float.toString((float)((int)(UI.this.speedSlider.getValue() * 100.0f)) / 100.0f) + "x");
                }
            });
            this.speedResetButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    UI.this.speedSlider.setValue(1.0f);
                }
            });
            this.alphaSlider.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    AnimationState.TrackEntry trackEntry;
                    UI.this.alphaLabel.setText(Integer.toString((int)(UI.this.alphaSlider.getValue() * 100.0f)) + "%");
                    int n = UI.this.trackButtons.getCheckedIndex();
                    if (n > 0 && (trackEntry = SkeletonViewer.this.state.getCurrent(n)) != null) {
                        trackEntry.setAlpha(UI.this.alphaSlider.getValue());
                        trackEntry.resetRotationDirections();
                    }
                }
            });
            this.mixSlider.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    UI.this.mixLabel.setText(Float.toString((float)((int)(UI.this.mixSlider.getValue() * 100.0f)) / 100.0f) + "s");
                    if (SkeletonViewer.this.state != null) {
                        SkeletonViewer.this.state.getData().setDefaultMix(UI.this.mixSlider.getValue());
                    }
                }
            });
            InputListener inputListener = new InputListener(){

                @Override
                public void enter(InputEvent inputEvent, float f, float f2, int n, Actor actor) {
                    if (n == -1) {
                        UI.this.stage.setScrollFocus(inputEvent.getListenerActor());
                    }
                }

                @Override
                public void exit(InputEvent inputEvent, float f, float f2, int n, Actor actor) {
                    if (n == -1 && UI.this.stage.getScrollFocus() == inputEvent.getListenerActor()) {
                        UI.this.stage.setScrollFocus(null);
                    }
                }
            };
            this.animationList.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (SkeletonViewer.this.state != null) {
                        String string = UI.this.animationList.getSelected();
                        if (string == null) {
                            SkeletonViewer.this.state.setEmptyAnimation(UI.this.trackButtons.getCheckedIndex(), UI.this.mixSlider.getValue());
                        } else {
                            SkeletonViewer.this.setAnimation();
                        }
                    }
                }
            });
            this.animationScroll.addListener(inputListener);
            this.loopCheckbox.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    SkeletonViewer.this.setAnimation();
                }
            });
            this.addCheckbox.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    SkeletonViewer.this.setAnimation();
                }
            });
            this.linearCheckbox.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (SkeletonViewer.this.atlas == null) {
                        return;
                    }
                    Texture.TextureFilter textureFilter = UI.this.linearCheckbox.isChecked() ? Texture.TextureFilter.Linear : Texture.TextureFilter.Nearest;
                    for (Texture texture : SkeletonViewer.this.atlas.getTextures()) {
                        texture.setFilter(textureFilter, textureFilter);
                    }
                }
            });
            this.skinList.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (SkeletonViewer.this.skeleton != null) {
                        String string = UI.this.skinList.getSelected();
                        if (string == null) {
                            SkeletonViewer.this.skeleton.setSkin((Skin)null);
                        } else {
                            SkeletonViewer.this.skeleton.setSkin(string);
                        }
                        SkeletonViewer.this.skeleton.setSlotsToSetupPose();
                    }
                }
            });
            this.skinScroll.addListener(inputListener);
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    int n = UI.this.trackButtons.getCheckedIndex();
                    if (n == -1) {
                        return;
                    }
                    AnimationState.TrackEntry trackEntry = SkeletonViewer.this.state.getCurrent(n);
                    UI.this.animationList.getSelection().setProgrammaticChangeEvents(false);
                    UI.this.animationList.setSelected(trackEntry == null ? null : trackEntry.animation.name);
                    UI.this.animationList.getSelection().setProgrammaticChangeEvents(true);
                    UI.this.alphaSlider.setDisabled(n == 0);
                    UI.this.alphaSlider.setValue(trackEntry == null ? 1.0f : trackEntry.alpha);
                    UI.this.addCheckbox.setDisabled(n == 0);
                    if (trackEntry != null) {
                        UI.this.loopCheckbox.setChecked(trackEntry.getLoop());
                        UI.this.addCheckbox.setChecked(trackEntry.getMixBlend() == Animation.MixBlend.add);
                    }
                }
            };
            for (TextButton textButton : this.trackButtons.getButtons()) {
                textButton.addListener(changeListener);
            }
            Gdx.input.setInputProcessor(new InputMultiplexer(this.stage, new InputAdapter(){
                float offsetX;
                float offsetY;

                @Override
                public boolean touchDown(int n, int n2, int n3, int n4) {
                    this.offsetX = n;
                    this.offsetY = Gdx.graphics.getHeight() - 1 - n2;
                    return false;
                }

                @Override
                public boolean touchDragged(int n, int n2, int n3) {
                    float f = (float)n - this.offsetX;
                    float f2 = (float)(Gdx.graphics.getHeight() - 1 - n2) - this.offsetY;
                    SkeletonViewer.this.camera.position.x -= f * SkeletonViewer.this.camera.zoom;
                    SkeletonViewer.this.camera.position.y -= f2 * SkeletonViewer.this.camera.zoom;
                    this.offsetX = n;
                    this.offsetY = Gdx.graphics.getHeight() - 1 - n2;
                    return false;
                }

                @Override
                public boolean touchUp(int n, int n2, int n3, int n4) {
                    UI.this.savePrefs();
                    return false;
                }
            }));
            ChangeListener changeListener2 = new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    if (actor instanceof Slider && ((Slider)actor).isDragging()) {
                        return;
                    }
                    UI.this.savePrefs();
                }
            };
            this.debugBonesCheckbox.addListener(changeListener2);
            this.debugRegionsCheckbox.addListener(changeListener2);
            this.debugMeshHullCheckbox.addListener(changeListener2);
            this.debugMeshTrianglesCheckbox.addListener(changeListener2);
            this.debugPathsCheckbox.addListener(changeListener2);
            this.debugPointsCheckbox.addListener(changeListener2);
            this.debugClippingCheckbox.addListener(changeListener2);
            this.premultipliedCheckbox.addListener(changeListener2);
            this.loopCheckbox.addListener(changeListener2);
            this.addCheckbox.addListener(changeListener2);
            this.speedSlider.addListener(changeListener2);
            this.speedResetButton.addListener(changeListener2);
            this.mixSlider.addListener(changeListener2);
            this.loadScaleSlider.addListener(changeListener2);
            this.loadScaleResetButton.addListener(changeListener2);
            this.zoomSlider.addListener(changeListener2);
            this.zoomResetButton.addListener(changeListener2);
            this.animationList.addListener(changeListener2);
            this.skinList.addListener(changeListener2);
        }

        Table table(Actor ... actorArray) {
            Table table = new Table(this.skin);
            table.defaults().space(6.0f);
            table.add(actorArray);
            return table;
        }

        void render() {
            if (SkeletonViewer.this.state != null && SkeletonViewer.this.state.getCurrent(this.trackButtons.getCheckedIndex()) == null) {
                this.animationList.getSelection().setProgrammaticChangeEvents(false);
                this.animationList.setSelected(null);
                this.animationList.getSelection().setProgrammaticChangeEvents(true);
            }
            this.statusLabel.pack();
            if (this.minimizeButton.isChecked()) {
                this.statusLabel.setPosition(10.0f, 25.0f, 12);
            } else {
                this.statusLabel.setPosition(this.window.getWidth() + 6.0f, 5.0f, 12);
            }
            this.stage.act();
            this.stage.draw();
        }

        void toast(String string) {
            Table table = new Table();
            table.add(new Label((CharSequence)string, this.skin));
            table.getColor().a = 0.0f;
            table.pack();
            table.setPosition(-table.getWidth(), -3.0f - table.getHeight());
            table.addAction(Actions.sequence(Actions.parallel(Actions.moveBy(0.0f, table.getHeight(), 0.3f), Actions.fadeIn(0.3f)), Actions.delay(5.0f), Actions.parallel(Actions.moveBy(0.0f, table.getHeight(), 0.3f), Actions.fadeOut(0.3f)), Actions.removeActor()));
            for (Actor actor : this.toasts.getChildren()) {
                actor.addAction(Actions.moveBy(0.0f, table.getHeight(), 0.3f));
            }
            this.toasts.addActor(table);
            this.toasts.getParent().toFront();
        }

        void savePrefs() {
            AnimationState.TrackEntry trackEntry;
            if (!this.prefsLoaded) {
                return;
            }
            SkeletonViewer.this.prefs.putBoolean("debugBones", this.debugBonesCheckbox.isChecked());
            SkeletonViewer.this.prefs.putBoolean("debugRegions", this.debugRegionsCheckbox.isChecked());
            SkeletonViewer.this.prefs.putBoolean("debugMeshHull", this.debugMeshHullCheckbox.isChecked());
            SkeletonViewer.this.prefs.putBoolean("debugMeshTriangles", this.debugMeshTrianglesCheckbox.isChecked());
            SkeletonViewer.this.prefs.putBoolean("debugPaths", this.debugPathsCheckbox.isChecked());
            SkeletonViewer.this.prefs.putBoolean("debugPoints", this.debugPointsCheckbox.isChecked());
            SkeletonViewer.this.prefs.putBoolean("debugClipping", this.debugClippingCheckbox.isChecked());
            SkeletonViewer.this.prefs.putBoolean("premultiplied", this.premultipliedCheckbox.isChecked());
            SkeletonViewer.this.prefs.putBoolean("loop", this.loopCheckbox.isChecked());
            SkeletonViewer.this.prefs.putBoolean("add", this.addCheckbox.isChecked());
            SkeletonViewer.this.prefs.putFloat("speed", this.speedSlider.getValue());
            SkeletonViewer.this.prefs.putFloat("mix", this.mixSlider.getValue());
            SkeletonViewer.this.prefs.putFloat("scale", this.loadScaleSlider.getValue());
            SkeletonViewer.this.prefs.putFloat("zoom", this.zoomSlider.getValue());
            SkeletonViewer.this.prefs.putFloat("x", SkeletonViewer.this.camera.position.x);
            SkeletonViewer.this.prefs.putFloat("y", SkeletonViewer.this.camera.position.y);
            if (SkeletonViewer.this.state != null && (trackEntry = SkeletonViewer.this.state.getCurrent(0)) != null) {
                String string = trackEntry.animation.name;
                if (string.equals("<empty>")) {
                    string = trackEntry.next == null ? "" : trackEntry.next.animation.name;
                }
                SkeletonViewer.this.prefs.putString("animationName", string);
            }
            if (this.skinList.getSelected() != null) {
                SkeletonViewer.this.prefs.putString("skinName", this.skinList.getSelected());
            }
            SkeletonViewer.this.prefs.flush();
        }

        void loadPrefs() {
            try {
                this.debugBonesCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("debugBones", true));
                this.debugRegionsCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("debugRegions", false));
                this.debugMeshHullCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("debugMeshHull", false));
                this.debugMeshTrianglesCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("debugMeshTriangles", false));
                this.debugPathsCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("debugPaths", true));
                this.debugPointsCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("debugPoints", true));
                this.debugClippingCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("debugClipping", true));
                this.premultipliedCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("premultiplied", true));
                this.loopCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("loop", true));
                this.addCheckbox.setChecked(SkeletonViewer.this.prefs.getBoolean("add", false));
                this.speedSlider.setValue(SkeletonViewer.this.prefs.getFloat("speed", 0.3f));
                this.mixSlider.setValue(SkeletonViewer.this.prefs.getFloat("mix", 0.3f));
                this.zoomSlider.setValue(SkeletonViewer.this.prefs.getFloat("zoom", 1.0f));
                SkeletonViewer.this.camera.zoom = 1.0f / SkeletonViewer.this.prefs.getFloat("zoom", 1.0f);
                SkeletonViewer.this.camera.position.x = SkeletonViewer.this.prefs.getFloat("x", 0.0f);
                SkeletonViewer.this.camera.position.y = SkeletonViewer.this.prefs.getFloat("y", 0.0f);
                this.loadScaleSlider.setValue(SkeletonViewer.this.prefs.getFloat("scale", 1.0f));
                this.animationList.setSelected(SkeletonViewer.this.prefs.getString("animationName", null));
                this.skinList.setSelected(SkeletonViewer.this.prefs.getString("skinName", null));
            }
            catch (Throwable throwable) {
                System.out.println("Unable to read preferences:");
                throwable.printStackTrace();
            }
        }
    }
}

