/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.utils.SpineUtils;

public class TransformConstraint
implements Updatable {
    final TransformConstraintData data;
    final Array<Bone> bones;
    Bone target;
    float rotateMix;
    float translateMix;
    float scaleMix;
    float shearMix;
    boolean active;
    final Vector2 temp = new Vector2();

    public TransformConstraint(TransformConstraintData transformConstraintData, Skeleton skeleton) {
        if (transformConstraintData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = transformConstraintData;
        this.rotateMix = transformConstraintData.rotateMix;
        this.translateMix = transformConstraintData.translateMix;
        this.scaleMix = transformConstraintData.scaleMix;
        this.shearMix = transformConstraintData.shearMix;
        this.bones = new Array(transformConstraintData.bones.size);
        for (BoneData boneData : transformConstraintData.bones) {
            this.bones.add(skeleton.findBone(boneData.name));
        }
        this.target = skeleton.findBone(transformConstraintData.target.name);
    }

    public TransformConstraint(TransformConstraint transformConstraint, Skeleton skeleton) {
        if (transformConstraint == null) {
            throw new IllegalArgumentException("constraint cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = transformConstraint.data;
        this.bones = new Array(transformConstraint.bones.size);
        for (Bone bone : transformConstraint.bones) {
            this.bones.add(skeleton.bones.get(bone.data.index));
        }
        this.target = skeleton.bones.get(transformConstraint.target.data.index);
        this.rotateMix = transformConstraint.rotateMix;
        this.translateMix = transformConstraint.translateMix;
        this.scaleMix = transformConstraint.scaleMix;
        this.shearMix = transformConstraint.shearMix;
    }

    @Override
    public void update() {
        if (this.data.local) {
            if (this.data.relative) {
                this.applyRelativeLocal();
            } else {
                this.applyAbsoluteLocal();
            }
        } else if (this.data.relative) {
            this.applyRelativeWorld();
        } else {
            this.applyAbsoluteWorld();
        }
    }

    private void applyAbsoluteWorld() {
        float f = this.rotateMix;
        float f2 = this.translateMix;
        float f3 = this.scaleMix;
        float f4 = this.shearMix;
        Bone bone = this.target;
        float f5 = bone.a;
        float f6 = bone.d;
        float f7 = bone.b;
        float f8 = bone.c;
        float f9 = f5 * f6 - f7 * f8 > 0.0f ? (float)Math.PI / 180 : (float)(-Math.PI) / 180;
        float f10 = this.data.offsetRotation * f9;
        float f11 = this.data.offsetShearY * f9;
        Array<Bone> array = this.bones;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            float f12;
            float f13;
            float f14;
            float f15;
            float f16;
            Bone bone2 = array.get(i);
            boolean bl = false;
            if (f != 0.0f) {
                f16 = bone2.a;
                f15 = bone2.b;
                f14 = bone2.c;
                f13 = bone2.d;
                f12 = SpineUtils.atan2(f8, f5) - SpineUtils.atan2(f14, f16) + f10;
                if (f12 > (float)Math.PI) {
                    f12 -= (float)Math.PI * 2;
                } else if (f12 < (float)(-Math.PI)) {
                    f12 += (float)Math.PI * 2;
                }
                float f17 = SpineUtils.cos(f12 *= f);
                float f18 = SpineUtils.sin(f12);
                bone2.a = f17 * f16 - f18 * f14;
                bone2.b = f17 * f15 - f18 * f13;
                bone2.c = f18 * f16 + f17 * f14;
                bone2.d = f18 * f15 + f17 * f13;
                bl = true;
            }
            if (f2 != 0.0f) {
                Vector2 vector2 = this.temp;
                bone.localToWorld(vector2.set(this.data.offsetX, this.data.offsetY));
                bone2.worldX += (vector2.x - bone2.worldX) * f2;
                bone2.worldY += (vector2.y - bone2.worldY) * f2;
                bl = true;
            }
            if (f3 > 0.0f) {
                f16 = (float)Math.sqrt(bone2.a * bone2.a + bone2.c * bone2.c);
                if (f16 != 0.0f) {
                    f16 = (f16 + ((float)Math.sqrt(f5 * f5 + f8 * f8) - f16 + this.data.offsetScaleX) * f3) / f16;
                }
                bone2.a *= f16;
                bone2.c *= f16;
                f16 = (float)Math.sqrt(bone2.b * bone2.b + bone2.d * bone2.d);
                if (f16 != 0.0f) {
                    f16 = (f16 + ((float)Math.sqrt(f7 * f7 + f6 * f6) - f16 + this.data.offsetScaleY) * f3) / f16;
                }
                bone2.b *= f16;
                bone2.d *= f16;
                bl = true;
            }
            if (f4 > 0.0f) {
                f16 = bone2.b;
                f15 = bone2.d;
                f14 = SpineUtils.atan2(f15, f16);
                f13 = SpineUtils.atan2(f6, f7) - SpineUtils.atan2(f8, f5) - (f14 - SpineUtils.atan2(bone2.c, bone2.a));
                if (f13 > (float)Math.PI) {
                    f13 -= (float)Math.PI * 2;
                } else if (f13 < (float)(-Math.PI)) {
                    f13 += (float)Math.PI * 2;
                }
                f13 = f14 + (f13 + f11) * f4;
                f12 = (float)Math.sqrt(f16 * f16 + f15 * f15);
                bone2.b = SpineUtils.cos(f13) * f12;
                bone2.d = SpineUtils.sin(f13) * f12;
                bl = true;
            }
            if (!bl) continue;
            bone2.appliedValid = false;
        }
    }

    private void applyRelativeWorld() {
        float f = this.rotateMix;
        float f2 = this.translateMix;
        float f3 = this.scaleMix;
        float f4 = this.shearMix;
        Bone bone = this.target;
        float f5 = bone.a;
        float f6 = bone.d;
        float f7 = bone.b;
        float f8 = bone.c;
        float f9 = f5 * f6 - f7 * f8 > 0.0f ? (float)Math.PI / 180 : (float)(-Math.PI) / 180;
        float f10 = this.data.offsetRotation * f9;
        float f11 = this.data.offsetShearY * f9;
        Array<Bone> array = this.bones;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            float f12;
            float f13;
            float f14;
            float f15;
            Bone bone2 = array.get(i);
            boolean bl = false;
            if (f != 0.0f) {
                f15 = bone2.a;
                f14 = bone2.b;
                f13 = bone2.c;
                f12 = bone2.d;
                float f16 = SpineUtils.atan2(f8, f5) + f10;
                if (f16 > (float)Math.PI) {
                    f16 -= (float)Math.PI * 2;
                } else if (f16 < (float)(-Math.PI)) {
                    f16 += (float)Math.PI * 2;
                }
                float f17 = SpineUtils.cos(f16 *= f);
                float f18 = SpineUtils.sin(f16);
                bone2.a = f17 * f15 - f18 * f13;
                bone2.b = f17 * f14 - f18 * f12;
                bone2.c = f18 * f15 + f17 * f13;
                bone2.d = f18 * f14 + f17 * f12;
                bl = true;
            }
            if (f2 != 0.0f) {
                Vector2 vector2 = this.temp;
                bone.localToWorld(vector2.set(this.data.offsetX, this.data.offsetY));
                bone2.worldX += vector2.x * f2;
                bone2.worldY += vector2.y * f2;
                bl = true;
            }
            if (f3 > 0.0f) {
                f15 = ((float)Math.sqrt(f5 * f5 + f8 * f8) - 1.0f + this.data.offsetScaleX) * f3 + 1.0f;
                bone2.a *= f15;
                bone2.c *= f15;
                f15 = ((float)Math.sqrt(f7 * f7 + f6 * f6) - 1.0f + this.data.offsetScaleY) * f3 + 1.0f;
                bone2.b *= f15;
                bone2.d *= f15;
                bl = true;
            }
            if (f4 > 0.0f) {
                f15 = SpineUtils.atan2(f6, f7) - SpineUtils.atan2(f8, f5);
                if (f15 > (float)Math.PI) {
                    f15 -= (float)Math.PI * 2;
                } else if (f15 < (float)(-Math.PI)) {
                    f15 += (float)Math.PI * 2;
                }
                f14 = bone2.b;
                f13 = bone2.d;
                f15 = SpineUtils.atan2(f13, f14) + (f15 - 1.5707964f + f11) * f4;
                f12 = (float)Math.sqrt(f14 * f14 + f13 * f13);
                bone2.b = SpineUtils.cos(f15) * f12;
                bone2.d = SpineUtils.sin(f15) * f12;
                bl = true;
            }
            if (!bl) continue;
            bone2.appliedValid = false;
        }
    }

    private void applyAbsoluteLocal() {
        float f = this.rotateMix;
        float f2 = this.translateMix;
        float f3 = this.scaleMix;
        float f4 = this.shearMix;
        Bone bone = this.target;
        if (!bone.appliedValid) {
            bone.updateAppliedTransform();
        }
        Array<Bone> array = this.bones;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            float f5;
            Bone bone2 = array.get(i);
            if (!bone2.appliedValid) {
                bone2.updateAppliedTransform();
            }
            float f6 = bone2.arotation;
            if (f != 0.0f) {
                f5 = bone.arotation - f6 + this.data.offsetRotation;
                f5 -= (float)((16384 - (int)(16384.499999999996 - (double)(f5 / 360.0f))) * 360);
                f6 += f5 * f;
            }
            f5 = bone2.ax;
            float f7 = bone2.ay;
            if (f2 != 0.0f) {
                f5 += (bone.ax - f5 + this.data.offsetX) * f2;
                f7 += (bone.ay - f7 + this.data.offsetY) * f2;
            }
            float f8 = bone2.ascaleX;
            float f9 = bone2.ascaleY;
            if (f3 != 0.0f) {
                if (f8 != 0.0f) {
                    f8 = (f8 + (bone.ascaleX - f8 + this.data.offsetScaleX) * f3) / f8;
                }
                if (f9 != 0.0f) {
                    f9 = (f9 + (bone.ascaleY - f9 + this.data.offsetScaleY) * f3) / f9;
                }
            }
            float f10 = bone2.ashearY;
            if (f4 != 0.0f) {
                float f11 = bone.ashearY - f10 + this.data.offsetShearY;
                f11 -= (float)((16384 - (int)(16384.499999999996 - (double)(f11 / 360.0f))) * 360);
                f10 += f11 * f4;
            }
            bone2.updateWorldTransform(f5, f7, f6, f8, f9, bone2.ashearX, f10);
        }
    }

    private void applyRelativeLocal() {
        float f = this.rotateMix;
        float f2 = this.translateMix;
        float f3 = this.scaleMix;
        float f4 = this.shearMix;
        Bone bone = this.target;
        if (!bone.appliedValid) {
            bone.updateAppliedTransform();
        }
        Array<Bone> array = this.bones;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Bone bone2 = array.get(i);
            if (!bone2.appliedValid) {
                bone2.updateAppliedTransform();
            }
            float f5 = bone2.arotation;
            if (f != 0.0f) {
                f5 += (bone.arotation + this.data.offsetRotation) * f;
            }
            float f6 = bone2.ax;
            float f7 = bone2.ay;
            if (f2 != 0.0f) {
                f6 += (bone.ax + this.data.offsetX) * f2;
                f7 += (bone.ay + this.data.offsetY) * f2;
            }
            float f8 = bone2.ascaleX;
            float f9 = bone2.ascaleY;
            if (f3 != 0.0f) {
                f8 *= (bone.ascaleX - 1.0f + this.data.offsetScaleX) * f3 + 1.0f;
                f9 *= (bone.ascaleY - 1.0f + this.data.offsetScaleY) * f3 + 1.0f;
            }
            float f10 = bone2.ashearY;
            if (f4 != 0.0f) {
                f10 += (bone.ashearY + this.data.offsetShearY) * f4;
            }
            bone2.updateWorldTransform(f6, f7, f5, f8, f9, bone2.ashearX, f10);
        }
    }

    public String toString() {
        return this.data.name;
    }
}

