/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Scaling;

public class CheckBox
extends TextButton {
    private Image image;
    private Cell imageCell;
    private CheckBoxStyle style;

    public CheckBox(String text, Skin skin) {
        this(text, skin.get(CheckBoxStyle.class));
    }

    public CheckBox(String text, CheckBoxStyle style) {
        super(text, style);
        Label label = this.getLabel();
        label.setAlignment(8);
        this.image = this.newImage();
        this.image.setDrawable(style.checkboxOff);
        this.clearChildren();
        this.imageCell = this.add(this.image);
        this.add(label);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    protected Image newImage() {
        return new Image(null, Scaling.none);
    }

    @Override
    public void setStyle(Button.ButtonStyle style) {
        if (!(style instanceof CheckBoxStyle)) {
            throw new IllegalArgumentException("style must be a CheckBoxStyle.");
        }
        this.style = (CheckBoxStyle)style;
        super.setStyle(style);
    }

    @Override
    public CheckBoxStyle getStyle() {
        return this.style;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Drawable checkbox = null;
        if (this.isDisabled()) {
            checkbox = this.isChecked && this.style.checkboxOnDisabled != null ? this.style.checkboxOnDisabled : this.style.checkboxOffDisabled;
        }
        if (checkbox == null) {
            boolean over;
            boolean bl = over = this.isOver() && !this.isDisabled();
            checkbox = this.isChecked && this.style.checkboxOn != null ? (over && this.style.checkboxOnOver != null ? this.style.checkboxOnOver : this.style.checkboxOn) : (over && this.style.checkboxOver != null ? this.style.checkboxOver : this.style.checkboxOff);
        }
        this.image.setDrawable(checkbox);
        super.draw(batch, parentAlpha);
    }

    public static class CheckBoxStyle
    extends TextButton.TextButtonStyle {
        public Drawable checkboxOn;
        public Drawable checkboxOff;
        public Drawable checkboxOnOver;
        public Drawable checkboxOver;
        public Drawable checkboxOnDisabled;
        public Drawable checkboxOffDisabled;

        public CheckBoxStyle() {
        }

        public CheckBoxStyle(CheckBoxStyle style) {
            super(style);
            this.checkboxOff = style.checkboxOff;
            this.checkboxOn = style.checkboxOn;
            this.checkboxOnOver = style.checkboxOnOver;
            this.checkboxOver = style.checkboxOver;
            this.checkboxOnDisabled = style.checkboxOnDisabled;
            this.checkboxOffDisabled = style.checkboxOffDisabled;
        }
    }
}

