/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DataInput;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonJson;
import com.esotericsoftware.spine.SkeletonLoader;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SkeletonBinary
extends SkeletonLoader {
    public SkeletonBinary(TextureAtlas textureAtlas) {
        super(textureAtlas);
    }

    @Override
    public SkeletonData readSkeletonData(FileHandle fileHandle) {
        if (fileHandle == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        SkeletonData skeletonData = this.readSkeletonData(fileHandle.read());
        skeletonData.name = fileHandle.nameWithoutExtension();
        return skeletonData;
    }

    public SkeletonData readSkeletonData(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("dataInput cannot be null.");
        }
        float f = this.scale;
        SkeletonInput skeletonInput = new SkeletonInput(inputStream);
        SkeletonData skeletonData = new SkeletonData();
        try {
            int n;
            int n2;
            int n3;
            Object object;
            int n4;
            Object object2;
            Object object3;
            long l = skeletonInput.readLong();
            skeletonData.hash = l == 0L ? null : Long.toString(l);
            skeletonData.version = skeletonInput.readString();
            if (skeletonData.version.isEmpty()) {
                skeletonData.version = null;
            }
            skeletonData.x = skeletonInput.readFloat();
            skeletonData.y = skeletonInput.readFloat();
            skeletonData.width = skeletonInput.readFloat();
            skeletonData.height = skeletonInput.readFloat();
            boolean bl = skeletonInput.readBoolean();
            if (bl) {
                skeletonData.fps = skeletonInput.readFloat();
                skeletonData.imagesPath = skeletonInput.readString();
                if (skeletonData.imagesPath.isEmpty()) {
                    skeletonData.imagesPath = null;
                }
                skeletonData.audioPath = skeletonInput.readString();
                if (skeletonData.audioPath.isEmpty()) {
                    skeletonData.audioPath = null;
                }
            }
            int n5 = skeletonInput.readInt(true);
            skeletonInput.strings = new String[n5];
            Object[] objectArray = skeletonInput.strings;
            for (int i = 0; i < n5; ++i) {
                objectArray[i] = skeletonInput.readString();
            }
            n5 = skeletonInput.readInt(true);
            BoneData[] boneDataArray = skeletonData.bones.setSize(n5);
            for (int i = 0; i < n5; ++i) {
                String string = skeletonInput.readString();
                object3 = i == 0 ? null : boneDataArray[skeletonInput.readInt(true)];
                object2 = new BoneData(i, string, (BoneData)object3);
                ((BoneData)object2).rotation = skeletonInput.readFloat();
                ((BoneData)object2).x = skeletonInput.readFloat() * f;
                ((BoneData)object2).y = skeletonInput.readFloat() * f;
                ((BoneData)object2).scaleX = skeletonInput.readFloat();
                ((BoneData)object2).scaleY = skeletonInput.readFloat();
                ((BoneData)object2).shearX = skeletonInput.readFloat();
                ((BoneData)object2).shearY = skeletonInput.readFloat();
                ((BoneData)object2).length = skeletonInput.readFloat() * f;
                ((BoneData)object2).transformMode = BoneData.TransformMode.values[skeletonInput.readInt(true)];
                ((BoneData)object2).skinRequired = skeletonInput.readBoolean();
                if (bl) {
                    Color.rgba8888ToColor(((BoneData)object2).color, skeletonInput.readInt());
                }
                boneDataArray[i] = object2;
            }
            n5 = skeletonInput.readInt(true);
            SlotData[] slotDataArray = skeletonData.slots.setSize(n5);
            for (n4 = 0; n4 < n5; ++n4) {
                object3 = skeletonInput.readString();
                object2 = boneDataArray[skeletonInput.readInt(true)];
                object = new SlotData(n4, (String)object3, (BoneData)object2);
                Color.rgba8888ToColor(object.color, skeletonInput.readInt());
                n3 = skeletonInput.readInt();
                if (n3 != -1) {
                    object.darkColor = new Color();
                    Color.rgb888ToColor(object.darkColor, n3);
                }
                object.attachmentName = skeletonInput.readStringRef();
                object.blendMode = BlendMode.values[skeletonInput.readInt(true)];
                slotDataArray[n4] = object;
            }
            n5 = skeletonInput.readInt(true);
            objectArray = skeletonData.ikConstraints.setSize(n5);
            for (n4 = 0; n4 < n5; ++n4) {
                object2 = new IkConstraintData(skeletonInput.readString());
                ((IkConstraintData)object2).order = skeletonInput.readInt(true);
                ((IkConstraintData)object2).skinRequired = skeletonInput.readBoolean();
                int n6 = skeletonInput.readInt(true);
                object = ((IkConstraintData)object2).bones.setSize(n6);
                for (n3 = 0; n3 < n6; ++n3) {
                    object[n3] = boneDataArray[skeletonInput.readInt(true)];
                }
                ((IkConstraintData)object2).target = boneDataArray[skeletonInput.readInt(true)];
                ((IkConstraintData)object2).mix = skeletonInput.readFloat();
                ((IkConstraintData)object2).softness = skeletonInput.readFloat() * f;
                ((IkConstraintData)object2).bendDirection = skeletonInput.readByte();
                ((IkConstraintData)object2).compress = skeletonInput.readBoolean();
                ((IkConstraintData)object2).stretch = skeletonInput.readBoolean();
                ((IkConstraintData)object2).uniform = skeletonInput.readBoolean();
                objectArray[n4] = object2;
            }
            n5 = skeletonInput.readInt(true);
            objectArray = skeletonData.transformConstraints.setSize(n5);
            for (n4 = 0; n4 < n5; ++n4) {
                object2 = new TransformConstraintData(skeletonInput.readString());
                ((TransformConstraintData)object2).order = skeletonInput.readInt(true);
                ((TransformConstraintData)object2).skinRequired = skeletonInput.readBoolean();
                int n7 = skeletonInput.readInt(true);
                object = ((TransformConstraintData)object2).bones.setSize(n7);
                for (n3 = 0; n3 < n7; ++n3) {
                    object[n3] = boneDataArray[skeletonInput.readInt(true)];
                }
                ((TransformConstraintData)object2).target = boneDataArray[skeletonInput.readInt(true)];
                ((TransformConstraintData)object2).local = skeletonInput.readBoolean();
                ((TransformConstraintData)object2).relative = skeletonInput.readBoolean();
                ((TransformConstraintData)object2).offsetRotation = skeletonInput.readFloat();
                ((TransformConstraintData)object2).offsetX = skeletonInput.readFloat() * f;
                ((TransformConstraintData)object2).offsetY = skeletonInput.readFloat() * f;
                ((TransformConstraintData)object2).offsetScaleX = skeletonInput.readFloat();
                ((TransformConstraintData)object2).offsetScaleY = skeletonInput.readFloat();
                ((TransformConstraintData)object2).offsetShearY = skeletonInput.readFloat();
                ((TransformConstraintData)object2).mixRotate = skeletonInput.readFloat();
                ((TransformConstraintData)object2).mixX = skeletonInput.readFloat();
                ((TransformConstraintData)object2).mixY = skeletonInput.readFloat();
                ((TransformConstraintData)object2).mixScaleX = skeletonInput.readFloat();
                ((TransformConstraintData)object2).mixScaleY = skeletonInput.readFloat();
                ((TransformConstraintData)object2).mixShearY = skeletonInput.readFloat();
                objectArray[n4] = object2;
            }
            n5 = skeletonInput.readInt(true);
            objectArray = skeletonData.pathConstraints.setSize(n5);
            for (n4 = 0; n4 < n5; ++n4) {
                object2 = new PathConstraintData(skeletonInput.readString());
                ((PathConstraintData)object2).order = skeletonInput.readInt(true);
                ((PathConstraintData)object2).skinRequired = skeletonInput.readBoolean();
                int n8 = skeletonInput.readInt(true);
                object = ((PathConstraintData)object2).bones.setSize(n8);
                for (n3 = 0; n3 < n8; ++n3) {
                    object[n3] = boneDataArray[skeletonInput.readInt(true)];
                }
                ((PathConstraintData)object2).target = slotDataArray[skeletonInput.readInt(true)];
                ((PathConstraintData)object2).positionMode = PathConstraintData.PositionMode.values[skeletonInput.readInt(true)];
                ((PathConstraintData)object2).spacingMode = PathConstraintData.SpacingMode.values[skeletonInput.readInt(true)];
                ((PathConstraintData)object2).rotateMode = PathConstraintData.RotateMode.values[skeletonInput.readInt(true)];
                ((PathConstraintData)object2).offsetRotation = skeletonInput.readFloat();
                ((PathConstraintData)object2).position = skeletonInput.readFloat();
                if (((PathConstraintData)object2).positionMode == PathConstraintData.PositionMode.fixed) {
                    ((PathConstraintData)object2).position *= f;
                }
                ((PathConstraintData)object2).spacing = skeletonInput.readFloat();
                if (((PathConstraintData)object2).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)object2).spacingMode == PathConstraintData.SpacingMode.fixed) {
                    ((PathConstraintData)object2).spacing *= f;
                }
                ((PathConstraintData)object2).mixRotate = skeletonInput.readFloat();
                ((PathConstraintData)object2).mixX = skeletonInput.readFloat();
                ((PathConstraintData)object2).mixY = skeletonInput.readFloat();
                objectArray[n4] = object2;
            }
            Skin skin = this.readSkin(skeletonInput, skeletonData, true, bl);
            if (skin != null) {
                skeletonData.defaultSkin = skin;
                skeletonData.skins.add(skin);
            }
            n5 = n2 + skeletonInput.readInt(true);
            objectArray = skeletonData.skins.setSize(n5);
            for (n2 = skeletonData.skins.size; n2 < n5; ++n2) {
                objectArray[n2] = this.readSkin(skeletonInput, skeletonData, false, bl);
            }
            n5 = this.linkedMeshes.size;
            T[] TArray = this.linkedMeshes.items;
            for (n = 0; n < n5; ++n) {
                Skin skin2;
                object = (SkeletonJson.LinkedMesh)TArray[n];
                Skin skin3 = skin2 = object.skin == null ? skeletonData.getDefaultSkin() : skeletonData.findSkin(object.skin);
                if (skin2 == null) {
                    throw new SerializationException("Skin not found: " + object.skin);
                }
                Attachment attachment = skin2.getAttachment(object.slotIndex, object.parent);
                if (attachment == null) {
                    throw new SerializationException("Parent mesh not found: " + object.parent);
                }
                object.mesh.setDeformAttachment(object.inheritDeform ? (VertexAttachment)attachment : object.mesh);
                object.mesh.setParentMesh((MeshAttachment)attachment);
                object.mesh.updateUVs();
            }
            this.linkedMeshes.clear();
            n5 = skeletonInput.readInt(true);
            objectArray = skeletonData.events.setSize(n5);
            for (n = 0; n < n5; ++n) {
                object = new EventData(skeletonInput.readStringRef());
                object.intValue = skeletonInput.readInt(false);
                object.floatValue = skeletonInput.readFloat();
                object.stringValue = skeletonInput.readString();
                object.audioPath = skeletonInput.readString();
                if (object.audioPath != null) {
                    object.volume = skeletonInput.readFloat();
                    object.balance = skeletonInput.readFloat();
                }
                objectArray[n] = object;
            }
            n5 = skeletonInput.readInt(true);
            objectArray = skeletonData.animations.setSize(n5);
            for (n = 0; n < n5; ++n) {
                objectArray[n] = this.readAnimation(skeletonInput, skeletonInput.readString(), skeletonData);
            }
        }
        catch (IOException iOException) {
            throw new SerializationException("Error reading skeleton file.", iOException);
        }
        finally {
            try {
                skeletonInput.close();
            }
            catch (IOException iOException) {}
        }
        return skeletonData;
    }

    private Skin readSkin(SkeletonInput skeletonInput, SkeletonData skeletonData, boolean bl, boolean bl2) throws IOException {
        int n;
        int n2;
        Skin skin;
        int n3;
        if (bl) {
            n3 = skeletonInput.readInt(true);
            if (n3 == 0) {
                return null;
            }
            skin = new Skin("default");
        } else {
            skin = new Skin(skeletonInput.readStringRef());
            BoneData[] boneDataArray = skin.bones.setSize(skeletonInput.readInt(true));
            T[] TArray = skeletonData.bones.items;
            n2 = skin.bones.size;
            for (n = 0; n < n2; ++n) {
                boneDataArray[n] = TArray[skeletonInput.readInt(true)];
            }
            TArray = skeletonData.ikConstraints.items;
            n2 = skeletonInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                skin.constraints.add((ConstraintData)TArray[skeletonInput.readInt(true)]);
            }
            TArray = skeletonData.transformConstraints.items;
            n2 = skeletonInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                skin.constraints.add((ConstraintData)TArray[skeletonInput.readInt(true)]);
            }
            TArray = skeletonData.pathConstraints.items;
            n2 = skeletonInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                skin.constraints.add((ConstraintData)TArray[skeletonInput.readInt(true)]);
            }
            skin.constraints.shrink();
            n3 = skeletonInput.readInt(true);
        }
        for (int i = 0; i < n3; ++i) {
            int n4 = skeletonInput.readInt(true);
            n2 = skeletonInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                String string = skeletonInput.readStringRef();
                Attachment attachment = this.readAttachment(skeletonInput, skeletonData, skin, n4, string, bl2);
                if (attachment == null) continue;
                skin.setAttachment(n4, string, attachment);
            }
        }
        return skin;
    }

    private Attachment readAttachment(SkeletonInput skeletonInput, SkeletonData skeletonData, Skin skin, int n, String string, boolean bl) throws IOException {
        float f = this.scale;
        String string2 = skeletonInput.readStringRef();
        if (string2 == null) {
            string2 = string;
        }
        switch (AttachmentType.values[skeletonInput.readByte()]) {
            case region: {
                RegionAttachment regionAttachment;
                String string3 = skeletonInput.readStringRef();
                float f2 = skeletonInput.readFloat();
                float f3 = skeletonInput.readFloat();
                float f4 = skeletonInput.readFloat();
                float f5 = skeletonInput.readFloat();
                float f6 = skeletonInput.readFloat();
                float f7 = skeletonInput.readFloat();
                float f8 = skeletonInput.readFloat();
                int n2 = skeletonInput.readInt();
                if (string3 == null) {
                    string3 = string2;
                }
                if ((regionAttachment = this.attachmentLoader.newRegionAttachment(skin, string2, string3)) == null) {
                    return null;
                }
                regionAttachment.setPath(string3);
                regionAttachment.setX(f3 * f);
                regionAttachment.setY(f4 * f);
                regionAttachment.setScaleX(f5);
                regionAttachment.setScaleY(f6);
                regionAttachment.setRotation(f2);
                regionAttachment.setWidth(f7 * f);
                regionAttachment.setHeight(f8 * f);
                Color.rgba8888ToColor(regionAttachment.getColor(), n2);
                regionAttachment.updateOffset();
                return regionAttachment;
            }
            case boundingbox: {
                int n3 = skeletonInput.readInt(true);
                Vertices vertices = this.readVertices(skeletonInput, n3);
                int n4 = bl ? skeletonInput.readInt() : 0;
                BoundingBoxAttachment boundingBoxAttachment = this.attachmentLoader.newBoundingBoxAttachment(skin, string2);
                if (boundingBoxAttachment == null) {
                    return null;
                }
                boundingBoxAttachment.setWorldVerticesLength(n3 << 1);
                boundingBoxAttachment.setVertices(vertices.vertices);
                boundingBoxAttachment.setBones(vertices.bones);
                if (bl) {
                    Color.rgba8888ToColor(boundingBoxAttachment.getColor(), n4);
                }
                return boundingBoxAttachment;
            }
            case mesh: {
                MeshAttachment meshAttachment;
                String string4 = skeletonInput.readStringRef();
                int n5 = skeletonInput.readInt();
                int n6 = skeletonInput.readInt(true);
                float[] fArray = this.readFloatArray(skeletonInput, n6 << 1, 1.0f);
                short[] sArray = this.readShortArray(skeletonInput);
                Vertices vertices = this.readVertices(skeletonInput, n6);
                int n7 = skeletonInput.readInt(true);
                short[] sArray2 = null;
                float f9 = 0.0f;
                float f10 = 0.0f;
                if (bl) {
                    sArray2 = this.readShortArray(skeletonInput);
                    f9 = skeletonInput.readFloat();
                    f10 = skeletonInput.readFloat();
                }
                if (string4 == null) {
                    string4 = string2;
                }
                if ((meshAttachment = this.attachmentLoader.newMeshAttachment(skin, string2, string4)) == null) {
                    return null;
                }
                meshAttachment.setPath(string4);
                Color.rgba8888ToColor(meshAttachment.getColor(), n5);
                meshAttachment.setBones(vertices.bones);
                meshAttachment.setVertices(vertices.vertices);
                meshAttachment.setWorldVerticesLength(n6 << 1);
                meshAttachment.setTriangles(sArray);
                meshAttachment.setRegionUVs(fArray);
                meshAttachment.updateUVs();
                meshAttachment.setHullLength(n7 << 1);
                if (bl) {
                    meshAttachment.setEdges(sArray2);
                    meshAttachment.setWidth(f9 * f);
                    meshAttachment.setHeight(f10 * f);
                }
                return meshAttachment;
            }
            case linkedmesh: {
                MeshAttachment meshAttachment;
                String string5 = skeletonInput.readStringRef();
                int n8 = skeletonInput.readInt();
                String string6 = skeletonInput.readStringRef();
                String string7 = skeletonInput.readStringRef();
                boolean bl2 = skeletonInput.readBoolean();
                float f11 = 0.0f;
                float f12 = 0.0f;
                if (bl) {
                    f11 = skeletonInput.readFloat();
                    f12 = skeletonInput.readFloat();
                }
                if (string5 == null) {
                    string5 = string2;
                }
                if ((meshAttachment = this.attachmentLoader.newMeshAttachment(skin, string2, string5)) == null) {
                    return null;
                }
                meshAttachment.setPath(string5);
                Color.rgba8888ToColor(meshAttachment.getColor(), n8);
                if (bl) {
                    meshAttachment.setWidth(f11 * f);
                    meshAttachment.setHeight(f12 * f);
                }
                this.linkedMeshes.add(new SkeletonJson.LinkedMesh(meshAttachment, string6, n, string7, bl2));
                return meshAttachment;
            }
            case path: {
                int n9;
                boolean bl3 = skeletonInput.readBoolean();
                boolean bl4 = skeletonInput.readBoolean();
                int n10 = skeletonInput.readInt(true);
                Vertices vertices = this.readVertices(skeletonInput, n10);
                float[] fArray = new float[n10 / 3];
                int n11 = fArray.length;
                for (n9 = 0; n9 < n11; ++n9) {
                    fArray[n9] = skeletonInput.readFloat() * f;
                }
                n9 = bl ? skeletonInput.readInt() : 0;
                PathAttachment pathAttachment = this.attachmentLoader.newPathAttachment(skin, string2);
                if (pathAttachment == null) {
                    return null;
                }
                pathAttachment.setClosed(bl3);
                pathAttachment.setConstantSpeed(bl4);
                pathAttachment.setWorldVerticesLength(n10 << 1);
                pathAttachment.setVertices(vertices.vertices);
                pathAttachment.setBones(vertices.bones);
                pathAttachment.setLengths(fArray);
                if (bl) {
                    Color.rgba8888ToColor(pathAttachment.getColor(), n9);
                }
                return pathAttachment;
            }
            case point: {
                float f13 = skeletonInput.readFloat();
                float f14 = skeletonInput.readFloat();
                float f15 = skeletonInput.readFloat();
                int n12 = bl ? skeletonInput.readInt() : 0;
                PointAttachment pointAttachment = this.attachmentLoader.newPointAttachment(skin, string2);
                if (pointAttachment == null) {
                    return null;
                }
                pointAttachment.setX(f14 * f);
                pointAttachment.setY(f15 * f);
                pointAttachment.setRotation(f13);
                if (bl) {
                    Color.rgba8888ToColor(pointAttachment.getColor(), n12);
                }
                return pointAttachment;
            }
            case clipping: {
                int n13 = skeletonInput.readInt(true);
                int n14 = skeletonInput.readInt(true);
                Vertices vertices = this.readVertices(skeletonInput, n14);
                int n15 = bl ? skeletonInput.readInt() : 0;
                ClippingAttachment clippingAttachment = this.attachmentLoader.newClippingAttachment(skin, string2);
                if (clippingAttachment == null) {
                    return null;
                }
                clippingAttachment.setEndSlot(skeletonData.slots.get(n13));
                clippingAttachment.setWorldVerticesLength(n14 << 1);
                clippingAttachment.setVertices(vertices.vertices);
                clippingAttachment.setBones(vertices.bones);
                if (bl) {
                    Color.rgba8888ToColor(clippingAttachment.getColor(), n15);
                }
                return clippingAttachment;
            }
        }
        return null;
    }

    private Vertices readVertices(SkeletonInput skeletonInput, int n) throws IOException {
        float f = this.scale;
        int n2 = n << 1;
        Vertices vertices = new Vertices();
        if (!skeletonInput.readBoolean()) {
            vertices.vertices = this.readFloatArray(skeletonInput, n2, f);
            return vertices;
        }
        FloatArray floatArray = new FloatArray(n2 * 3 * 3);
        IntArray intArray = new IntArray(n2 * 3);
        for (int i = 0; i < n; ++i) {
            int n3 = skeletonInput.readInt(true);
            intArray.add(n3);
            for (int j = 0; j < n3; ++j) {
                intArray.add(skeletonInput.readInt(true));
                floatArray.add(skeletonInput.readFloat() * f);
                floatArray.add(skeletonInput.readFloat() * f);
                floatArray.add(skeletonInput.readFloat());
            }
        }
        vertices.vertices = floatArray.toArray();
        vertices.bones = intArray.toArray();
        return vertices;
    }

    private float[] readFloatArray(SkeletonInput skeletonInput, int n, float f) throws IOException {
        float[] fArray = new float[n];
        if (f == 1.0f) {
            for (int i = 0; i < n; ++i) {
                fArray[i] = skeletonInput.readFloat();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                fArray[i] = skeletonInput.readFloat() * f;
            }
        }
        return fArray;
    }

    private short[] readShortArray(SkeletonInput skeletonInput) throws IOException {
        int n = skeletonInput.readInt(true);
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = skeletonInput.readShort();
        }
        return sArray;
    }

    private Animation readAnimation(SkeletonInput skeletonInput, String string, SkeletonData skeletonData) throws IOException {
        int n;
        float f;
        float f2;
        float f3;
        float f4;
        int n2;
        int n3;
        int n4;
        byte by;
        int n5;
        int n6;
        int n7;
        int n8;
        Array<Animation.Timeline> array = new Array<Animation.Timeline>(skeletonInput.readInt(true));
        float f5 = this.scale;
        int n9 = skeletonInput.readInt(true);
        for (n8 = 0; n8 < n9; ++n8) {
            n7 = skeletonInput.readInt(true);
            n6 = skeletonInput.readInt(true);
            block62: for (n5 = 0; n5 < n6; ++n5) {
                by = skeletonInput.readByte();
                n4 = skeletonInput.readInt(true);
                n3 = n4 - 1;
                switch (by) {
                    case 0: {
                        Animation.Timeline timeline = new Animation.AttachmentTimeline(n4, n7);
                        for (n2 = 0; n2 < n4; ++n2) {
                            ((Animation.AttachmentTimeline)timeline).setFrame(n2, skeletonInput.readFloat(), skeletonInput.readStringRef());
                        }
                        array.add(timeline);
                        continue block62;
                    }
                    case 1: {
                        Animation.Timeline timeline = new Animation.RGBATimeline(n4, skeletonInput.readInt(true), n7);
                        float f6 = skeletonInput.readFloat();
                        float f7 = (float)skeletonInput.read() / 255.0f;
                        float f8 = (float)skeletonInput.read() / 255.0f;
                        float f9 = (float)skeletonInput.read() / 255.0f;
                        f4 = (float)skeletonInput.read() / 255.0f;
                        int n10 = 0;
                        int n11 = 0;
                        while (true) {
                            ((Animation.RGBATimeline)timeline).setFrame(n10, f6, f7, f8, f9, f4);
                            if (n10 == n3) break;
                            float f10 = skeletonInput.readFloat();
                            float f11 = (float)skeletonInput.read() / 255.0f;
                            float f12 = (float)skeletonInput.read() / 255.0f;
                            f3 = (float)skeletonInput.read() / 255.0f;
                            f2 = (float)skeletonInput.read() / 255.0f;
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(n10);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n11++, n10, 0, f6, f10, f7, f11, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n11++, n10, 1, f6, f10, f8, f12, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n11++, n10, 2, f6, f10, f9, f3, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n11++, n10, 3, f6, f10, f4, f2, 1.0f);
                                }
                            }
                            f6 = f10;
                            f7 = f11;
                            f8 = f12;
                            f9 = f3;
                            f4 = f2;
                            ++n10;
                        }
                        array.add(timeline);
                        continue block62;
                    }
                    case 2: {
                        Animation.Timeline timeline = new Animation.RGBTimeline(n4, skeletonInput.readInt(true), n7);
                        float f13 = skeletonInput.readFloat();
                        float f7 = (float)skeletonInput.read() / 255.0f;
                        float f14 = (float)skeletonInput.read() / 255.0f;
                        float f15 = (float)skeletonInput.read() / 255.0f;
                        int n12 = 0;
                        int n13 = 0;
                        while (true) {
                            ((Animation.RGBTimeline)timeline).setFrame(n12, f13, f7, f14, f15);
                            if (n12 == n3) break;
                            float f16 = skeletonInput.readFloat();
                            float f17 = (float)skeletonInput.read() / 255.0f;
                            float f18 = (float)skeletonInput.read() / 255.0f;
                            float f19 = (float)skeletonInput.read() / 255.0f;
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(n12);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n13++, n12, 0, f13, f16, f7, f17, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n13++, n12, 1, f13, f16, f14, f18, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n13++, n12, 2, f13, f16, f15, f19, 1.0f);
                                }
                            }
                            f13 = f16;
                            f7 = f17;
                            f14 = f18;
                            f15 = f19;
                            ++n12;
                        }
                        array.add(timeline);
                        continue block62;
                    }
                    case 3: {
                        float f20;
                        float f21;
                        float f22;
                        Animation.Timeline timeline = new Animation.RGBA2Timeline(n4, skeletonInput.readInt(true), n7);
                        float f23 = skeletonInput.readFloat();
                        float f7 = (float)skeletonInput.read() / 255.0f;
                        float f24 = (float)skeletonInput.read() / 255.0f;
                        float f25 = (float)skeletonInput.read() / 255.0f;
                        f4 = (float)skeletonInput.read() / 255.0f;
                        float f26 = (float)skeletonInput.read() / 255.0f;
                        float f27 = (float)skeletonInput.read() / 255.0f;
                        float f28 = (float)skeletonInput.read() / 255.0f;
                        int n14 = 0;
                        int n15 = 0;
                        while (true) {
                            ((Animation.RGBA2Timeline)timeline).setFrame(n14, f23, f7, f24, f25, f4, f26, f27, f28);
                            if (n14 == n3) break;
                            f3 = skeletonInput.readFloat();
                            f2 = (float)skeletonInput.read() / 255.0f;
                            f = (float)skeletonInput.read() / 255.0f;
                            f22 = (float)skeletonInput.read() / 255.0f;
                            f21 = (float)skeletonInput.read() / 255.0f;
                            f20 = (float)skeletonInput.read() / 255.0f;
                            float f29 = (float)skeletonInput.read() / 255.0f;
                            float f30 = (float)skeletonInput.read() / 255.0f;
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(n14);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n15++, n14, 0, f23, f3, f7, f2, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n15++, n14, 1, f23, f3, f24, f, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n15++, n14, 2, f23, f3, f25, f22, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n15++, n14, 3, f23, f3, f4, f21, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n15++, n14, 4, f23, f3, f26, f20, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n15++, n14, 5, f23, f3, f27, f29, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n15++, n14, 6, f23, f3, f28, f30, 1.0f);
                                }
                            }
                            f23 = f3;
                            f7 = f2;
                            f24 = f;
                            f25 = f22;
                            f4 = f21;
                            f26 = f20;
                            f27 = f29;
                            f28 = f30;
                            ++n14;
                        }
                        array.add(timeline);
                        continue block62;
                    }
                    case 4: {
                        float f20;
                        float f21;
                        float f22;
                        Animation.Timeline timeline = new Animation.RGB2Timeline(n4, skeletonInput.readInt(true), n7);
                        float f31 = skeletonInput.readFloat();
                        float f7 = (float)skeletonInput.read() / 255.0f;
                        float f32 = (float)skeletonInput.read() / 255.0f;
                        float f33 = (float)skeletonInput.read() / 255.0f;
                        f4 = (float)skeletonInput.read() / 255.0f;
                        float f34 = (float)skeletonInput.read() / 255.0f;
                        float f35 = (float)skeletonInput.read() / 255.0f;
                        int n16 = 0;
                        int n14 = 0;
                        while (true) {
                            ((Animation.RGB2Timeline)timeline).setFrame(n16, f31, f7, f32, f33, f4, f34, f35);
                            if (n16 == n3) break;
                            float f36 = skeletonInput.readFloat();
                            f3 = (float)skeletonInput.read() / 255.0f;
                            f2 = (float)skeletonInput.read() / 255.0f;
                            f = (float)skeletonInput.read() / 255.0f;
                            f22 = (float)skeletonInput.read() / 255.0f;
                            f21 = (float)skeletonInput.read() / 255.0f;
                            f20 = (float)skeletonInput.read() / 255.0f;
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(n16);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n16, 0, f31, f36, f7, f3, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n16, 1, f31, f36, f32, f2, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n16, 2, f31, f36, f33, f, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n16, 3, f31, f36, f4, f22, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n16, 4, f31, f36, f34, f21, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n16, 5, f31, f36, f35, f20, 1.0f);
                                }
                            }
                            f31 = f36;
                            f7 = f3;
                            f32 = f2;
                            f33 = f;
                            f4 = f22;
                            f34 = f21;
                            f35 = f20;
                            ++n16;
                        }
                        array.add(timeline);
                        continue block62;
                    }
                    case 5: {
                        Animation.Timeline timeline = new Animation.AlphaTimeline(n4, skeletonInput.readInt(true), n7);
                        float f37 = skeletonInput.readFloat();
                        float f7 = (float)skeletonInput.read() / 255.0f;
                        int n17 = 0;
                        int n18 = 0;
                        while (true) {
                            ((Animation.CurveTimeline1)timeline).setFrame(n17, f37, f7);
                            if (n17 == n3) break;
                            f4 = skeletonInput.readFloat();
                            float f38 = (float)skeletonInput.read() / 255.0f;
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(n17);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n18++, n17, 0, f37, f4, f7, f38, 1.0f);
                                }
                            }
                            f37 = f4;
                            f7 = f38;
                            ++n17;
                        }
                        array.add(timeline);
                    }
                }
            }
        }
        n9 = skeletonInput.readInt(true);
        for (n8 = 0; n8 < n9; ++n8) {
            n7 = skeletonInput.readInt(true);
            n6 = skeletonInput.readInt(true);
            block70: for (n5 = 0; n5 < n6; ++n5) {
                by = skeletonInput.readByte();
                n4 = skeletonInput.readInt(true);
                n3 = skeletonInput.readInt(true);
                switch (by) {
                    case 0: {
                        array.add(this.readTimeline(skeletonInput, new Animation.RotateTimeline(n4, n3, n7), 1.0f));
                        continue block70;
                    }
                    case 1: {
                        array.add(this.readTimeline(skeletonInput, new Animation.TranslateTimeline(n4, n3, n7), f5));
                        continue block70;
                    }
                    case 2: {
                        array.add(this.readTimeline(skeletonInput, new Animation.TranslateXTimeline(n4, n3, n7), f5));
                        continue block70;
                    }
                    case 3: {
                        array.add(this.readTimeline(skeletonInput, new Animation.TranslateYTimeline(n4, n3, n7), f5));
                        continue block70;
                    }
                    case 4: {
                        array.add(this.readTimeline(skeletonInput, new Animation.ScaleTimeline(n4, n3, n7), 1.0f));
                        continue block70;
                    }
                    case 5: {
                        array.add(this.readTimeline(skeletonInput, new Animation.ScaleXTimeline(n4, n3, n7), 1.0f));
                        continue block70;
                    }
                    case 6: {
                        array.add(this.readTimeline(skeletonInput, new Animation.ScaleYTimeline(n4, n3, n7), 1.0f));
                        continue block70;
                    }
                    case 7: {
                        array.add(this.readTimeline(skeletonInput, new Animation.ShearTimeline(n4, n3, n7), 1.0f));
                        continue block70;
                    }
                    case 8: {
                        array.add(this.readTimeline(skeletonInput, new Animation.ShearXTimeline(n4, n3, n7), 1.0f));
                        continue block70;
                    }
                    case 9: {
                        array.add(this.readTimeline(skeletonInput, new Animation.ShearYTimeline(n4, n3, n7), 1.0f));
                    }
                }
            }
        }
        n9 = skeletonInput.readInt(true);
        for (n8 = 0; n8 < n9; ++n8) {
            n7 = skeletonInput.readInt(true);
            n5 = skeletonInput.readInt(true);
            n6 = n5 - 1;
            Animation.IkConstraintTimeline ikConstraintTimeline = new Animation.IkConstraintTimeline(n5, skeletonInput.readInt(true), n7);
            float f39 = skeletonInput.readFloat();
            float f40 = skeletonInput.readFloat();
            float f41 = skeletonInput.readFloat() * f5;
            n2 = 0;
            int n19 = 0;
            while (true) {
                ikConstraintTimeline.setFrame(n2, f39, f40, f41, skeletonInput.readByte(), skeletonInput.readBoolean(), skeletonInput.readBoolean());
                if (n2 == n6) break;
                float f42 = skeletonInput.readFloat();
                float f43 = skeletonInput.readFloat();
                f4 = skeletonInput.readFloat() * f5;
                switch (skeletonInput.readByte()) {
                    case 1: {
                        ikConstraintTimeline.setStepped(n2);
                        break;
                    }
                    case 2: {
                        this.setBezier(skeletonInput, ikConstraintTimeline, n19++, n2, 0, f39, f42, f40, f43, 1.0f);
                        this.setBezier(skeletonInput, ikConstraintTimeline, n19++, n2, 1, f39, f42, f41, f4, f5);
                    }
                }
                f39 = f42;
                f40 = f43;
                f41 = f4;
                ++n2;
            }
            array.add(ikConstraintTimeline);
        }
        n9 = skeletonInput.readInt(true);
        for (n8 = 0; n8 < n9; ++n8) {
            n7 = skeletonInput.readInt(true);
            n5 = skeletonInput.readInt(true);
            n6 = n5 - 1;
            Animation.TransformConstraintTimeline transformConstraintTimeline = new Animation.TransformConstraintTimeline(n5, skeletonInput.readInt(true), n7);
            float f44 = skeletonInput.readFloat();
            float f45 = skeletonInput.readFloat();
            float f46 = skeletonInput.readFloat();
            float f47 = skeletonInput.readFloat();
            float f48 = skeletonInput.readFloat();
            float f49 = skeletonInput.readFloat();
            float f50 = skeletonInput.readFloat();
            int n20 = 0;
            int n21 = 0;
            while (true) {
                transformConstraintTimeline.setFrame(n20, f44, f45, f46, f47, f48, f49, f50);
                if (n20 == n6) break;
                float f51 = skeletonInput.readFloat();
                float f52 = skeletonInput.readFloat();
                float f53 = skeletonInput.readFloat();
                float f54 = skeletonInput.readFloat();
                f3 = skeletonInput.readFloat();
                f2 = skeletonInput.readFloat();
                f = skeletonInput.readFloat();
                switch (skeletonInput.readByte()) {
                    case 1: {
                        transformConstraintTimeline.setStepped(n20);
                        break;
                    }
                    case 2: {
                        this.setBezier(skeletonInput, transformConstraintTimeline, n21++, n20, 0, f44, f51, f45, f52, 1.0f);
                        this.setBezier(skeletonInput, transformConstraintTimeline, n21++, n20, 1, f44, f51, f46, f53, 1.0f);
                        this.setBezier(skeletonInput, transformConstraintTimeline, n21++, n20, 2, f44, f51, f47, f54, 1.0f);
                        this.setBezier(skeletonInput, transformConstraintTimeline, n21++, n20, 3, f44, f51, f48, f3, 1.0f);
                        this.setBezier(skeletonInput, transformConstraintTimeline, n21++, n20, 4, f44, f51, f49, f2, 1.0f);
                        this.setBezier(skeletonInput, transformConstraintTimeline, n21++, n20, 5, f44, f51, f50, f, 1.0f);
                    }
                }
                f44 = f51;
                f45 = f52;
                f46 = f53;
                f47 = f54;
                f48 = f3;
                f49 = f2;
                f50 = f;
                ++n20;
            }
            array.add(transformConstraintTimeline);
        }
        n9 = skeletonInput.readInt(true);
        for (n8 = 0; n8 < n9; ++n8) {
            n7 = skeletonInput.readInt(true);
            PathConstraintData pathConstraintData = skeletonData.pathConstraints.get(n7);
            int n22 = skeletonInput.readInt(true);
            block76: for (n6 = 0; n6 < n22; ++n6) {
                switch (skeletonInput.readByte()) {
                    case 0: {
                        array.add(this.readTimeline(skeletonInput, new Animation.PathConstraintPositionTimeline(skeletonInput.readInt(true), skeletonInput.readInt(true), n7), pathConstraintData.positionMode == PathConstraintData.PositionMode.fixed ? f5 : 1.0f));
                        continue block76;
                    }
                    case 1: {
                        array.add(this.readTimeline(skeletonInput, new Animation.PathConstraintSpacingTimeline(skeletonInput.readInt(true), skeletonInput.readInt(true), n7), pathConstraintData.spacingMode == PathConstraintData.SpacingMode.length || pathConstraintData.spacingMode == PathConstraintData.SpacingMode.fixed ? f5 : 1.0f));
                        continue block76;
                    }
                    case 2: {
                        Animation.PathConstraintMixTimeline pathConstraintMixTimeline = new Animation.PathConstraintMixTimeline(skeletonInput.readInt(true), skeletonInput.readInt(true), n7);
                        float f55 = skeletonInput.readFloat();
                        float f56 = skeletonInput.readFloat();
                        float f57 = skeletonInput.readFloat();
                        float f58 = skeletonInput.readFloat();
                        int n23 = 0;
                        int n24 = 0;
                        int n25 = pathConstraintMixTimeline.getFrameCount() - 1;
                        while (true) {
                            pathConstraintMixTimeline.setFrame(n23, f55, f56, f57, f58);
                            if (n23 == n25) break;
                            float f59 = skeletonInput.readFloat();
                            float f60 = skeletonInput.readFloat();
                            float f61 = skeletonInput.readFloat();
                            float f62 = skeletonInput.readFloat();
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    pathConstraintMixTimeline.setStepped(n23);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, pathConstraintMixTimeline, n24++, n23, 0, f55, f59, f56, f60, 1.0f);
                                    this.setBezier(skeletonInput, pathConstraintMixTimeline, n24++, n23, 1, f55, f59, f57, f61, 1.0f);
                                    this.setBezier(skeletonInput, pathConstraintMixTimeline, n24++, n23, 2, f55, f59, f58, f62, 1.0f);
                                }
                            }
                            f55 = f59;
                            f56 = f60;
                            f57 = f61;
                            f58 = f62;
                            ++n23;
                        }
                        array.add(pathConstraintMixTimeline);
                    }
                }
            }
        }
        n9 = skeletonInput.readInt(true);
        for (n8 = 0; n8 < n9; ++n8) {
            Skin skin = skeletonData.skins.get(skeletonInput.readInt(true));
            n6 = skeletonInput.readInt(true);
            for (int i = 0; i < n6; ++i) {
                int n26 = skeletonInput.readInt(true);
                int n27 = skeletonInput.readInt(true);
                for (int j = 0; j < n27; ++j) {
                    String string2 = skeletonInput.readStringRef();
                    VertexAttachment vertexAttachment = (VertexAttachment)skin.getAttachment(n26, string2);
                    if (vertexAttachment == null) {
                        throw new SerializationException("Vertex attachment not found: " + string2);
                    }
                    boolean bl = vertexAttachment.getBones() != null;
                    float[] fArray = vertexAttachment.getVertices();
                    int n28 = bl ? fArray.length / 3 << 1 : fArray.length;
                    int n29 = skeletonInput.readInt(true);
                    int n30 = n29 - 1;
                    Animation.DeformTimeline deformTimeline = new Animation.DeformTimeline(n29, skeletonInput.readInt(true), n26, vertexAttachment);
                    float f63 = skeletonInput.readFloat();
                    int n31 = 0;
                    int n32 = 0;
                    while (true) {
                        float[] fArray2;
                        int n33;
                        if ((n33 = skeletonInput.readInt(true)) == 0) {
                            fArray2 = bl ? new float[n28] : fArray;
                        } else {
                            int n34;
                            fArray2 = new float[n28];
                            int n35 = skeletonInput.readInt(true);
                            n33 += n35;
                            if (f5 == 1.0f) {
                                for (n34 = n35; n34 < n33; ++n34) {
                                    fArray2[n34] = skeletonInput.readFloat();
                                }
                            } else {
                                for (n34 = n35; n34 < n33; ++n34) {
                                    fArray2[n34] = skeletonInput.readFloat() * f5;
                                }
                            }
                            if (!bl) {
                                int n36 = fArray2.length;
                                for (n34 = 0; n34 < n36; ++n34) {
                                    int n37 = n34;
                                    fArray2[n37] = fArray2[n37] + fArray[n34];
                                }
                            }
                        }
                        deformTimeline.setFrame(n31, f63, fArray2);
                        if (n31 == n30) break;
                        float f64 = skeletonInput.readFloat();
                        switch (skeletonInput.readByte()) {
                            case 1: {
                                deformTimeline.setStepped(n31);
                                break;
                            }
                            case 2: {
                                this.setBezier(skeletonInput, deformTimeline, n32++, n31, 0, f63, f64, 0.0f, 1.0f, 1.0f);
                            }
                        }
                        f63 = f64;
                        ++n31;
                    }
                    array.add(deformTimeline);
                }
            }
        }
        n8 = skeletonInput.readInt(true);
        if (n8 > 0) {
            Animation.DrawOrderTimeline drawOrderTimeline = new Animation.DrawOrderTimeline(n8);
            int n38 = skeletonData.slots.size;
            for (int i = 0; i < n8; ++i) {
                int n39;
                float f65 = skeletonInput.readFloat();
                int n40 = skeletonInput.readInt(true);
                int[] nArray = new int[n38];
                for (int j = n38 - 1; j >= 0; --j) {
                    nArray[j] = -1;
                }
                int[] nArray2 = new int[n38 - n40];
                int n41 = 0;
                int n42 = 0;
                for (n39 = 0; n39 < n40; ++n39) {
                    int n43 = skeletonInput.readInt(true);
                    while (n41 != n43) {
                        nArray2[n42++] = n41++;
                    }
                    nArray[n41 + skeletonInput.readInt((boolean)true)] = n41++;
                }
                while (n41 < n38) {
                    nArray2[n42++] = n41++;
                }
                for (n39 = n38 - 1; n39 >= 0; --n39) {
                    if (nArray[n39] != -1) continue;
                    nArray[n39] = nArray2[--n42];
                }
                drawOrderTimeline.setFrame(i, f65, nArray);
            }
            array.add(drawOrderTimeline);
        }
        if ((n = skeletonInput.readInt(true)) > 0) {
            Animation.EventTimeline eventTimeline = new Animation.EventTimeline(n);
            for (int i = 0; i < n; ++i) {
                float f66 = skeletonInput.readFloat();
                EventData eventData = skeletonData.events.get(skeletonInput.readInt(true));
                Event event = new Event(f66, eventData);
                event.intValue = skeletonInput.readInt(false);
                event.floatValue = skeletonInput.readFloat();
                String string3 = event.stringValue = skeletonInput.readBoolean() ? skeletonInput.readString() : eventData.stringValue;
                if (event.getData().audioPath != null) {
                    event.volume = skeletonInput.readFloat();
                    event.balance = skeletonInput.readFloat();
                }
                eventTimeline.setFrame(i, event);
            }
            array.add(eventTimeline);
        }
        float f67 = 0.0f;
        T[] TArray = array.items;
        int n44 = array.size;
        for (int i = 0; i < n44; ++i) {
            f67 = Math.max(f67, ((Animation.Timeline)TArray[i]).getDuration());
        }
        return new Animation(string, array, f67);
    }

    private Animation.Timeline readTimeline(SkeletonInput skeletonInput, Animation.CurveTimeline1 curveTimeline1, float f) throws IOException {
        float f2 = skeletonInput.readFloat();
        float f3 = skeletonInput.readFloat() * f;
        int n = 0;
        int n2 = 0;
        int n3 = curveTimeline1.getFrameCount() - 1;
        while (true) {
            curveTimeline1.setFrame(n, f2, f3);
            if (n == n3) break;
            float f4 = skeletonInput.readFloat();
            float f5 = skeletonInput.readFloat() * f;
            switch (skeletonInput.readByte()) {
                case 1: {
                    curveTimeline1.setStepped(n);
                    break;
                }
                case 2: {
                    this.setBezier(skeletonInput, curveTimeline1, n2++, n, 0, f2, f4, f3, f5, f);
                }
            }
            f2 = f4;
            f3 = f5;
            ++n;
        }
        return curveTimeline1;
    }

    private Animation.Timeline readTimeline(SkeletonInput skeletonInput, Animation.CurveTimeline2 curveTimeline2, float f) throws IOException {
        float f2 = skeletonInput.readFloat();
        float f3 = skeletonInput.readFloat() * f;
        float f4 = skeletonInput.readFloat() * f;
        int n = 0;
        int n2 = 0;
        int n3 = curveTimeline2.getFrameCount() - 1;
        while (true) {
            curveTimeline2.setFrame(n, f2, f3, f4);
            if (n == n3) break;
            float f5 = skeletonInput.readFloat();
            float f6 = skeletonInput.readFloat() * f;
            float f7 = skeletonInput.readFloat() * f;
            switch (skeletonInput.readByte()) {
                case 1: {
                    curveTimeline2.setStepped(n);
                    break;
                }
                case 2: {
                    this.setBezier(skeletonInput, curveTimeline2, n2++, n, 0, f2, f5, f3, f6, f);
                    this.setBezier(skeletonInput, curveTimeline2, n2++, n, 1, f2, f5, f4, f7, f);
                }
            }
            f2 = f5;
            f3 = f6;
            f4 = f7;
            ++n;
        }
        return curveTimeline2;
    }

    void setBezier(SkeletonInput skeletonInput, Animation.CurveTimeline curveTimeline, int n, int n2, int n3, float f, float f2, float f3, float f4, float f5) throws IOException {
        curveTimeline.setBezier(n, n2, n3, f, f3, skeletonInput.readFloat(), skeletonInput.readFloat() * f5, skeletonInput.readFloat(), skeletonInput.readFloat() * f5, f2, f4);
    }

    static class SkeletonInput
    extends DataInput {
        private char[] chars = new char[32];
        String[] strings;

        public SkeletonInput(InputStream inputStream) {
            super(inputStream);
        }

        public String readStringRef() throws IOException {
            int n = this.readInt(true);
            return n == 0 ? null : this.strings[n - 1];
        }

        @Override
        public String readString() throws IOException {
            int n = this.readInt(true);
            switch (n) {
                case 0: {
                    return null;
                }
                case 1: {
                    return "";
                }
            }
            if (this.chars.length < --n) {
                this.chars = new char[n];
            }
            char[] cArray = this.chars;
            int n2 = 0;
            int n3 = 0;
            block9: while (n3 < n) {
                int n4 = this.read();
                switch (n4 >> 4) {
                    case -1: {
                        throw new EOFException();
                    }
                    case 12: 
                    case 13: {
                        cArray[n2++] = (char)((n4 & 0x1F) << 6 | this.read() & 0x3F);
                        n3 += 2;
                        continue block9;
                    }
                    case 14: {
                        cArray[n2++] = (char)((n4 & 0xF) << 12 | (this.read() & 0x3F) << 6 | this.read() & 0x3F);
                        n3 += 3;
                        continue block9;
                    }
                }
                cArray[n2++] = (char)n4;
                ++n3;
            }
            return new String(cArray, 0, n2);
        }
    }

    static class Vertices {
        int[] bones;
        float[] vertices;

        Vertices() {
        }
    }
}

