/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.utils.SpineUtils;

public class Bone
implements Updatable {
    final BoneData data;
    final Skeleton skeleton;
    final Bone parent;
    final Array<Bone> children = new Array();
    float x;
    float y;
    float rotation;
    float scaleX;
    float scaleY;
    float shearX;
    float shearY;
    float ax;
    float ay;
    float arotation;
    float ascaleX;
    float ascaleY;
    float ashearX;
    float ashearY;
    float a;
    float b;
    float worldX;
    float c;
    float d;
    float worldY;
    boolean sorted;
    boolean active;

    public Bone(BoneData boneData, Skeleton skeleton, Bone bone) {
        if (boneData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = boneData;
        this.skeleton = skeleton;
        this.parent = bone;
        this.setToSetupPose();
    }

    public Bone(Bone bone, Skeleton skeleton, Bone bone2) {
        if (bone == null) {
            throw new IllegalArgumentException("bone cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.skeleton = skeleton;
        this.parent = bone2;
        this.data = bone.data;
        this.x = bone.x;
        this.y = bone.y;
        this.rotation = bone.rotation;
        this.scaleX = bone.scaleX;
        this.scaleY = bone.scaleY;
        this.shearX = bone.shearX;
        this.shearY = bone.shearY;
    }

    @Override
    public void update() {
        this.updateWorldTransform(this.ax, this.ay, this.arotation, this.ascaleX, this.ascaleY, this.ashearX, this.ashearY);
    }

    public void updateWorldTransform(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.ax = f;
        this.ay = f2;
        this.arotation = f3;
        this.ascaleX = f4;
        this.ascaleY = f5;
        this.ashearX = f6;
        this.ashearY = f7;
        Bone bone = this.parent;
        if (bone == null) {
            Skeleton skeleton = this.skeleton;
            float f8 = f3 + 90.0f + f7;
            float f9 = skeleton.scaleX;
            float f10 = skeleton.scaleY;
            this.a = SpineUtils.cosDeg(f3 + f6) * f4 * f9;
            this.b = SpineUtils.cosDeg(f8) * f5 * f9;
            this.c = SpineUtils.sinDeg(f3 + f6) * f4 * f10;
            this.d = SpineUtils.sinDeg(f8) * f5 * f10;
            this.worldX = f * f9 + skeleton.x;
            this.worldY = f2 * f10 + skeleton.y;
            return;
        }
        float f11 = bone.a;
        float f12 = bone.b;
        float f13 = bone.c;
        float f14 = bone.d;
        this.worldX = f11 * f + f12 * f2 + bone.worldX;
        this.worldY = f13 * f + f14 * f2 + bone.worldY;
        switch (this.data.transformMode) {
            case normal: {
                float f15 = f3 + 90.0f + f7;
                float f16 = SpineUtils.cosDeg(f3 + f6) * f4;
                float f17 = SpineUtils.cosDeg(f15) * f5;
                float f18 = SpineUtils.sinDeg(f3 + f6) * f4;
                float f19 = SpineUtils.sinDeg(f15) * f5;
                this.a = f11 * f16 + f12 * f18;
                this.b = f11 * f17 + f12 * f19;
                this.c = f13 * f16 + f14 * f18;
                this.d = f13 * f17 + f14 * f19;
                return;
            }
            case onlyTranslation: {
                float f20 = f3 + 90.0f + f7;
                this.a = SpineUtils.cosDeg(f3 + f6) * f4;
                this.b = SpineUtils.cosDeg(f20) * f5;
                this.c = SpineUtils.sinDeg(f3 + f6) * f4;
                this.d = SpineUtils.sinDeg(f20) * f5;
                break;
            }
            case noRotationOrReflection: {
                float f21;
                float f22 = f11 * f11 + f13 * f13;
                if (f22 > 1.0E-4f) {
                    f22 = Math.abs(f11 * f14 - f12 * f13) / f22;
                    f12 = (f13 /= this.skeleton.scaleY) * f22;
                    f14 = (f11 /= this.skeleton.scaleX) * f22;
                    f21 = SpineUtils.atan2(f13, f11) * 57.295776f;
                } else {
                    f11 = 0.0f;
                    f13 = 0.0f;
                    f21 = 90.0f - SpineUtils.atan2(f14, f12) * 57.295776f;
                }
                float f23 = f3 + f6 - f21;
                float f24 = f3 + f7 - f21 + 90.0f;
                float f25 = SpineUtils.cosDeg(f23) * f4;
                float f26 = SpineUtils.cosDeg(f24) * f5;
                float f27 = SpineUtils.sinDeg(f23) * f4;
                float f28 = SpineUtils.sinDeg(f24) * f5;
                this.a = f11 * f25 - f12 * f27;
                this.b = f11 * f26 - f12 * f28;
                this.c = f13 * f25 + f14 * f27;
                this.d = f13 * f26 + f14 * f28;
                break;
            }
            case noScale: 
            case noScaleOrReflection: {
                float f29 = SpineUtils.cosDeg(f3);
                float f30 = SpineUtils.sinDeg(f3);
                float f31 = (f11 * f29 + f12 * f30) / this.skeleton.scaleX;
                float f32 = (f13 * f29 + f14 * f30) / this.skeleton.scaleY;
                float f33 = (float)Math.sqrt(f31 * f31 + f32 * f32);
                if (f33 > 1.0E-5f) {
                    f33 = 1.0f / f33;
                }
                f31 *= f33;
                f32 *= f33;
                f33 = (float)Math.sqrt(f31 * f31 + f32 * f32);
                if (this.data.transformMode == BoneData.TransformMode.noScale && f11 * f14 - f12 * f13 < 0.0f != (this.skeleton.scaleX < 0.0f != this.skeleton.scaleY < 0.0f)) {
                    f33 = -f33;
                }
                float f34 = 1.5707964f + SpineUtils.atan2(f32, f31);
                float f35 = SpineUtils.cos(f34) * f33;
                float f36 = SpineUtils.sin(f34) * f33;
                float f37 = SpineUtils.cosDeg(f6) * f4;
                float f38 = SpineUtils.cosDeg(90.0f + f7) * f5;
                float f39 = SpineUtils.sinDeg(f6) * f4;
                float f40 = SpineUtils.sinDeg(90.0f + f7) * f5;
                this.a = f31 * f37 + f35 * f39;
                this.b = f31 * f38 + f35 * f40;
                this.c = f32 * f37 + f36 * f39;
                this.d = f32 * f38 + f36 * f40;
                break;
            }
        }
        this.a *= this.skeleton.scaleX;
        this.b *= this.skeleton.scaleX;
        this.c *= this.skeleton.scaleY;
        this.d *= this.skeleton.scaleY;
    }

    public void setToSetupPose() {
        BoneData boneData = this.data;
        this.x = boneData.x;
        this.y = boneData.y;
        this.rotation = boneData.rotation;
        this.scaleX = boneData.scaleX;
        this.scaleY = boneData.scaleY;
        this.shearX = boneData.shearX;
        this.shearY = boneData.shearY;
    }

    public void updateAppliedTransform() {
        Bone bone = this.parent;
        if (bone == null) {
            this.ax = this.worldX - this.skeleton.x;
            this.ay = this.worldY - this.skeleton.y;
            float f = this.a;
            float f2 = this.b;
            float f3 = this.c;
            float f4 = this.d;
            this.arotation = SpineUtils.atan2(f3, f) * 57.295776f;
            this.ascaleX = (float)Math.sqrt(f * f + f3 * f3);
            this.ascaleY = (float)Math.sqrt(f2 * f2 + f4 * f4);
            this.ashearX = 0.0f;
            this.ashearY = SpineUtils.atan2(f * f2 + f3 * f4, f * f4 - f2 * f3) * 57.295776f;
            return;
        }
        float f = bone.a;
        float f5 = bone.b;
        float f6 = bone.c;
        float f7 = bone.d;
        float f8 = 1.0f / (f * f7 - f5 * f6);
        float f9 = this.worldX - bone.worldX;
        float f10 = this.worldY - bone.worldY;
        this.ax = f9 * f7 * f8 - f10 * f5 * f8;
        this.ay = f10 * f * f8 - f9 * f6 * f8;
        float f11 = f8 * f7;
        float f12 = f8 * f;
        float f13 = f8 * f5;
        float f14 = f8 * f6;
        float f15 = f11 * this.a - f13 * this.c;
        float f16 = f11 * this.b - f13 * this.d;
        float f17 = f12 * this.c - f14 * this.a;
        float f18 = f12 * this.d - f14 * this.b;
        this.ashearX = 0.0f;
        this.ascaleX = (float)Math.sqrt(f15 * f15 + f17 * f17);
        if (this.ascaleX > 1.0E-4f) {
            float f19 = f15 * f18 - f16 * f17;
            this.ascaleY = f19 / this.ascaleX;
            this.ashearY = SpineUtils.atan2(f15 * f16 + f17 * f18, f19) * 57.295776f;
            this.arotation = SpineUtils.atan2(f17, f15) * 57.295776f;
        } else {
            this.ascaleX = 0.0f;
            this.ascaleY = (float)Math.sqrt(f16 * f16 + f18 * f18);
            this.ashearY = 0.0f;
            this.arotation = 90.0f - SpineUtils.atan2(f18, f16) * 57.295776f;
        }
    }

    public float getA() {
        return this.a;
    }

    public float getB() {
        return this.b;
    }

    public float getC() {
        return this.c;
    }

    public float getD() {
        return this.d;
    }

    public float getWorldX() {
        return this.worldX;
    }

    public float getWorldY() {
        return this.worldY;
    }

    public Vector2 localToWorld(Vector2 vector2) {
        if (vector2 == null) {
            throw new IllegalArgumentException("local cannot be null.");
        }
        float f = vector2.x;
        float f2 = vector2.y;
        vector2.x = f * this.a + f2 * this.b + this.worldX;
        vector2.y = f * this.c + f2 * this.d + this.worldY;
        return vector2;
    }

    public String toString() {
        return this.data.name;
    }
}

