/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.utils.Pool;

public abstract class TemporalAction
extends Action {
    private float duration;
    private float time;
    private Interpolation interpolation;
    private boolean reverse;
    private boolean began;
    private boolean complete;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean act(float delta) {
        if (this.complete) {
            return true;
        }
        Pool pool = this.getPool();
        this.setPool(null);
        try {
            float percent;
            if (!this.began) {
                this.begin();
                this.began = true;
            }
            this.time += delta;
            this.complete = this.time >= this.duration;
            float f = percent = this.complete ? 1.0f : this.time / this.duration;
            if (this.interpolation != null) {
                percent = this.interpolation.apply(percent);
            }
            this.update(this.reverse ? 1.0f - percent : percent);
            if (this.complete) {
                this.end();
            }
            boolean bl = this.complete;
            return bl;
        }
        finally {
            this.setPool(pool);
        }
    }

    protected void begin() {
    }

    protected void end() {
    }

    protected abstract void update(float var1);

    @Override
    public void restart() {
        this.time = 0.0f;
        this.began = false;
        this.complete = false;
    }

    @Override
    public void reset() {
        super.reset();
        this.reverse = false;
        this.interpolation = null;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void setInterpolation(Interpolation interpolation) {
        this.interpolation = interpolation;
    }
}

