/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.utils.SpineUtils;

public class Bone
implements Updatable {
    final BoneData data;
    final Skeleton skeleton;
    final Bone parent;
    final Array<Bone> children = new Array();
    float x;
    float y;
    float rotation;
    float scaleX;
    float scaleY;
    float shearX;
    float shearY;
    float ax;
    float ay;
    float arotation;
    float ascaleX;
    float ascaleY;
    float ashearX;
    float ashearY;
    float a;
    float b;
    float worldX;
    float c;
    float d;
    float worldY;
    BoneData.Inherit inherit;
    boolean sorted;
    boolean active;

    public Bone(BoneData boneData, Skeleton skeleton, Bone bone) {
        if (boneData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = boneData;
        this.skeleton = skeleton;
        this.parent = bone;
        this.setToSetupPose();
    }

    @Override
    public void update(Skeleton.Physics physics) {
        this.updateWorldTransform(this.ax, this.ay, this.arotation, this.ascaleX, this.ascaleY, this.ashearX, this.ashearY);
    }

    public void updateWorldTransform(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.ax = f;
        this.ay = f2;
        this.arotation = f3;
        this.ascaleX = f4;
        this.ascaleY = f5;
        this.ashearX = f6;
        this.ashearY = f7;
        Bone bone = this.parent;
        if (bone == null) {
            Skeleton skeleton = this.skeleton;
            float f8 = skeleton.scaleX;
            float f9 = skeleton.scaleY;
            float f10 = (f3 + f6) * ((float)Math.PI / 180);
            float f11 = (f3 + 90.0f + f7) * ((float)Math.PI / 180);
            this.a = SpineUtils.cos(f10) * f4 * f8;
            this.b = SpineUtils.cos(f11) * f5 * f8;
            this.c = SpineUtils.sin(f10) * f4 * f9;
            this.d = SpineUtils.sin(f11) * f5 * f9;
            this.worldX = f * f8 + skeleton.x;
            this.worldY = f2 * f9 + skeleton.y;
            return;
        }
        float f12 = bone.a;
        float f13 = bone.b;
        float f14 = bone.c;
        float f15 = bone.d;
        this.worldX = f12 * f + f13 * f2 + bone.worldX;
        this.worldY = f14 * f + f15 * f2 + bone.worldY;
        switch (this.inherit) {
            case normal: {
                float f16 = (f3 + f6) * ((float)Math.PI / 180);
                float f17 = (f3 + 90.0f + f7) * ((float)Math.PI / 180);
                float f18 = SpineUtils.cos(f16) * f4;
                float f19 = SpineUtils.cos(f17) * f5;
                float f20 = SpineUtils.sin(f16) * f4;
                float f21 = SpineUtils.sin(f17) * f5;
                this.a = f12 * f18 + f13 * f20;
                this.b = f12 * f19 + f13 * f21;
                this.c = f14 * f18 + f15 * f20;
                this.d = f14 * f19 + f15 * f21;
                return;
            }
            case onlyTranslation: {
                float f22 = (f3 + f6) * ((float)Math.PI / 180);
                float f23 = (f3 + 90.0f + f7) * ((float)Math.PI / 180);
                this.a = SpineUtils.cos(f22) * f4;
                this.b = SpineUtils.cos(f23) * f5;
                this.c = SpineUtils.sin(f22) * f4;
                this.d = SpineUtils.sin(f23) * f5;
                break;
            }
            case noRotationOrReflection: {
                float f24;
                float f25 = 1.0f / this.skeleton.scaleX;
                float f26 = 1.0f / this.skeleton.scaleY;
                float f27 = (f12 *= f25) * f12 + (f14 *= f26) * f14;
                if (f27 > 1.0E-4f) {
                    f27 = Math.abs(f12 * f15 * f26 - f13 * f25 * f14) / f27;
                    f13 = f14 * f27;
                    f15 = f12 * f27;
                    f24 = SpineUtils.atan2Deg(f14, f12);
                } else {
                    f12 = 0.0f;
                    f14 = 0.0f;
                    f24 = 90.0f - SpineUtils.atan2Deg(f15, f13);
                }
                float f28 = (f3 + f6 - f24) * ((float)Math.PI / 180);
                float f29 = (f3 + f7 - f24 + 90.0f) * ((float)Math.PI / 180);
                float f30 = SpineUtils.cos(f28) * f4;
                float f31 = SpineUtils.cos(f29) * f5;
                float f32 = SpineUtils.sin(f28) * f4;
                float f33 = SpineUtils.sin(f29) * f5;
                this.a = f12 * f30 - f13 * f32;
                this.b = f12 * f31 - f13 * f33;
                this.c = f14 * f30 + f15 * f32;
                this.d = f14 * f31 + f15 * f33;
                break;
            }
            case noScale: 
            case noScaleOrReflection: {
                float f34 = SpineUtils.cos(f3 *= (float)Math.PI / 180);
                float f35 = SpineUtils.sin(f3);
                float f36 = (f12 * f34 + f13 * f35) / this.skeleton.scaleX;
                float f37 = (f14 * f34 + f15 * f35) / this.skeleton.scaleY;
                float f38 = (float)Math.sqrt(f36 * f36 + f37 * f37);
                if (f38 > 1.0E-5f) {
                    f38 = 1.0f / f38;
                }
                f36 *= f38;
                f37 *= f38;
                f38 = (float)Math.sqrt(f36 * f36 + f37 * f37);
                if (this.inherit == BoneData.Inherit.noScale && f12 * f15 - f13 * f14 < 0.0f != (this.skeleton.scaleX < 0.0f != this.skeleton.scaleY < 0.0f)) {
                    f38 = -f38;
                }
                f3 = 1.5707964f + SpineUtils.atan2(f37, f36);
                float f39 = SpineUtils.cos(f3) * f38;
                float f40 = SpineUtils.sin(f3) * f38;
                f7 = (90.0f + f7) * ((float)Math.PI / 180);
                float f41 = SpineUtils.cos(f6 *= (float)Math.PI / 180) * f4;
                float f42 = SpineUtils.cos(f7) * f5;
                float f43 = SpineUtils.sin(f6) * f4;
                float f44 = SpineUtils.sin(f7) * f5;
                this.a = f36 * f41 + f39 * f43;
                this.b = f36 * f42 + f39 * f44;
                this.c = f37 * f41 + f40 * f43;
                this.d = f37 * f42 + f40 * f44;
            }
        }
        this.a *= this.skeleton.scaleX;
        this.b *= this.skeleton.scaleX;
        this.c *= this.skeleton.scaleY;
        this.d *= this.skeleton.scaleY;
    }

    public void setToSetupPose() {
        BoneData boneData = this.data;
        this.x = boneData.x;
        this.y = boneData.y;
        this.rotation = boneData.rotation;
        this.scaleX = boneData.scaleX;
        this.scaleY = boneData.scaleY;
        this.shearX = boneData.shearX;
        this.shearY = boneData.shearY;
        this.inherit = boneData.inherit;
    }

    public void updateAppliedTransform() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        Bone bone = this.parent;
        if (bone == null) {
            this.ax = this.worldX - this.skeleton.x;
            this.ay = this.worldY - this.skeleton.y;
            float f6 = this.a;
            float f7 = this.b;
            float f8 = this.c;
            float f9 = this.d;
            this.arotation = SpineUtils.atan2Deg(f8, f6);
            this.ascaleX = (float)Math.sqrt(f6 * f6 + f8 * f8);
            this.ascaleY = (float)Math.sqrt(f7 * f7 + f9 * f9);
            this.ashearX = 0.0f;
            this.ashearY = SpineUtils.atan2Deg(f6 * f7 + f8 * f9, f6 * f9 - f7 * f8);
            return;
        }
        float f10 = bone.a;
        float f11 = bone.b;
        float f12 = bone.c;
        float f13 = bone.d;
        float f14 = 1.0f / (f10 * f13 - f11 * f12);
        float f15 = f13 * f14;
        float f16 = f11 * f14;
        float f17 = f12 * f14;
        float f18 = f10 * f14;
        float f19 = this.worldX - bone.worldX;
        float f20 = this.worldY - bone.worldY;
        this.ax = f19 * f15 - f20 * f16;
        this.ay = f20 * f18 - f19 * f17;
        if (this.inherit == BoneData.Inherit.onlyTranslation) {
            f5 = this.a;
            f4 = this.b;
            f3 = this.c;
            f2 = this.d;
        } else {
            switch (this.inherit) {
                case noRotationOrReflection: {
                    f = Math.abs(f10 * f13 - f11 * f12) / (f10 * f10 + f12 * f12);
                    f11 = -f12 * this.skeleton.scaleX * f / this.skeleton.scaleY;
                    f13 = f10 * this.skeleton.scaleY * f / this.skeleton.scaleX;
                    f14 = 1.0f / (f10 * f13 - f11 * f12);
                    f15 = f13 * f14;
                    f16 = f11 * f14;
                    break;
                }
                case noScale: 
                case noScaleOrReflection: {
                    f = this.rotation * ((float)Math.PI / 180);
                    float f21 = SpineUtils.cos(f);
                    float f22 = SpineUtils.sin(f);
                    f10 = (f10 * f21 + f11 * f22) / this.skeleton.scaleX;
                    f12 = (f12 * f21 + f13 * f22) / this.skeleton.scaleY;
                    float f23 = (float)Math.sqrt(f10 * f10 + f12 * f12);
                    if (f23 > 1.0E-5f) {
                        f23 = 1.0f / f23;
                    }
                    f10 *= f23;
                    f12 *= f23;
                    f23 = (float)Math.sqrt(f10 * f10 + f12 * f12);
                    if (this.inherit == BoneData.Inherit.noScale && f14 < 0.0f != (this.skeleton.scaleX < 0.0f != this.skeleton.scaleY < 0.0f)) {
                        f23 = -f23;
                    }
                    f = 1.5707964f + SpineUtils.atan2(f12, f10);
                    f11 = SpineUtils.cos(f) * f23;
                    f13 = SpineUtils.sin(f) * f23;
                    f14 = 1.0f / (f10 * f13 - f11 * f12);
                    f15 = f13 * f14;
                    f16 = f11 * f14;
                    f17 = f12 * f14;
                    f18 = f10 * f14;
                }
            }
            f5 = f15 * this.a - f16 * this.c;
            f4 = f15 * this.b - f16 * this.d;
            f3 = f18 * this.c - f17 * this.a;
            f2 = f18 * this.d - f17 * this.b;
        }
        this.ashearX = 0.0f;
        this.ascaleX = (float)Math.sqrt(f5 * f5 + f3 * f3);
        if (this.ascaleX > 1.0E-4f) {
            f = f5 * f2 - f4 * f3;
            this.ascaleY = f / this.ascaleX;
            this.ashearY = -SpineUtils.atan2Deg(f5 * f4 + f3 * f2, f);
            this.arotation = SpineUtils.atan2Deg(f3, f5);
        } else {
            this.ascaleX = 0.0f;
            this.ascaleY = (float)Math.sqrt(f4 * f4 + f2 * f2);
            this.ashearY = 0.0f;
            this.arotation = 90.0f - SpineUtils.atan2Deg(f2, f4);
        }
    }

    public float getA() {
        return this.a;
    }

    public float getB() {
        return this.b;
    }

    public float getC() {
        return this.c;
    }

    public float getD() {
        return this.d;
    }

    public float getWorldX() {
        return this.worldX;
    }

    public float getWorldY() {
        return this.worldY;
    }

    public float getWorldScaleX() {
        return (float)Math.sqrt(this.a * this.a + this.c * this.c);
    }

    public Vector2 localToWorld(Vector2 vector2) {
        if (vector2 == null) {
            throw new IllegalArgumentException("local cannot be null.");
        }
        float f = vector2.x;
        float f2 = vector2.y;
        vector2.x = f * this.a + f2 * this.b + this.worldX;
        vector2.y = f * this.c + f2 * this.d + this.worldY;
        return vector2;
    }

    public String toString() {
        return this.data.name;
    }
}

