/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.IkConstraint;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraint;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.PhysicsConstraint;
import com.esotericsoftware.spine.PhysicsConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraint;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class Skeleton {
    private static final short[] quadTriangles = new short[]{0, 1, 2, 2, 3, 0};
    final SkeletonData data;
    final Array<Bone> bones;
    final Array<Slot> slots;
    Array<Slot> drawOrder;
    final Array<IkConstraint> ikConstraints;
    final Array<TransformConstraint> transformConstraints;
    final Array<PathConstraint> pathConstraints;
    final Array<PhysicsConstraint> physicsConstraints;
    final Array<Updatable> updateCache = new Array();
    Skin skin;
    final Color color;
    float x;
    float y;
    float scaleX = 1.0f;
    float scaleY = 1.0f;
    float time;

    public Skeleton(SkeletonData skeletonData) {
        Object object;
        Bone bone;
        if (skeletonData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = skeletonData;
        this.bones = new Array(skeletonData.bones.size);
        T[] TArray = this.bones.items;
        for (BoneData object2 : skeletonData.bones) {
            if (object2.parent == null) {
                bone = new Bone(object2, this, null);
            } else {
                object = (Bone)TArray[object2.parent.index];
                bone = new Bone(object2, this, (Bone)object);
                ((Bone)object).children.add(bone);
            }
            this.bones.add(bone);
        }
        this.slots = new Array(skeletonData.slots.size);
        this.drawOrder = new Array(skeletonData.slots.size);
        for (SlotData slotData : skeletonData.slots) {
            bone = (Bone)TArray[slotData.boneData.index];
            object = new Slot(slotData, bone);
            this.slots.add((Slot)object);
            this.drawOrder.add((Slot)object);
        }
        this.ikConstraints = new Array(skeletonData.ikConstraints.size);
        for (IkConstraintData ikConstraintData : skeletonData.ikConstraints) {
            this.ikConstraints.add(new IkConstraint(ikConstraintData, this));
        }
        this.transformConstraints = new Array(skeletonData.transformConstraints.size);
        for (TransformConstraintData transformConstraintData : skeletonData.transformConstraints) {
            this.transformConstraints.add(new TransformConstraint(transformConstraintData, this));
        }
        this.pathConstraints = new Array(skeletonData.pathConstraints.size);
        for (PathConstraintData pathConstraintData : skeletonData.pathConstraints) {
            this.pathConstraints.add(new PathConstraint(pathConstraintData, this));
        }
        this.physicsConstraints = new Array(skeletonData.physicsConstraints.size);
        for (PhysicsConstraintData physicsConstraintData : skeletonData.physicsConstraints) {
            this.physicsConstraints.add(new PhysicsConstraint(physicsConstraintData, this));
        }
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.updateCache();
    }

    public void updateCache() {
        int n;
        int n2;
        int n3;
        Array<Updatable> array = this.updateCache;
        array.clear();
        int n4 = this.bones.size;
        T[] TArray = this.bones.items;
        for (n3 = 0; n3 < n4; ++n3) {
            Bone bone = (Bone)TArray[n3];
            bone.sorted = bone.data.skinRequired;
            bone.active = !bone.sorted;
        }
        if (this.skin != null) {
            T[] TArray2 = this.skin.bones.items;
            n2 = this.skin.bones.size;
            for (int i = 0; i < n2; ++i) {
                Bone bone = (Bone)TArray[((BoneData)TArray2[i]).index];
                do {
                    bone.sorted = false;
                    bone.active = true;
                } while ((bone = bone.parent) != null);
            }
        }
        n3 = this.ikConstraints.size;
        int n5 = this.transformConstraints.size;
        n2 = this.pathConstraints.size;
        int n6 = this.physicsConstraints.size;
        T[] TArray3 = this.ikConstraints.items;
        T[] TArray4 = this.transformConstraints.items;
        T[] TArray5 = this.pathConstraints.items;
        T[] TArray6 = this.physicsConstraints.items;
        int n7 = n3 + n5 + n2 + n6;
        block3: for (n = 0; n < n7; ++n) {
            Updatable updatable;
            int n8;
            for (n8 = 0; n8 < n3; ++n8) {
                updatable = (IkConstraint)TArray3[n8];
                if (updatable.data.order != n) continue;
                this.sortIkConstraint((IkConstraint)updatable);
                continue block3;
            }
            for (n8 = 0; n8 < n5; ++n8) {
                updatable = (TransformConstraint)TArray4[n8];
                if (((TransformConstraint)updatable).data.order != n) continue;
                this.sortTransformConstraint((TransformConstraint)updatable);
                continue block3;
            }
            for (n8 = 0; n8 < n2; ++n8) {
                updatable = (PathConstraint)TArray5[n8];
                if (((PathConstraint)updatable).data.order != n) continue;
                this.sortPathConstraint((PathConstraint)updatable);
                continue block3;
            }
            for (n8 = 0; n8 < n6; ++n8) {
                updatable = (PhysicsConstraint)TArray6[n8];
                if (((PhysicsConstraint)updatable).data.order != n) continue;
                this.sortPhysicsConstraint((PhysicsConstraint)updatable);
                continue block3;
            }
        }
        for (n = 0; n < n4; ++n) {
            this.sortBone((Bone)TArray[n]);
        }
    }

    private void sortIkConstraint(IkConstraint ikConstraint) {
        boolean bl = ikConstraint.active = ikConstraint.target.active && (!ikConstraint.data.skinRequired || this.skin != null && this.skin.constraints.contains(ikConstraint.data, true));
        if (!ikConstraint.active) {
            return;
        }
        Bone bone = ikConstraint.target;
        this.sortBone(bone);
        Array<Bone> array = ikConstraint.bones;
        Bone bone2 = array.first();
        this.sortBone(bone2);
        if (array.size == 1) {
            this.updateCache.add(ikConstraint);
            this.sortReset(bone2.children);
        } else {
            Bone bone3 = array.peek();
            this.sortBone(bone3);
            this.updateCache.add(ikConstraint);
            this.sortReset(bone2.children);
            bone3.sorted = true;
        }
    }

    private void sortTransformConstraint(TransformConstraint transformConstraint) {
        int n;
        boolean bl = transformConstraint.active = transformConstraint.target.active && (!transformConstraint.data.skinRequired || this.skin != null && this.skin.constraints.contains(transformConstraint.data, true));
        if (!transformConstraint.active) {
            return;
        }
        this.sortBone(transformConstraint.target);
        T[] TArray = transformConstraint.bones.items;
        int n2 = transformConstraint.bones.size;
        if (transformConstraint.data.local) {
            for (n = 0; n < n2; ++n) {
                Bone bone = (Bone)TArray[n];
                this.sortBone(bone.parent);
                this.sortBone(bone);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.sortBone((Bone)TArray[n]);
            }
        }
        this.updateCache.add(transformConstraint);
        for (n = 0; n < n2; ++n) {
            this.sortReset(((Bone)TArray[n]).children);
        }
        for (n = 0; n < n2; ++n) {
            ((Bone)TArray[n]).sorted = true;
        }
    }

    private void sortPathConstraint(PathConstraint pathConstraint) {
        int n;
        Attachment attachment;
        boolean bl = pathConstraint.active = pathConstraint.target.bone.active && (!pathConstraint.data.skinRequired || this.skin != null && this.skin.constraints.contains(pathConstraint.data, true));
        if (!pathConstraint.active) {
            return;
        }
        Slot slot = pathConstraint.target;
        int n2 = slot.getData().index;
        Bone bone = slot.bone;
        if (this.skin != null) {
            this.sortPathConstraintAttachment(this.skin, n2, bone);
        }
        if (this.data.defaultSkin != null && this.data.defaultSkin != this.skin) {
            this.sortPathConstraintAttachment(this.data.defaultSkin, n2, bone);
        }
        if ((attachment = slot.attachment) instanceof PathAttachment) {
            this.sortPathConstraintAttachment(attachment, bone);
        }
        T[] TArray = pathConstraint.bones.items;
        int n3 = pathConstraint.bones.size;
        for (n = 0; n < n3; ++n) {
            this.sortBone((Bone)TArray[n]);
        }
        this.updateCache.add(pathConstraint);
        for (n = 0; n < n3; ++n) {
            this.sortReset(((Bone)TArray[n]).children);
        }
        for (n = 0; n < n3; ++n) {
            ((Bone)TArray[n]).sorted = true;
        }
    }

    private void sortPathConstraintAttachment(Skin skin, int n, Bone bone) {
        T[] TArray = skin.attachments.orderedItems().items;
        int n2 = skin.attachments.size;
        for (int i = 0; i < n2; ++i) {
            Skin.SkinEntry skinEntry = (Skin.SkinEntry)TArray[i];
            if (skinEntry.slotIndex != n) continue;
            this.sortPathConstraintAttachment(skinEntry.attachment, bone);
        }
    }

    private void sortPathConstraintAttachment(Attachment attachment, Bone bone) {
        if (!(attachment instanceof PathAttachment)) {
            return;
        }
        int[] nArray = ((PathAttachment)attachment).getBones();
        if (nArray == null) {
            this.sortBone(bone);
        } else {
            T[] TArray = this.bones.items;
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                int n3 = nArray[n++];
                n3 += n;
                while (n < n3) {
                    this.sortBone((Bone)TArray[nArray[n++]]);
                }
            }
        }
    }

    private void sortPhysicsConstraint(PhysicsConstraint physicsConstraint) {
        Bone bone = physicsConstraint.bone;
        boolean bl = physicsConstraint.active = bone.active && (!physicsConstraint.data.skinRequired || this.skin != null && this.skin.constraints.contains(physicsConstraint.data, true));
        if (!physicsConstraint.active) {
            return;
        }
        this.sortBone(bone);
        this.updateCache.add(physicsConstraint);
        this.sortReset(bone.children);
        bone.sorted = true;
    }

    private void sortBone(Bone bone) {
        if (bone.sorted) {
            return;
        }
        Bone bone2 = bone.parent;
        if (bone2 != null) {
            this.sortBone(bone2);
        }
        bone.sorted = true;
        this.updateCache.add(bone);
    }

    private void sortReset(Array<Bone> array) {
        T[] TArray = array.items;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Bone bone = (Bone)TArray[i];
            if (!bone.active) continue;
            if (bone.sorted) {
                this.sortReset(bone.children);
            }
            bone.sorted = false;
        }
    }

    public void updateWorldTransform(Physics physics) {
        T[] TArray = this.bones.items;
        int n = this.bones.size;
        for (int i = 0; i < n; ++i) {
            Bone bone = (Bone)TArray[i];
            bone.ax = bone.x;
            bone.ay = bone.y;
            bone.arotation = bone.rotation;
            bone.ascaleX = bone.scaleX;
            bone.ascaleY = bone.scaleY;
            bone.ashearX = bone.shearX;
            bone.ashearY = bone.shearY;
        }
        T[] TArray2 = this.updateCache.items;
        int n2 = this.updateCache.size;
        for (n = 0; n < n2; ++n) {
            ((Updatable)TArray2[n]).update(physics);
        }
    }

    public void setToSetupPose() {
        this.setBonesToSetupPose();
        this.setSlotsToSetupPose();
    }

    public void setBonesToSetupPose() {
        T[] TArray = this.bones.items;
        int n = this.bones.size;
        for (int i = 0; i < n; ++i) {
            ((Bone)TArray[i]).setToSetupPose();
        }
        T[] TArray2 = this.ikConstraints.items;
        int n2 = this.ikConstraints.size;
        for (n = 0; n < n2; ++n) {
            ((IkConstraint)TArray2[n]).setToSetupPose();
        }
        T[] TArray3 = this.transformConstraints.items;
        int n3 = this.transformConstraints.size;
        for (n2 = 0; n2 < n3; ++n2) {
            ((TransformConstraint)TArray3[n2]).setToSetupPose();
        }
        T[] TArray4 = this.pathConstraints.items;
        int n4 = this.pathConstraints.size;
        for (n3 = 0; n3 < n4; ++n3) {
            ((PathConstraint)TArray4[n3]).setToSetupPose();
        }
        T[] TArray5 = this.physicsConstraints.items;
        int n5 = this.physicsConstraints.size;
        for (n4 = 0; n4 < n5; ++n4) {
            ((PhysicsConstraint)TArray5[n4]).setToSetupPose();
        }
    }

    public void setSlotsToSetupPose() {
        T[] TArray = this.slots.items;
        int n = this.slots.size;
        SpineUtils.arraycopy(TArray, 0, this.drawOrder.items, 0, n);
        for (int i = 0; i < n; ++i) {
            ((Slot)TArray[i]).setToSetupPose();
        }
    }

    public Array<Bone> getBones() {
        return this.bones;
    }

    public Array<Slot> getSlots() {
        return this.slots;
    }

    public void setSkin(String string) {
        Skin skin = this.data.findSkin(string);
        if (skin == null) {
            throw new IllegalArgumentException("Skin not found: " + string);
        }
        this.setSkin(skin);
    }

    public void setSkin(Skin skin) {
        if (skin == this.skin) {
            return;
        }
        if (skin != null) {
            if (this.skin != null) {
                skin.attachAll(this, this.skin);
            } else {
                T[] TArray = this.slots.items;
                int n = this.slots.size;
                for (int i = 0; i < n; ++i) {
                    Attachment attachment;
                    Slot slot = (Slot)TArray[i];
                    String string = slot.data.attachmentName;
                    if (string == null || (attachment = skin.getAttachment(i, string)) == null) continue;
                    slot.setAttachment(attachment);
                }
            }
        }
        this.skin = skin;
        this.updateCache();
    }

    public Attachment getAttachment(int n, String string) {
        Attachment attachment;
        if (string == null) {
            throw new IllegalArgumentException("attachmentName cannot be null.");
        }
        if (this.skin != null && (attachment = this.skin.getAttachment(n, string)) != null) {
            return attachment;
        }
        if (this.data.defaultSkin != null) {
            return this.data.defaultSkin.getAttachment(n, string);
        }
        return null;
    }

    public void setScale(float f, float f2) {
        this.scaleX = f;
        this.scaleY = f2;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void update(float f) {
        this.time += f;
    }

    public String toString() {
        return this.data.name != null ? this.data.name : super.toString();
    }

    public static enum Physics {
        none,
        reset,
        update,
        pose;

    }
}

