/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DataInput;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.PhysicsConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonLoader;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.Sequence;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SkeletonBinary
extends SkeletonLoader {
    private final Array<LinkedMesh> linkedMeshes = new Array();

    public SkeletonBinary(TextureAtlas textureAtlas) {
        super(textureAtlas);
    }

    @Override
    public SkeletonData readSkeletonData(FileHandle fileHandle) {
        if (fileHandle == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        SkeletonData skeletonData = this.readSkeletonData(fileHandle.read());
        skeletonData.name = fileHandle.nameWithoutExtension();
        return skeletonData;
    }

    public SkeletonData readSkeletonData(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("dataInput cannot be null.");
        }
        float f = this.scale;
        SkeletonInput skeletonInput = new SkeletonInput(inputStream);
        SkeletonData skeletonData = new SkeletonData();
        try {
            int n;
            int n2;
            int n3;
            Object object;
            int n4;
            Object object2;
            Object object3;
            long l = skeletonInput.readLong();
            skeletonData.hash = l == 0L ? null : Long.toString(l);
            skeletonData.version = skeletonInput.readString();
            if (skeletonData.version.isEmpty()) {
                skeletonData.version = null;
            }
            skeletonData.x = skeletonInput.readFloat();
            skeletonData.y = skeletonInput.readFloat();
            skeletonData.width = skeletonInput.readFloat();
            skeletonData.height = skeletonInput.readFloat();
            skeletonData.referenceScale = skeletonInput.readFloat() * f;
            boolean bl = skeletonInput.readBoolean();
            if (bl) {
                skeletonData.fps = skeletonInput.readFloat();
                skeletonData.imagesPath = skeletonInput.readString();
                if (skeletonData.imagesPath.isEmpty()) {
                    skeletonData.imagesPath = null;
                }
                skeletonData.audioPath = skeletonInput.readString();
                if (skeletonData.audioPath.isEmpty()) {
                    skeletonData.audioPath = null;
                }
            }
            int n5 = skeletonInput.readInt(true);
            skeletonInput.strings = new String[n5];
            Object[] objectArray = skeletonInput.strings;
            for (int i = 0; i < n5; ++i) {
                objectArray[i] = skeletonInput.readString();
            }
            n5 = skeletonInput.readInt(true);
            BoneData[] boneDataArray = skeletonData.bones.setSize(n5);
            for (int i = 0; i < n5; ++i) {
                String string = skeletonInput.readString();
                object3 = i == 0 ? null : boneDataArray[skeletonInput.readInt(true)];
                object2 = new BoneData(i, string, (BoneData)object3);
                ((BoneData)object2).rotation = skeletonInput.readFloat();
                ((BoneData)object2).x = skeletonInput.readFloat() * f;
                ((BoneData)object2).y = skeletonInput.readFloat() * f;
                ((BoneData)object2).scaleX = skeletonInput.readFloat();
                ((BoneData)object2).scaleY = skeletonInput.readFloat();
                ((BoneData)object2).shearX = skeletonInput.readFloat();
                ((BoneData)object2).shearY = skeletonInput.readFloat();
                ((BoneData)object2).length = skeletonInput.readFloat() * f;
                ((BoneData)object2).inherit = BoneData.Inherit.values[skeletonInput.readByte()];
                ((BoneData)object2).skinRequired = skeletonInput.readBoolean();
                if (bl) {
                    Color.rgba8888ToColor(((BoneData)object2).color, skeletonInput.readInt());
                    ((BoneData)object2).icon = skeletonInput.readString();
                    ((BoneData)object2).visible = skeletonInput.readBoolean();
                }
                boneDataArray[i] = object2;
            }
            n5 = skeletonInput.readInt(true);
            SlotData[] slotDataArray = skeletonData.slots.setSize(n5);
            for (n4 = 0; n4 < n5; ++n4) {
                object3 = skeletonInput.readString();
                object2 = boneDataArray[skeletonInput.readInt(true)];
                object = new SlotData(n4, (String)object3, (BoneData)object2);
                Color.rgba8888ToColor(object.color, skeletonInput.readInt());
                n3 = skeletonInput.readInt();
                if (n3 != -1) {
                    object.darkColor = new Color();
                    Color.rgb888ToColor(object.darkColor, n3);
                }
                object.attachmentName = skeletonInput.readStringRef();
                object.blendMode = BlendMode.values[skeletonInput.readInt(true)];
                if (bl) {
                    object.visible = skeletonInput.readBoolean();
                }
                slotDataArray[n4] = object;
            }
            n5 = skeletonInput.readInt(true);
            objectArray = skeletonData.ikConstraints.setSize(n5);
            for (n4 = 0; n4 < n5; ++n4) {
                object2 = new IkConstraintData(skeletonInput.readString());
                ((IkConstraintData)object2).order = skeletonInput.readInt(true);
                int n6 = skeletonInput.readInt(true);
                object = ((IkConstraintData)object2).bones.setSize(n6);
                for (n3 = 0; n3 < n6; ++n3) {
                    object[n3] = boneDataArray[skeletonInput.readInt(true)];
                }
                ((IkConstraintData)object2).target = boneDataArray[skeletonInput.readInt(true)];
                n3 = skeletonInput.read();
                ((IkConstraintData)object2).skinRequired = (n3 & 1) != 0;
                ((IkConstraintData)object2).bendDirection = (n3 & 2) != 0 ? 1 : -1;
                ((IkConstraintData)object2).compress = (n3 & 4) != 0;
                ((IkConstraintData)object2).stretch = (n3 & 8) != 0;
                boolean bl2 = ((IkConstraintData)object2).uniform = (n3 & 0x10) != 0;
                if ((n3 & 0x20) != 0) {
                    float f2 = ((IkConstraintData)object2).mix = (n3 & 0x40) != 0 ? skeletonInput.readFloat() : 1.0f;
                }
                if ((n3 & 0x80) != 0) {
                    ((IkConstraintData)object2).softness = skeletonInput.readFloat() * f;
                }
                objectArray[n4] = object2;
            }
            n5 = skeletonInput.readInt(true);
            objectArray = skeletonData.transformConstraints.setSize(n5);
            for (n4 = 0; n4 < n5; ++n4) {
                object2 = new TransformConstraintData(skeletonInput.readString());
                ((TransformConstraintData)object2).order = skeletonInput.readInt(true);
                int n7 = skeletonInput.readInt(true);
                object = ((TransformConstraintData)object2).bones.setSize(n7);
                for (n3 = 0; n3 < n7; ++n3) {
                    object[n3] = boneDataArray[skeletonInput.readInt(true)];
                }
                ((TransformConstraintData)object2).target = boneDataArray[skeletonInput.readInt(true)];
                n3 = skeletonInput.read();
                ((TransformConstraintData)object2).skinRequired = (n3 & 1) != 0;
                ((TransformConstraintData)object2).local = (n3 & 2) != 0;
                boolean bl3 = ((TransformConstraintData)object2).relative = (n3 & 4) != 0;
                if ((n3 & 8) != 0) {
                    ((TransformConstraintData)object2).offsetRotation = skeletonInput.readFloat();
                }
                if ((n3 & 0x10) != 0) {
                    ((TransformConstraintData)object2).offsetX = skeletonInput.readFloat() * f;
                }
                if ((n3 & 0x20) != 0) {
                    ((TransformConstraintData)object2).offsetY = skeletonInput.readFloat() * f;
                }
                if ((n3 & 0x40) != 0) {
                    ((TransformConstraintData)object2).offsetScaleX = skeletonInput.readFloat();
                }
                if ((n3 & 0x80) != 0) {
                    ((TransformConstraintData)object2).offsetScaleY = skeletonInput.readFloat();
                }
                if (((n3 = skeletonInput.read()) & 1) != 0) {
                    ((TransformConstraintData)object2).offsetShearY = skeletonInput.readFloat();
                }
                if ((n3 & 2) != 0) {
                    ((TransformConstraintData)object2).mixRotate = skeletonInput.readFloat();
                }
                if ((n3 & 4) != 0) {
                    ((TransformConstraintData)object2).mixX = skeletonInput.readFloat();
                }
                if ((n3 & 8) != 0) {
                    ((TransformConstraintData)object2).mixY = skeletonInput.readFloat();
                }
                if ((n3 & 0x10) != 0) {
                    ((TransformConstraintData)object2).mixScaleX = skeletonInput.readFloat();
                }
                if ((n3 & 0x20) != 0) {
                    ((TransformConstraintData)object2).mixScaleY = skeletonInput.readFloat();
                }
                if ((n3 & 0x40) != 0) {
                    ((TransformConstraintData)object2).mixShearY = skeletonInput.readFloat();
                }
                objectArray[n4] = object2;
            }
            n5 = skeletonInput.readInt(true);
            objectArray = skeletonData.pathConstraints.setSize(n5);
            for (n4 = 0; n4 < n5; ++n4) {
                object2 = new PathConstraintData(skeletonInput.readString());
                ((PathConstraintData)object2).order = skeletonInput.readInt(true);
                ((PathConstraintData)object2).skinRequired = skeletonInput.readBoolean();
                int n8 = skeletonInput.readInt(true);
                object = ((PathConstraintData)object2).bones.setSize(n8);
                for (n3 = 0; n3 < n8; ++n3) {
                    object[n3] = boneDataArray[skeletonInput.readInt(true)];
                }
                ((PathConstraintData)object2).target = slotDataArray[skeletonInput.readInt(true)];
                n3 = skeletonInput.read();
                ((PathConstraintData)object2).positionMode = PathConstraintData.PositionMode.values[n3 & 1];
                ((PathConstraintData)object2).spacingMode = PathConstraintData.SpacingMode.values[n3 >> 1 & 3];
                ((PathConstraintData)object2).rotateMode = PathConstraintData.RotateMode.values[n3 >> 3 & 3];
                if ((n3 & 0x80) != 0) {
                    ((PathConstraintData)object2).offsetRotation = skeletonInput.readFloat();
                }
                ((PathConstraintData)object2).position = skeletonInput.readFloat();
                if (((PathConstraintData)object2).positionMode == PathConstraintData.PositionMode.fixed) {
                    ((PathConstraintData)object2).position *= f;
                }
                ((PathConstraintData)object2).spacing = skeletonInput.readFloat();
                if (((PathConstraintData)object2).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)object2).spacingMode == PathConstraintData.SpacingMode.fixed) {
                    ((PathConstraintData)object2).spacing *= f;
                }
                ((PathConstraintData)object2).mixRotate = skeletonInput.readFloat();
                ((PathConstraintData)object2).mixX = skeletonInput.readFloat();
                ((PathConstraintData)object2).mixY = skeletonInput.readFloat();
                objectArray[n4] = object2;
            }
            n5 = skeletonInput.readInt(true);
            objectArray = skeletonData.physicsConstraints.setSize(n5);
            for (n4 = 0; n4 < n5; ++n4) {
                PhysicsConstraintData physicsConstraintData = new PhysicsConstraintData(skeletonInput.readString());
                physicsConstraintData.order = skeletonInput.readInt(true);
                physicsConstraintData.bone = boneDataArray[skeletonInput.readInt(true)];
                int n9 = skeletonInput.read();
                boolean bl4 = physicsConstraintData.skinRequired = (n9 & 1) != 0;
                if ((n9 & 2) != 0) {
                    physicsConstraintData.x = skeletonInput.readFloat();
                }
                if ((n9 & 4) != 0) {
                    physicsConstraintData.y = skeletonInput.readFloat();
                }
                if ((n9 & 8) != 0) {
                    physicsConstraintData.rotate = skeletonInput.readFloat();
                }
                if ((n9 & 0x10) != 0) {
                    physicsConstraintData.scaleX = skeletonInput.readFloat();
                }
                if ((n9 & 0x20) != 0) {
                    physicsConstraintData.shearX = skeletonInput.readFloat();
                }
                physicsConstraintData.limit = ((n9 & 0x40) != 0 ? skeletonInput.readFloat() : 5000.0f) * f;
                physicsConstraintData.step = 1.0f / (float)skeletonInput.readUnsignedByte();
                physicsConstraintData.inertia = skeletonInput.readFloat();
                physicsConstraintData.strength = skeletonInput.readFloat();
                physicsConstraintData.damping = skeletonInput.readFloat();
                physicsConstraintData.massInverse = (n9 & 0x80) != 0 ? skeletonInput.readFloat() : 1.0f;
                physicsConstraintData.wind = skeletonInput.readFloat();
                physicsConstraintData.gravity = skeletonInput.readFloat();
                n9 = skeletonInput.read();
                if ((n9 & 1) != 0) {
                    physicsConstraintData.inertiaGlobal = true;
                }
                if ((n9 & 2) != 0) {
                    physicsConstraintData.strengthGlobal = true;
                }
                if ((n9 & 4) != 0) {
                    physicsConstraintData.dampingGlobal = true;
                }
                if ((n9 & 8) != 0) {
                    physicsConstraintData.massGlobal = true;
                }
                if ((n9 & 0x10) != 0) {
                    physicsConstraintData.windGlobal = true;
                }
                if ((n9 & 0x20) != 0) {
                    physicsConstraintData.gravityGlobal = true;
                }
                if ((n9 & 0x40) != 0) {
                    physicsConstraintData.mixGlobal = true;
                }
                physicsConstraintData.mix = (n9 & 0x80) != 0 ? skeletonInput.readFloat() : 1.0f;
                objectArray[n4] = physicsConstraintData;
            }
            Skin skin = this.readSkin(skeletonInput, skeletonData, true, bl);
            if (skin != null) {
                skeletonData.defaultSkin = skin;
                skeletonData.skins.add(skin);
            }
            n5 = n2 + skeletonInput.readInt(true);
            objectArray = skeletonData.skins.setSize(n5);
            for (n2 = skeletonData.skins.size; n2 < n5; ++n2) {
                objectArray[n2] = this.readSkin(skeletonInput, skeletonData, false, bl);
            }
            n5 = this.linkedMeshes.size;
            T[] TArray = this.linkedMeshes.items;
            for (n = 0; n < n5; ++n) {
                object = (LinkedMesh)TArray[n];
                Skin skin2 = skeletonData.skins.get(object.skinIndex);
                Attachment attachment = skin2.getAttachment(object.slotIndex, object.parent);
                if (attachment == null) {
                    throw new SerializationException("Parent mesh not found: " + object.parent);
                }
                object.mesh.setTimelineAttachment(object.inheritTimelines ? (VertexAttachment)attachment : object.mesh);
                object.mesh.setParentMesh((MeshAttachment)attachment);
                if (object.mesh.getSequence() != null) continue;
                object.mesh.updateRegion();
            }
            this.linkedMeshes.clear();
            n5 = skeletonInput.readInt(true);
            objectArray = skeletonData.events.setSize(n5);
            for (n = 0; n < n5; ++n) {
                object = new EventData(skeletonInput.readString());
                object.intValue = skeletonInput.readInt(false);
                object.floatValue = skeletonInput.readFloat();
                object.stringValue = skeletonInput.readString();
                object.audioPath = skeletonInput.readString();
                if (object.audioPath != null) {
                    object.volume = skeletonInput.readFloat();
                    object.balance = skeletonInput.readFloat();
                }
                objectArray[n] = object;
            }
            n5 = skeletonInput.readInt(true);
            objectArray = skeletonData.animations.setSize(n5);
            for (n = 0; n < n5; ++n) {
                objectArray[n] = this.readAnimation(skeletonInput, skeletonInput.readString(), skeletonData);
            }
        }
        catch (IOException iOException) {
            throw new SerializationException("Error reading skeleton file.", iOException);
        }
        finally {
            try {
                skeletonInput.close();
            }
            catch (IOException iOException) {}
        }
        return skeletonData;
    }

    private Skin readSkin(SkeletonInput skeletonInput, SkeletonData skeletonData, boolean bl, boolean bl2) throws IOException {
        int n;
        int n2;
        Skin skin;
        int n3;
        if (bl) {
            n3 = skeletonInput.readInt(true);
            if (n3 == 0) {
                return null;
            }
            skin = new Skin("default");
        } else {
            skin = new Skin(skeletonInput.readString());
            if (bl2) {
                Color.rgba8888ToColor(skin.color, skeletonInput.readInt());
            }
            BoneData[] boneDataArray = skin.bones.setSize(skeletonInput.readInt(true));
            T[] TArray = skeletonData.bones.items;
            n2 = skin.bones.size;
            for (n = 0; n < n2; ++n) {
                boneDataArray[n] = TArray[skeletonInput.readInt(true)];
            }
            TArray = skeletonData.ikConstraints.items;
            n2 = skeletonInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                skin.constraints.add((ConstraintData)TArray[skeletonInput.readInt(true)]);
            }
            TArray = skeletonData.transformConstraints.items;
            n2 = skeletonInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                skin.constraints.add((ConstraintData)TArray[skeletonInput.readInt(true)]);
            }
            TArray = skeletonData.pathConstraints.items;
            n2 = skeletonInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                skin.constraints.add((ConstraintData)TArray[skeletonInput.readInt(true)]);
            }
            TArray = skeletonData.physicsConstraints.items;
            n2 = skeletonInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                skin.constraints.add((ConstraintData)TArray[skeletonInput.readInt(true)]);
            }
            skin.constraints.shrink();
            n3 = skeletonInput.readInt(true);
        }
        for (int i = 0; i < n3; ++i) {
            int n4 = skeletonInput.readInt(true);
            n2 = skeletonInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                String string = skeletonInput.readStringRef();
                Attachment attachment = this.readAttachment(skeletonInput, skeletonData, skin, n4, string, bl2);
                if (attachment == null) continue;
                skin.setAttachment(n4, string, attachment);
            }
        }
        return skin;
    }

    private Attachment readAttachment(SkeletonInput skeletonInput, SkeletonData skeletonData, Skin skin, int n, String string, boolean bl) throws IOException {
        float f = this.scale;
        byte by = skeletonInput.readByte();
        String string2 = (by & 8) != 0 ? skeletonInput.readStringRef() : string;
        switch (AttachmentType.values[by & 7]) {
            case region: {
                RegionAttachment regionAttachment;
                String string3 = (by & 0x10) != 0 ? skeletonInput.readStringRef() : null;
                int n2 = (by & 0x20) != 0 ? skeletonInput.readInt() : -1;
                Sequence sequence = (by & 0x40) != 0 ? this.readSequence(skeletonInput) : null;
                float f2 = (by & 0x80) != 0 ? skeletonInput.readFloat() : 0.0f;
                float f3 = skeletonInput.readFloat();
                float f4 = skeletonInput.readFloat();
                float f5 = skeletonInput.readFloat();
                float f6 = skeletonInput.readFloat();
                float f7 = skeletonInput.readFloat();
                float f8 = skeletonInput.readFloat();
                if (string3 == null) {
                    string3 = string2;
                }
                if ((regionAttachment = this.attachmentLoader.newRegionAttachment(skin, string2, string3, sequence)) == null) {
                    return null;
                }
                regionAttachment.setPath(string3);
                regionAttachment.setX(f3 * f);
                regionAttachment.setY(f4 * f);
                regionAttachment.setScaleX(f5);
                regionAttachment.setScaleY(f6);
                regionAttachment.setRotation(f2);
                regionAttachment.setWidth(f7 * f);
                regionAttachment.setHeight(f8 * f);
                Color.rgba8888ToColor(regionAttachment.getColor(), n2);
                regionAttachment.setSequence(sequence);
                if (sequence == null) {
                    regionAttachment.updateRegion();
                }
                return regionAttachment;
            }
            case boundingbox: {
                Vertices vertices = this.readVertices(skeletonInput, (by & 0x10) != 0);
                int n3 = bl ? skeletonInput.readInt() : 0;
                BoundingBoxAttachment boundingBoxAttachment = this.attachmentLoader.newBoundingBoxAttachment(skin, string2);
                if (boundingBoxAttachment == null) {
                    return null;
                }
                boundingBoxAttachment.setWorldVerticesLength(vertices.length);
                boundingBoxAttachment.setVertices(vertices.vertices);
                boundingBoxAttachment.setBones(vertices.bones);
                if (bl) {
                    Color.rgba8888ToColor(boundingBoxAttachment.getColor(), n3);
                }
                return boundingBoxAttachment;
            }
            case mesh: {
                MeshAttachment meshAttachment;
                String string4 = (by & 0x10) != 0 ? skeletonInput.readStringRef() : string2;
                int n4 = (by & 0x20) != 0 ? skeletonInput.readInt() : -1;
                Sequence sequence = (by & 0x40) != 0 ? this.readSequence(skeletonInput) : null;
                int n5 = skeletonInput.readInt(true);
                Vertices vertices = this.readVertices(skeletonInput, (by & 0x80) != 0);
                float[] fArray = this.readFloatArray(skeletonInput, vertices.length, 1.0f);
                short[] sArray = this.readShortArray(skeletonInput, (vertices.length - n5 - 2) * 3);
                short[] sArray2 = null;
                float f9 = 0.0f;
                float f10 = 0.0f;
                if (bl) {
                    sArray2 = this.readShortArray(skeletonInput, skeletonInput.readInt(true));
                    f9 = skeletonInput.readFloat();
                    f10 = skeletonInput.readFloat();
                }
                if ((meshAttachment = this.attachmentLoader.newMeshAttachment(skin, string2, string4, sequence)) == null) {
                    return null;
                }
                meshAttachment.setPath(string4);
                Color.rgba8888ToColor(meshAttachment.getColor(), n4);
                meshAttachment.setBones(vertices.bones);
                meshAttachment.setVertices(vertices.vertices);
                meshAttachment.setWorldVerticesLength(vertices.length);
                meshAttachment.setTriangles(sArray);
                meshAttachment.setRegionUVs(fArray);
                if (sequence == null) {
                    meshAttachment.updateRegion();
                }
                meshAttachment.setHullLength(n5 << 1);
                meshAttachment.setSequence(sequence);
                if (bl) {
                    meshAttachment.setEdges(sArray2);
                    meshAttachment.setWidth(f9 * f);
                    meshAttachment.setHeight(f10 * f);
                }
                return meshAttachment;
            }
            case linkedmesh: {
                MeshAttachment meshAttachment;
                String string5 = (by & 0x10) != 0 ? skeletonInput.readStringRef() : string2;
                int n6 = (by & 0x20) != 0 ? skeletonInput.readInt() : -1;
                Sequence sequence = (by & 0x40) != 0 ? this.readSequence(skeletonInput) : null;
                boolean bl2 = (by & 0x80) != 0;
                int n7 = skeletonInput.readInt(true);
                String string6 = skeletonInput.readStringRef();
                float f11 = 0.0f;
                float f12 = 0.0f;
                if (bl) {
                    f11 = skeletonInput.readFloat();
                    f12 = skeletonInput.readFloat();
                }
                if ((meshAttachment = this.attachmentLoader.newMeshAttachment(skin, string2, string5, sequence)) == null) {
                    return null;
                }
                meshAttachment.setPath(string5);
                Color.rgba8888ToColor(meshAttachment.getColor(), n6);
                meshAttachment.setSequence(sequence);
                if (bl) {
                    meshAttachment.setWidth(f11 * f);
                    meshAttachment.setHeight(f12 * f);
                }
                this.linkedMeshes.add(new LinkedMesh(meshAttachment, n7, n, string6, bl2));
                return meshAttachment;
            }
            case path: {
                int n8;
                boolean bl3 = (by & 0x10) != 0;
                boolean bl4 = (by & 0x20) != 0;
                Vertices vertices = this.readVertices(skeletonInput, (by & 0x40) != 0);
                float[] fArray = new float[vertices.length / 6];
                int n9 = fArray.length;
                for (n8 = 0; n8 < n9; ++n8) {
                    fArray[n8] = skeletonInput.readFloat() * f;
                }
                n8 = bl ? skeletonInput.readInt() : 0;
                PathAttachment pathAttachment = this.attachmentLoader.newPathAttachment(skin, string2);
                if (pathAttachment == null) {
                    return null;
                }
                pathAttachment.setClosed(bl3);
                pathAttachment.setConstantSpeed(bl4);
                pathAttachment.setWorldVerticesLength(vertices.length);
                pathAttachment.setVertices(vertices.vertices);
                pathAttachment.setBones(vertices.bones);
                pathAttachment.setLengths(fArray);
                if (bl) {
                    Color.rgba8888ToColor(pathAttachment.getColor(), n8);
                }
                return pathAttachment;
            }
            case point: {
                float f13 = skeletonInput.readFloat();
                float f14 = skeletonInput.readFloat();
                float f15 = skeletonInput.readFloat();
                int n10 = bl ? skeletonInput.readInt() : 0;
                PointAttachment pointAttachment = this.attachmentLoader.newPointAttachment(skin, string2);
                if (pointAttachment == null) {
                    return null;
                }
                pointAttachment.setX(f14 * f);
                pointAttachment.setY(f15 * f);
                pointAttachment.setRotation(f13);
                if (bl) {
                    Color.rgba8888ToColor(pointAttachment.getColor(), n10);
                }
                return pointAttachment;
            }
            case clipping: {
                int n11 = skeletonInput.readInt(true);
                Vertices vertices = this.readVertices(skeletonInput, (by & 0x10) != 0);
                int n12 = bl ? skeletonInput.readInt() : 0;
                ClippingAttachment clippingAttachment = this.attachmentLoader.newClippingAttachment(skin, string2);
                if (clippingAttachment == null) {
                    return null;
                }
                clippingAttachment.setEndSlot(skeletonData.slots.get(n11));
                clippingAttachment.setWorldVerticesLength(vertices.length);
                clippingAttachment.setVertices(vertices.vertices);
                clippingAttachment.setBones(vertices.bones);
                if (bl) {
                    Color.rgba8888ToColor(clippingAttachment.getColor(), n12);
                }
                return clippingAttachment;
            }
        }
        return null;
    }

    private Sequence readSequence(SkeletonInput skeletonInput) throws IOException {
        Sequence sequence = new Sequence(skeletonInput.readInt(true));
        sequence.setStart(skeletonInput.readInt(true));
        sequence.setDigits(skeletonInput.readInt(true));
        sequence.setSetupIndex(skeletonInput.readInt(true));
        return sequence;
    }

    private Vertices readVertices(SkeletonInput skeletonInput, boolean bl) throws IOException {
        float f = this.scale;
        int n = skeletonInput.readInt(true);
        Vertices vertices = new Vertices();
        vertices.length = n << 1;
        if (!bl) {
            vertices.vertices = this.readFloatArray(skeletonInput, vertices.length, f);
            return vertices;
        }
        FloatArray floatArray = new FloatArray(vertices.length * 3 * 3);
        IntArray intArray = new IntArray(vertices.length * 3);
        for (int i = 0; i < n; ++i) {
            int n2 = skeletonInput.readInt(true);
            intArray.add(n2);
            for (int j = 0; j < n2; ++j) {
                intArray.add(skeletonInput.readInt(true));
                floatArray.add(skeletonInput.readFloat() * f);
                floatArray.add(skeletonInput.readFloat() * f);
                floatArray.add(skeletonInput.readFloat());
            }
        }
        vertices.vertices = floatArray.toArray();
        vertices.bones = intArray.toArray();
        return vertices;
    }

    private float[] readFloatArray(SkeletonInput skeletonInput, int n, float f) throws IOException {
        float[] fArray = new float[n];
        if (f == 1.0f) {
            for (int i = 0; i < n; ++i) {
                fArray[i] = skeletonInput.readFloat();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                fArray[i] = skeletonInput.readFloat() * f;
            }
        }
        return fArray;
    }

    private short[] readShortArray(SkeletonInput skeletonInput, int n) throws IOException {
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)skeletonInput.readInt(true);
        }
        return sArray;
    }

    private Animation readAnimation(SkeletonInput skeletonInput, String string, SkeletonData skeletonData) throws IOException {
        int n;
        float f;
        float f2;
        float f3;
        float f4;
        int n2;
        byte by;
        int n3;
        int n4;
        int n5;
        int n6;
        Array<Animation.Timeline> array = new Array<Animation.Timeline>(skeletonInput.readInt(true));
        float f5 = this.scale;
        int n7 = skeletonInput.readInt(true);
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = skeletonInput.readInt(true);
            n4 = skeletonInput.readInt(true);
            block71: for (n3 = 0; n3 < n4; ++n3) {
                by = skeletonInput.readByte();
                n2 = skeletonInput.readInt(true);
                int n8 = n2 - 1;
                switch (by) {
                    case 0: {
                        Animation.Timeline timeline = new Animation.AttachmentTimeline(n2, n5);
                        for (int i = 0; i < n2; ++i) {
                            ((Animation.AttachmentTimeline)timeline).setFrame(i, skeletonInput.readFloat(), skeletonInput.readStringRef());
                        }
                        array.add(timeline);
                        continue block71;
                    }
                    case 1: {
                        Animation.Timeline timeline = new Animation.RGBATimeline(n2, skeletonInput.readInt(true), n5);
                        float f6 = skeletonInput.readFloat();
                        float f7 = (float)skeletonInput.read() / 255.0f;
                        float f8 = (float)skeletonInput.read() / 255.0f;
                        float f9 = (float)skeletonInput.read() / 255.0f;
                        f4 = (float)skeletonInput.read() / 255.0f;
                        int n9 = 0;
                        int n10 = 0;
                        while (true) {
                            ((Animation.RGBATimeline)timeline).setFrame(n9, f6, f7, f8, f9, f4);
                            if (n9 == n8) break;
                            float f10 = skeletonInput.readFloat();
                            float f11 = (float)skeletonInput.read() / 255.0f;
                            float f12 = (float)skeletonInput.read() / 255.0f;
                            f3 = (float)skeletonInput.read() / 255.0f;
                            f2 = (float)skeletonInput.read() / 255.0f;
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(n9);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n10++, n9, 0, f6, f10, f7, f11, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n10++, n9, 1, f6, f10, f8, f12, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n10++, n9, 2, f6, f10, f9, f3, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n10++, n9, 3, f6, f10, f4, f2, 1.0f);
                                }
                            }
                            f6 = f10;
                            f7 = f11;
                            f8 = f12;
                            f9 = f3;
                            f4 = f2;
                            ++n9;
                        }
                        array.add(timeline);
                        continue block71;
                    }
                    case 2: {
                        Animation.Timeline timeline = new Animation.RGBTimeline(n2, skeletonInput.readInt(true), n5);
                        float f13 = skeletonInput.readFloat();
                        float f7 = (float)skeletonInput.read() / 255.0f;
                        float f14 = (float)skeletonInput.read() / 255.0f;
                        float f15 = (float)skeletonInput.read() / 255.0f;
                        int n11 = 0;
                        int n12 = 0;
                        while (true) {
                            ((Animation.RGBTimeline)timeline).setFrame(n11, f13, f7, f14, f15);
                            if (n11 == n8) break;
                            float f16 = skeletonInput.readFloat();
                            float f17 = (float)skeletonInput.read() / 255.0f;
                            float f18 = (float)skeletonInput.read() / 255.0f;
                            float f19 = (float)skeletonInput.read() / 255.0f;
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(n11);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n12++, n11, 0, f13, f16, f7, f17, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n12++, n11, 1, f13, f16, f14, f18, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n12++, n11, 2, f13, f16, f15, f19, 1.0f);
                                }
                            }
                            f13 = f16;
                            f7 = f17;
                            f14 = f18;
                            f15 = f19;
                            ++n11;
                        }
                        array.add(timeline);
                        continue block71;
                    }
                    case 3: {
                        float f20;
                        float f21;
                        float f22;
                        Animation.Timeline timeline = new Animation.RGBA2Timeline(n2, skeletonInput.readInt(true), n5);
                        float f23 = skeletonInput.readFloat();
                        float f7 = (float)skeletonInput.read() / 255.0f;
                        float f24 = (float)skeletonInput.read() / 255.0f;
                        float f25 = (float)skeletonInput.read() / 255.0f;
                        f4 = (float)skeletonInput.read() / 255.0f;
                        float f26 = (float)skeletonInput.read() / 255.0f;
                        float f27 = (float)skeletonInput.read() / 255.0f;
                        float f28 = (float)skeletonInput.read() / 255.0f;
                        int n13 = 0;
                        int n14 = 0;
                        while (true) {
                            ((Animation.RGBA2Timeline)timeline).setFrame(n13, f23, f7, f24, f25, f4, f26, f27, f28);
                            if (n13 == n8) break;
                            f3 = skeletonInput.readFloat();
                            f2 = (float)skeletonInput.read() / 255.0f;
                            f = (float)skeletonInput.read() / 255.0f;
                            f22 = (float)skeletonInput.read() / 255.0f;
                            f21 = (float)skeletonInput.read() / 255.0f;
                            f20 = (float)skeletonInput.read() / 255.0f;
                            float f29 = (float)skeletonInput.read() / 255.0f;
                            float f30 = (float)skeletonInput.read() / 255.0f;
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(n13);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n13, 0, f23, f3, f7, f2, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n13, 1, f23, f3, f24, f, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n13, 2, f23, f3, f25, f22, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n13, 3, f23, f3, f4, f21, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n13, 4, f23, f3, f26, f20, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n13, 5, f23, f3, f27, f29, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n13, 6, f23, f3, f28, f30, 1.0f);
                                }
                            }
                            f23 = f3;
                            f7 = f2;
                            f24 = f;
                            f25 = f22;
                            f4 = f21;
                            f26 = f20;
                            f27 = f29;
                            f28 = f30;
                            ++n13;
                        }
                        array.add(timeline);
                        continue block71;
                    }
                    case 4: {
                        float f20;
                        float f21;
                        float f22;
                        Animation.Timeline timeline = new Animation.RGB2Timeline(n2, skeletonInput.readInt(true), n5);
                        float f31 = skeletonInput.readFloat();
                        float f7 = (float)skeletonInput.read() / 255.0f;
                        float f32 = (float)skeletonInput.read() / 255.0f;
                        float f33 = (float)skeletonInput.read() / 255.0f;
                        f4 = (float)skeletonInput.read() / 255.0f;
                        float f34 = (float)skeletonInput.read() / 255.0f;
                        float f35 = (float)skeletonInput.read() / 255.0f;
                        int n15 = 0;
                        int n13 = 0;
                        while (true) {
                            ((Animation.RGB2Timeline)timeline).setFrame(n15, f31, f7, f32, f33, f4, f34, f35);
                            if (n15 == n8) break;
                            float f36 = skeletonInput.readFloat();
                            f3 = (float)skeletonInput.read() / 255.0f;
                            f2 = (float)skeletonInput.read() / 255.0f;
                            f = (float)skeletonInput.read() / 255.0f;
                            f22 = (float)skeletonInput.read() / 255.0f;
                            f21 = (float)skeletonInput.read() / 255.0f;
                            f20 = (float)skeletonInput.read() / 255.0f;
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(n15);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n13++, n15, 0, f31, f36, f7, f3, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n13++, n15, 1, f31, f36, f32, f2, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n13++, n15, 2, f31, f36, f33, f, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n13++, n15, 3, f31, f36, f4, f22, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n13++, n15, 4, f31, f36, f34, f21, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n13++, n15, 5, f31, f36, f35, f20, 1.0f);
                                }
                            }
                            f31 = f36;
                            f7 = f3;
                            f32 = f2;
                            f33 = f;
                            f4 = f22;
                            f34 = f21;
                            f35 = f20;
                            ++n15;
                        }
                        array.add(timeline);
                        continue block71;
                    }
                    case 5: {
                        Animation.Timeline timeline = new Animation.AlphaTimeline(n2, skeletonInput.readInt(true), n5);
                        float f37 = skeletonInput.readFloat();
                        float f7 = (float)skeletonInput.read() / 255.0f;
                        int n16 = 0;
                        int n17 = 0;
                        while (true) {
                            ((Animation.CurveTimeline1)timeline).setFrame(n16, f37, f7);
                            if (n16 == n8) break;
                            f4 = skeletonInput.readFloat();
                            float f38 = (float)skeletonInput.read() / 255.0f;
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(n16);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n17++, n16, 0, f37, f4, f7, f38, 1.0f);
                                }
                            }
                            f37 = f4;
                            f7 = f38;
                            ++n16;
                        }
                        array.add(timeline);
                    }
                }
            }
        }
        n7 = skeletonInput.readInt(true);
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = skeletonInput.readInt(true);
            n4 = skeletonInput.readInt(true);
            block79: for (n3 = 0; n3 < n4; ++n3) {
                by = skeletonInput.readByte();
                n2 = skeletonInput.readInt(true);
                if (by == 10) {
                    Animation.InheritTimeline inheritTimeline = new Animation.InheritTimeline(n2, n5);
                    for (int i = 0; i < n2; ++i) {
                        inheritTimeline.setFrame(i, skeletonInput.readFloat(), BoneData.Inherit.values[skeletonInput.readByte()]);
                    }
                    array.add(inheritTimeline);
                    continue;
                }
                int n18 = skeletonInput.readInt(true);
                switch (by) {
                    case 0: {
                        this.readTimeline(skeletonInput, array, new Animation.RotateTimeline(n2, n18, n5), 1.0f);
                        continue block79;
                    }
                    case 1: {
                        this.readTimeline(skeletonInput, array, new Animation.TranslateTimeline(n2, n18, n5), f5);
                        continue block79;
                    }
                    case 2: {
                        this.readTimeline(skeletonInput, array, new Animation.TranslateXTimeline(n2, n18, n5), f5);
                        continue block79;
                    }
                    case 3: {
                        this.readTimeline(skeletonInput, array, new Animation.TranslateYTimeline(n2, n18, n5), f5);
                        continue block79;
                    }
                    case 4: {
                        this.readTimeline(skeletonInput, array, new Animation.ScaleTimeline(n2, n18, n5), 1.0f);
                        continue block79;
                    }
                    case 5: {
                        this.readTimeline(skeletonInput, array, new Animation.ScaleXTimeline(n2, n18, n5), 1.0f);
                        continue block79;
                    }
                    case 6: {
                        this.readTimeline(skeletonInput, array, new Animation.ScaleYTimeline(n2, n18, n5), 1.0f);
                        continue block79;
                    }
                    case 7: {
                        this.readTimeline(skeletonInput, array, new Animation.ShearTimeline(n2, n18, n5), 1.0f);
                        continue block79;
                    }
                    case 8: {
                        this.readTimeline(skeletonInput, array, new Animation.ShearXTimeline(n2, n18, n5), 1.0f);
                        continue block79;
                    }
                    case 9: {
                        this.readTimeline(skeletonInput, array, new Animation.ShearYTimeline(n2, n18, n5), 1.0f);
                    }
                }
            }
        }
        n7 = skeletonInput.readInt(true);
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = skeletonInput.readInt(true);
            n3 = skeletonInput.readInt(true);
            n4 = n3 - 1;
            Animation.IkConstraintTimeline ikConstraintTimeline = new Animation.IkConstraintTimeline(n3, skeletonInput.readInt(true), n5);
            n2 = skeletonInput.read();
            float f39 = skeletonInput.readFloat();
            float f40 = (n2 & 1) != 0 ? ((n2 & 2) != 0 ? skeletonInput.readFloat() : 1.0f) : 0.0f;
            float f41 = (n2 & 4) != 0 ? skeletonInput.readFloat() * f5 : 0.0f;
            int n19 = 0;
            int n20 = 0;
            while (true) {
                float f42;
                ikConstraintTimeline.setFrame(n19, f39, f40, f41, (n2 & 8) != 0 ? 1 : -1, (n2 & 0x10) != 0, (n2 & 0x20) != 0);
                if (n19 == n4) break;
                n2 = skeletonInput.read();
                float f43 = skeletonInput.readFloat();
                f4 = (n2 & 1) != 0 ? ((n2 & 2) != 0 ? skeletonInput.readFloat() : 1.0f) : 0.0f;
                float f44 = f42 = (n2 & 4) != 0 ? skeletonInput.readFloat() * f5 : 0.0f;
                if ((n2 & 0x40) != 0) {
                    ikConstraintTimeline.setStepped(n19);
                } else if ((n2 & 0x80) != 0) {
                    this.setBezier(skeletonInput, ikConstraintTimeline, n20++, n19, 0, f39, f43, f40, f4, 1.0f);
                    this.setBezier(skeletonInput, ikConstraintTimeline, n20++, n19, 1, f39, f43, f41, f42, f5);
                }
                f39 = f43;
                f40 = f4;
                f41 = f42;
                ++n19;
            }
            array.add(ikConstraintTimeline);
        }
        n7 = skeletonInput.readInt(true);
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = skeletonInput.readInt(true);
            n3 = skeletonInput.readInt(true);
            n4 = n3 - 1;
            Animation.TransformConstraintTimeline transformConstraintTimeline = new Animation.TransformConstraintTimeline(n3, skeletonInput.readInt(true), n5);
            float f45 = skeletonInput.readFloat();
            float f46 = skeletonInput.readFloat();
            float f47 = skeletonInput.readFloat();
            float f48 = skeletonInput.readFloat();
            float f49 = skeletonInput.readFloat();
            float f50 = skeletonInput.readFloat();
            float f51 = skeletonInput.readFloat();
            int n21 = 0;
            int n22 = 0;
            while (true) {
                transformConstraintTimeline.setFrame(n21, f45, f46, f47, f48, f49, f50, f51);
                if (n21 == n4) break;
                float f52 = skeletonInput.readFloat();
                float f53 = skeletonInput.readFloat();
                float f54 = skeletonInput.readFloat();
                float f55 = skeletonInput.readFloat();
                f3 = skeletonInput.readFloat();
                f2 = skeletonInput.readFloat();
                f = skeletonInput.readFloat();
                switch (skeletonInput.readByte()) {
                    case 1: {
                        transformConstraintTimeline.setStepped(n21);
                        break;
                    }
                    case 2: {
                        this.setBezier(skeletonInput, transformConstraintTimeline, n22++, n21, 0, f45, f52, f46, f53, 1.0f);
                        this.setBezier(skeletonInput, transformConstraintTimeline, n22++, n21, 1, f45, f52, f47, f54, 1.0f);
                        this.setBezier(skeletonInput, transformConstraintTimeline, n22++, n21, 2, f45, f52, f48, f55, 1.0f);
                        this.setBezier(skeletonInput, transformConstraintTimeline, n22++, n21, 3, f45, f52, f49, f3, 1.0f);
                        this.setBezier(skeletonInput, transformConstraintTimeline, n22++, n21, 4, f45, f52, f50, f2, 1.0f);
                        this.setBezier(skeletonInput, transformConstraintTimeline, n22++, n21, 5, f45, f52, f51, f, 1.0f);
                    }
                }
                f45 = f52;
                f46 = f53;
                f47 = f54;
                f48 = f55;
                f49 = f3;
                f50 = f2;
                f51 = f;
                ++n21;
            }
            array.add(transformConstraintTimeline);
        }
        n7 = skeletonInput.readInt(true);
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = skeletonInput.readInt(true);
            PathConstraintData pathConstraintData = skeletonData.pathConstraints.get(n5);
            int n23 = skeletonInput.readInt(true);
            block86: for (n4 = 0; n4 < n23; ++n4) {
                byte by2 = skeletonInput.readByte();
                int n24 = skeletonInput.readInt(true);
                int n25 = skeletonInput.readInt(true);
                switch (by2) {
                    case 0: {
                        this.readTimeline(skeletonInput, array, new Animation.PathConstraintPositionTimeline(n24, n25, n5), pathConstraintData.positionMode == PathConstraintData.PositionMode.fixed ? f5 : 1.0f);
                        continue block86;
                    }
                    case 1: {
                        this.readTimeline(skeletonInput, array, new Animation.PathConstraintSpacingTimeline(n24, n25, n5), pathConstraintData.spacingMode == PathConstraintData.SpacingMode.length || pathConstraintData.spacingMode == PathConstraintData.SpacingMode.fixed ? f5 : 1.0f);
                        continue block86;
                    }
                    case 2: {
                        Animation.PathConstraintMixTimeline pathConstraintMixTimeline = new Animation.PathConstraintMixTimeline(n24, n25, n5);
                        float f56 = skeletonInput.readFloat();
                        float f57 = skeletonInput.readFloat();
                        float f58 = skeletonInput.readFloat();
                        float f59 = skeletonInput.readFloat();
                        int n26 = 0;
                        int n27 = 0;
                        int n28 = pathConstraintMixTimeline.getFrameCount() - 1;
                        while (true) {
                            pathConstraintMixTimeline.setFrame(n26, f56, f57, f58, f59);
                            if (n26 == n28) break;
                            float f60 = skeletonInput.readFloat();
                            float f61 = skeletonInput.readFloat();
                            f3 = skeletonInput.readFloat();
                            f2 = skeletonInput.readFloat();
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    pathConstraintMixTimeline.setStepped(n26);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, pathConstraintMixTimeline, n27++, n26, 0, f56, f60, f57, f61, 1.0f);
                                    this.setBezier(skeletonInput, pathConstraintMixTimeline, n27++, n26, 1, f56, f60, f58, f3, 1.0f);
                                    this.setBezier(skeletonInput, pathConstraintMixTimeline, n27++, n26, 2, f56, f60, f59, f2, 1.0f);
                                }
                            }
                            f56 = f60;
                            f57 = f61;
                            f58 = f3;
                            f59 = f2;
                            ++n26;
                        }
                        array.add(pathConstraintMixTimeline);
                    }
                }
            }
        }
        n7 = skeletonInput.readInt(true);
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = skeletonInput.readInt(true) - 1;
            n4 = skeletonInput.readInt(true);
            block89: for (int i = 0; i < n4; ++i) {
                byte by3 = skeletonInput.readByte();
                int n29 = skeletonInput.readInt(true);
                if (by3 == 8) {
                    Animation.PhysicsConstraintResetTimeline physicsConstraintResetTimeline = new Animation.PhysicsConstraintResetTimeline(n29, n5);
                    for (int j = 0; j < n29; ++j) {
                        physicsConstraintResetTimeline.setFrame(j, skeletonInput.readFloat());
                    }
                    array.add(physicsConstraintResetTimeline);
                    continue;
                }
                int n30 = skeletonInput.readInt(true);
                switch (by3) {
                    case 0: {
                        this.readTimeline(skeletonInput, array, new Animation.PhysicsConstraintInertiaTimeline(n29, n30, n5), 1.0f);
                        continue block89;
                    }
                    case 1: {
                        this.readTimeline(skeletonInput, array, new Animation.PhysicsConstraintStrengthTimeline(n29, n30, n5), 1.0f);
                        continue block89;
                    }
                    case 2: {
                        this.readTimeline(skeletonInput, array, new Animation.PhysicsConstraintDampingTimeline(n29, n30, n5), 1.0f);
                        continue block89;
                    }
                    case 4: {
                        this.readTimeline(skeletonInput, array, new Animation.PhysicsConstraintMassTimeline(n29, n30, n5), 1.0f);
                        continue block89;
                    }
                    case 5: {
                        this.readTimeline(skeletonInput, array, new Animation.PhysicsConstraintWindTimeline(n29, n30, n5), 1.0f);
                        continue block89;
                    }
                    case 6: {
                        this.readTimeline(skeletonInput, array, new Animation.PhysicsConstraintGravityTimeline(n29, n30, n5), 1.0f);
                        continue block89;
                    }
                    case 7: {
                        this.readTimeline(skeletonInput, array, new Animation.PhysicsConstraintMixTimeline(n29, n30, n5), 1.0f);
                    }
                }
            }
        }
        n7 = skeletonInput.readInt(true);
        for (n6 = 0; n6 < n7; ++n6) {
            Skin skin = skeletonData.skins.get(skeletonInput.readInt(true));
            n4 = skeletonInput.readInt(true);
            for (int i = 0; i < n4; ++i) {
                int n31 = skeletonInput.readInt(true);
                int n32 = skeletonInput.readInt(true);
                block93: for (int j = 0; j < n32; ++j) {
                    String string2 = skeletonInput.readStringRef();
                    Attachment attachment = skin.getAttachment(n31, string2);
                    if (attachment == null) {
                        throw new SerializationException("Timeline attachment not found: " + string2);
                    }
                    byte by4 = skeletonInput.readByte();
                    int n33 = skeletonInput.readInt(true);
                    int n34 = n33 - 1;
                    switch (by4) {
                        case 0: {
                            Object object = (VertexAttachment)attachment;
                            int n35 = ((VertexAttachment)object).getBones() != null ? 1 : 0;
                            float[] fArray = ((VertexAttachment)object).getVertices();
                            int n36 = n35 != 0 ? fArray.length / 3 << 1 : fArray.length;
                            Animation.DeformTimeline deformTimeline = new Animation.DeformTimeline(n33, skeletonInput.readInt(true), n31, (VertexAttachment)object);
                            float f62 = skeletonInput.readFloat();
                            int n37 = 0;
                            int n38 = 0;
                            while (true) {
                                float[] fArray2;
                                int n39;
                                if ((n39 = skeletonInput.readInt(true)) == 0) {
                                    fArray2 = n35 != 0 ? new float[n36] : fArray;
                                } else {
                                    int n40;
                                    fArray2 = new float[n36];
                                    int n41 = skeletonInput.readInt(true);
                                    n39 += n41;
                                    if (f5 == 1.0f) {
                                        for (n40 = n41; n40 < n39; ++n40) {
                                            fArray2[n40] = skeletonInput.readFloat();
                                        }
                                    } else {
                                        for (n40 = n41; n40 < n39; ++n40) {
                                            fArray2[n40] = skeletonInput.readFloat() * f5;
                                        }
                                    }
                                    if (n35 == 0) {
                                        int n42 = fArray2.length;
                                        for (n40 = 0; n40 < n42; ++n40) {
                                            int n43 = n40;
                                            fArray2[n43] = fArray2[n43] + fArray[n40];
                                        }
                                    }
                                }
                                deformTimeline.setFrame(n37, f62, fArray2);
                                if (n37 == n34) break;
                                float f63 = skeletonInput.readFloat();
                                switch (skeletonInput.readByte()) {
                                    case 1: {
                                        deformTimeline.setStepped(n37);
                                        break;
                                    }
                                    case 2: {
                                        this.setBezier(skeletonInput, deformTimeline, n38++, n37, 0, f62, f63, 0.0f, 1.0f, 1.0f);
                                    }
                                }
                                f62 = f63;
                                ++n37;
                            }
                            array.add(deformTimeline);
                            continue block93;
                        }
                        case 1: {
                            int n36;
                            int n35;
                            Object object = new Animation.SequenceTimeline(n33, n31, attachment);
                            for (n35 = 0; n35 < n33; ++n35) {
                                float f64 = skeletonInput.readFloat();
                                n36 = skeletonInput.readInt();
                                ((Animation.SequenceTimeline)object).setFrame(n35, f64, Sequence.SequenceMode.values[n36 & 0xF], n36 >> 4, skeletonInput.readFloat());
                            }
                            array.add((Animation.Timeline)object);
                        }
                    }
                }
            }
        }
        n6 = skeletonInput.readInt(true);
        if (n6 > 0) {
            Animation.DrawOrderTimeline drawOrderTimeline = new Animation.DrawOrderTimeline(n6);
            int n44 = skeletonData.slots.size;
            for (int i = 0; i < n6; ++i) {
                int n45;
                float f65 = skeletonInput.readFloat();
                int n46 = skeletonInput.readInt(true);
                int[] nArray = new int[n44];
                for (int j = n44 - 1; j >= 0; --j) {
                    nArray[j] = -1;
                }
                int[] nArray2 = new int[n44 - n46];
                int n47 = 0;
                int n48 = 0;
                for (n45 = 0; n45 < n46; ++n45) {
                    int n49 = skeletonInput.readInt(true);
                    while (n47 != n49) {
                        nArray2[n48++] = n47++;
                    }
                    nArray[n47 + skeletonInput.readInt((boolean)true)] = n47++;
                }
                while (n47 < n44) {
                    nArray2[n48++] = n47++;
                }
                for (n45 = n44 - 1; n45 >= 0; --n45) {
                    if (nArray[n45] != -1) continue;
                    nArray[n45] = nArray2[--n48];
                }
                drawOrderTimeline.setFrame(i, f65, nArray);
            }
            array.add(drawOrderTimeline);
        }
        if ((n = skeletonInput.readInt(true)) > 0) {
            Animation.EventTimeline eventTimeline = new Animation.EventTimeline(n);
            for (int i = 0; i < n; ++i) {
                float f66 = skeletonInput.readFloat();
                EventData eventData = skeletonData.events.get(skeletonInput.readInt(true));
                Event event = new Event(f66, eventData);
                event.intValue = skeletonInput.readInt(false);
                event.floatValue = skeletonInput.readFloat();
                event.stringValue = skeletonInput.readString();
                if (event.stringValue == null) {
                    event.stringValue = eventData.stringValue;
                }
                if (event.getData().audioPath != null) {
                    event.volume = skeletonInput.readFloat();
                    event.balance = skeletonInput.readFloat();
                }
                eventTimeline.setFrame(i, event);
            }
            array.add(eventTimeline);
        }
        float f67 = 0.0f;
        T[] TArray = array.items;
        int n50 = array.size;
        for (int i = 0; i < n50; ++i) {
            f67 = Math.max(f67, ((Animation.Timeline)TArray[i]).getDuration());
        }
        return new Animation(string, array, f67);
    }

    private void readTimeline(SkeletonInput skeletonInput, Array<Animation.Timeline> array, Animation.CurveTimeline1 curveTimeline1, float f) throws IOException {
        float f2 = skeletonInput.readFloat();
        float f3 = skeletonInput.readFloat() * f;
        int n = 0;
        int n2 = 0;
        int n3 = curveTimeline1.getFrameCount() - 1;
        while (true) {
            curveTimeline1.setFrame(n, f2, f3);
            if (n == n3) break;
            float f4 = skeletonInput.readFloat();
            float f5 = skeletonInput.readFloat() * f;
            switch (skeletonInput.readByte()) {
                case 1: {
                    curveTimeline1.setStepped(n);
                    break;
                }
                case 2: {
                    this.setBezier(skeletonInput, curveTimeline1, n2++, n, 0, f2, f4, f3, f5, f);
                }
            }
            f2 = f4;
            f3 = f5;
            ++n;
        }
        array.add(curveTimeline1);
    }

    private void readTimeline(SkeletonInput skeletonInput, Array<Animation.Timeline> array, Animation.CurveTimeline2 curveTimeline2, float f) throws IOException {
        float f2 = skeletonInput.readFloat();
        float f3 = skeletonInput.readFloat() * f;
        float f4 = skeletonInput.readFloat() * f;
        int n = 0;
        int n2 = 0;
        int n3 = curveTimeline2.getFrameCount() - 1;
        while (true) {
            curveTimeline2.setFrame(n, f2, f3, f4);
            if (n == n3) break;
            float f5 = skeletonInput.readFloat();
            float f6 = skeletonInput.readFloat() * f;
            float f7 = skeletonInput.readFloat() * f;
            switch (skeletonInput.readByte()) {
                case 1: {
                    curveTimeline2.setStepped(n);
                    break;
                }
                case 2: {
                    this.setBezier(skeletonInput, curveTimeline2, n2++, n, 0, f2, f5, f3, f6, f);
                    this.setBezier(skeletonInput, curveTimeline2, n2++, n, 1, f2, f5, f4, f7, f);
                }
            }
            f2 = f5;
            f3 = f6;
            f4 = f7;
            ++n;
        }
        array.add(curveTimeline2);
    }

    void setBezier(SkeletonInput skeletonInput, Animation.CurveTimeline curveTimeline, int n, int n2, int n3, float f, float f2, float f3, float f4, float f5) throws IOException {
        curveTimeline.setBezier(n, n2, n3, f, f3, skeletonInput.readFloat(), skeletonInput.readFloat() * f5, skeletonInput.readFloat(), skeletonInput.readFloat() * f5, f2, f4);
    }

    static class SkeletonInput
    extends DataInput {
        private char[] chars = new char[32];
        String[] strings;

        public SkeletonInput(InputStream inputStream) {
            super(inputStream);
        }

        public String readStringRef() throws IOException {
            int n = this.readInt(true);
            return n == 0 ? null : this.strings[n - 1];
        }

        @Override
        public String readString() throws IOException {
            int n = this.readInt(true);
            switch (n) {
                case 0: {
                    return null;
                }
                case 1: {
                    return "";
                }
            }
            if (this.chars.length < --n) {
                this.chars = new char[n];
            }
            char[] cArray = this.chars;
            int n2 = 0;
            int n3 = 0;
            block9: while (n3 < n) {
                int n4 = this.read();
                switch (n4 >> 4) {
                    case -1: {
                        throw new EOFException();
                    }
                    case 12: 
                    case 13: {
                        cArray[n2++] = (char)((n4 & 0x1F) << 6 | this.read() & 0x3F);
                        n3 += 2;
                        continue block9;
                    }
                    case 14: {
                        cArray[n2++] = (char)((n4 & 0xF) << 12 | (this.read() & 0x3F) << 6 | this.read() & 0x3F);
                        n3 += 3;
                        continue block9;
                    }
                }
                cArray[n2++] = (char)n4;
                ++n3;
            }
            return new String(cArray, 0, n2);
        }
    }

    static class LinkedMesh {
        String parent;
        int skinIndex;
        int slotIndex;
        MeshAttachment mesh;
        boolean inheritTimelines;

        public LinkedMesh(MeshAttachment meshAttachment, int n, int n2, String string, boolean bl) {
            this.mesh = meshAttachment;
            this.skinIndex = n;
            this.slotIndex = n2;
            this.parent = string;
            this.inheritTimelines = bl;
        }
    }

    static class Vertices {
        int length;
        int[] bones;
        float[] vertices;

        Vertices() {
        }
    }
}

