/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.HasTextureRegion;

public class Sequence {
    private static int nextID;
    private final int id = Sequence.nextID();
    private final TextureRegion[] regions;
    private int start;
    private int digits;
    private int setupIndex;

    public Sequence(int n) {
        this.regions = new TextureRegion[n];
    }

    public void apply(Slot slot, HasTextureRegion hasTextureRegion) {
        int n = slot.getSequenceIndex();
        if (n == -1) {
            n = this.setupIndex;
        }
        if (n >= this.regions.length) {
            n = this.regions.length - 1;
        }
        TextureRegion textureRegion = this.regions[n];
        if (hasTextureRegion.getRegion() != textureRegion) {
            hasTextureRegion.setRegion(textureRegion);
            hasTextureRegion.updateRegion();
        }
    }

    public String getPath(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + this.digits);
        stringBuilder.append(string);
        String string2 = Integer.toString(this.start + n);
        for (int i = this.digits - string2.length(); i > 0; --i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public void setStart(int n) {
        this.start = n;
    }

    public void setDigits(int n) {
        this.digits = n;
    }

    public void setSetupIndex(int n) {
        this.setupIndex = n;
    }

    public TextureRegion[] getRegions() {
        return this.regions;
    }

    public int getId() {
        return this.id;
    }

    private static synchronized int nextID() {
        return nextID++;
    }

    public static enum SequenceMode {
        hold,
        once,
        loop,
        pingpong,
        onceReverse,
        loopReverse,
        pingpongReverse;

        public static final SequenceMode[] values;

        static {
            values = SequenceMode.values();
        }
    }
}

