/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.AddAction;
import com.badlogic.gdx.scenes.scene2d.actions.AddListenerAction;
import com.badlogic.gdx.scenes.scene2d.actions.AfterAction;
import com.badlogic.gdx.scenes.scene2d.actions.AlphaAction;
import com.badlogic.gdx.scenes.scene2d.actions.ColorAction;
import com.badlogic.gdx.scenes.scene2d.actions.DelayAction;
import com.badlogic.gdx.scenes.scene2d.actions.FloatAction;
import com.badlogic.gdx.scenes.scene2d.actions.IntAction;
import com.badlogic.gdx.scenes.scene2d.actions.LayoutAction;
import com.badlogic.gdx.scenes.scene2d.actions.MoveByAction;
import com.badlogic.gdx.scenes.scene2d.actions.MoveToAction;
import com.badlogic.gdx.scenes.scene2d.actions.ParallelAction;
import com.badlogic.gdx.scenes.scene2d.actions.RemoveAction;
import com.badlogic.gdx.scenes.scene2d.actions.RemoveActorAction;
import com.badlogic.gdx.scenes.scene2d.actions.RemoveListenerAction;
import com.badlogic.gdx.scenes.scene2d.actions.RepeatAction;
import com.badlogic.gdx.scenes.scene2d.actions.RotateByAction;
import com.badlogic.gdx.scenes.scene2d.actions.RotateToAction;
import com.badlogic.gdx.scenes.scene2d.actions.RunnableAction;
import com.badlogic.gdx.scenes.scene2d.actions.ScaleByAction;
import com.badlogic.gdx.scenes.scene2d.actions.ScaleToAction;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.actions.SizeByAction;
import com.badlogic.gdx.scenes.scene2d.actions.SizeToAction;
import com.badlogic.gdx.scenes.scene2d.actions.TimeScaleAction;
import com.badlogic.gdx.scenes.scene2d.actions.TouchableAction;
import com.badlogic.gdx.scenes.scene2d.actions.VisibleAction;
import com.badlogic.gdx.utils.DefaultPool;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.PoolManager;

public class Actions {
    public static final PoolManager ACTION_POOLS = new PoolManager();

    public static <T extends Action> void registerAction(Class<T> poolClass, DefaultPool.PoolSupplier<T> supplier) {
        ACTION_POOLS.addPool(poolClass, supplier);
    }

    public static <T extends Action> T action(Class<T> type) {
        Pool<T> pool = ACTION_POOLS.getPoolOrNull(type);
        if (pool == null) {
            throw new GdxRuntimeException("No action pool registered for type " + type + ". Register it with Actions#registerAction.");
        }
        Action action = (Action)pool.obtain();
        action.setPool(pool);
        return (T)action;
    }

    public static MoveByAction moveBy(float amountX, float amountY, float duration) {
        return Actions.moveBy(amountX, amountY, duration, null);
    }

    public static MoveByAction moveBy(float amountX, float amountY, float duration, Interpolation interpolation) {
        MoveByAction action = Actions.action(MoveByAction.class);
        action.setAmount(amountX, amountY);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static ScaleToAction scaleTo(float x, float y, float duration, Interpolation interpolation) {
        ScaleToAction action = Actions.action(ScaleToAction.class);
        action.setScale(x, y);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static AlphaAction alpha(float a, float duration, Interpolation interpolation) {
        AlphaAction action = Actions.action(AlphaAction.class);
        action.setAlpha(a);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static AlphaAction fadeOut(float duration) {
        return Actions.alpha(0.0f, duration, null);
    }

    public static AlphaAction fadeOut(float duration, Interpolation interpolation) {
        AlphaAction action = Actions.action(AlphaAction.class);
        action.setAlpha(0.0f);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static AlphaAction fadeIn(float duration) {
        return Actions.alpha(1.0f, duration, null);
    }

    public static RemoveActorAction removeActor() {
        return Actions.action(RemoveActorAction.class);
    }

    public static DelayAction delay(float duration) {
        DelayAction action = Actions.action(DelayAction.class);
        action.setDuration(duration);
        return action;
    }

    public static SequenceAction sequence(Action action1, Action action2) {
        SequenceAction action = Actions.action(SequenceAction.class);
        action.addAction(action1);
        action.addAction(action2);
        return action;
    }

    public static SequenceAction sequence(Action action1, Action action2, Action action3, Action action4) {
        SequenceAction action = Actions.action(SequenceAction.class);
        action.addAction(action1);
        action.addAction(action2);
        action.addAction(action3);
        action.addAction(action4);
        return action;
    }

    public static ParallelAction parallel(Action action1, Action action2) {
        ParallelAction action = Actions.action(ParallelAction.class);
        action.addAction(action1);
        action.addAction(action2);
        return action;
    }

    static {
        Actions.registerAction(AddAction.class, AddAction::new);
        Actions.registerAction(AddListenerAction.class, AddListenerAction::new);
        Actions.registerAction(AfterAction.class, AfterAction::new);
        Actions.registerAction(AlphaAction.class, AlphaAction::new);
        Actions.registerAction(ColorAction.class, ColorAction::new);
        Actions.registerAction(DelayAction.class, DelayAction::new);
        Actions.registerAction(FloatAction.class, FloatAction::new);
        Actions.registerAction(IntAction.class, IntAction::new);
        Actions.registerAction(LayoutAction.class, LayoutAction::new);
        Actions.registerAction(MoveByAction.class, MoveByAction::new);
        Actions.registerAction(MoveToAction.class, MoveToAction::new);
        Actions.registerAction(ParallelAction.class, ParallelAction::new);
        Actions.registerAction(RemoveAction.class, RemoveAction::new);
        Actions.registerAction(RemoveActorAction.class, RemoveActorAction::new);
        Actions.registerAction(RemoveListenerAction.class, RemoveListenerAction::new);
        Actions.registerAction(RepeatAction.class, RepeatAction::new);
        Actions.registerAction(RotateByAction.class, RotateByAction::new);
        Actions.registerAction(RotateToAction.class, RotateToAction::new);
        Actions.registerAction(RunnableAction.class, RunnableAction::new);
        Actions.registerAction(ScaleByAction.class, ScaleByAction::new);
        Actions.registerAction(ScaleToAction.class, ScaleToAction::new);
        Actions.registerAction(SequenceAction.class, SequenceAction::new);
        Actions.registerAction(SizeByAction.class, SizeByAction::new);
        Actions.registerAction(SizeToAction.class, SizeToAction::new);
        Actions.registerAction(TimeScaleAction.class, TimeScaleAction::new);
        Actions.registerAction(TouchableAction.class, TouchableAction::new);
        Actions.registerAction(VisibleAction.class, VisibleAction::new);
    }
}

