/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.ArraySupplier;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Queue<T>
implements Iterable<T> {
    protected T[] values;
    protected int head = 0;
    protected int tail = 0;
    public int size = 0;

    public Queue() {
        this(16);
    }

    public Queue(int initialSize) {
        this(initialSize, ArraySupplier.object());
    }

    public Queue(int initialSize, ArraySupplier<T[]> arraySupplier) {
        this.values = arraySupplier.get(initialSize);
    }

    public void addLast(T object) {
        T[] values = this.values;
        if (this.size == values.length) {
            this.resize(values.length << 1);
            values = this.values;
        }
        values[this.tail++] = object;
        if (this.tail == values.length) {
            this.tail = 0;
        }
        ++this.size;
    }

    protected void resize(int newSize) {
        T[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        T[] newArray = Arrays.copyOf(values, newSize);
        if (head < tail) {
            System.arraycopy(values, head, newArray, 0, tail - head);
        } else if (this.size > 0) {
            int rest = values.length - head;
            System.arraycopy(values, head, newArray, 0, rest);
            System.arraycopy(values, 0, newArray, rest, tail);
        }
        this.values = newArray;
        this.head = 0;
        this.tail = this.size;
    }

    public T removeIndex(int index) {
        T value;
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        T[] values = this.values;
        int head = this.head++;
        int tail = this.tail--;
        index += head;
        if (head < tail) {
            value = values[index];
            System.arraycopy(values, index + 1, values, index, tail - index);
            values[tail] = null;
        } else if (index >= values.length) {
            value = values[index -= values.length];
            System.arraycopy(values, index + 1, values, index, tail - index);
            --this.tail;
        } else {
            value = values[index];
            System.arraycopy(values, head, values, head + 1, index - head);
            values[head] = null;
            if (this.head == values.length) {
                this.head = 0;
            }
        }
        --this.size;
        return value;
    }

    public T get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int i = this.head + index;
        T[] values = this.values;
        if (i >= values.length) {
            i -= values.length;
        }
        return values[i];
    }

    @Override
    public Iterator<T> iterator() {
        return new QueueIterator(this, true);
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        T[] values = this.values;
        int head = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        sb.append(values[head]);
        int i = (head + 1) % values.length;
        while (i != tail) {
            sb.append(", ").append(values[i]);
            i = (i + 1) % values.length;
        }
        sb.append(']');
        return sb.toString();
    }

    public int hashCode() {
        int size = this.size;
        T[] values = this.values;
        int backingLength = values.length;
        int index = this.head;
        int hash = size + 1;
        for (int s = 0; s < size; ++s) {
            T value = values[index];
            hash *= 31;
            if (value != null) {
                hash += value.hashCode();
            }
            if (++index != backingLength) continue;
            index = 0;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Queue)) {
            return false;
        }
        Queue q = (Queue)o;
        int size = this.size;
        if (q.size != size) {
            return false;
        }
        T[] myValues = this.values;
        int myBackingLength = myValues.length;
        T[] itsValues = q.values;
        int itsBackingLength = itsValues.length;
        int myIndex = this.head;
        int itsIndex = q.head;
        for (int s = 0; s < size; ++s) {
            T myValue = myValues[myIndex];
            T itsValue = itsValues[itsIndex];
            if (!(myValue != null ? myValue.equals(itsValue) : itsValue == null)) {
                return false;
            }
            ++itsIndex;
            if (++myIndex == myBackingLength) {
                myIndex = 0;
            }
            if (itsIndex != itsBackingLength) continue;
            itsIndex = 0;
        }
        return true;
    }

    public static class QueueIterator<T>
    implements Iterable<T>,
    Iterator<T> {
        private final Queue<T> queue;
        private final boolean allowRemove;
        int index;
        boolean valid = true;

        public QueueIterator(Queue<T> queue, boolean allowRemove) {
            this.queue = queue;
            this.allowRemove = allowRemove;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.queue.size;
        }

        @Override
        public T next() {
            if (this.index >= this.queue.size) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.queue.get(this.index++);
        }

        @Override
        public void remove() {
            if (!this.allowRemove) {
                throw new GdxRuntimeException("Remove not allowed.");
            }
            --this.index;
            this.queue.removeIndex(this.index);
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

