/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.IntSet;
import com.badlogic.gdx.utils.ObjectSet;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.BoneLocal;
import com.esotericsoftware.spine.Constraint;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.IkConstraint;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.IkConstraintPose;
import com.esotericsoftware.spine.PathConstraint;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.PathConstraintPose;
import com.esotericsoftware.spine.PhysicsConstraint;
import com.esotericsoftware.spine.PhysicsConstraintData;
import com.esotericsoftware.spine.PhysicsConstraintPose;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slider;
import com.esotericsoftware.spine.SliderData;
import com.esotericsoftware.spine.SliderPose;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.SlotPose;
import com.esotericsoftware.spine.TransformConstraint;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.TransformConstraintPose;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.HasTextureRegion;
import com.esotericsoftware.spine.attachments.Sequence;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class Animation {
    final String name;
    float duration;
    Array<Timeline> timelines;
    final ObjectSet<String> timelineIds;
    final IntArray bones;

    public Animation(String string, Array<Timeline> array, float f) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        this.name = string;
        this.duration = f;
        int n = array.size << 1;
        this.timelineIds = new ObjectSet(n);
        this.bones = new IntArray(n);
        this.setTimelines(array);
    }

    public void setTimelines(Array<Timeline> array) {
        if (array == null) {
            throw new IllegalArgumentException("timelines cannot be null.");
        }
        this.timelines = array;
        int n = array.size;
        this.timelineIds.clear(n << 1);
        this.bones.clear();
        IntSet intSet = new IntSet();
        Timeline[] timelineArray = (Timeline[])array.items;
        for (int i = 0; i < n; ++i) {
            BoneTimeline boneTimeline;
            Timeline timeline = timelineArray[i];
            this.timelineIds.addAll((String[])timeline.getPropertyIds());
            if (!(timeline instanceof BoneTimeline) || !intSet.add((boneTimeline = (BoneTimeline)((Object)timeline)).getBoneIndex())) continue;
            this.bones.add(boneTimeline.getBoneIndex());
        }
        this.bones.shrink();
    }

    public boolean hasTimeline(String[] stringArray) {
        for (String string : stringArray) {
            if (!this.timelineIds.contains(string)) continue;
            return true;
        }
        return false;
    }

    public float getDuration() {
        return this.duration;
    }

    public void apply(Skeleton skeleton, float f, float f2, boolean bl, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl2) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        if (bl && this.duration != 0.0f) {
            f2 %= this.duration;
            if (f > 0.0f) {
                f %= this.duration;
            }
        }
        Timeline[] timelineArray = (Timeline[])this.timelines.items;
        int n = this.timelines.size;
        for (int i = 0; i < n; ++i) {
            timelineArray[i].apply(skeleton, f, f2, array, f3, mixBlend, mixDirection, bl2);
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static abstract class Timeline {
        private final String[] propertyIds;
        final float[] frames;

        public Timeline(int n, String ... stringArray) {
            if (stringArray == null) {
                throw new IllegalArgumentException("propertyIds cannot be null.");
            }
            this.propertyIds = stringArray;
            this.frames = new float[n * this.getFrameEntries()];
        }

        public String[] getPropertyIds() {
            return this.propertyIds;
        }

        public int getFrameEntries() {
            return 1;
        }

        public int getFrameCount() {
            return this.frames.length / this.getFrameEntries();
        }

        public float getDuration() {
            return this.frames[this.frames.length - this.getFrameEntries()];
        }

        public abstract void apply(Skeleton var1, float var2, float var3, Array<Event> var4, float var5, MixBlend var6, MixDirection var7, boolean var8);

        static int search(float[] fArray, float f) {
            int n = fArray.length;
            for (int i = 1; i < n; ++i) {
                if (!(fArray[i] > f)) continue;
                return i - 1;
            }
            return n - 1;
        }

        static int search(float[] fArray, float f, int n) {
            int n2 = fArray.length;
            for (int i = n; i < n2; i += n) {
                if (!(fArray[i] > f)) continue;
                return i - n;
            }
            return n2 - n;
        }
    }

    public static interface BoneTimeline {
        public int getBoneIndex();
    }

    public static enum MixBlend {
        setup,
        first,
        replace,
        add;

    }

    public static enum MixDirection {
        in,
        out;

    }

    public static class SliderMixTimeline
    extends ConstraintTimeline1 {
        public SliderMixTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.sliderMix);
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            Slider slider = (Slider)((Constraint[])skeleton.constraints.items)[this.constraintIndex];
            if (slider.active) {
                SliderPose sliderPose = bl ? (SliderPose)slider.applied : (SliderPose)slider.pose;
                sliderPose.mix = this.getAbsoluteValue(f2, f3, mixBlend, sliderPose.mix, ((SliderPose)((SliderData)slider.data).setup).mix);
            }
        }
    }

    public static class SliderTimeline
    extends ConstraintTimeline1 {
        public SliderTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.sliderTime);
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            Slider slider = (Slider)((Constraint[])skeleton.constraints.items)[this.constraintIndex];
            if (slider.active) {
                SliderPose sliderPose = bl ? (SliderPose)slider.applied : (SliderPose)slider.pose;
                sliderPose.time = this.getAbsoluteValue(f2, f3, mixBlend, sliderPose.time, ((SliderPose)((SliderData)slider.data).setup).time);
            }
        }
    }

    public static class PhysicsConstraintResetTimeline
    extends Timeline
    implements ConstraintTimeline {
        private static final String[] propertyIds = new String[]{Integer.toString(Property.physicsConstraintReset.ordinal())};
        final int constraintIndex;

        public PhysicsConstraintResetTimeline(int n, int n2) {
            super(n, propertyIds);
            this.constraintIndex = n2;
        }

        @Override
        public int getConstraintIndex() {
            return this.constraintIndex;
        }

        @Override
        public int getFrameCount() {
            return this.frames.length;
        }

        public void setFrame(int n, float f) {
            this.frames[n] = f;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            PhysicsConstraint physicsConstraint = null;
            if (this.constraintIndex != -1) {
                physicsConstraint = (PhysicsConstraint)((Constraint[])skeleton.constraints.items)[this.constraintIndex];
                if (!physicsConstraint.active) {
                    return;
                }
            }
            float[] fArray = this.frames;
            if (f > f2) {
                this.apply(skeleton, f, 2.1474836E9f, null, f3, mixBlend, mixDirection, bl);
                f = -1.0f;
            } else if (f >= fArray[fArray.length - 1]) {
                return;
            }
            if (f2 < fArray[0]) {
                return;
            }
            if (f < fArray[0] || f2 >= fArray[PhysicsConstraintResetTimeline.search(fArray, f) + 1]) {
                if (physicsConstraint != null) {
                    physicsConstraint.reset(skeleton);
                } else {
                    PhysicsConstraint[] physicsConstraintArray = (PhysicsConstraint[])skeleton.physics.items;
                    int n = skeleton.physics.size;
                    for (int i = 0; i < n; ++i) {
                        physicsConstraint = physicsConstraintArray[i];
                        if (!physicsConstraint.active) continue;
                        physicsConstraint.reset(skeleton);
                    }
                }
            }
        }
    }

    public static class PhysicsConstraintMixTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintMixTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.physicsConstraintMix);
        }

        @Override
        protected float get(PhysicsConstraintPose physicsConstraintPose) {
            return physicsConstraintPose.mix;
        }

        @Override
        protected void set(PhysicsConstraintPose physicsConstraintPose, float f) {
            physicsConstraintPose.mix = f;
        }

        @Override
        protected boolean global(PhysicsConstraintData physicsConstraintData) {
            return physicsConstraintData.mixGlobal;
        }
    }

    public static class PhysicsConstraintGravityTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintGravityTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.physicsConstraintGravity);
        }

        @Override
        protected float get(PhysicsConstraintPose physicsConstraintPose) {
            return physicsConstraintPose.gravity;
        }

        @Override
        protected void set(PhysicsConstraintPose physicsConstraintPose, float f) {
            physicsConstraintPose.gravity = f;
        }

        @Override
        protected boolean global(PhysicsConstraintData physicsConstraintData) {
            return physicsConstraintData.gravityGlobal;
        }
    }

    public static class PhysicsConstraintWindTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintWindTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.physicsConstraintWind);
        }

        @Override
        protected float get(PhysicsConstraintPose physicsConstraintPose) {
            return physicsConstraintPose.wind;
        }

        @Override
        protected void set(PhysicsConstraintPose physicsConstraintPose, float f) {
            physicsConstraintPose.wind = f;
        }

        @Override
        protected boolean global(PhysicsConstraintData physicsConstraintData) {
            return physicsConstraintData.windGlobal;
        }
    }

    public static class PhysicsConstraintMassTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintMassTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.physicsConstraintMass);
        }

        @Override
        protected float get(PhysicsConstraintPose physicsConstraintPose) {
            return 1.0f / physicsConstraintPose.massInverse;
        }

        @Override
        protected void set(PhysicsConstraintPose physicsConstraintPose, float f) {
            physicsConstraintPose.massInverse = 1.0f / f;
        }

        @Override
        protected boolean global(PhysicsConstraintData physicsConstraintData) {
            return physicsConstraintData.massGlobal;
        }
    }

    public static class PhysicsConstraintDampingTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintDampingTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.physicsConstraintDamping);
        }

        @Override
        protected float get(PhysicsConstraintPose physicsConstraintPose) {
            return physicsConstraintPose.damping;
        }

        @Override
        protected void set(PhysicsConstraintPose physicsConstraintPose, float f) {
            physicsConstraintPose.damping = f;
        }

        @Override
        protected boolean global(PhysicsConstraintData physicsConstraintData) {
            return physicsConstraintData.dampingGlobal;
        }
    }

    public static class PhysicsConstraintStrengthTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintStrengthTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.physicsConstraintStrength);
        }

        @Override
        protected float get(PhysicsConstraintPose physicsConstraintPose) {
            return physicsConstraintPose.strength;
        }

        @Override
        protected void set(PhysicsConstraintPose physicsConstraintPose, float f) {
            physicsConstraintPose.strength = f;
        }

        @Override
        protected boolean global(PhysicsConstraintData physicsConstraintData) {
            return physicsConstraintData.strengthGlobal;
        }
    }

    public static class PhysicsConstraintInertiaTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintInertiaTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.physicsConstraintInertia);
        }

        @Override
        protected float get(PhysicsConstraintPose physicsConstraintPose) {
            return physicsConstraintPose.inertia;
        }

        @Override
        protected void set(PhysicsConstraintPose physicsConstraintPose, float f) {
            physicsConstraintPose.inertia = f;
        }

        @Override
        protected boolean global(PhysicsConstraintData physicsConstraintData) {
            return physicsConstraintData.inertiaGlobal;
        }
    }

    public static abstract class PhysicsConstraintTimeline
    extends ConstraintTimeline1 {
        public PhysicsConstraintTimeline(int n, int n2, int n3, Property property) {
            super(n, n2, n3, property);
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            if (this.constraintIndex == -1) {
                float f4 = f2 >= this.frames[0] ? this.getCurveValue(f2) : 0.0f;
                PhysicsConstraint[] physicsConstraintArray = (PhysicsConstraint[])skeleton.physics.items;
                int n = skeleton.physics.size;
                for (int i = 0; i < n; ++i) {
                    PhysicsConstraint physicsConstraint = physicsConstraintArray[i];
                    if (!physicsConstraint.active || !this.global((PhysicsConstraintData)physicsConstraint.data)) continue;
                    PhysicsConstraintPose physicsConstraintPose = bl ? (PhysicsConstraintPose)physicsConstraint.applied : (PhysicsConstraintPose)physicsConstraint.pose;
                    this.set(physicsConstraintPose, this.getAbsoluteValue(f2, f3, mixBlend, this.get(physicsConstraintPose), this.get((PhysicsConstraintPose)((PhysicsConstraintData)physicsConstraint.data).setup), f4));
                }
            } else {
                PhysicsConstraint physicsConstraint = (PhysicsConstraint)((Constraint[])skeleton.constraints.items)[this.constraintIndex];
                if (physicsConstraint.active) {
                    PhysicsConstraintPose physicsConstraintPose = bl ? (PhysicsConstraintPose)physicsConstraint.applied : (PhysicsConstraintPose)physicsConstraint.pose;
                    this.set(physicsConstraintPose, this.getAbsoluteValue(f2, f3, mixBlend, this.get(physicsConstraintPose), this.get((PhysicsConstraintPose)((PhysicsConstraintData)physicsConstraint.data).setup)));
                }
            }
        }

        protected abstract float get(PhysicsConstraintPose var1);

        protected abstract void set(PhysicsConstraintPose var1, float var2);

        protected abstract boolean global(PhysicsConstraintData var1);
    }

    public static class PathConstraintMixTimeline
    extends CurveTimeline
    implements ConstraintTimeline {
        final int constraintIndex;

        public PathConstraintMixTimeline(int n, int n2, int n3) {
            super(n, n2, Property.pathConstraintMix.ordinal() + "|" + n3);
            this.constraintIndex = n3;
        }

        @Override
        public int getFrameEntries() {
            return 4;
        }

        @Override
        public int getConstraintIndex() {
            return this.constraintIndex;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4) {
            this.frames[n <<= 2] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            float f4;
            float f5;
            float f6;
            PathConstraint pathConstraint = (PathConstraint)((Constraint[])skeleton.constraints.items)[this.constraintIndex];
            if (!pathConstraint.active) {
                return;
            }
            PathConstraintPose pathConstraintPose = bl ? (PathConstraintPose)pathConstraint.applied : (PathConstraintPose)pathConstraint.pose;
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                PathConstraintPose pathConstraintPose2 = (PathConstraintPose)((PathConstraintData)pathConstraint.data).setup;
                switch (mixBlend) {
                    case setup: {
                        pathConstraintPose.mixRotate = pathConstraintPose2.mixRotate;
                        pathConstraintPose.mixX = pathConstraintPose2.mixX;
                        pathConstraintPose.mixY = pathConstraintPose2.mixY;
                        break;
                    }
                    case first: {
                        pathConstraintPose.mixRotate += (pathConstraintPose2.mixRotate - pathConstraintPose.mixRotate) * f3;
                        pathConstraintPose.mixX += (pathConstraintPose2.mixX - pathConstraintPose.mixX) * f3;
                        pathConstraintPose.mixY += (pathConstraintPose2.mixY - pathConstraintPose.mixY) * f3;
                    }
                }
                return;
            }
            int n = PathConstraintMixTimeline.search(fArray, f2, 4);
            int n2 = (int)this.curves[n >> 2];
            switch (n2) {
                case 0: {
                    float f7 = fArray[n];
                    f6 = fArray[n + 1];
                    f5 = fArray[n + 2];
                    f4 = fArray[n + 3];
                    float f8 = (f2 - f7) / (fArray[n + 4] - f7);
                    f6 += (fArray[n + 4 + 1] - f6) * f8;
                    f5 += (fArray[n + 4 + 2] - f5) * f8;
                    f4 += (fArray[n + 4 + 3] - f4) * f8;
                    break;
                }
                case 1: {
                    f6 = fArray[n + 1];
                    f5 = fArray[n + 2];
                    f4 = fArray[n + 3];
                    break;
                }
                default: {
                    f6 = this.getBezierValue(f2, n, 1, n2 - 2);
                    f5 = this.getBezierValue(f2, n, 2, n2 + 18 - 2);
                    f4 = this.getBezierValue(f2, n, 3, n2 + 36 - 2);
                }
            }
            switch (mixBlend) {
                case setup: {
                    PathConstraintPose pathConstraintPose3 = (PathConstraintPose)((PathConstraintData)pathConstraint.data).setup;
                    pathConstraintPose.mixRotate = pathConstraintPose3.mixRotate + (f6 - pathConstraintPose3.mixRotate) * f3;
                    pathConstraintPose.mixX = pathConstraintPose3.mixX + (f5 - pathConstraintPose3.mixX) * f3;
                    pathConstraintPose.mixY = pathConstraintPose3.mixY + (f4 - pathConstraintPose3.mixY) * f3;
                    break;
                }
                case first: 
                case replace: {
                    pathConstraintPose.mixRotate += (f6 - pathConstraintPose.mixRotate) * f3;
                    pathConstraintPose.mixX += (f5 - pathConstraintPose.mixX) * f3;
                    pathConstraintPose.mixY += (f4 - pathConstraintPose.mixY) * f3;
                    break;
                }
                case add: {
                    pathConstraintPose.mixRotate += f6 * f3;
                    pathConstraintPose.mixX += f5 * f3;
                    pathConstraintPose.mixY += f4 * f3;
                }
            }
        }
    }

    public static class PathConstraintSpacingTimeline
    extends ConstraintTimeline1 {
        public PathConstraintSpacingTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.pathConstraintSpacing);
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            PathConstraint pathConstraint = (PathConstraint)((Constraint[])skeleton.constraints.items)[this.constraintIndex];
            if (pathConstraint.active) {
                PathConstraintPose pathConstraintPose = bl ? (PathConstraintPose)pathConstraint.applied : (PathConstraintPose)pathConstraint.pose;
                pathConstraintPose.spacing = this.getAbsoluteValue(f2, f3, mixBlend, pathConstraintPose.spacing, ((PathConstraintPose)((PathConstraintData)pathConstraint.data).setup).spacing);
            }
        }
    }

    public static class PathConstraintPositionTimeline
    extends ConstraintTimeline1 {
        public PathConstraintPositionTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.pathConstraintPosition);
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            PathConstraint pathConstraint = (PathConstraint)((Constraint[])skeleton.constraints.items)[this.constraintIndex];
            if (pathConstraint.active) {
                PathConstraintPose pathConstraintPose = bl ? (PathConstraintPose)pathConstraint.applied : (PathConstraintPose)pathConstraint.pose;
                pathConstraintPose.position = this.getAbsoluteValue(f2, f3, mixBlend, pathConstraintPose.position, ((PathConstraintPose)((PathConstraintData)pathConstraint.data).setup).position);
            }
        }
    }

    public static abstract class ConstraintTimeline1
    extends CurveTimeline1
    implements ConstraintTimeline {
        final int constraintIndex;

        public ConstraintTimeline1(int n, int n2, int n3, Property property) {
            super(n, n2, property.ordinal() + "|" + n3);
            this.constraintIndex = n3;
        }

        @Override
        public int getConstraintIndex() {
            return this.constraintIndex;
        }
    }

    public static class TransformConstraintTimeline
    extends CurveTimeline
    implements ConstraintTimeline {
        final int constraintIndex;

        public TransformConstraintTimeline(int n, int n2, int n3) {
            super(n, n2, Property.transformConstraint.ordinal() + "|" + n3);
            this.constraintIndex = n3;
        }

        @Override
        public int getFrameEntries() {
            return 7;
        }

        @Override
        public int getConstraintIndex() {
            return this.constraintIndex;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
            this.frames[n *= 7] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
            this.frames[n + 4] = f5;
            this.frames[n + 5] = f6;
            this.frames[n + 6] = f7;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            float f9;
            TransformConstraint transformConstraint = (TransformConstraint)((Constraint[])skeleton.constraints.items)[this.constraintIndex];
            if (!transformConstraint.active) {
                return;
            }
            TransformConstraintPose transformConstraintPose = bl ? (TransformConstraintPose)transformConstraint.applied : (TransformConstraintPose)transformConstraint.pose;
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                TransformConstraintPose transformConstraintPose2 = (TransformConstraintPose)((TransformConstraintData)transformConstraint.data).setup;
                switch (mixBlend) {
                    case setup: {
                        transformConstraintPose.mixRotate = transformConstraintPose2.mixRotate;
                        transformConstraintPose.mixX = transformConstraintPose2.mixX;
                        transformConstraintPose.mixY = transformConstraintPose2.mixY;
                        transformConstraintPose.mixScaleX = transformConstraintPose2.mixScaleX;
                        transformConstraintPose.mixScaleY = transformConstraintPose2.mixScaleY;
                        transformConstraintPose.mixShearY = transformConstraintPose2.mixShearY;
                        break;
                    }
                    case first: {
                        transformConstraintPose.mixRotate += (transformConstraintPose2.mixRotate - transformConstraintPose.mixRotate) * f3;
                        transformConstraintPose.mixX += (transformConstraintPose2.mixX - transformConstraintPose.mixX) * f3;
                        transformConstraintPose.mixY += (transformConstraintPose2.mixY - transformConstraintPose.mixY) * f3;
                        transformConstraintPose.mixScaleX += (transformConstraintPose2.mixScaleX - transformConstraintPose.mixScaleX) * f3;
                        transformConstraintPose.mixScaleY += (transformConstraintPose2.mixScaleY - transformConstraintPose.mixScaleY) * f3;
                        transformConstraintPose.mixShearY += (transformConstraintPose2.mixShearY - transformConstraintPose.mixShearY) * f3;
                    }
                }
                return;
            }
            int n = TransformConstraintTimeline.search(fArray, f2, 7);
            int n2 = (int)this.curves[n / 7];
            switch (n2) {
                case 0: {
                    float f10 = fArray[n];
                    f9 = fArray[n + 1];
                    f8 = fArray[n + 2];
                    f7 = fArray[n + 3];
                    f6 = fArray[n + 4];
                    f5 = fArray[n + 5];
                    f4 = fArray[n + 6];
                    float f11 = (f2 - f10) / (fArray[n + 7] - f10);
                    f9 += (fArray[n + 7 + 1] - f9) * f11;
                    f8 += (fArray[n + 7 + 2] - f8) * f11;
                    f7 += (fArray[n + 7 + 3] - f7) * f11;
                    f6 += (fArray[n + 7 + 4] - f6) * f11;
                    f5 += (fArray[n + 7 + 5] - f5) * f11;
                    f4 += (fArray[n + 7 + 6] - f4) * f11;
                    break;
                }
                case 1: {
                    f9 = fArray[n + 1];
                    f8 = fArray[n + 2];
                    f7 = fArray[n + 3];
                    f6 = fArray[n + 4];
                    f5 = fArray[n + 5];
                    f4 = fArray[n + 6];
                    break;
                }
                default: {
                    f9 = this.getBezierValue(f2, n, 1, n2 - 2);
                    f8 = this.getBezierValue(f2, n, 2, n2 + 18 - 2);
                    f7 = this.getBezierValue(f2, n, 3, n2 + 36 - 2);
                    f6 = this.getBezierValue(f2, n, 4, n2 + 54 - 2);
                    f5 = this.getBezierValue(f2, n, 5, n2 + 72 - 2);
                    f4 = this.getBezierValue(f2, n, 6, n2 + 90 - 2);
                }
            }
            switch (mixBlend) {
                case setup: {
                    TransformConstraintPose transformConstraintPose3 = (TransformConstraintPose)((TransformConstraintData)transformConstraint.data).setup;
                    transformConstraintPose.mixRotate = transformConstraintPose3.mixRotate + (f9 - transformConstraintPose3.mixRotate) * f3;
                    transformConstraintPose.mixX = transformConstraintPose3.mixX + (f8 - transformConstraintPose3.mixX) * f3;
                    transformConstraintPose.mixY = transformConstraintPose3.mixY + (f7 - transformConstraintPose3.mixY) * f3;
                    transformConstraintPose.mixScaleX = transformConstraintPose3.mixScaleX + (f6 - transformConstraintPose3.mixScaleX) * f3;
                    transformConstraintPose.mixScaleY = transformConstraintPose3.mixScaleY + (f5 - transformConstraintPose3.mixScaleY) * f3;
                    transformConstraintPose.mixShearY = transformConstraintPose3.mixShearY + (f4 - transformConstraintPose3.mixShearY) * f3;
                    break;
                }
                case first: 
                case replace: {
                    transformConstraintPose.mixRotate += (f9 - transformConstraintPose.mixRotate) * f3;
                    transformConstraintPose.mixX += (f8 - transformConstraintPose.mixX) * f3;
                    transformConstraintPose.mixY += (f7 - transformConstraintPose.mixY) * f3;
                    transformConstraintPose.mixScaleX += (f6 - transformConstraintPose.mixScaleX) * f3;
                    transformConstraintPose.mixScaleY += (f5 - transformConstraintPose.mixScaleY) * f3;
                    transformConstraintPose.mixShearY += (f4 - transformConstraintPose.mixShearY) * f3;
                    break;
                }
                case add: {
                    transformConstraintPose.mixRotate += f9 * f3;
                    transformConstraintPose.mixX += f8 * f3;
                    transformConstraintPose.mixY += f7 * f3;
                    transformConstraintPose.mixScaleX += f6 * f3;
                    transformConstraintPose.mixScaleY += f5 * f3;
                    transformConstraintPose.mixShearY += f4 * f3;
                }
            }
        }
    }

    public static class IkConstraintTimeline
    extends CurveTimeline
    implements ConstraintTimeline {
        final int constraintIndex;

        public IkConstraintTimeline(int n, int n2, int n3) {
            super(n, n2, Property.ikConstraint.ordinal() + "|" + n3);
            this.constraintIndex = n3;
        }

        @Override
        public int getFrameEntries() {
            return 6;
        }

        @Override
        public int getConstraintIndex() {
            return this.constraintIndex;
        }

        public void setFrame(int n, float f, float f2, float f3, int n2, boolean bl, boolean bl2) {
            this.frames[n *= 6] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = n2;
            this.frames[n + 4] = bl ? 1.0f : 0.0f;
            this.frames[n + 5] = bl2 ? 1.0f : 0.0f;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            float f4;
            float f5;
            IkConstraint ikConstraint = (IkConstraint)((Constraint[])skeleton.constraints.items)[this.constraintIndex];
            if (!ikConstraint.active) {
                return;
            }
            IkConstraintPose ikConstraintPose = bl ? (IkConstraintPose)ikConstraint.applied : (IkConstraintPose)ikConstraint.pose;
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                IkConstraintPose ikConstraintPose2 = (IkConstraintPose)((IkConstraintData)ikConstraint.data).setup;
                switch (mixBlend) {
                    case setup: {
                        ikConstraintPose.mix = ikConstraintPose2.mix;
                        ikConstraintPose.softness = ikConstraintPose2.softness;
                        ikConstraintPose.bendDirection = ikConstraintPose2.bendDirection;
                        ikConstraintPose.compress = ikConstraintPose2.compress;
                        ikConstraintPose.stretch = ikConstraintPose2.stretch;
                        break;
                    }
                    case first: {
                        ikConstraintPose.mix += (ikConstraintPose2.mix - ikConstraintPose.mix) * f3;
                        ikConstraintPose.softness += (ikConstraintPose2.softness - ikConstraintPose.softness) * f3;
                        ikConstraintPose.bendDirection = ikConstraintPose2.bendDirection;
                        ikConstraintPose.compress = ikConstraintPose2.compress;
                        ikConstraintPose.stretch = ikConstraintPose2.stretch;
                    }
                }
                return;
            }
            int n = IkConstraintTimeline.search(fArray, f2, 6);
            int n2 = (int)this.curves[n / 6];
            switch (n2) {
                case 0: {
                    float f6 = fArray[n];
                    f5 = fArray[n + 1];
                    f4 = fArray[n + 2];
                    float f7 = (f2 - f6) / (fArray[n + 6] - f6);
                    f5 += (fArray[n + 6 + 1] - f5) * f7;
                    f4 += (fArray[n + 6 + 2] - f4) * f7;
                    break;
                }
                case 1: {
                    f5 = fArray[n + 1];
                    f4 = fArray[n + 2];
                    break;
                }
                default: {
                    f5 = this.getBezierValue(f2, n, 1, n2 - 2);
                    f4 = this.getBezierValue(f2, n, 2, n2 + 18 - 2);
                }
            }
            switch (mixBlend) {
                case setup: {
                    IkConstraintPose ikConstraintPose3 = (IkConstraintPose)((IkConstraintData)ikConstraint.data).setup;
                    ikConstraintPose.mix = ikConstraintPose3.mix + (f5 - ikConstraintPose3.mix) * f3;
                    ikConstraintPose.softness = ikConstraintPose3.softness + (f4 - ikConstraintPose3.softness) * f3;
                    if (mixDirection != MixDirection.out) break;
                    ikConstraintPose.bendDirection = ikConstraintPose3.bendDirection;
                    ikConstraintPose.compress = ikConstraintPose3.compress;
                    ikConstraintPose.stretch = ikConstraintPose3.stretch;
                    return;
                }
                case first: 
                case replace: {
                    ikConstraintPose.mix += (f5 - ikConstraintPose.mix) * f3;
                    ikConstraintPose.softness += (f4 - ikConstraintPose.softness) * f3;
                    if (mixDirection != MixDirection.out) break;
                    return;
                }
                case add: {
                    ikConstraintPose.mix += f5 * f3;
                    ikConstraintPose.softness += f4 * f3;
                    if (mixDirection != MixDirection.out) break;
                    return;
                }
            }
            ikConstraintPose.bendDirection = (int)fArray[n + 3];
            ikConstraintPose.compress = fArray[n + 4] != 0.0f;
            ikConstraintPose.stretch = fArray[n + 5] != 0.0f;
        }
    }

    public static interface ConstraintTimeline {
        public int getConstraintIndex();
    }

    public static class DrawOrderTimeline
    extends Timeline {
        private static final String[] propertyIds = new String[]{Integer.toString(Property.drawOrder.ordinal())};
        private final int[][] drawOrders;

        public DrawOrderTimeline(int n) {
            super(n, propertyIds);
            this.drawOrders = new int[n][];
        }

        @Override
        public int getFrameCount() {
            return this.frames.length;
        }

        public void setFrame(int n, float f, int[] nArray) {
            this.frames[n] = f;
            this.drawOrders[n] = nArray;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            if (mixDirection == MixDirection.out) {
                if (mixBlend == MixBlend.setup) {
                    SpineUtils.arraycopy(skeleton.slots.items, 0, skeleton.drawOrder.items, 0, skeleton.slots.size);
                }
                return;
            }
            if (f2 < this.frames[0]) {
                if (mixBlend == MixBlend.setup || mixBlend == MixBlend.first) {
                    SpineUtils.arraycopy(skeleton.slots.items, 0, skeleton.drawOrder.items, 0, skeleton.slots.size);
                }
                return;
            }
            int[] nArray = this.drawOrders[DrawOrderTimeline.search(this.frames, f2)];
            if (nArray == null) {
                SpineUtils.arraycopy(skeleton.slots.items, 0, skeleton.drawOrder.items, 0, skeleton.slots.size);
            } else {
                Slot[] slotArray = (Slot[])skeleton.slots.items;
                Slot[] slotArray2 = (Slot[])skeleton.drawOrder.items;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    slotArray2[i] = slotArray[nArray[i]];
                }
            }
        }
    }

    public static class EventTimeline
    extends Timeline {
        private static final String[] propertyIds = new String[]{Integer.toString(Property.event.ordinal())};
        private final Event[] events;

        public EventTimeline(int n) {
            super(n, propertyIds);
            this.events = new Event[n];
        }

        @Override
        public int getFrameCount() {
            return this.frames.length;
        }

        public void setFrame(int n, Event event) {
            this.frames[n] = event.time;
            this.events[n] = event;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            int n;
            if (array == null) {
                return;
            }
            float[] fArray = this.frames;
            int n2 = fArray.length;
            if (f > f2) {
                this.apply(skeleton, f, 2.1474836E9f, array, f3, mixBlend, mixDirection, bl);
                f = -1.0f;
            } else if (f >= fArray[n2 - 1]) {
                return;
            }
            if (f2 < fArray[0]) {
                return;
            }
            if (f < fArray[0]) {
                n = 0;
            } else {
                float f4 = fArray[n];
                for (n = EventTimeline.search(fArray, f) + 1; n > 0 && fArray[n - 1] == f4; --n) {
                }
            }
            while (n < n2 && f2 >= fArray[n]) {
                array.add(this.events[n]);
                ++n;
            }
        }
    }

    public static class SequenceTimeline
    extends Timeline
    implements SlotTimeline {
        final int slotIndex;
        final HasTextureRegion attachment;

        public SequenceTimeline(int n, int n2, Attachment attachment) {
            super(n, Property.sequence.ordinal() + "|" + n2 + "|" + ((HasTextureRegion)((Object)attachment)).getSequence().getId());
            this.slotIndex = n2;
            this.attachment = (HasTextureRegion)((Object)attachment);
        }

        @Override
        public int getFrameEntries() {
            return 3;
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        public void setFrame(int n, float f, Sequence.SequenceMode sequenceMode, int n2, float f2) {
            this.frames[n *= 3] = f;
            this.frames[n + 1] = sequenceMode.ordinal() | n2 << 4;
            this.frames[n + 2] = f2;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            Object object;
            Slot slot = ((Slot[])skeleton.slots.items)[this.slotIndex];
            if (!slot.bone.active) {
                return;
            }
            SlotPose slotPose = bl ? (SlotPose)slot.applied : (SlotPose)slot.pose;
            Attachment attachment = slotPose.attachment;
            if (!(attachment == this.attachment || attachment instanceof VertexAttachment && ((VertexAttachment)(object = (VertexAttachment)attachment)).getTimelineAttachment() == this.attachment)) {
                return;
            }
            object = ((HasTextureRegion)((Object)attachment)).getSequence();
            if (object == null) {
                return;
            }
            if (mixDirection == MixDirection.out) {
                if (mixBlend == MixBlend.setup) {
                    slotPose.setSequenceIndex(-1);
                }
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (mixBlend == MixBlend.setup || mixBlend == MixBlend.first) {
                    slotPose.setSequenceIndex(-1);
                }
                return;
            }
            int n = SequenceTimeline.search(fArray, f2, 3);
            float f4 = fArray[n];
            int n2 = (int)fArray[n + 1];
            float f5 = fArray[n + 2];
            int n3 = n2 >> 4;
            int n4 = ((Sequence)object).getRegions().length;
            Sequence.SequenceMode sequenceMode = Sequence.SequenceMode.values[n2 & 0xF];
            if (sequenceMode != Sequence.SequenceMode.hold) {
                n3 = (int)((float)n3 + ((f2 - f4) / f5 + 1.0E-4f));
                switch (sequenceMode) {
                    case once: {
                        n3 = Math.min(n4 - 1, n3);
                        break;
                    }
                    case loop: {
                        n3 %= n4;
                        break;
                    }
                    case pingpong: {
                        int n5 = (n4 << 1) - 2;
                        int n6 = n3 = n5 == 0 ? 0 : n3 % n5;
                        if (n3 < n4) break;
                        n3 = n5 - n3;
                        break;
                    }
                    case onceReverse: {
                        n3 = Math.max(n4 - 1 - n3, 0);
                        break;
                    }
                    case loopReverse: {
                        n3 = n4 - 1 - n3 % n4;
                        break;
                    }
                    case pingpongReverse: {
                        int n7 = (n4 << 1) - 2;
                        int n8 = n3 = n7 == 0 ? 0 : (n3 + n4 - 1) % n7;
                        if (n3 < n4) break;
                        n3 = n7 - n3;
                    }
                }
            }
            slotPose.setSequenceIndex(n3);
        }
    }

    public static class DeformTimeline
    extends SlotCurveTimeline {
        final VertexAttachment attachment;
        private final float[][] vertices;

        public DeformTimeline(int n, int n2, int n3, VertexAttachment vertexAttachment) {
            super(n, n2, n3, Property.deform.ordinal() + "|" + n3 + "|" + vertexAttachment.getId());
            this.attachment = vertexAttachment;
            this.vertices = new float[n][];
        }

        @Override
        public int getFrameCount() {
            return this.frames.length;
        }

        public void setFrame(int n, float f, float[] fArray) {
            this.frames[n] = f;
            this.vertices[n] = fArray;
        }

        @Override
        public void setBezier(int n, int n2, int n3, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            float[] fArray = this.curves;
            int n4 = this.getFrameCount() + n * 18;
            if (n3 == 0) {
                fArray[n2] = 2 + n4;
            }
            float f9 = (f - f3 * 2.0f + f5) * 0.03f;
            float f10 = f6 * 0.03f - f4 * 0.06f;
            float f11 = ((f3 - f5) * 3.0f - f + f7) * 0.006f;
            float f12 = (f4 - f6 + 0.33333334f) * 0.018f;
            float f13 = f9 * 2.0f + f11;
            float f14 = f10 * 2.0f + f12;
            float f15 = (f3 - f) * 0.3f + f9 + f11 * 0.16666667f;
            float f16 = f4 * 0.3f + f10 + f12 * 0.16666667f;
            float f17 = f + f15;
            float f18 = f16;
            int n5 = n4 + 18;
            while (n4 < n5) {
                fArray[n4] = f17;
                fArray[n4 + 1] = f18;
                f17 += (f15 += (f13 += f11));
                f18 += (f16 += (f14 += f12));
                n4 += 2;
            }
        }

        private float getCurvePercent(float f, int n) {
            float[] fArray = this.curves;
            int n2 = (int)fArray[n];
            switch (n2) {
                case 0: {
                    float f2 = this.frames[n];
                    return (f - f2) / (this.frames[n + this.getFrameEntries()] - f2);
                }
                case 1: {
                    return 0.0f;
                }
            }
            n2 -= 2;
            if (fArray[n2] > f) {
                float f3 = this.frames[n];
                return fArray[n2 + 1] * (f - f3) / (fArray[n2] - f3);
            }
            int n3 = n2 + 18;
            n2 += 2;
            while (n2 < n3) {
                if (fArray[n2] >= f) {
                    float f4 = fArray[n2 - 2];
                    float f5 = fArray[n2 - 1];
                    return f5 + (f - f4) / (fArray[n2] - f4) * (fArray[n2 + 1] - f5);
                }
                n2 += 2;
            }
            float f6 = fArray[n3 - 2];
            float f7 = fArray[n3 - 1];
            return f7 + (1.0f - f7) * (f - f6) / (this.frames[n + this.getFrameEntries()] - f6);
        }

        @Override
        protected void apply(Slot slot, SlotPose slotPose, float f, float f2, MixBlend mixBlend) {
            VertexAttachment vertexAttachment;
            Object object = slotPose.attachment;
            if (!(object instanceof VertexAttachment) || (vertexAttachment = (VertexAttachment)object).getTimelineAttachment() != this.attachment) {
                return;
            }
            object = slotPose.deform;
            if (((FloatArray)object).size == 0) {
                mixBlend = MixBlend.setup;
            }
            float[][] fArray = this.vertices;
            int n = fArray[0].length;
            float[] fArray2 = this.frames;
            if (f < fArray2[0]) {
                switch (mixBlend) {
                    case setup: {
                        ((FloatArray)object).clear();
                        break;
                    }
                    case first: {
                        if (f2 == 1.0f) {
                            ((FloatArray)object).clear();
                            return;
                        }
                        float[] fArray3 = ((FloatArray)object).setSize(n);
                        if (vertexAttachment.getBones() == null) {
                            float[] fArray4 = vertexAttachment.getVertices();
                            for (int i = 0; i < n; ++i) {
                                int n2 = i;
                                fArray3[n2] = fArray3[n2] + (fArray4[i] - fArray3[i]) * f2;
                            }
                        } else {
                            f2 = 1.0f - f2;
                            int n3 = 0;
                            while (n3 < n) {
                                int n4 = n3++;
                                fArray3[n4] = fArray3[n4] * f2;
                            }
                        }
                        break;
                    }
                }
                return;
            }
            float[] fArray5 = ((FloatArray)object).setSize(n);
            if (f >= fArray2[fArray2.length - 1]) {
                float[] fArray6 = fArray[fArray2.length - 1];
                if (f2 == 1.0f) {
                    if (mixBlend == MixBlend.add) {
                        if (vertexAttachment.getBones() == null) {
                            float[] fArray7 = vertexAttachment.getVertices();
                            for (int i = 0; i < n; ++i) {
                                int n5 = i;
                                fArray5[n5] = fArray5[n5] + (fArray6[i] - fArray7[i]);
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                int n6 = i;
                                fArray5[n6] = fArray5[n6] + fArray6[i];
                            }
                        }
                    } else {
                        SpineUtils.arraycopy(fArray6, 0, fArray5, 0, n);
                    }
                } else {
                    switch (mixBlend) {
                        case setup: {
                            if (vertexAttachment.getBones() == null) {
                                float[] fArray8 = vertexAttachment.getVertices();
                                for (int i = 0; i < n; ++i) {
                                    float f3 = fArray8[i];
                                    fArray5[i] = f3 + (fArray6[i] - f3) * f2;
                                }
                            } else {
                                for (int i = 0; i < n; ++i) {
                                    fArray5[i] = fArray6[i] * f2;
                                }
                            }
                            break;
                        }
                        case first: 
                        case replace: {
                            for (int i = 0; i < n; ++i) {
                                int n7 = i;
                                fArray5[n7] = fArray5[n7] + (fArray6[i] - fArray5[i]) * f2;
                            }
                            break;
                        }
                        case add: {
                            if (vertexAttachment.getBones() == null) {
                                float[] fArray9 = vertexAttachment.getVertices();
                                for (int i = 0; i < n; ++i) {
                                    int n8 = i;
                                    fArray5[n8] = fArray5[n8] + (fArray6[i] - fArray9[i]) * f2;
                                }
                            } else {
                                for (int i = 0; i < n; ++i) {
                                    int n9 = i;
                                    fArray5[n9] = fArray5[n9] + fArray6[i] * f2;
                                }
                            }
                            break;
                        }
                    }
                }
                return;
            }
            int n10 = DeformTimeline.search(fArray2, f);
            float f4 = this.getCurvePercent(f, n10);
            float[] fArray10 = fArray[n10];
            float[] fArray11 = fArray[n10 + 1];
            if (f2 == 1.0f) {
                if (mixBlend == MixBlend.add) {
                    if (vertexAttachment.getBones() == null) {
                        float[] fArray12 = vertexAttachment.getVertices();
                        for (int i = 0; i < n; ++i) {
                            float f5 = fArray10[i];
                            int n11 = i;
                            fArray5[n11] = fArray5[n11] + (f5 + (fArray11[i] - f5) * f4 - fArray12[i]);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            float f6 = fArray10[i];
                            int n12 = i;
                            fArray5[n12] = fArray5[n12] + (f6 + (fArray11[i] - f6) * f4);
                        }
                    }
                } else if (f4 == 0.0f) {
                    SpineUtils.arraycopy(fArray10, 0, fArray5, 0, n);
                } else {
                    for (int i = 0; i < n; ++i) {
                        float f7 = fArray10[i];
                        fArray5[i] = f7 + (fArray11[i] - f7) * f4;
                    }
                }
            } else {
                switch (mixBlend) {
                    case setup: {
                        if (vertexAttachment.getBones() == null) {
                            float[] fArray13 = vertexAttachment.getVertices();
                            for (int i = 0; i < n; ++i) {
                                float f8 = fArray10[i];
                                float f9 = fArray13[i];
                                fArray5[i] = f9 + (f8 + (fArray11[i] - f8) * f4 - f9) * f2;
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                float f10 = fArray10[i];
                                fArray5[i] = (f10 + (fArray11[i] - f10) * f4) * f2;
                            }
                        }
                        break;
                    }
                    case first: 
                    case replace: {
                        for (int i = 0; i < n; ++i) {
                            float f11 = fArray10[i];
                            int n13 = i;
                            fArray5[n13] = fArray5[n13] + (f11 + (fArray11[i] - f11) * f4 - fArray5[i]) * f2;
                        }
                        break;
                    }
                    case add: {
                        if (vertexAttachment.getBones() == null) {
                            float[] fArray14 = vertexAttachment.getVertices();
                            for (int i = 0; i < n; ++i) {
                                float f12 = fArray10[i];
                                int n14 = i;
                                fArray5[n14] = fArray5[n14] + (f12 + (fArray11[i] - f12) * f4 - fArray14[i]) * f2;
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                float f13 = fArray10[i];
                                int n15 = i;
                                fArray5[n15] = fArray5[n15] + (f13 + (fArray11[i] - f13) * f4) * f2;
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    public static class AttachmentTimeline
    extends Timeline
    implements SlotTimeline {
        final int slotIndex;
        final String[] attachmentNames;

        public AttachmentTimeline(int n, int n2) {
            super(n, Property.attachment.ordinal() + "|" + n2);
            this.slotIndex = n2;
            this.attachmentNames = new String[n];
        }

        @Override
        public int getFrameCount() {
            return this.frames.length;
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        public void setFrame(int n, float f, String string) {
            this.frames[n] = f;
            this.attachmentNames[n] = string;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            SlotPose slotPose;
            Slot slot = ((Slot[])skeleton.slots.items)[this.slotIndex];
            if (!slot.bone.active) {
                return;
            }
            SlotPose slotPose2 = slotPose = bl ? (SlotPose)slot.applied : (SlotPose)slot.pose;
            if (mixDirection == MixDirection.out) {
                if (mixBlend == MixBlend.setup) {
                    this.setAttachment(skeleton, slotPose, ((SlotData)slot.data).attachmentName);
                }
            } else if (f2 < this.frames[0]) {
                if (mixBlend == MixBlend.setup || mixBlend == MixBlend.first) {
                    this.setAttachment(skeleton, slotPose, ((SlotData)slot.data).attachmentName);
                }
            } else {
                this.setAttachment(skeleton, slotPose, this.attachmentNames[AttachmentTimeline.search(this.frames, f2)]);
            }
        }

        private void setAttachment(Skeleton skeleton, SlotPose slotPose, String string) {
            slotPose.setAttachment(string == null ? null : skeleton.getAttachment(this.slotIndex, string));
        }
    }

    public static class RGB2Timeline
    extends SlotCurveTimeline {
        public RGB2Timeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.rgb.ordinal() + "|" + n3, Property.rgb2.ordinal() + "|" + n3);
        }

        @Override
        public int getFrameEntries() {
            return 7;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
            this.frames[n *= 7] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
            this.frames[n + 4] = f5;
            this.frames[n + 5] = f6;
            this.frames[n + 6] = f7;
        }

        @Override
        protected void apply(Slot slot, SlotPose slotPose, float f, float f2, MixBlend mixBlend) {
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            float[] fArray = this.frames;
            Color color = slotPose.color;
            Color color2 = slotPose.darkColor;
            if (f < fArray[0]) {
                SlotPose slotPose2 = (SlotPose)((SlotData)slot.data).setup;
                Color color3 = slotPose2.color;
                Color color4 = slotPose2.darkColor;
                switch (mixBlend) {
                    case setup: {
                        color.r = color3.r;
                        color.g = color3.g;
                        color.b = color3.b;
                        color2.r = color4.r;
                        color2.g = color4.g;
                        color2.b = color4.b;
                        break;
                    }
                    case first: {
                        color.r += (color3.r - color.r) * f2;
                        color.g += (color3.g - color.g) * f2;
                        color.b += (color3.b - color.b) * f2;
                        color2.r += (color4.r - color2.r) * f2;
                        color2.g += (color4.g - color2.g) * f2;
                        color2.b += (color4.b - color2.b) * f2;
                    }
                }
                return;
            }
            int n = RGB2Timeline.search(fArray, f, 7);
            int n2 = (int)this.curves[n / 7];
            switch (n2) {
                case 0: {
                    float f9 = fArray[n];
                    f8 = fArray[n + 1];
                    f7 = fArray[n + 2];
                    f6 = fArray[n + 3];
                    f5 = fArray[n + 4];
                    f4 = fArray[n + 5];
                    f3 = fArray[n + 6];
                    float f10 = (f - f9) / (fArray[n + 7] - f9);
                    f8 += (fArray[n + 7 + 1] - f8) * f10;
                    f7 += (fArray[n + 7 + 2] - f7) * f10;
                    f6 += (fArray[n + 7 + 3] - f6) * f10;
                    f5 += (fArray[n + 7 + 4] - f5) * f10;
                    f4 += (fArray[n + 7 + 5] - f4) * f10;
                    f3 += (fArray[n + 7 + 6] - f3) * f10;
                    break;
                }
                case 1: {
                    f8 = fArray[n + 1];
                    f7 = fArray[n + 2];
                    f6 = fArray[n + 3];
                    f5 = fArray[n + 4];
                    f4 = fArray[n + 5];
                    f3 = fArray[n + 6];
                    break;
                }
                default: {
                    f8 = this.getBezierValue(f, n, 1, n2 - 2);
                    f7 = this.getBezierValue(f, n, 2, n2 + 18 - 2);
                    f6 = this.getBezierValue(f, n, 3, n2 + 36 - 2);
                    f5 = this.getBezierValue(f, n, 4, n2 + 54 - 2);
                    f4 = this.getBezierValue(f, n, 5, n2 + 72 - 2);
                    f3 = this.getBezierValue(f, n, 6, n2 + 90 - 2);
                }
            }
            if (f2 == 1.0f) {
                color.r = f8;
                color.g = f7;
                color.b = f6;
                color2.r = f5;
                color2.g = f4;
                color2.b = f3;
            } else {
                if (mixBlend == MixBlend.setup) {
                    SlotPose slotPose3 = (SlotPose)((SlotData)slot.data).setup;
                    Color color5 = slotPose3.color;
                    Color color6 = slotPose3.darkColor;
                    color.r = color5.r;
                    color.g = color5.g;
                    color.b = color5.b;
                    color2.r = color6.r;
                    color2.g = color6.g;
                    color2.b = color6.b;
                }
                color.r += (f8 - color.r) * f2;
                color.g += (f7 - color.g) * f2;
                color.b += (f6 - color.b) * f2;
                color2.r += (f5 - color2.r) * f2;
                color2.g += (f4 - color2.g) * f2;
                color2.b += (f3 - color2.b) * f2;
            }
        }
    }

    public static class RGBA2Timeline
    extends SlotCurveTimeline {
        public RGBA2Timeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.rgb.ordinal() + "|" + n3, Property.alpha.ordinal() + "|" + n3, Property.rgb2.ordinal() + "|" + n3);
        }

        @Override
        public int getFrameEntries() {
            return 8;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            this.frames[n <<= 3] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
            this.frames[n + 4] = f5;
            this.frames[n + 5] = f6;
            this.frames[n + 6] = f7;
            this.frames[n + 7] = f8;
        }

        @Override
        protected void apply(Slot slot, SlotPose slotPose, float f, float f2, MixBlend mixBlend) {
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            float f9;
            float[] fArray = this.frames;
            Color color = slotPose.color;
            Color color2 = slotPose.darkColor;
            if (f < fArray[0]) {
                SlotPose slotPose2 = (SlotPose)((SlotData)slot.data).setup;
                Color color3 = slotPose2.color;
                Color color4 = slotPose2.darkColor;
                switch (mixBlend) {
                    case setup: {
                        color.set(color3);
                        color2.r = color4.r;
                        color2.g = color4.g;
                        color2.b = color4.b;
                        break;
                    }
                    case first: {
                        color.add((color3.r - color.r) * f2, (color3.g - color.g) * f2, (color3.b - color.b) * f2, (color3.a - color.a) * f2);
                        color2.r += (color4.r - color2.r) * f2;
                        color2.g += (color4.g - color2.g) * f2;
                        color2.b += (color4.b - color2.b) * f2;
                    }
                }
                return;
            }
            int n = RGBA2Timeline.search(fArray, f, 8);
            int n2 = (int)this.curves[n >> 3];
            switch (n2) {
                case 0: {
                    float f10 = fArray[n];
                    f9 = fArray[n + 1];
                    f8 = fArray[n + 2];
                    f7 = fArray[n + 3];
                    f6 = fArray[n + 4];
                    f5 = fArray[n + 5];
                    f4 = fArray[n + 6];
                    f3 = fArray[n + 7];
                    float f11 = (f - f10) / (fArray[n + 8] - f10);
                    f9 += (fArray[n + 8 + 1] - f9) * f11;
                    f8 += (fArray[n + 8 + 2] - f8) * f11;
                    f7 += (fArray[n + 8 + 3] - f7) * f11;
                    f6 += (fArray[n + 8 + 4] - f6) * f11;
                    f5 += (fArray[n + 8 + 5] - f5) * f11;
                    f4 += (fArray[n + 8 + 6] - f4) * f11;
                    f3 += (fArray[n + 8 + 7] - f3) * f11;
                    break;
                }
                case 1: {
                    f9 = fArray[n + 1];
                    f8 = fArray[n + 2];
                    f7 = fArray[n + 3];
                    f6 = fArray[n + 4];
                    f5 = fArray[n + 5];
                    f4 = fArray[n + 6];
                    f3 = fArray[n + 7];
                    break;
                }
                default: {
                    f9 = this.getBezierValue(f, n, 1, n2 - 2);
                    f8 = this.getBezierValue(f, n, 2, n2 + 18 - 2);
                    f7 = this.getBezierValue(f, n, 3, n2 + 36 - 2);
                    f6 = this.getBezierValue(f, n, 4, n2 + 54 - 2);
                    f5 = this.getBezierValue(f, n, 5, n2 + 72 - 2);
                    f4 = this.getBezierValue(f, n, 6, n2 + 90 - 2);
                    f3 = this.getBezierValue(f, n, 7, n2 + 108 - 2);
                }
            }
            if (f2 == 1.0f) {
                color.set(f9, f8, f7, f6);
                color2.r = f5;
                color2.g = f4;
                color2.b = f3;
            } else {
                if (mixBlend == MixBlend.setup) {
                    SlotPose slotPose3 = (SlotPose)((SlotData)slot.data).setup;
                    color.set(slotPose3.color);
                    Color color5 = slotPose3.darkColor;
                    color2.r = color5.r;
                    color2.g = color5.g;
                    color2.b = color5.b;
                }
                color.add((f9 - color.r) * f2, (f8 - color.g) * f2, (f7 - color.b) * f2, (f6 - color.a) * f2);
                color2.r += (f5 - color2.r) * f2;
                color2.g += (f4 - color2.g) * f2;
                color2.b += (f3 - color2.b) * f2;
            }
        }
    }

    public static class AlphaTimeline
    extends CurveTimeline1
    implements SlotTimeline {
        final int slotIndex;

        public AlphaTimeline(int n, int n2, int n3) {
            super(n, n2, Property.alpha.ordinal() + "|" + n3);
            this.slotIndex = n3;
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            Slot slot = ((Slot[])skeleton.slots.items)[this.slotIndex];
            if (!slot.bone.active) {
                return;
            }
            Color color = (bl ? (SlotPose)slot.applied : (SlotPose)slot.pose).color;
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                Color color2 = ((SlotPose)((SlotData)slot.data).setup).color;
                switch (mixBlend) {
                    case setup: {
                        color.a = color2.a;
                        break;
                    }
                    case first: {
                        color.a += (color2.a - color.a) * f3;
                    }
                }
                return;
            }
            float f4 = this.getCurveValue(f2);
            if (f3 == 1.0f) {
                color.a = f4;
            } else {
                if (mixBlend == MixBlend.setup) {
                    color.a = ((SlotPose)((SlotData)slot.data).setup).color.a;
                }
                color.a += (f4 - color.a) * f3;
            }
        }
    }

    public static class RGBTimeline
    extends SlotCurveTimeline {
        public RGBTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.rgb.ordinal() + "|" + n3);
        }

        @Override
        public int getFrameEntries() {
            return 4;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4) {
            this.frames[n <<= 2] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
        }

        @Override
        protected void apply(Slot slot, SlotPose slotPose, float f, float f2, MixBlend mixBlend) {
            float f3;
            float f4;
            float f5;
            float[] fArray = this.frames;
            Color color = slotPose.color;
            if (f < fArray[0]) {
                Color color2 = ((SlotPose)((SlotData)slot.data).setup).color;
                switch (mixBlend) {
                    case setup: {
                        color.r = color2.r;
                        color.g = color2.g;
                        color.b = color2.b;
                        break;
                    }
                    case first: {
                        color.r += (color2.r - color.r) * f2;
                        color.g += (color2.g - color.g) * f2;
                        color.b += (color2.b - color.b) * f2;
                    }
                }
                return;
            }
            int n = RGBTimeline.search(fArray, f, 4);
            int n2 = (int)this.curves[n >> 2];
            switch (n2) {
                case 0: {
                    float f6 = fArray[n];
                    f5 = fArray[n + 1];
                    f4 = fArray[n + 2];
                    f3 = fArray[n + 3];
                    float f7 = (f - f6) / (fArray[n + 4] - f6);
                    f5 += (fArray[n + 4 + 1] - f5) * f7;
                    f4 += (fArray[n + 4 + 2] - f4) * f7;
                    f3 += (fArray[n + 4 + 3] - f3) * f7;
                    break;
                }
                case 1: {
                    f5 = fArray[n + 1];
                    f4 = fArray[n + 2];
                    f3 = fArray[n + 3];
                    break;
                }
                default: {
                    f5 = this.getBezierValue(f, n, 1, n2 - 2);
                    f4 = this.getBezierValue(f, n, 2, n2 + 18 - 2);
                    f3 = this.getBezierValue(f, n, 3, n2 + 36 - 2);
                }
            }
            if (f2 == 1.0f) {
                color.r = f5;
                color.g = f4;
                color.b = f3;
            } else {
                if (mixBlend == MixBlend.setup) {
                    Color color3 = ((SlotPose)((SlotData)slot.data).setup).color;
                    color.r = color3.r;
                    color.g = color3.g;
                    color.b = color3.b;
                }
                color.r += (f5 - color.r) * f2;
                color.g += (f4 - color.g) * f2;
                color.b += (f3 - color.b) * f2;
            }
        }
    }

    public static class RGBATimeline
    extends SlotCurveTimeline {
        public RGBATimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.rgb.ordinal() + "|" + n3, Property.alpha.ordinal() + "|" + n3);
        }

        @Override
        public int getFrameEntries() {
            return 5;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4, float f5) {
            this.frames[n *= 5] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
            this.frames[n + 4] = f5;
        }

        @Override
        protected void apply(Slot slot, SlotPose slotPose, float f, float f2, MixBlend mixBlend) {
            float f3;
            float f4;
            float f5;
            float f6;
            float[] fArray = this.frames;
            Color color = slotPose.color;
            if (f < fArray[0]) {
                Color color2 = ((SlotPose)((SlotData)slot.data).setup).color;
                switch (mixBlend) {
                    case setup: {
                        color.set(color2);
                        break;
                    }
                    case first: {
                        color.add((color2.r - color.r) * f2, (color2.g - color.g) * f2, (color2.b - color.b) * f2, (color2.a - color.a) * f2);
                    }
                }
                return;
            }
            int n = RGBATimeline.search(fArray, f, 5);
            int n2 = (int)this.curves[n / 5];
            switch (n2) {
                case 0: {
                    float f7 = fArray[n];
                    f6 = fArray[n + 1];
                    f5 = fArray[n + 2];
                    f4 = fArray[n + 3];
                    f3 = fArray[n + 4];
                    float f8 = (f - f7) / (fArray[n + 5] - f7);
                    f6 += (fArray[n + 5 + 1] - f6) * f8;
                    f5 += (fArray[n + 5 + 2] - f5) * f8;
                    f4 += (fArray[n + 5 + 3] - f4) * f8;
                    f3 += (fArray[n + 5 + 4] - f3) * f8;
                    break;
                }
                case 1: {
                    f6 = fArray[n + 1];
                    f5 = fArray[n + 2];
                    f4 = fArray[n + 3];
                    f3 = fArray[n + 4];
                    break;
                }
                default: {
                    f6 = this.getBezierValue(f, n, 1, n2 - 2);
                    f5 = this.getBezierValue(f, n, 2, n2 + 18 - 2);
                    f4 = this.getBezierValue(f, n, 3, n2 + 36 - 2);
                    f3 = this.getBezierValue(f, n, 4, n2 + 54 - 2);
                }
            }
            if (f2 == 1.0f) {
                color.set(f6, f5, f4, f3);
            } else {
                if (mixBlend == MixBlend.setup) {
                    color.set(((SlotPose)((SlotData)slot.data).setup).color);
                }
                color.add((f6 - color.r) * f2, (f5 - color.g) * f2, (f4 - color.b) * f2, (f3 - color.a) * f2);
            }
        }
    }

    public static abstract class SlotCurveTimeline
    extends CurveTimeline
    implements SlotTimeline {
        final int slotIndex;

        public SlotCurveTimeline(int n, int n2, int n3, String ... stringArray) {
            super(n, n2, stringArray);
            this.slotIndex = n3;
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            Slot slot = ((Slot[])skeleton.slots.items)[this.slotIndex];
            if (slot.bone.active) {
                this.apply(slot, bl ? (SlotPose)slot.applied : (SlotPose)slot.pose, f2, f3, mixBlend);
            }
        }

        protected abstract void apply(Slot var1, SlotPose var2, float var3, float var4, MixBlend var5);
    }

    public static class InheritTimeline
    extends Timeline
    implements BoneTimeline {
        final int boneIndex;

        public InheritTimeline(int n, int n2) {
            super(n, Property.inherit.ordinal() + "|" + n2);
            this.boneIndex = n2;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public int getFrameEntries() {
            return 2;
        }

        public void setFrame(int n, float f, BoneData.Inherit inherit) {
            this.frames[n *= 2] = f;
            this.frames[n + 1] = inherit.ordinal();
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            BoneLocal boneLocal;
            Bone bone = ((Bone[])skeleton.bones.items)[this.boneIndex];
            if (!bone.active) {
                return;
            }
            BoneLocal boneLocal2 = boneLocal = bl ? (BoneLocal)bone.applied : (BoneLocal)bone.pose;
            if (mixDirection == MixDirection.out) {
                if (mixBlend == MixBlend.setup) {
                    boneLocal.inherit = ((BoneLocal)((BoneData)bone.data).setup).inherit;
                }
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (mixBlend == MixBlend.setup || mixBlend == MixBlend.first) {
                    boneLocal.inherit = ((BoneLocal)((BoneData)bone.data).setup).inherit;
                }
            } else {
                boneLocal.inherit = BoneData.Inherit.values[(int)fArray[InheritTimeline.search(fArray, f2, 2) + 1]];
            }
        }
    }

    public static class ShearYTimeline
    extends BoneTimeline1 {
        public ShearYTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.shearY);
        }

        @Override
        protected void apply(BoneLocal boneLocal, BoneLocal boneLocal2, float f, float f2, MixBlend mixBlend, MixDirection mixDirection) {
            boneLocal.shearY = this.getRelativeValue(f, f2, mixBlend, boneLocal.shearY, boneLocal2.shearY);
        }
    }

    public static class ShearXTimeline
    extends BoneTimeline1 {
        public ShearXTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.shearX);
        }

        @Override
        protected void apply(BoneLocal boneLocal, BoneLocal boneLocal2, float f, float f2, MixBlend mixBlend, MixDirection mixDirection) {
            boneLocal.shearX = this.getRelativeValue(f, f2, mixBlend, boneLocal.shearX, boneLocal2.shearX);
        }
    }

    public static class ShearTimeline
    extends BoneTimeline2 {
        public ShearTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.shearX, Property.shearY);
        }

        @Override
        protected void apply(BoneLocal boneLocal, BoneLocal boneLocal2, float f, float f2, MixBlend mixBlend, MixDirection mixDirection) {
            float f3;
            float f4;
            float[] fArray = this.frames;
            if (f < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        boneLocal.shearX = boneLocal2.shearX;
                        boneLocal.shearY = boneLocal2.shearY;
                        break;
                    }
                    case first: {
                        boneLocal.shearX += (boneLocal2.shearX - boneLocal.shearX) * f2;
                        boneLocal.shearY += (boneLocal2.shearY - boneLocal.shearY) * f2;
                    }
                }
                return;
            }
            int n = ShearTimeline.search(fArray, f, 3);
            int n2 = (int)this.curves[n / 3];
            switch (n2) {
                case 0: {
                    float f5 = fArray[n];
                    f4 = fArray[n + 1];
                    f3 = fArray[n + 2];
                    float f6 = (f - f5) / (fArray[n + 3] - f5);
                    f4 += (fArray[n + 3 + 1] - f4) * f6;
                    f3 += (fArray[n + 3 + 2] - f3) * f6;
                    break;
                }
                case 1: {
                    f4 = fArray[n + 1];
                    f3 = fArray[n + 2];
                    break;
                }
                default: {
                    f4 = this.getBezierValue(f, n, 1, n2 - 2);
                    f3 = this.getBezierValue(f, n, 2, n2 + 18 - 2);
                }
            }
            switch (mixBlend) {
                case setup: {
                    boneLocal.shearX = boneLocal2.shearX + f4 * f2;
                    boneLocal.shearY = boneLocal2.shearY + f3 * f2;
                    break;
                }
                case first: 
                case replace: {
                    boneLocal.shearX += (boneLocal2.shearX + f4 - boneLocal.shearX) * f2;
                    boneLocal.shearY += (boneLocal2.shearY + f3 - boneLocal.shearY) * f2;
                    break;
                }
                case add: {
                    boneLocal.shearX += f4 * f2;
                    boneLocal.shearY += f3 * f2;
                }
            }
        }
    }

    public static class ScaleYTimeline
    extends BoneTimeline1 {
        public ScaleYTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.scaleY);
        }

        @Override
        protected void apply(BoneLocal boneLocal, BoneLocal boneLocal2, float f, float f2, MixBlend mixBlend, MixDirection mixDirection) {
            boneLocal.scaleY = this.getScaleValue(f, f2, mixBlend, mixDirection, boneLocal.scaleY, boneLocal2.scaleY);
        }
    }

    public static class ScaleXTimeline
    extends BoneTimeline1 {
        public ScaleXTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.scaleX);
        }

        @Override
        protected void apply(BoneLocal boneLocal, BoneLocal boneLocal2, float f, float f2, MixBlend mixBlend, MixDirection mixDirection) {
            boneLocal.scaleX = this.getScaleValue(f, f2, mixBlend, mixDirection, boneLocal.scaleX, boneLocal2.scaleX);
        }
    }

    public static class ScaleTimeline
    extends BoneTimeline2 {
        public ScaleTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.scaleX, Property.scaleY);
        }

        @Override
        protected void apply(BoneLocal boneLocal, BoneLocal boneLocal2, float f, float f2, MixBlend mixBlend, MixDirection mixDirection) {
            float f3;
            float f4;
            float f5;
            float f6;
            float[] fArray = this.frames;
            if (f < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        boneLocal.scaleX = boneLocal2.scaleX;
                        boneLocal.scaleY = boneLocal2.scaleY;
                        break;
                    }
                    case first: {
                        boneLocal.scaleX += (boneLocal2.scaleX - boneLocal.scaleX) * f2;
                        boneLocal.scaleY += (boneLocal2.scaleY - boneLocal.scaleY) * f2;
                    }
                }
                return;
            }
            int n = ScaleTimeline.search(fArray, f, 3);
            int n2 = (int)this.curves[n / 3];
            switch (n2) {
                case 0: {
                    f6 = fArray[n];
                    f5 = fArray[n + 1];
                    f4 = fArray[n + 2];
                    f3 = (f - f6) / (fArray[n + 3] - f6);
                    f5 += (fArray[n + 3 + 1] - f5) * f3;
                    f4 += (fArray[n + 3 + 2] - f4) * f3;
                    break;
                }
                case 1: {
                    f5 = fArray[n + 1];
                    f4 = fArray[n + 2];
                    break;
                }
                default: {
                    f5 = this.getBezierValue(f, n, 1, n2 - 2);
                    f4 = this.getBezierValue(f, n, 2, n2 + 18 - 2);
                }
            }
            f5 *= boneLocal2.scaleX;
            f4 *= boneLocal2.scaleY;
            if (f2 == 1.0f) {
                if (mixBlend == MixBlend.add) {
                    boneLocal.scaleX += f5 - boneLocal2.scaleX;
                    boneLocal.scaleY += f4 - boneLocal2.scaleY;
                } else {
                    boneLocal.scaleX = f5;
                    boneLocal.scaleY = f4;
                }
            } else if (mixDirection == MixDirection.out) {
                switch (mixBlend) {
                    case setup: {
                        f6 = boneLocal2.scaleX;
                        f3 = boneLocal2.scaleY;
                        boneLocal.scaleX = f6 + (Math.abs(f5) * Math.signum(f6) - f6) * f2;
                        boneLocal.scaleY = f3 + (Math.abs(f4) * Math.signum(f3) - f3) * f2;
                        break;
                    }
                    case first: 
                    case replace: {
                        f6 = boneLocal.scaleX;
                        f3 = boneLocal.scaleY;
                        boneLocal.scaleX = f6 + (Math.abs(f5) * Math.signum(f6) - f6) * f2;
                        boneLocal.scaleY = f3 + (Math.abs(f4) * Math.signum(f3) - f3) * f2;
                        break;
                    }
                    case add: {
                        boneLocal.scaleX += (f5 - boneLocal2.scaleX) * f2;
                        boneLocal.scaleY += (f4 - boneLocal2.scaleY) * f2;
                    }
                }
            } else {
                switch (mixBlend) {
                    case setup: {
                        f6 = Math.abs(boneLocal2.scaleX) * Math.signum(f5);
                        f3 = Math.abs(boneLocal2.scaleY) * Math.signum(f4);
                        boneLocal.scaleX = f6 + (f5 - f6) * f2;
                        boneLocal.scaleY = f3 + (f4 - f3) * f2;
                        break;
                    }
                    case first: 
                    case replace: {
                        f6 = Math.abs(boneLocal.scaleX) * Math.signum(f5);
                        f3 = Math.abs(boneLocal.scaleY) * Math.signum(f4);
                        boneLocal.scaleX = f6 + (f5 - f6) * f2;
                        boneLocal.scaleY = f3 + (f4 - f3) * f2;
                        break;
                    }
                    case add: {
                        boneLocal.scaleX += (f5 - boneLocal2.scaleX) * f2;
                        boneLocal.scaleY += (f4 - boneLocal2.scaleY) * f2;
                    }
                }
            }
        }
    }

    public static class TranslateYTimeline
    extends BoneTimeline1 {
        public TranslateYTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.y);
        }

        @Override
        protected void apply(BoneLocal boneLocal, BoneLocal boneLocal2, float f, float f2, MixBlend mixBlend, MixDirection mixDirection) {
            boneLocal.y = this.getRelativeValue(f, f2, mixBlend, boneLocal.y, boneLocal2.y);
        }
    }

    public static class TranslateXTimeline
    extends BoneTimeline1 {
        public TranslateXTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.x);
        }

        @Override
        protected void apply(BoneLocal boneLocal, BoneLocal boneLocal2, float f, float f2, MixBlend mixBlend, MixDirection mixDirection) {
            boneLocal.x = this.getRelativeValue(f, f2, mixBlend, boneLocal.x, boneLocal2.x);
        }
    }

    public static class TranslateTimeline
    extends BoneTimeline2 {
        public TranslateTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.x, Property.y);
        }

        @Override
        protected void apply(BoneLocal boneLocal, BoneLocal boneLocal2, float f, float f2, MixBlend mixBlend, MixDirection mixDirection) {
            float f3;
            float f4;
            float[] fArray = this.frames;
            if (f < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        boneLocal.x = boneLocal2.x;
                        boneLocal.y = boneLocal2.y;
                        break;
                    }
                    case first: {
                        boneLocal.x += (boneLocal2.x - boneLocal.x) * f2;
                        boneLocal.y += (boneLocal2.y - boneLocal.y) * f2;
                    }
                }
                return;
            }
            int n = TranslateTimeline.search(fArray, f, 3);
            int n2 = (int)this.curves[n / 3];
            switch (n2) {
                case 0: {
                    float f5 = fArray[n];
                    f4 = fArray[n + 1];
                    f3 = fArray[n + 2];
                    float f6 = (f - f5) / (fArray[n + 3] - f5);
                    f4 += (fArray[n + 3 + 1] - f4) * f6;
                    f3 += (fArray[n + 3 + 2] - f3) * f6;
                    break;
                }
                case 1: {
                    f4 = fArray[n + 1];
                    f3 = fArray[n + 2];
                    break;
                }
                default: {
                    f4 = this.getBezierValue(f, n, 1, n2 - 2);
                    f3 = this.getBezierValue(f, n, 2, n2 + 18 - 2);
                }
            }
            switch (mixBlend) {
                case setup: {
                    boneLocal.x = boneLocal2.x + f4 * f2;
                    boneLocal.y = boneLocal2.y + f3 * f2;
                    break;
                }
                case first: 
                case replace: {
                    boneLocal.x += (boneLocal2.x + f4 - boneLocal.x) * f2;
                    boneLocal.y += (boneLocal2.y + f3 - boneLocal.y) * f2;
                    break;
                }
                case add: {
                    boneLocal.x += f4 * f2;
                    boneLocal.y += f3 * f2;
                }
            }
        }
    }

    public static class RotateTimeline
    extends BoneTimeline1 {
        public RotateTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.rotate);
        }

        @Override
        protected void apply(BoneLocal boneLocal, BoneLocal boneLocal2, float f, float f2, MixBlend mixBlend, MixDirection mixDirection) {
            boneLocal.rotation = this.getRelativeValue(f, f2, mixBlend, boneLocal.rotation, boneLocal2.rotation);
        }
    }

    public static abstract class BoneTimeline1
    extends CurveTimeline1
    implements BoneTimeline {
        final int boneIndex;

        public BoneTimeline1(int n, int n2, int n3, Property property) {
            super(n, n2, property.ordinal() + "|" + n3);
            this.boneIndex = n3;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            Bone bone = ((Bone[])skeleton.bones.items)[this.boneIndex];
            if (bone.active) {
                this.apply(bl ? (BoneLocal)bone.applied : (BoneLocal)bone.pose, (BoneLocal)((BoneData)bone.data).setup, f2, f3, mixBlend, mixDirection);
            }
        }

        protected abstract void apply(BoneLocal var1, BoneLocal var2, float var3, float var4, MixBlend var5, MixDirection var6);
    }

    public static abstract class BoneTimeline2
    extends CurveTimeline
    implements BoneTimeline {
        final int boneIndex;

        public BoneTimeline2(int n, int n2, int n3, Property property, Property property2) {
            super(n, n2, property.ordinal() + "|" + n3, property2.ordinal() + "|" + n3);
            this.boneIndex = n3;
        }

        @Override
        public int getFrameEntries() {
            return 3;
        }

        public void setFrame(int n, float f, float f2, float f3) {
            this.frames[n *= 3] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection, boolean bl) {
            Bone bone = ((Bone[])skeleton.bones.items)[this.boneIndex];
            if (bone.active) {
                this.apply(bl ? (BoneLocal)bone.applied : (BoneLocal)bone.pose, (BoneLocal)((BoneData)bone.data).setup, f2, f3, mixBlend, mixDirection);
            }
        }

        protected abstract void apply(BoneLocal var1, BoneLocal var2, float var3, float var4, MixBlend var5, MixDirection var6);
    }

    public static abstract class CurveTimeline1
    extends CurveTimeline {
        public CurveTimeline1(int n, int n2, String string) {
            super(n, n2, string);
        }

        @Override
        public int getFrameEntries() {
            return 2;
        }

        public void setFrame(int n, float f, float f2) {
            this.frames[n <<= 1] = f;
            this.frames[n + 1] = f2;
        }

        public float getCurveValue(float f) {
            int n;
            float[] fArray = this.frames;
            int n2 = fArray.length - 2;
            for (n = 2; n <= n2; n += 2) {
                if (!(fArray[n] > f)) continue;
                n2 = n - 2;
                break;
            }
            n = (int)this.curves[n2 >> 1];
            return switch (n) {
                case 0 -> {
                    float var5_5 = fArray[n2];
                    float var6_6 = fArray[n2 + 1];
                    yield var6_6 + (f - var5_5) / (fArray[n2 + 2] - var5_5) * (fArray[n2 + 2 + 1] - var6_6);
                }
                case 1 -> fArray[n2 + 1];
                default -> this.getBezierValue(f, n2, 1, n - 2);
            };
        }

        public float getRelativeValue(float f, float f2, MixBlend mixBlend, float f3, float f4) {
            if (f < this.frames[0]) {
                return switch (mixBlend) {
                    case MixBlend.setup -> f4;
                    case MixBlend.first -> f3 + (f4 - f3) * f2;
                    default -> f3;
                };
            }
            float f5 = this.getCurveValue(f);
            return switch (mixBlend) {
                default -> throw new IncompatibleClassChangeError();
                case MixBlend.setup -> f4 + f5 * f2;
                case MixBlend.first, MixBlend.replace -> f3 + (f5 + f4 - f3) * f2;
                case MixBlend.add -> f3 + f5 * f2;
            };
        }

        public float getAbsoluteValue(float f, float f2, MixBlend mixBlend, float f3, float f4) {
            if (f < this.frames[0]) {
                return switch (mixBlend) {
                    case MixBlend.setup -> f4;
                    case MixBlend.first -> f3 + (f4 - f3) * f2;
                    default -> f3;
                };
            }
            float f5 = this.getCurveValue(f);
            return switch (mixBlend) {
                default -> throw new IncompatibleClassChangeError();
                case MixBlend.setup -> f4 + (f5 - f4) * f2;
                case MixBlend.first, MixBlend.replace -> f3 + (f5 - f3) * f2;
                case MixBlend.add -> f3 + f5 * f2;
            };
        }

        public float getAbsoluteValue(float f, float f2, MixBlend mixBlend, float f3, float f4, float f5) {
            if (f < this.frames[0]) {
                return switch (mixBlend) {
                    case MixBlend.setup -> f4;
                    case MixBlend.first -> f3 + (f4 - f3) * f2;
                    default -> f3;
                };
            }
            return switch (mixBlend) {
                default -> throw new IncompatibleClassChangeError();
                case MixBlend.setup -> f4 + (f5 - f4) * f2;
                case MixBlend.first, MixBlend.replace -> f3 + (f5 - f3) * f2;
                case MixBlend.add -> f3 + f5 * f2;
            };
        }

        public float getScaleValue(float f, float f2, MixBlend mixBlend, MixDirection mixDirection, float f3, float f4) {
            float[] fArray = this.frames;
            if (f < fArray[0]) {
                return switch (mixBlend) {
                    case MixBlend.setup -> f4;
                    case MixBlend.first -> f3 + (f4 - f3) * f2;
                    default -> f3;
                };
            }
            float f5 = this.getCurveValue(f) * f4;
            if (f2 == 1.0f) {
                return mixBlend == MixBlend.add ? f3 + f5 - f4 : f5;
            }
            if (mixDirection == MixDirection.out) {
                switch (mixBlend) {
                    case setup: {
                        return f4 + (Math.abs(f5) * Math.signum(f4) - f4) * f2;
                    }
                    case first: 
                    case replace: {
                        return f3 + (Math.abs(f5) * Math.signum(f3) - f3) * f2;
                    }
                }
            } else {
                switch (mixBlend) {
                    case setup: {
                        float f6 = Math.abs(f4) * Math.signum(f5);
                        return f6 + (f5 - f6) * f2;
                    }
                    case first: 
                    case replace: {
                        float f7 = Math.abs(f3) * Math.signum(f5);
                        return f7 + (f5 - f7) * f2;
                    }
                }
            }
            return f3 + (f5 - f4) * f2;
        }
    }

    public static abstract class CurveTimeline
    extends Timeline {
        float[] curves;

        public CurveTimeline(int n, int n2, String ... stringArray) {
            super(n, stringArray);
            this.curves = new float[n + n2 * 18];
            this.curves[n - 1] = 1.0f;
        }

        public void setStepped(int n) {
            this.curves[n] = 1.0f;
        }

        public void shrink(int n) {
            int n2 = this.getFrameCount() + n * 18;
            if (this.curves.length > n2) {
                float[] fArray = new float[n2];
                SpineUtils.arraycopy(this.curves, 0, fArray, 0, n2);
                this.curves = fArray;
            }
        }

        public void setBezier(int n, int n2, int n3, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            float[] fArray = this.curves;
            int n4 = this.getFrameCount() + n * 18;
            if (n3 == 0) {
                fArray[n2] = 2 + n4;
            }
            float f9 = (f - f3 * 2.0f + f5) * 0.03f;
            float f10 = (f2 - f4 * 2.0f + f6) * 0.03f;
            float f11 = ((f3 - f5) * 3.0f - f + f7) * 0.006f;
            float f12 = ((f4 - f6) * 3.0f - f2 + f8) * 0.006f;
            float f13 = f9 * 2.0f + f11;
            float f14 = f10 * 2.0f + f12;
            float f15 = (f3 - f) * 0.3f + f9 + f11 * 0.16666667f;
            float f16 = (f4 - f2) * 0.3f + f10 + f12 * 0.16666667f;
            float f17 = f + f15;
            float f18 = f2 + f16;
            int n5 = n4 + 18;
            while (n4 < n5) {
                fArray[n4] = f17;
                fArray[n4 + 1] = f18;
                f17 += (f15 += (f13 += f11));
                f18 += (f16 += (f14 += f12));
                n4 += 2;
            }
        }

        public float getBezierValue(float f, int n, int n2, int n3) {
            float[] fArray = this.curves;
            if (fArray[n3] > f) {
                float f2 = this.frames[n];
                float f3 = this.frames[n + n2];
                return f3 + (f - f2) / (fArray[n3] - f2) * (fArray[n3 + 1] - f3);
            }
            int n4 = n3 + 18;
            n3 += 2;
            while (n3 < n4) {
                if (fArray[n3] >= f) {
                    float f4 = fArray[n3 - 2];
                    float f5 = fArray[n3 - 1];
                    return f5 + (f - f4) / (fArray[n3] - f4) * (fArray[n3 + 1] - f5);
                }
                n3 += 2;
            }
            float f6 = fArray[n4 - 2];
            float f7 = fArray[n4 - 1];
            return f7 + (f - f6) / (this.frames[n += this.getFrameEntries()] - f6) * (this.frames[n + n2] - f7);
        }
    }

    public static interface SlotTimeline {
        public int getSlotIndex();
    }

    private static enum Property {
        rotate,
        x,
        y,
        scaleX,
        scaleY,
        shearX,
        shearY,
        inherit,
        rgb,
        alpha,
        rgb2,
        attachment,
        deform,
        event,
        drawOrder,
        ikConstraint,
        transformConstraint,
        pathConstraintPosition,
        pathConstraintSpacing,
        pathConstraintMix,
        physicsConstraintInertia,
        physicsConstraintStrength,
        physicsConstraintDamping,
        physicsConstraintMass,
        physicsConstraintWind,
        physicsConstraintGravity,
        physicsConstraintMix,
        physicsConstraintReset,
        sequence,
        sliderTime,
        sliderMix;

    }
}

