/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.BonePose;
import com.esotericsoftware.spine.Constraint;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.IkConstraintPose;
import com.esotericsoftware.spine.Physics;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.utils.SpineUtils;

public class IkConstraint
extends Constraint<IkConstraint, IkConstraintData, IkConstraintPose> {
    final Array<BonePose> bones;
    Bone target;

    public IkConstraint(IkConstraintData ikConstraintData, Skeleton skeleton) {
        super(ikConstraintData, new IkConstraintPose(), new IkConstraintPose());
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.bones = new Array(true, ikConstraintData.bones.size, BonePose[]::new);
        for (BoneData boneData : ikConstraintData.bones) {
            this.bones.add((BonePose)((Bone[])skeleton.bones.items)[boneData.index].constrained);
        }
        this.target = ((Bone[])skeleton.bones.items)[ikConstraintData.target.index];
    }

    @Override
    public void update(Skeleton skeleton, Physics physics) {
        IkConstraintPose ikConstraintPose = (IkConstraintPose)this.applied;
        if (ikConstraintPose.mix == 0.0f) {
            return;
        }
        BonePose bonePose = (BonePose)this.target.applied;
        BonePose[] bonePoseArray = (BonePose[])this.bones.items;
        switch (this.bones.size) {
            case 1: {
                IkConstraint.apply(skeleton, bonePoseArray[0], bonePose.worldX, bonePose.worldY, ikConstraintPose.compress, ikConstraintPose.stretch, ((IkConstraintData)this.data).uniform, ikConstraintPose.mix);
                break;
            }
            case 2: {
                IkConstraint.apply(skeleton, bonePoseArray[0], bonePoseArray[1], bonePose.worldX, bonePose.worldY, ikConstraintPose.bendDirection, ikConstraintPose.stretch, ((IkConstraintData)this.data).uniform, ikConstraintPose.softness, ikConstraintPose.mix);
            }
        }
    }

    @Override
    void sort(Skeleton skeleton) {
        skeleton.sortBone(this.target);
        Bone bone = ((BonePose[])this.bones.items)[0].bone;
        skeleton.sortBone(bone);
        skeleton.updateCache.add(this);
        bone.sorted = false;
        skeleton.sortReset(bone.children);
        skeleton.constrained(bone);
        if (this.bones.size > 1) {
            skeleton.constrained(((BonePose[])this.bones.items)[1].bone);
        }
    }

    @Override
    boolean isSourceActive() {
        return this.target.active;
    }

    public static void apply(Skeleton skeleton, BonePose bonePose, float f, float f2, boolean bl, boolean bl2, boolean bl3, float f3) {
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        if (bonePose == null) {
            throw new IllegalArgumentException("bone cannot be null.");
        }
        bonePose.modifyLocal(skeleton);
        BonePose bonePose2 = (BonePose)bonePose.bone.parent.applied;
        float f9 = bonePose2.a;
        float f10 = bonePose2.b;
        float f11 = bonePose2.c;
        float f12 = bonePose2.d;
        float f13 = -bonePose.shearX - bonePose.rotation;
        switch (bonePose.inherit) {
            case onlyTranslation: {
                f8 = (f - bonePose.worldX) * Math.signum(skeleton.scaleX);
                f7 = (f2 - bonePose.worldY) * Math.signum(skeleton.scaleY);
                break;
            }
            case noRotationOrReflection: {
                f6 = Math.abs(f9 * f12 - f10 * f11) / Math.max(1.0E-4f, f9 * f9 + f11 * f11);
                f5 = f9 / skeleton.scaleX;
                f4 = f11 / skeleton.scaleY;
                f10 = -f4 * f6 * skeleton.scaleX;
                f12 = f5 * f6 * skeleton.scaleY;
                f13 += SpineUtils.atan2Deg(f4, f5);
            }
            default: {
                float f14 = f - bonePose2.worldX;
                float f15 = f2 - bonePose2.worldY;
                float f16 = f9 * f12 - f10 * f11;
                if (Math.abs(f16) <= 1.0E-4f) {
                    f8 = 0.0f;
                    f7 = 0.0f;
                    break;
                }
                f8 = (f14 * f12 - f15 * f10) / f16 - bonePose.x;
                f7 = (f15 * f9 - f14 * f11) / f16 - bonePose.y;
            }
        }
        f13 += SpineUtils.atan2Deg(f7, f8);
        if (bonePose.scaleX < 0.0f) {
            f13 += 180.0f;
        }
        if (f13 > 180.0f) {
            f13 -= 360.0f;
        } else if (f13 < -180.0f) {
            f13 += 360.0f;
        }
        bonePose.rotation += f13 * f3;
        if (bl || bl2) {
            switch (bonePose.inherit) {
                case noScale: 
                case noScaleOrReflection: {
                    f8 = f - bonePose.worldX;
                    f7 = f2 - bonePose.worldY;
                }
            }
            f6 = ((BoneData)bonePose.bone.data).length * bonePose.scaleX;
            if (f6 > 1.0E-4f) {
                f5 = f8 * f8 + f7 * f7;
                if (bl && f5 < f6 * f6 || bl2 && f5 > f6 * f6) {
                    f4 = ((float)Math.sqrt(f5) / f6 - 1.0f) * f3 + 1.0f;
                    bonePose.scaleX *= f4;
                    if (bl3) {
                        bonePose.scaleY *= f4;
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void apply(Skeleton var0, BonePose var1_1, BonePose var2_2, float var3_3, float var4_4, int var5_5, boolean var6_6, boolean var7_7, float var8_8, float var9_9) {
        block34: {
            block33: {
                if (var1_1 == null) {
                    throw new IllegalArgumentException("parent cannot be null.");
                }
                if (var2_2 == null) {
                    throw new IllegalArgumentException("child cannot be null.");
                }
                if (var1_1.inherit != BoneData.Inherit.normal || var2_2.inherit != BoneData.Inherit.normal) {
                    return;
                }
                var1_1.modifyLocal(var0);
                var2_2.modifyLocal(var0);
                var10_10 = var1_1.x;
                var11_11 = var1_1.y;
                var12_12 = var1_1.scaleX;
                var13_13 = var1_1.scaleY;
                var14_14 = var2_2.scaleX;
                if (var12_12 < 0.0f) {
                    var12_12 = -var12_12;
                    var15_15 = 180;
                    var17_16 = -1;
                } else {
                    var15_15 = 0;
                    var17_16 = 1;
                }
                if (var13_13 < 0.0f) {
                    var13_13 = -var13_13;
                    var17_16 = -var17_16;
                }
                if (var14_14 < 0.0f) {
                    var14_14 = -var14_14;
                    var16_17 = 180;
                } else {
                    var16_17 = 0;
                }
                var20_18 = var1_1.a;
                var21_19 = var1_1.b;
                var22_20 = var1_1.c;
                var23_21 = var1_1.d;
                v0 = var24_22 = Math.abs(var12_12 - var13_13) <= 1.0E-4f;
                if (!var24_22 || var6_6) {
                    var2_2.y = 0.0f;
                    var18_23 = var20_18 * var2_2.x + var1_1.worldX;
                    var19_24 = var22_20 * var2_2.x + var1_1.worldY;
                } else {
                    var18_23 = var20_18 * var2_2.x + var21_19 * var2_2.y + var1_1.worldX;
                    var19_24 = var22_20 * var2_2.x + var23_21 * var2_2.y + var1_1.worldY;
                }
                var25_25 = (BonePose)var1_1.bone.parent.applied;
                var20_18 = var25_25.a;
                var21_19 = var25_25.b;
                var22_20 = var25_25.c;
                var23_21 = var25_25.d;
                var26_26 = var20_18 * var23_21 - var21_19 * var22_20;
                var27_27 = var18_23 - var25_25.worldX;
                var28_28 = var19_24 - var25_25.worldY;
                var26_26 = Math.abs(var26_26) <= 1.0E-4f ? 0.0f : 1.0f / var26_26;
                var29_29 = (var27_27 * var23_21 - var28_28 * var21_19) * var26_26 - var10_10;
                var30_30 = (var28_28 * var20_18 - var27_27 * var22_20) * var26_26 - var11_11;
                var31_31 = (float)Math.sqrt(var29_29 * var29_29 + var30_30 * var30_30);
                var32_32 = ((BoneData)var2_2.bone.data).length * var14_14;
                if (var31_31 < 1.0E-4f) {
                    IkConstraint.apply(var0, var1_1, var3_3, var4_4, false, var6_6, false, var9_9);
                    var2_2.rotation = 0.0f;
                    return;
                }
                var27_27 = var3_3 - var25_25.worldX;
                var28_28 = var4_4 - var25_25.worldY;
                var35_33 = (var27_27 * var23_21 - var28_28 * var21_19) * var26_26 - var10_10;
                var36_34 = (var28_28 * var20_18 - var27_27 * var22_20) * var26_26 - var11_11;
                var37_35 = var35_33 * var35_33 + var36_34 * var36_34;
                if (var8_8 != 0.0f) {
                    var8_8 *= var12_12 * (var14_14 + 1.0f) * 0.5f;
                    var38_36 = (float)Math.sqrt(var37_35);
                    var39_37 = var38_36 - var31_31 - var32_32 * var12_12 + var8_8;
                    if (var39_37 > 0.0f) {
                        var40_38 = Math.min(1.0f, var39_37 / (var8_8 * 2.0f)) - 1.0f;
                        var40_38 = (var39_37 - var8_8 * (1.0f - var40_38 * var40_38)) / var38_36;
                        var35_33 -= var40_38 * var35_33;
                        var36_34 -= var40_38 * var36_34;
                        var37_35 = var35_33 * var35_33 + var36_34 * var36_34;
                    }
                }
                if (!var24_22) break block33;
                if ((var38_36 = (var37_35 - var31_31 * var31_31 - (var32_32 *= var12_12) * var32_32) / (2.0f * var31_31 * var32_32)) < -1.0f) {
                    var38_36 = -1.0f;
                    var34_39 = 3.1415927f * (float)var5_5;
                } else if (var38_36 > 1.0f) {
                    var38_36 = 1.0f;
                    var34_39 = 0.0f;
                    if (var6_6) {
                        var20_18 = ((float)Math.sqrt(var37_35) / (var31_31 + var32_32) - 1.0f) * var9_9 + 1.0f;
                        var1_1.scaleX *= var20_18;
                        if (var7_7) {
                            var1_1.scaleY *= var20_18;
                        }
                    }
                } else {
                    var34_39 = (float)Math.acos(var38_36) * (float)var5_5;
                }
                var20_18 = var31_31 + var32_32 * var38_36;
                var21_19 = var32_32 * SpineUtils.sin(var34_39);
                var33_40 = SpineUtils.atan2(var36_34 * var20_18 - var35_33 * var21_19, var35_33 * var20_18 + var36_34 * var21_19);
                break block34;
            }
            var20_18 = var12_12 * var32_32;
            var21_19 = var13_13 * var32_32;
            var38_36 = var20_18 * var20_18;
            var39_37 = var21_19 * var21_19;
            var40_38 = SpineUtils.atan2(var36_34, var35_33);
            var41_41 = -2.0f * var39_37 * var31_31;
            var42_42 = var39_37 - var38_36;
            var22_20 = var39_37 * var31_31 * var31_31 + var38_36 * var37_35 - var38_36 * var39_37;
            var23_21 = var41_41 * var41_41 - 4.0f * var42_42 * var22_20;
            if (!(var23_21 >= 0.0f)) ** GOTO lbl-1000
            var43_43 = (float)Math.sqrt(var23_21);
            if (var41_41 < 0.0f) {
                var43_43 = -var43_43;
            }
            var43_43 = -(var41_41 + var43_43) * 0.5f;
            var44_44 = var43_43 / var42_42;
            var45_45 = var22_20 / var43_43;
            var46_46 = Math.abs(var44_44) < Math.abs(var45_45) ? var44_44 : var45_45;
            if ((var44_44 = var37_35 - var46_46 * var46_46) >= 0.0f) {
                var28_28 = (float)Math.sqrt(var44_44) * (float)var5_5;
                var33_40 = var40_38 - SpineUtils.atan2(var28_28, var46_46);
                var34_39 = SpineUtils.atan2(var28_28 / var13_13, (var46_46 - var31_31) / var12_12);
            } else lbl-1000:
            // 2 sources

            {
                var43_43 = 3.1415927f;
                var44_44 = var31_31 - var20_18;
                var45_45 = var44_44 * var44_44;
                var46_46 = 0.0f;
                var47_47 = 0.0f;
                var48_48 = var31_31 + var20_18;
                var49_49 = var48_48 * var48_48;
                var50_50 = 0.0f;
                var22_20 = -var20_18 * var31_31 / (var38_36 - var39_37);
                if (var22_20 >= -1.0f && var22_20 <= 1.0f) {
                    var27_27 = var20_18 * SpineUtils.cos(var22_20 = (float)Math.acos(var22_20)) + var31_31;
                    var23_21 = var27_27 * var27_27 + (var28_28 = var21_19 * SpineUtils.sin(var22_20)) * var28_28;
                    if (var23_21 < var45_45) {
                        var43_43 = var22_20;
                        var45_45 = var23_21;
                        var44_44 = var27_27;
                        var46_46 = var28_28;
                    }
                    if (var23_21 > var49_49) {
                        var47_47 = var22_20;
                        var49_49 = var23_21;
                        var48_48 = var27_27;
                        var50_50 = var28_28;
                    }
                }
                if (var37_35 <= (var45_45 + var49_49) * 0.5f) {
                    var33_40 = var40_38 - SpineUtils.atan2(var46_46 * (float)var5_5, var44_44);
                    var34_39 = var43_43 * (float)var5_5;
                } else {
                    var33_40 = var40_38 - SpineUtils.atan2(var50_50 * (float)var5_5, var48_48);
                    var34_39 = var47_47 * (float)var5_5;
                }
            }
        }
        var38_36 = SpineUtils.atan2(var2_2.y, var2_2.x) * (float)var17_16;
        var33_40 = (var33_40 - var38_36) * 57.295776f + (float)var15_15 - var1_1.rotation;
        if (var33_40 > 180.0f) {
            var33_40 -= 360.0f;
        } else if (var33_40 < -180.0f) {
            var33_40 += 360.0f;
        }
        var1_1.rotation += var33_40 * var9_9;
        var34_39 = ((var34_39 + var38_36) * 57.295776f - var2_2.shearX) * (float)var17_16 + (float)var16_17 - var2_2.rotation;
        if (var34_39 > 180.0f) {
            var34_39 -= 360.0f;
        } else if (var34_39 < -180.0f) {
            var34_39 += 360.0f;
        }
        var2_2.rotation += var34_39 * var9_9;
    }
}

