/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.BonePose;
import com.esotericsoftware.spine.Constraint;
import com.esotericsoftware.spine.Physics;
import com.esotericsoftware.spine.PhysicsConstraintData;
import com.esotericsoftware.spine.PhysicsConstraintPose;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.utils.SpineUtils;

public class PhysicsConstraint
extends Constraint<PhysicsConstraint, PhysicsConstraintData, PhysicsConstraintPose> {
    BonePose bone;
    boolean reset = true;
    float ux;
    float uy;
    float cx;
    float cy;
    float tx;
    float ty;
    float xOffset;
    float xLag;
    float xVelocity;
    float yOffset;
    float yLag;
    float yVelocity;
    float rotateOffset;
    float rotateLag;
    float rotateVelocity;
    float scaleOffset;
    float scaleLag;
    float scaleVelocity;
    float remaining;
    float lastTime;

    public PhysicsConstraint(PhysicsConstraintData physicsConstraintData, Skeleton skeleton) {
        super(physicsConstraintData, new PhysicsConstraintPose(), new PhysicsConstraintPose());
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.bone = (BonePose)((Bone[])skeleton.bones.items)[physicsConstraintData.bone.index].constrained;
    }

    public void reset(Skeleton skeleton) {
        this.remaining = 0.0f;
        this.lastTime = skeleton.time;
        this.reset = true;
        this.xOffset = 0.0f;
        this.xLag = 0.0f;
        this.xVelocity = 0.0f;
        this.yOffset = 0.0f;
        this.yLag = 0.0f;
        this.yVelocity = 0.0f;
        this.rotateOffset = 0.0f;
        this.rotateLag = 0.0f;
        this.rotateVelocity = 0.0f;
        this.scaleOffset = 0.0f;
        this.scaleLag = 0.0f;
        this.scaleVelocity = 0.0f;
    }

    @Override
    public void update(Skeleton skeleton, Physics physics) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        PhysicsConstraintPose physicsConstraintPose = (PhysicsConstraintPose)this.applied;
        float f6 = physicsConstraintPose.mix;
        if (f6 == 0.0f) {
            return;
        }
        boolean bl = ((PhysicsConstraintData)this.data).x > 0.0f;
        boolean bl2 = ((PhysicsConstraintData)this.data).y > 0.0f;
        boolean bl3 = ((PhysicsConstraintData)this.data).rotate > 0.0f || ((PhysicsConstraintData)this.data).shearX > 0.0f;
        boolean bl4 = ((PhysicsConstraintData)this.data).scaleX > 0.0f;
        BonePose bonePose = this.bone;
        float f7 = ((BoneData)bonePose.bone.data).length;
        float f8 = ((PhysicsConstraintData)this.data).step;
        float f9 = 0.0f;
        switch (physics) {
            case none: {
                return;
            }
            case reset: {
                this.reset(skeleton);
            }
            case update: {
                f5 = Math.max(skeleton.time - this.lastTime, 0.0f);
                f4 = this.remaining;
                this.remaining += f5;
                this.lastTime = skeleton.time;
                f3 = bonePose.worldX;
                f2 = bonePose.worldY;
                if (this.reset) {
                    this.reset = false;
                    this.ux = f3;
                    this.uy = f2;
                } else {
                    float f10;
                    float f11;
                    float f12;
                    float f13;
                    float f14;
                    float f15;
                    f = this.remaining;
                    float f16 = physicsConstraintPose.inertia;
                    float f17 = skeleton.data.referenceScale;
                    float f18 = -1.0f;
                    float f19 = 0.0f;
                    float f20 = 0.0f;
                    float f21 = ((PhysicsConstraintData)this.data).limit * f5;
                    float f22 = f21 * Math.abs(skeleton.scaleY);
                    f21 *= Math.abs(skeleton.scaleX);
                    if (bl || bl2) {
                        if (bl) {
                            f15 = (this.ux - f3) * f16;
                            this.xOffset += f15 > f21 ? f21 : (f15 < -f21 ? -f21 : f15);
                            this.ux = f3;
                        }
                        if (bl2) {
                            f15 = (this.uy - f2) * f16;
                            this.yOffset += f15 > f22 ? f22 : (f15 < -f22 ? -f22 : f15);
                            this.uy = f2;
                        }
                        if (f >= f8) {
                            f15 = this.xOffset;
                            f14 = this.yOffset;
                            f18 = (float)Math.pow(physicsConstraintPose.damping, 60.0f * f8);
                            f19 = f8 * physicsConstraintPose.massInverse;
                            f20 = physicsConstraintPose.strength;
                            f13 = f17 * physicsConstraintPose.wind;
                            f12 = f17 * physicsConstraintPose.gravity;
                            f11 = (f13 * skeleton.windX + f12 * skeleton.gravityX) * skeleton.scaleX;
                            f10 = (f13 * skeleton.windY + f12 * skeleton.gravityY) * skeleton.scaleY;
                            do {
                                if (bl) {
                                    this.xVelocity += (f11 - this.xOffset * f20) * f19;
                                    this.xOffset += this.xVelocity * f8;
                                    this.xVelocity *= f18;
                                }
                                if (!bl2) continue;
                                this.yVelocity -= (f10 + this.yOffset * f20) * f19;
                                this.yOffset += this.yVelocity * f8;
                                this.yVelocity *= f18;
                            } while ((f -= f8) >= f8);
                            this.xLag = this.xOffset - f15;
                            this.yLag = this.yOffset - f14;
                        }
                        f9 = Math.max(0.0f, 1.0f - f / f8);
                        if (bl) {
                            bonePose.worldX += (this.xOffset - this.xLag * f9) * f6 * ((PhysicsConstraintData)this.data).x;
                        }
                        if (bl2) {
                            bonePose.worldY += (this.yOffset - this.yLag * f9) * f6 * ((PhysicsConstraintData)this.data).y;
                        }
                    }
                    if (bl3 || bl4) {
                        float f23;
                        f15 = SpineUtils.atan2(bonePose.c, bonePose.a);
                        f12 = 0.0f;
                        f11 = this.cx - bonePose.worldX;
                        f10 = this.cy - bonePose.worldY;
                        if (f11 > f21) {
                            f11 = f21;
                        } else if (f11 < -f21) {
                            f11 = -f21;
                        }
                        if (f10 > f22) {
                            f10 = f22;
                        } else if (f10 < -f22) {
                            f10 = -f22;
                        }
                        if (bl3) {
                            f12 = (((PhysicsConstraintData)this.data).rotate + ((PhysicsConstraintData)this.data).shearX) * f6;
                            f9 = this.rotateLag * Math.max(0.0f, 1.0f - f4 / f8);
                            f23 = SpineUtils.atan2(f10 + this.ty, f11 + this.tx) - f15 - (this.rotateOffset - f9) * f12;
                            this.rotateOffset += (f23 - (float)Math.ceil(f23 * 0.15915494f - 0.5f) * ((float)Math.PI * 2)) * f16;
                            f23 = (this.rotateOffset - f9) * f12 + f15;
                            f14 = SpineUtils.cos(f23);
                            f13 = SpineUtils.sin(f23);
                            if (bl4 && (f23 = f7 * bonePose.getWorldScaleX()) > 0.0f) {
                                this.scaleOffset += (f11 * f14 + f10 * f13) * f16 / f23;
                            }
                        } else {
                            f14 = SpineUtils.cos(f15);
                            f13 = SpineUtils.sin(f15);
                            f23 = f7 * bonePose.getWorldScaleX() - this.scaleLag * Math.max(0.0f, 1.0f - f4 / f8);
                            if (f23 > 0.0f) {
                                this.scaleOffset += (f11 * f14 + f10 * f13) * f16 / f23;
                            }
                        }
                        f = this.remaining;
                        if (f >= f8) {
                            if (f18 == -1.0f) {
                                f18 = (float)Math.pow(physicsConstraintPose.damping, 60.0f * f8);
                                f19 = f8 * physicsConstraintPose.massInverse;
                                f20 = physicsConstraintPose.strength;
                            }
                            f23 = physicsConstraintPose.wind * skeleton.windX + physicsConstraintPose.gravity * skeleton.gravityX;
                            float f24 = physicsConstraintPose.wind * skeleton.windY + physicsConstraintPose.gravity * skeleton.gravityY;
                            float f25 = this.rotateOffset;
                            float f26 = this.scaleOffset;
                            float f27 = f7 / f17;
                            while (true) {
                                f -= f8;
                                if (bl4) {
                                    this.scaleVelocity += (f23 * f14 - f24 * f13 - this.scaleOffset * f20) * f19;
                                    this.scaleOffset += this.scaleVelocity * f8;
                                    this.scaleVelocity *= f18;
                                }
                                if (bl3) {
                                    this.rotateVelocity -= ((f23 * f13 + f24 * f14) * f27 + this.rotateOffset * f20) * f19;
                                    this.rotateOffset += this.rotateVelocity * f8;
                                    this.rotateVelocity *= f18;
                                    if (f < f8) break;
                                    float f28 = this.rotateOffset * f12 + f15;
                                    f14 = SpineUtils.cos(f28);
                                    f13 = SpineUtils.sin(f28);
                                    continue;
                                }
                                if (f < f8) break;
                            }
                            this.rotateLag = this.rotateOffset - f25;
                            this.scaleLag = this.scaleOffset - f26;
                        }
                        f9 = Math.max(0.0f, 1.0f - f / f8);
                    }
                    this.remaining = f;
                }
                this.cx = bonePose.worldX;
                this.cy = bonePose.worldY;
                break;
            }
            case pose: {
                f9 = Math.max(0.0f, 1.0f - this.remaining / f8);
                if (bl) {
                    bonePose.worldX += (this.xOffset - this.xLag * f9) * f6 * ((PhysicsConstraintData)this.data).x;
                }
                if (!bl2) break;
                bonePose.worldY += (this.yOffset - this.yLag * f9) * f6 * ((PhysicsConstraintData)this.data).y;
            }
        }
        if (bl3) {
            f5 = (this.rotateOffset - this.rotateLag * f9) * f6;
            if (((PhysicsConstraintData)this.data).shearX > 0.0f) {
                f = 0.0f;
                if (((PhysicsConstraintData)this.data).rotate > 0.0f) {
                    f = f5 * ((PhysicsConstraintData)this.data).rotate;
                    f4 = SpineUtils.sin(f);
                    f3 = SpineUtils.cos(f);
                    f2 = bonePose.b;
                    bonePose.b = f3 * f2 - f4 * bonePose.d;
                    bonePose.d = f4 * f2 + f3 * bonePose.d;
                }
                f4 = SpineUtils.sin(f += f5 * ((PhysicsConstraintData)this.data).shearX);
                f3 = SpineUtils.cos(f);
                f2 = bonePose.a;
                bonePose.a = f3 * f2 - f4 * bonePose.c;
                bonePose.c = f4 * f2 + f3 * bonePose.c;
            } else {
                f4 = SpineUtils.sin(f5 *= ((PhysicsConstraintData)this.data).rotate);
                f3 = SpineUtils.cos(f5);
                f2 = bonePose.a;
                bonePose.a = f3 * f2 - f4 * bonePose.c;
                bonePose.c = f4 * f2 + f3 * bonePose.c;
                f2 = bonePose.b;
                bonePose.b = f3 * f2 - f4 * bonePose.d;
                bonePose.d = f4 * f2 + f3 * bonePose.d;
            }
        }
        if (bl4) {
            f5 = 1.0f + (this.scaleOffset - this.scaleLag * f9) * f6 * ((PhysicsConstraintData)this.data).scaleX;
            bonePose.a *= f5;
            bonePose.c *= f5;
        }
        if (physics != Physics.pose) {
            this.tx = f7 * bonePose.a;
            this.ty = f7 * bonePose.c;
        }
        bonePose.modifyWorld(skeleton.update);
    }

    @Override
    void sort(Skeleton skeleton) {
        Bone bone = this.bone.bone;
        skeleton.sortBone(bone);
        skeleton.updateCache.add(this);
        skeleton.sortReset(bone.children);
        skeleton.constrained(bone);
    }

    @Override
    boolean isSourceActive() {
        return this.bone.bone.active;
    }
}

