/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Constraint;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.Physics;
import com.esotericsoftware.spine.PhysicsConstraint;
import com.esotericsoftware.spine.Posed;
import com.esotericsoftware.spine.PosedActive;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.SlotPose;
import com.esotericsoftware.spine.Update;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class Skeleton {
    private static final short[] quadTriangles = new short[]{0, 1, 2, 2, 3, 0};
    final SkeletonData data;
    final Array<Bone> bones;
    final Array<Slot> slots;
    Array<Slot> drawOrder;
    final Array<Constraint> constraints;
    final Array<PhysicsConstraint> physics;
    final Array updateCache = new Array();
    final Array<Posed> resetCache = new Array(true, 16, Posed[]::new);
    Skin skin;
    final Color color;
    float x;
    float y;
    float scaleX = 1.0f;
    float scaleY = 1.0f;
    float time;
    float windX = 1.0f;
    float windY = 0.0f;
    float gravityX = 0.0f;
    float gravityY = 1.0f;
    int update;

    public Skeleton(SkeletonData skeletonData) {
        PosedActive posedActive;
        Posed posed;
        if (skeletonData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = skeletonData;
        this.bones = new Array(true, skeletonData.bones.size, Bone[]::new);
        Bone[] boneArray = (Bone[])this.bones.items;
        for (BoneData posedData : skeletonData.bones) {
            if (posedData.parent == null) {
                posed = new Bone(posedData, null);
            } else {
                posedActive = boneArray[posedData.parent.index];
                posed = new Bone(posedData, (Bone)posedActive);
                posedActive.children.add((Bone)posed);
            }
            this.bones.add((Bone)posed);
        }
        this.slots = new Array(true, skeletonData.slots.size, Slot[]::new);
        this.drawOrder = new Array(true, skeletonData.slots.size, Slot[]::new);
        for (SlotData slotData : skeletonData.slots) {
            posed = new Slot(slotData, this);
            this.slots.add((Slot)posed);
            this.drawOrder.add((Slot)posed);
        }
        this.physics = new Array(true, 8, PhysicsConstraint[]::new);
        this.constraints = new Array(true, skeletonData.constraints.size, Constraint[]::new);
        for (ConstraintData constraintData : skeletonData.constraints) {
            posed = constraintData.create(this);
            if (posed instanceof PhysicsConstraint) {
                posedActive = (PhysicsConstraint)posed;
                this.physics.add((PhysicsConstraint)posedActive);
            }
            this.constraints.add((Constraint)posed);
        }
        this.physics.shrink();
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.updateCache();
    }

    public void updateCache() {
        PosedActive posedActive;
        int n;
        int n2;
        this.updateCache.clear();
        this.resetCache.clear();
        Slot[] slotArray = (Slot[])this.slots.items;
        int n3 = this.slots.size;
        for (n2 = 0; n2 < n3; ++n2) {
            slotArray[n2].pose();
        }
        n2 = this.bones.size;
        Bone[] boneArray = (Bone[])this.bones.items;
        for (int i = 0; i < n2; ++i) {
            Bone bone = boneArray[i];
            bone.sorted = ((BoneData)bone.data).skinRequired;
            bone.active = !bone.sorted;
            bone.pose();
        }
        if (this.skin != null) {
            BoneData[] boneDataArray = (BoneData[])this.skin.bones.items;
            n = this.skin.bones.size;
            for (int i = 0; i < n; ++i) {
                posedActive = boneArray[boneDataArray[i].index];
                do {
                    ((Bone)posedActive).sorted = false;
                    ((Bone)posedActive).active = true;
                } while ((posedActive = ((Bone)posedActive).parent) != null);
            }
        }
        Constraint[] constraintArray = (Constraint[])this.constraints.items;
        int n4 = this.constraints.size;
        for (n = 0; n < n4; ++n) {
            constraintArray[n].pose();
        }
        for (n = 0; n < n4; ++n) {
            posedActive = constraintArray[n];
            boolean bl = ((Constraint)posedActive).active = ((Constraint)posedActive).isSourceActive() && (!((ConstraintData)((Constraint)posedActive).data).skinRequired || this.skin != null && this.skin.constraints.contains((ConstraintData)((Constraint)posedActive).data, true));
            if (!((Constraint)posedActive).active) continue;
            ((Constraint)posedActive).sort(this);
        }
        for (n = 0; n < n2; ++n) {
            this.sortBone(boneArray[n]);
        }
        T[] TArray = this.updateCache.items;
        n4 = this.updateCache.size;
        for (int i = 0; i < n4; ++i) {
            Object t = TArray[i];
            if (!(t instanceof Bone)) continue;
            posedActive = (Bone)t;
            TArray[i] = ((Bone)posedActive).applied;
        }
    }

    void constrained(Posed posed) {
        if (posed.pose == posed.applied) {
            posed.constrained();
            this.resetCache.add(posed);
        }
    }

    void sortBone(Bone bone) {
        if (bone.sorted || !bone.active) {
            return;
        }
        Bone bone2 = bone.parent;
        if (bone2 != null) {
            this.sortBone(bone2);
        }
        bone.sorted = true;
        this.updateCache.add(bone);
    }

    void sortReset(Array<Bone> array) {
        Bone[] boneArray = (Bone[])array.items;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Bone bone = boneArray[i];
            if (!bone.active) continue;
            if (bone.sorted) {
                this.sortReset(bone.children);
            }
            bone.sorted = false;
        }
    }

    public void updateWorldTransform(Physics physics) {
        ++this.update;
        Posed[] posedArray = (Posed[])this.resetCache.items;
        int n = this.resetCache.size;
        for (int i = 0; i < n; ++i) {
            posedArray[i].reset();
        }
        T[] TArray = this.updateCache.items;
        int n2 = this.updateCache.size;
        for (n = 0; n < n2; ++n) {
            ((Update)TArray[n]).update(this, physics);
        }
    }

    public void setupPose() {
        this.setupPoseBones();
        this.setupPoseSlots();
    }

    public void setupPoseBones() {
        Bone[] boneArray = (Bone[])this.bones.items;
        int n = this.bones.size;
        for (int i = 0; i < n; ++i) {
            boneArray[i].setupPose();
        }
        Constraint[] constraintArray = (Constraint[])this.constraints.items;
        int n2 = this.constraints.size;
        for (n = 0; n < n2; ++n) {
            constraintArray[n].setupPose();
        }
    }

    public void setupPoseSlots() {
        Slot[] slotArray = (Slot[])this.slots.items;
        int n = this.slots.size;
        SpineUtils.arraycopy(slotArray, 0, this.drawOrder.items, 0, n);
        for (int i = 0; i < n; ++i) {
            slotArray[i].setupPose();
        }
    }

    public Array<Bone> getBones() {
        return this.bones;
    }

    public void setSkin(String string) {
        Skin skin = this.data.findSkin(string);
        if (skin == null) {
            throw new IllegalArgumentException("Skin not found: " + string);
        }
        this.setSkin(skin);
    }

    public void setSkin(Skin skin) {
        if (skin == this.skin) {
            return;
        }
        if (skin != null) {
            if (this.skin != null) {
                skin.attachAll(this, this.skin);
            } else {
                Slot[] slotArray = (Slot[])this.slots.items;
                int n = this.slots.size;
                for (int i = 0; i < n; ++i) {
                    Attachment attachment;
                    Slot slot = slotArray[i];
                    String string = ((SlotData)slot.data).attachmentName;
                    if (string == null || (attachment = skin.getAttachment(i, string)) == null) continue;
                    ((SlotPose)slot.pose).setAttachment(attachment);
                }
            }
        }
        this.skin = skin;
        this.updateCache();
    }

    public Attachment getAttachment(int n, String string) {
        Attachment attachment;
        if (string == null) {
            throw new IllegalArgumentException("attachmentName cannot be null.");
        }
        if (this.skin != null && (attachment = this.skin.getAttachment(n, string)) != null) {
            return attachment;
        }
        if (this.data.defaultSkin != null) {
            return this.data.defaultSkin.getAttachment(n, string);
        }
        return null;
    }

    public void setScale(float f, float f2) {
        this.scaleX = f;
        this.scaleY = f2;
    }

    public void update(float f) {
        this.time += f;
    }

    public String toString() {
        return this.data.name != null ? this.data.name : super.toString();
    }
}

