/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DataInput;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.BoneLocal;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.IkConstraintPose;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.PathConstraintPose;
import com.esotericsoftware.spine.PhysicsConstraintData;
import com.esotericsoftware.spine.PhysicsConstraintPose;
import com.esotericsoftware.spine.PosedData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonLoader;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SliderData;
import com.esotericsoftware.spine.SliderPose;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.SlotPose;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.TransformConstraintPose;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.Sequence;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SkeletonBinary
extends SkeletonLoader {
    private final Array<LinkedMesh> linkedMeshes = new Array(true, 8, LinkedMesh[]::new);

    public SkeletonBinary(TextureAtlas textureAtlas) {
        super(textureAtlas);
    }

    @Override
    public SkeletonData readSkeletonData(FileHandle fileHandle) {
        if (fileHandle == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        try {
            SkeletonData skeletonData = this.readSkeletonData(fileHandle.read());
            skeletonData.name = fileHandle.nameWithoutExtension();
            return skeletonData;
        }
        catch (Throwable throwable) {
            throw new SerializationException("Error reading binary skeleton file: " + fileHandle, throwable);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SkeletonData readSkeletonData(InputStream var1_1) {
        block97: {
            if (var1_1 == null) {
                throw new IllegalArgumentException("dataInput cannot be null.");
            }
            var2_2 = this.scale;
            var3_3 = new SkeletonInput(var1_1);
            var4_4 = new SkeletonData();
            var5_5 = null;
            try {
                var6_6 = var3_3.readLong();
                var4_4.hash = var6_6 == 0L ? null : Long.toString(var6_6);
                var4_4.version = var3_3.readString();
                if (var4_4.version.isEmpty()) {
                    var4_4.version = null;
                }
                var5_5 = var4_4.version;
                var4_4.x = var3_3.readFloat();
                var4_4.y = var3_3.readFloat();
                var4_4.width = var3_3.readFloat();
                var4_4.height = var3_3.readFloat();
                var4_4.referenceScale = var3_3.readFloat() * var2_2;
                var8_9 = var3_3.readBoolean();
                if (var8_9) {
                    var4_4.fps = var3_3.readFloat();
                    var4_4.imagesPath = var3_3.readString();
                    var4_4.audioPath = var3_3.readString();
                }
                var9_10 = var3_3.readInt(true);
                var3_3.strings = new String[var9_10];
                var10_11 = var3_3.strings;
                for (var11_12 = 0; var11_12 < var9_10; ++var11_12) {
                    var10_11[var11_12] = var3_3.readString();
                }
                var9_10 = var3_3.readInt(true);
                var11_13 = var4_4.bones.setSize(var9_10);
                for (var12_14 = 0; var12_14 < var9_10; ++var12_14) {
                    var13_16 = var3_3.readString();
                    var14_18 = var12_14 == 0 ? null : var11_13[var3_3.readInt(true)];
                    var15_19 = new BoneData(var12_14, var13_16, (BoneData)var14_18);
                    var16_22 = (BoneLocal)var15_19.setup;
                    var16_22.rotation = var3_3.readFloat();
                    var16_22.x = var3_3.readFloat() * var2_2;
                    var16_22.y = var3_3.readFloat() * var2_2;
                    var16_22.scaleX = var3_3.readFloat();
                    var16_22.scaleY = var3_3.readFloat();
                    var16_22.shearX = var3_3.readFloat();
                    var16_22.shearY = var3_3.readFloat();
                    var16_22.inherit = BoneData.Inherit.values[var3_3.readByte()];
                    var15_19.length = var3_3.readFloat() * var2_2;
                    var15_19.skinRequired = var3_3.readBoolean();
                    if (var8_9) {
                        Color.rgba8888ToColor(var15_19.color, var3_3.readInt());
                        var15_19.icon = var3_3.readString();
                        var15_19.visible = var3_3.readBoolean();
                    }
                    var11_13[var12_14] = var15_19;
                }
                var9_10 = var3_3.readInt(true);
                var12_15 = var4_4.slots.setSize(var9_10);
                for (var13_17 = 0; var13_17 < var9_10; ++var13_17) {
                    var14_18 = var3_3.readString();
                    var15_19 = var11_13[var3_3.readInt(true)];
                    var16_22 = new SlotData(var13_17, (String)var14_18, var15_19);
                    Color.rgba8888ToColor(((SlotPose)var16_22.setup).color, var3_3.readInt());
                    var17_25 = var3_3.readInt();
                    if (var17_25 != -1) {
                        ((SlotPose)var16_22.setup).darkColor = new Color();
                        Color.rgb888ToColor(((SlotPose)var16_22.setup).darkColor, var17_25);
                    }
                    var16_22.attachmentName = var3_3.readStringRef();
                    var16_22.blendMode = BlendMode.values[var3_3.readInt(true)];
                    if (var8_9) {
                        var16_22.visible = var3_3.readBoolean();
                    }
                    var12_15[var13_17] = var16_22;
                }
                var13_17 = var3_3.readInt(true);
                var14_18 = var4_4.constraints.setSize(var13_17);
                block43: for (var15_20 = 0; var15_20 < var13_17; ++var15_20) {
                    var16_22 = var3_3.readString();
                    switch (var3_3.readByte()) {
                        case 0: {
                            var18_27 = new IkConstraintData((String)var16_22);
                            var17_25 = var3_3.readInt(true);
                            var19_31 = var18_27.bones.setSize(var17_25);
                            for (var20_38 = 0; var20_38 < var17_25; ++var20_38) {
                                var19_31[var20_38] = var11_13[var3_3.readInt(true)];
                            }
                            var18_27.target = var11_13[var3_3.readInt(true)];
                            var20_38 = var3_3.read();
                            var18_27.skinRequired = (var20_38 & 1) != 0;
                            var18_27.uniform = (var20_38 & 2) != 0;
                            var21_45 = (IkConstraintPose)var18_27.setup;
                            var21_45.bendDirection = (var20_38 & 4) != 0 ? -1 : 1;
                            var21_45.compress = (var20_38 & 8) != 0;
                            v0 = var21_45.stretch = (var20_38 & 16) != 0;
                            if ((var20_38 & 32) != 0) {
                                v1 = var21_45.mix = (var20_38 & 64) != 0 ? var3_3.readFloat() : 1.0f;
                            }
                            if ((var20_38 & 128) != 0) {
                                var21_45.softness = var3_3.readFloat() * var2_2;
                            }
                            var14_18[var15_20] = var18_27;
                            continue block43;
                        }
                        case 2: {
                            var18_27 = new TransformConstraintData((String)var16_22);
                            var17_25 = var3_3.readInt(true);
                            var19_32 = var18_27.bones.setSize(var17_25);
                            for (var20_39 = 0; var20_39 < var17_25; ++var20_39) {
                                var19_32[var20_39] = var11_13[var3_3.readInt(true)];
                            }
                            var18_27.source = var11_13[var3_3.readInt(true)];
                            var20_39 = var3_3.read();
                            var18_27.skinRequired = (var20_39 & 1) != 0;
                            var18_27.localSource = (var20_39 & 2) != 0;
                            var18_27.localTarget = (var20_39 & 4) != 0;
                            var18_27.additive = (var20_39 & 8) != 0;
                            var18_27.clamp = (var20_39 & 16) != 0;
                            var17_25 = var20_39 >> 5;
                            var21_46 = var18_27.properties.setSize(var17_25);
                            var22_50 = 0;
lbl113:
                            // 2 sources

                            while (true) {
                                if (var22_50 < var17_25) {
                                    var24_52 = 1.0f;
                                    switch (var3_3.readByte()) {
                                        case 0: {
                                            v2 /* !! */  = new TransformConstraintData.FromRotate();
                                            break;
                                        }
                                        case 1: {
                                            var24_52 = var2_2;
                                            v2 /* !! */  = new TransformConstraintData.FromX();
                                            break;
                                        }
                                        case 2: {
                                            var24_52 = var2_2;
                                            v2 /* !! */  = new TransformConstraintData.FromY();
                                            break;
                                        }
                                        case 3: {
                                            v2 /* !! */  = new TransformConstraintData.FromScaleX();
                                            break;
                                        }
                                        case 4: {
                                            v2 /* !! */  = new TransformConstraintData.FromScaleY();
                                            break;
                                        }
                                        case 5: {
                                            v2 /* !! */  = new TransformConstraintData.FromShearY();
                                            break;
                                        }
                                        default: {
                                            v2 /* !! */  = null;
                                        }
                                    }
                                    var25_53 /* !! */  = v2 /* !! */ ;
                                    var25_53 /* !! */ .offset = var3_3.readFloat() * var24_52;
                                    var23_51 = var3_3.readByte();
                                    var26_54 = var25_53 /* !! */ .to.setSize(var23_51);
                                    break block97;
                                }
                                var20_39 = var3_3.read();
                                if ((var20_39 & 1) != 0) {
                                    var18_27.offsets[0] = var3_3.readFloat();
                                }
                                if ((var20_39 & 2) != 0) {
                                    var18_27.offsets[1] = var3_3.readFloat() * var2_2;
                                }
                                if ((var20_39 & 4) != 0) {
                                    var18_27.offsets[2] = var3_3.readFloat() * var2_2;
                                }
                                if ((var20_39 & 8) != 0) {
                                    var18_27.offsets[3] = var3_3.readFloat();
                                }
                                if ((var20_39 & 16) != 0) {
                                    var18_27.offsets[4] = var3_3.readFloat();
                                }
                                if ((var20_39 & 32) != 0) {
                                    var18_27.offsets[5] = var3_3.readFloat();
                                }
                                var20_39 = var3_3.read();
                                var22_49 = (TransformConstraintPose)var18_27.setup;
                                if ((var20_39 & 1) != 0) {
                                    var22_49.mixRotate = var3_3.readFloat();
                                }
                                if ((var20_39 & 2) != 0) {
                                    var22_49.mixX = var3_3.readFloat();
                                }
                                if ((var20_39 & 4) != 0) {
                                    var22_49.mixY = var3_3.readFloat();
                                }
                                if ((var20_39 & 8) != 0) {
                                    var22_49.mixScaleX = var3_3.readFloat();
                                }
                                if ((var20_39 & 16) != 0) {
                                    var22_49.mixScaleY = var3_3.readFloat();
                                }
                                if ((var20_39 & 32) != 0) {
                                    var22_49.mixShearY = var3_3.readFloat();
                                }
                                var14_18[var15_20] = var18_27;
                                continue block43;
                                break;
                            }
                        }
                        case 1: {
                            var18_27 = new PathConstraintData((String)var16_22);
                            var17_25 = var3_3.readInt(true);
                            var19_33 = var18_27.bones.setSize(var17_25);
                            for (var20_40 = 0; var20_40 < var17_25; ++var20_40) {
                                var19_33[var20_40] = var11_13[var3_3.readInt(true)];
                            }
                            var18_27.slot = var12_15[var3_3.readInt(true)];
                            var20_40 = var3_3.read();
                            var18_27.skinRequired = (var20_40 & 1) != 0;
                            var18_27.positionMode = PathConstraintData.PositionMode.values[var20_40 >> 1 & 2];
                            var18_27.spacingMode = PathConstraintData.SpacingMode.values[var20_40 >> 2 & 3];
                            var18_27.rotateMode = PathConstraintData.RotateMode.values[var20_40 >> 4 & 3];
                            if ((var20_40 & 128) != 0) {
                                var18_27.offsetRotation = var3_3.readFloat();
                            }
                            var21_47 = (PathConstraintPose)var18_27.setup;
                            var21_47.position = var3_3.readFloat();
                            if (var18_27.positionMode == PathConstraintData.PositionMode.fixed) {
                                var21_47.position *= var2_2;
                            }
                            var21_47.spacing = var3_3.readFloat();
                            if (var18_27.spacingMode == PathConstraintData.SpacingMode.length || var18_27.spacingMode == PathConstraintData.SpacingMode.fixed) {
                                var21_47.spacing *= var2_2;
                            }
                            var21_47.mixRotate = var3_3.readFloat();
                            var21_47.mixX = var3_3.readFloat();
                            var21_47.mixY = var3_3.readFloat();
                            var14_18[var15_20] = var18_27;
                            continue block43;
                        }
                        case 3: {
                            var18_27 = new PhysicsConstraintData((String)var16_22);
                            var18_27.bone = var11_13[var3_3.readInt(true)];
                            var19_34 = var3_3.read();
                            v3 = var18_27.skinRequired = (var19_34 & 1) != 0;
                            if ((var19_34 & 2) != 0) {
                                var18_27.x = var3_3.readFloat();
                            }
                            if ((var19_34 & 4) != 0) {
                                var18_27.y = var3_3.readFloat();
                            }
                            if ((var19_34 & 8) != 0) {
                                var18_27.rotate = var3_3.readFloat();
                            }
                            if ((var19_34 & 16) != 0) {
                                var18_27.scaleX = var3_3.readFloat();
                            }
                            if ((var19_34 & 32) != 0) {
                                var18_27.shearX = var3_3.readFloat();
                            }
                            var18_27.limit = ((var19_34 & 64) != 0 ? var3_3.readFloat() : 5000.0f) * var2_2;
                            var18_27.step = 1.0f / (float)var3_3.readUnsignedByte();
                            var20_41 = (PhysicsConstraintPose)var18_27.setup;
                            var20_41.inertia = var3_3.readFloat();
                            var20_41.strength = var3_3.readFloat();
                            var20_41.damping = var3_3.readFloat();
                            var20_41.massInverse = (var19_34 & 128) != 0 ? var3_3.readFloat() : 1.0f;
                            var20_41.wind = var3_3.readFloat();
                            var20_41.gravity = var3_3.readFloat();
                            var19_34 = var3_3.read();
                            if ((var19_34 & 1) != 0) {
                                var18_27.inertiaGlobal = true;
                            }
                            if ((var19_34 & 2) != 0) {
                                var18_27.strengthGlobal = true;
                            }
                            if ((var19_34 & 4) != 0) {
                                var18_27.dampingGlobal = true;
                            }
                            if ((var19_34 & 8) != 0) {
                                var18_27.massGlobal = true;
                            }
                            if ((var19_34 & 16) != 0) {
                                var18_27.windGlobal = true;
                            }
                            if ((var19_34 & 32) != 0) {
                                var18_27.gravityGlobal = true;
                            }
                            if ((var19_34 & 64) != 0) {
                                var18_27.mixGlobal = true;
                            }
                            var20_41.mix = (var19_34 & 128) != 0 ? var3_3.readFloat() : 1.0f;
                            var14_18[var15_20] = var18_27;
                            continue block43;
                        }
                        case 4: {
                            var18_27 = new SliderData((String)var16_22);
                            var19_35 = var3_3.read();
                            var18_27.skinRequired = (var19_35 & 1) != 0;
                            var18_27.loop = (var19_35 & 2) != 0;
                            v4 = var18_27.additive = (var19_35 & 4) != 0;
                            if ((var19_35 & 8) != 0) {
                                ((SliderPose)var18_27.setup).time = var3_3.readFloat();
                            }
                            if ((var19_35 & 16) != 0) {
                                v5 = ((SliderPose)var18_27.setup).mix = (var19_35 & 32) != 0 ? var3_3.readFloat() : 1.0f;
                            }
                            if ((var19_35 & 64) != 0) {
                                var18_27.local = (var19_35 & 128) != 0;
                                var18_27.bone = var11_13[var3_3.readInt(true)];
                                var20_42 = var3_3.readFloat();
                                var21_48 = 1.0f;
                                switch (var3_3.readByte()) {
                                    case 0: {
                                        v6 /* !! */  = new TransformConstraintData.FromRotate();
                                        break;
                                    }
                                    case 1: {
                                        var21_48 = var2_2;
                                        v6 /* !! */  = new TransformConstraintData.FromX();
                                        break;
                                    }
                                    case 2: {
                                        var21_48 = var2_2;
                                        v6 /* !! */  = new TransformConstraintData.FromY();
                                        break;
                                    }
                                    case 3: {
                                        v6 /* !! */  = new TransformConstraintData.FromScaleX();
                                        break;
                                    }
                                    case 4: {
                                        v6 /* !! */  = new TransformConstraintData.FromScaleY();
                                        break;
                                    }
                                    case 5: {
                                        v6 /* !! */  = new TransformConstraintData.FromShearY();
                                        break;
                                    }
                                    default: {
                                        v6 /* !! */  = null;
                                    }
                                }
                                var18_27.property = v6 /* !! */ ;
                                var18_27.property.offset = var20_42 * var21_48;
                                var18_27.offset = var3_3.readFloat();
                                var18_27.scale = var3_3.readFloat() / var21_48;
                            }
                            var14_18[var15_20] = var18_27;
                            continue block43;
                        }
                    }
                }
                var15_21 = this.readSkin(var3_3, var4_4, true, var8_9);
                if (var15_21 != null) {
                    var4_4.defaultSkin = var15_21;
                    var4_4.skins.add(var15_21);
                }
                var9_10 = var16_23 + var3_3.readInt(true);
                var10_11 = var4_4.skins.setSize(var9_10);
                for (var16_23 = var4_4.skins.size; var16_23 < var9_10; ++var16_23) {
                    var10_11[var16_23] = this.readSkin(var3_3, var4_4, false, var8_9);
                }
                var9_10 = this.linkedMeshes.size;
                var16_24 = (LinkedMesh[])this.linkedMeshes.items;
                for (var17_25 = 0; var17_25 < var9_10; ++var17_25) {
                    var18_27 = var16_24[var17_25];
                    var19_36 = ((Skin[])var4_4.skins.items)[var18_27.skinIndex];
                    var20_43 = var19_36.getAttachment(var18_27.slotIndex, var18_27.parent);
                    if (var20_43 == null) {
                        throw new SerializationException("Parent mesh not found: " + var18_27.parent);
                    }
                    var18_27.mesh.setTimelineAttachment(var18_27.inheritTimelines != false ? (VertexAttachment)var20_43 : var18_27.mesh);
                    var18_27.mesh.setParentMesh((MeshAttachment)var20_43);
                    if (var18_27.mesh.getRegion() != null) continue;
                    var18_27.mesh.updateRegion();
                }
                this.linkedMeshes.clear();
                var9_10 = var3_3.readInt(true);
                var10_11 = var4_4.events.setSize(var9_10);
                for (var17_25 = 0; var17_25 < var9_10; ++var17_25) {
                    var18_27 = new EventData(var3_3.readString());
                    var18_27.intValue = var3_3.readInt(false);
                    var18_27.floatValue = var3_3.readFloat();
                    var18_27.stringValue = var3_3.readString();
                    var18_27.audioPath = var3_3.readString();
                    if (var18_27.audioPath != null) {
                        var18_27.volume = var3_3.readFloat();
                        var18_27.balance = var3_3.readFloat();
                    }
                    var10_11[var17_25] = var18_27;
                }
                var9_10 = var3_3.readInt(true);
                var17_26 = var4_4.animations.setSize(var9_10);
                for (var18_28 = 0; var18_28 < var9_10; ++var18_28) {
                    var17_26[var18_28] = this.readAnimation(var3_3, var3_3.readString(), var4_4);
                }
                for (var19_37 = 0; var19_37 < var13_17; ++var19_37) {
                    var20_44 = var14_18[var19_37];
                    if (!(var20_44 instanceof SliderData)) continue;
                    var18_30 = (SliderData)var20_44;
                    var18_30.animation = var17_26[var3_3.readInt(true)];
                }
                return var4_4;
            }
            catch (Throwable var6_8) {
                if (var5_5 == null) throw new SerializationException("Error binary skeleton data.", var6_8);
                throw new SerializationException("Error reading binary skeleton data, version: " + var5_5, var6_8);
            }
            finally {
                try {
                    var3_3.close();
                }
                catch (IOException var6_7) {}
            }
        }
        for (var27_55 = 0; var27_55 < var23_51; ++var27_55) {
            var28_56 = 1.0f;
            switch (var3_3.readByte()) {
                case 0: {
                    v7 /* !! */  = new TransformConstraintData.ToRotate();
                    break;
                }
                case 1: {
                    var28_56 = var2_2;
                    v7 /* !! */  = new TransformConstraintData.ToX();
                    break;
                }
                case 2: {
                    var28_56 = var2_2;
                    v7 /* !! */  = new TransformConstraintData.ToY();
                    break;
                }
                case 3: {
                    v7 /* !! */  = new TransformConstraintData.ToScaleX();
                    break;
                }
                case 4: {
                    v7 /* !! */  = new TransformConstraintData.ToScaleY();
                    break;
                }
                case 5: {
                    v7 /* !! */  = new TransformConstraintData.ToShearY();
                    break;
                }
                default: {
                    v7 /* !! */  = null;
                }
            }
            var29_57 /* !! */  = v7 /* !! */ ;
            var29_57 /* !! */ .offset = var3_3.readFloat() * var28_56;
            var29_57 /* !! */ .max = var3_3.readFloat() * var28_56;
            var29_57 /* !! */ .scale = var3_3.readFloat() * var28_56 / var24_52;
            var26_54[var27_55] = var29_57 /* !! */ ;
        }
        var21_46[var22_50] = var25_53 /* !! */ ;
        ++var22_50;
        ** while (true)
    }

    private Skin readSkin(SkeletonInput skeletonInput, SkeletonData skeletonData, boolean bl, boolean bl2) throws IOException {
        int n;
        int n2;
        Skin skin;
        int n3;
        if (bl) {
            n3 = skeletonInput.readInt(true);
            if (n3 == 0) {
                return null;
            }
            skin = new Skin("default");
        } else {
            skin = new Skin(skeletonInput.readString());
            if (bl2) {
                Color.rgba8888ToColor(skin.color, skeletonInput.readInt());
            }
            T[] TArray = skeletonData.bones.items;
            n2 = skeletonInput.readInt(true);
            PosedData[] posedDataArray = skin.bones.setSize(n2);
            for (n = 0; n < n2; ++n) {
                posedDataArray[n] = TArray[skeletonInput.readInt(true)];
            }
            TArray = skeletonData.constraints.items;
            n2 = skeletonInput.readInt(true);
            posedDataArray = skin.constraints.setSize(n2);
            for (n = 0; n < n2; ++n) {
                posedDataArray[n] = TArray[skeletonInput.readInt(true)];
            }
            n3 = skeletonInput.readInt(true);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = skeletonInput.readInt(true);
            n = skeletonInput.readInt(true);
            for (int i = 0; i < n; ++i) {
                String string = skeletonInput.readStringRef();
                Attachment attachment = this.readAttachment(skeletonInput, skeletonData, skin, n4, string, bl2);
                if (attachment == null) continue;
                skin.setAttachment(n4, string, attachment);
            }
        }
        return skin;
    }

    private Attachment readAttachment(SkeletonInput skeletonInput, SkeletonData skeletonData, Skin skin, int n, String string, boolean bl) throws IOException {
        float f = this.scale;
        byte by = skeletonInput.readByte();
        String string2 = (by & 8) != 0 ? skeletonInput.readStringRef() : string;
        return switch (AttachmentType.values[by & 7]) {
            case AttachmentType.region -> {
                RegionAttachment var20_58;
                String var10_10 = (by & 0x10) != 0 ? skeletonInput.readStringRef() : null;
                int var11_17 = (by & 0x20) != 0 ? skeletonInput.readInt() : -1;
                Sequence var12_24 = (by & 0x40) != 0 ? this.readSequence(skeletonInput) : null;
                float var13_31 = (by & 0x80) != 0 ? skeletonInput.readFloat() : 0.0f;
                float var14_37 = skeletonInput.readFloat();
                float var15_42 = skeletonInput.readFloat();
                float var16_47 = skeletonInput.readFloat();
                float var17_50 = skeletonInput.readFloat();
                float var18_53 = skeletonInput.readFloat();
                float var19_56 = skeletonInput.readFloat();
                if (var10_10 == null) {
                    var10_10 = string2;
                }
                if ((var20_58 = this.attachmentLoader.newRegionAttachment(skin, string2, var10_10, var12_24)) == null) {
                    yield null;
                }
                var20_58.setPath(var10_10);
                var20_58.setX(var14_37 * f);
                var20_58.setY(var15_42 * f);
                var20_58.setScaleX(var16_47);
                var20_58.setScaleY(var17_50);
                var20_58.setRotation(var13_31);
                var20_58.setWidth(var18_53 * f);
                var20_58.setHeight(var19_56 * f);
                Color.rgba8888ToColor(var20_58.getColor(), var11_17);
                var20_58.setSequence(var12_24);
                if (var20_58.getRegion() != null) {
                    var20_58.updateRegion();
                }
                yield var20_58;
            }
            case AttachmentType.boundingbox -> {
                Vertices var10_11 = this.readVertices(skeletonInput, (by & 0x10) != 0);
                int var11_18 = bl ? skeletonInput.readInt() : 0;
                BoundingBoxAttachment var12_25 = this.attachmentLoader.newBoundingBoxAttachment(skin, string2);
                if (var12_25 == null) {
                    yield null;
                }
                var12_25.setWorldVerticesLength(var10_11.length);
                var12_25.setVertices(var10_11.vertices);
                var12_25.setBones(var10_11.bones);
                if (bl) {
                    Color.rgba8888ToColor(var12_25.getColor(), var11_18);
                }
                yield var12_25;
            }
            case AttachmentType.mesh -> {
                MeshAttachment var20_59;
                String var10_12 = (by & 0x10) != 0 ? skeletonInput.readStringRef() : string2;
                int var11_19 = (by & 0x20) != 0 ? skeletonInput.readInt() : -1;
                Sequence var12_26 = (by & 0x40) != 0 ? this.readSequence(skeletonInput) : null;
                int var13_32 = skeletonInput.readInt(true);
                Vertices var14_38 = this.readVertices(skeletonInput, (by & 0x80) != 0);
                float[] var15_43 = this.readFloatArray(skeletonInput, var14_38.length, 1.0f);
                short[] var16_48 = this.readShortArray(skeletonInput, (var14_38.length - var13_32 - 2) * 3);
                short[] var17_51 = null;
                float var18_54 = 0.0f;
                float var19_57 = 0.0f;
                if (bl) {
                    var17_51 = this.readShortArray(skeletonInput, skeletonInput.readInt(true));
                    var18_54 = skeletonInput.readFloat();
                    var19_57 = skeletonInput.readFloat();
                }
                if ((var20_59 = this.attachmentLoader.newMeshAttachment(skin, string2, var10_12, var12_26)) == null) {
                    yield null;
                }
                var20_59.setPath(var10_12);
                Color.rgba8888ToColor(var20_59.getColor(), var11_19);
                var20_59.setBones(var14_38.bones);
                var20_59.setVertices(var14_38.vertices);
                var20_59.setWorldVerticesLength(var14_38.length);
                var20_59.setTriangles(var16_48);
                var20_59.setRegionUVs(var15_43);
                if (var20_59.getRegion() != null) {
                    var20_59.updateRegion();
                }
                var20_59.setHullLength(var13_32 << 1);
                var20_59.setSequence(var12_26);
                if (bl) {
                    var20_59.setEdges(var17_51);
                    var20_59.setWidth(var18_54 * f);
                    var20_59.setHeight(var19_57 * f);
                }
                yield var20_59;
            }
            case AttachmentType.linkedmesh -> {
                MeshAttachment var18_55;
                String var10_13 = (by & 0x10) != 0 ? skeletonInput.readStringRef() : string2;
                int var11_20 = (by & 0x20) != 0 ? skeletonInput.readInt() : -1;
                Sequence var12_27 = (by & 0x40) != 0 ? this.readSequence(skeletonInput) : null;
                boolean var13_33 = (by & 0x80) != 0;
                int var14_39 = skeletonInput.readInt(true);
                String var15_44 = skeletonInput.readStringRef();
                float var16_49 = 0.0f;
                float var17_52 = 0.0f;
                if (bl) {
                    var16_49 = skeletonInput.readFloat();
                    var17_52 = skeletonInput.readFloat();
                }
                if ((var18_55 = this.attachmentLoader.newMeshAttachment(skin, string2, var10_13, var12_27)) == null) {
                    yield null;
                }
                var18_55.setPath(var10_13);
                Color.rgba8888ToColor(var18_55.getColor(), var11_20);
                var18_55.setSequence(var12_27);
                if (bl) {
                    var18_55.setWidth(var16_49 * f);
                    var18_55.setHeight(var17_52 * f);
                }
                this.linkedMeshes.add(new LinkedMesh(var18_55, var14_39, n, var15_44, var13_33));
                yield var18_55;
            }
            case AttachmentType.path -> {
                int var14_40;
                boolean var10_14 = (by & 0x10) != 0;
                boolean var11_21 = (by & 0x20) != 0;
                Vertices var12_28 = this.readVertices(skeletonInput, (by & 0x40) != 0);
                float[] var13_34 = new float[var12_28.length / 6];
                int var15_45 = var13_34.length;
                for (var14_40 = 0; var14_40 < var15_45; ++var14_40) {
                    var13_34[var14_40] = skeletonInput.readFloat() * f;
                }
                var14_40 = bl ? skeletonInput.readInt() : 0;
                PathAttachment var15_46 = this.attachmentLoader.newPathAttachment(skin, string2);
                if (var15_46 == null) {
                    yield null;
                }
                var15_46.setClosed(var10_14);
                var15_46.setConstantSpeed(var11_21);
                var15_46.setWorldVerticesLength(var12_28.length);
                var15_46.setVertices(var12_28.vertices);
                var15_46.setBones(var12_28.bones);
                var15_46.setLengths(var13_34);
                if (bl) {
                    Color.rgba8888ToColor(var15_46.getColor(), var14_40);
                }
                yield var15_46;
            }
            case AttachmentType.point -> {
                float var10_15 = skeletonInput.readFloat();
                float var11_22 = skeletonInput.readFloat();
                float var12_29 = skeletonInput.readFloat();
                int var13_35 = bl ? skeletonInput.readInt() : 0;
                PointAttachment var14_41 = this.attachmentLoader.newPointAttachment(skin, string2);
                if (var14_41 == null) {
                    yield null;
                }
                var14_41.setX(var11_22 * f);
                var14_41.setY(var12_29 * f);
                var14_41.setRotation(var10_15);
                if (bl) {
                    Color.rgba8888ToColor(var14_41.getColor(), var13_35);
                }
                yield var14_41;
            }
            case AttachmentType.clipping -> {
                int var10_16 = skeletonInput.readInt(true);
                Vertices var11_23 = this.readVertices(skeletonInput, (by & 0x10) != 0);
                int var12_30 = bl ? skeletonInput.readInt() : 0;
                ClippingAttachment var13_36 = this.attachmentLoader.newClippingAttachment(skin, string2);
                if (var13_36 == null) {
                    yield null;
                }
                var13_36.setEndSlot(((SlotData[])skeletonData.slots.items)[var10_16]);
                var13_36.setWorldVerticesLength(var11_23.length);
                var13_36.setVertices(var11_23.vertices);
                var13_36.setBones(var11_23.bones);
                if (bl) {
                    Color.rgba8888ToColor(var13_36.getColor(), var12_30);
                }
                yield var13_36;
            }
            default -> null;
        };
    }

    private Sequence readSequence(SkeletonInput skeletonInput) throws IOException {
        Sequence sequence = new Sequence(skeletonInput.readInt(true));
        sequence.setStart(skeletonInput.readInt(true));
        sequence.setDigits(skeletonInput.readInt(true));
        sequence.setSetupIndex(skeletonInput.readInt(true));
        return sequence;
    }

    private Vertices readVertices(SkeletonInput skeletonInput, boolean bl) throws IOException {
        float f = this.scale;
        int n = skeletonInput.readInt(true);
        Vertices vertices = new Vertices();
        vertices.length = n << 1;
        if (!bl) {
            vertices.vertices = this.readFloatArray(skeletonInput, vertices.length, f);
            return vertices;
        }
        FloatArray floatArray = new FloatArray(vertices.length * 3 * 3);
        IntArray intArray = new IntArray(vertices.length * 3);
        for (int i = 0; i < n; ++i) {
            int n2 = skeletonInput.readInt(true);
            intArray.add(n2);
            for (int j = 0; j < n2; ++j) {
                intArray.add(skeletonInput.readInt(true));
                floatArray.add(skeletonInput.readFloat() * f);
                floatArray.add(skeletonInput.readFloat() * f);
                floatArray.add(skeletonInput.readFloat());
            }
        }
        vertices.vertices = floatArray.toArray();
        vertices.bones = intArray.toArray();
        return vertices;
    }

    private float[] readFloatArray(SkeletonInput skeletonInput, int n, float f) throws IOException {
        float[] fArray = new float[n];
        if (f == 1.0f) {
            for (int i = 0; i < n; ++i) {
                fArray[i] = skeletonInput.readFloat();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                fArray[i] = skeletonInput.readFloat() * f;
            }
        }
        return fArray;
    }

    private short[] readShortArray(SkeletonInput skeletonInput, int n) throws IOException {
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)skeletonInput.readInt(true);
        }
        return sArray;
    }

    private Animation readAnimation(SkeletonInput skeletonInput, String string, SkeletonData skeletonData) throws IOException {
        int n;
        float f;
        float f2;
        float f3;
        float f4;
        int n2;
        byte by;
        int n3;
        int n4;
        int n5;
        int n6;
        Array<Animation.Timeline> array = new Array<Animation.Timeline>(true, skeletonInput.readInt(true), Animation.Timeline[]::new);
        float f5 = this.scale;
        int n7 = skeletonInput.readInt(true);
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = skeletonInput.readInt(true);
            n4 = skeletonInput.readInt(true);
            block75: for (n3 = 0; n3 < n4; ++n3) {
                by = skeletonInput.readByte();
                n2 = skeletonInput.readInt(true);
                int n8 = n2 - 1;
                switch (by) {
                    case 0: {
                        Animation.Timeline timeline = new Animation.AttachmentTimeline(n2, n5);
                        for (int i = 0; i < n2; ++i) {
                            ((Animation.AttachmentTimeline)timeline).setFrame(i, skeletonInput.readFloat(), skeletonInput.readStringRef());
                        }
                        array.add(timeline);
                        continue block75;
                    }
                    case 1: {
                        Animation.Timeline timeline = new Animation.RGBATimeline(n2, skeletonInput.readInt(true), n5);
                        float f6 = skeletonInput.readFloat();
                        float f7 = (float)skeletonInput.read() / 255.0f;
                        float f8 = (float)skeletonInput.read() / 255.0f;
                        float f9 = (float)skeletonInput.read() / 255.0f;
                        f4 = (float)skeletonInput.read() / 255.0f;
                        int n9 = 0;
                        int n10 = 0;
                        while (true) {
                            ((Animation.RGBATimeline)timeline).setFrame(n9, f6, f7, f8, f9, f4);
                            if (n9 == n8) break;
                            float f10 = skeletonInput.readFloat();
                            float f11 = (float)skeletonInput.read() / 255.0f;
                            float f12 = (float)skeletonInput.read() / 255.0f;
                            f3 = (float)skeletonInput.read() / 255.0f;
                            f2 = (float)skeletonInput.read() / 255.0f;
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(n9);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n10++, n9, 0, f6, f10, f7, f11, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n10++, n9, 1, f6, f10, f8, f12, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n10++, n9, 2, f6, f10, f9, f3, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n10++, n9, 3, f6, f10, f4, f2, 1.0f);
                                }
                            }
                            f6 = f10;
                            f7 = f11;
                            f8 = f12;
                            f9 = f3;
                            f4 = f2;
                            ++n9;
                        }
                        array.add(timeline);
                        continue block75;
                    }
                    case 2: {
                        Animation.Timeline timeline = new Animation.RGBTimeline(n2, skeletonInput.readInt(true), n5);
                        float f13 = skeletonInput.readFloat();
                        float f7 = (float)skeletonInput.read() / 255.0f;
                        float f14 = (float)skeletonInput.read() / 255.0f;
                        float f15 = (float)skeletonInput.read() / 255.0f;
                        int n11 = 0;
                        int n12 = 0;
                        while (true) {
                            ((Animation.RGBTimeline)timeline).setFrame(n11, f13, f7, f14, f15);
                            if (n11 == n8) break;
                            float f16 = skeletonInput.readFloat();
                            float f17 = (float)skeletonInput.read() / 255.0f;
                            float f18 = (float)skeletonInput.read() / 255.0f;
                            float f19 = (float)skeletonInput.read() / 255.0f;
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(n11);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n12++, n11, 0, f13, f16, f7, f17, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n12++, n11, 1, f13, f16, f14, f18, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n12++, n11, 2, f13, f16, f15, f19, 1.0f);
                                }
                            }
                            f13 = f16;
                            f7 = f17;
                            f14 = f18;
                            f15 = f19;
                            ++n11;
                        }
                        array.add(timeline);
                        continue block75;
                    }
                    case 3: {
                        float f20;
                        float f21;
                        float f22;
                        Animation.Timeline timeline = new Animation.RGBA2Timeline(n2, skeletonInput.readInt(true), n5);
                        float f23 = skeletonInput.readFloat();
                        float f7 = (float)skeletonInput.read() / 255.0f;
                        float f24 = (float)skeletonInput.read() / 255.0f;
                        float f25 = (float)skeletonInput.read() / 255.0f;
                        f4 = (float)skeletonInput.read() / 255.0f;
                        float f26 = (float)skeletonInput.read() / 255.0f;
                        float f27 = (float)skeletonInput.read() / 255.0f;
                        float f28 = (float)skeletonInput.read() / 255.0f;
                        int n13 = 0;
                        int n14 = 0;
                        while (true) {
                            ((Animation.RGBA2Timeline)timeline).setFrame(n13, f23, f7, f24, f25, f4, f26, f27, f28);
                            if (n13 == n8) break;
                            f3 = skeletonInput.readFloat();
                            f2 = (float)skeletonInput.read() / 255.0f;
                            f = (float)skeletonInput.read() / 255.0f;
                            f22 = (float)skeletonInput.read() / 255.0f;
                            f21 = (float)skeletonInput.read() / 255.0f;
                            f20 = (float)skeletonInput.read() / 255.0f;
                            float f29 = (float)skeletonInput.read() / 255.0f;
                            float f30 = (float)skeletonInput.read() / 255.0f;
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(n13);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n13, 0, f23, f3, f7, f2, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n13, 1, f23, f3, f24, f, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n13, 2, f23, f3, f25, f22, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n13, 3, f23, f3, f4, f21, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n13, 4, f23, f3, f26, f20, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n13, 5, f23, f3, f27, f29, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n14++, n13, 6, f23, f3, f28, f30, 1.0f);
                                }
                            }
                            f23 = f3;
                            f7 = f2;
                            f24 = f;
                            f25 = f22;
                            f4 = f21;
                            f26 = f20;
                            f27 = f29;
                            f28 = f30;
                            ++n13;
                        }
                        array.add(timeline);
                        continue block75;
                    }
                    case 4: {
                        float f20;
                        float f21;
                        float f22;
                        Animation.Timeline timeline = new Animation.RGB2Timeline(n2, skeletonInput.readInt(true), n5);
                        float f31 = skeletonInput.readFloat();
                        float f7 = (float)skeletonInput.read() / 255.0f;
                        float f32 = (float)skeletonInput.read() / 255.0f;
                        float f33 = (float)skeletonInput.read() / 255.0f;
                        f4 = (float)skeletonInput.read() / 255.0f;
                        float f34 = (float)skeletonInput.read() / 255.0f;
                        float f35 = (float)skeletonInput.read() / 255.0f;
                        int n15 = 0;
                        int n13 = 0;
                        while (true) {
                            ((Animation.RGB2Timeline)timeline).setFrame(n15, f31, f7, f32, f33, f4, f34, f35);
                            if (n15 == n8) break;
                            float f36 = skeletonInput.readFloat();
                            f3 = (float)skeletonInput.read() / 255.0f;
                            f2 = (float)skeletonInput.read() / 255.0f;
                            f = (float)skeletonInput.read() / 255.0f;
                            f22 = (float)skeletonInput.read() / 255.0f;
                            f21 = (float)skeletonInput.read() / 255.0f;
                            f20 = (float)skeletonInput.read() / 255.0f;
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(n15);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n13++, n15, 0, f31, f36, f7, f3, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n13++, n15, 1, f31, f36, f32, f2, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n13++, n15, 2, f31, f36, f33, f, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n13++, n15, 3, f31, f36, f4, f22, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n13++, n15, 4, f31, f36, f34, f21, 1.0f);
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n13++, n15, 5, f31, f36, f35, f20, 1.0f);
                                }
                            }
                            f31 = f36;
                            f7 = f3;
                            f32 = f2;
                            f33 = f;
                            f4 = f22;
                            f34 = f21;
                            f35 = f20;
                            ++n15;
                        }
                        array.add(timeline);
                        continue block75;
                    }
                    case 5: {
                        Animation.Timeline timeline = new Animation.AlphaTimeline(n2, skeletonInput.readInt(true), n5);
                        float f37 = skeletonInput.readFloat();
                        float f7 = (float)skeletonInput.read() / 255.0f;
                        int n16 = 0;
                        int n17 = 0;
                        while (true) {
                            ((Animation.CurveTimeline1)timeline).setFrame(n16, f37, f7);
                            if (n16 == n8) break;
                            f4 = skeletonInput.readFloat();
                            float f38 = (float)skeletonInput.read() / 255.0f;
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    ((Animation.CurveTimeline)timeline).setStepped(n16);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, (Animation.CurveTimeline)timeline, n17++, n16, 0, f37, f4, f7, f38, 1.0f);
                                }
                            }
                            f37 = f4;
                            f7 = f38;
                            ++n16;
                        }
                        array.add(timeline);
                    }
                }
            }
        }
        n7 = skeletonInput.readInt(true);
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = skeletonInput.readInt(true);
            n4 = skeletonInput.readInt(true);
            block83: for (n3 = 0; n3 < n4; ++n3) {
                by = skeletonInput.readByte();
                n2 = skeletonInput.readInt(true);
                if (by == 10) {
                    Animation.InheritTimeline inheritTimeline = new Animation.InheritTimeline(n2, n5);
                    for (int i = 0; i < n2; ++i) {
                        inheritTimeline.setFrame(i, skeletonInput.readFloat(), BoneData.Inherit.values[skeletonInput.readByte()]);
                    }
                    array.add(inheritTimeline);
                    continue;
                }
                int n18 = skeletonInput.readInt(true);
                switch (by) {
                    case 0: {
                        this.readTimeline(skeletonInput, array, new Animation.RotateTimeline(n2, n18, n5), 1.0f);
                        continue block83;
                    }
                    case 1: {
                        this.readTimeline(skeletonInput, array, new Animation.TranslateTimeline(n2, n18, n5), f5);
                        continue block83;
                    }
                    case 2: {
                        this.readTimeline(skeletonInput, array, new Animation.TranslateXTimeline(n2, n18, n5), f5);
                        continue block83;
                    }
                    case 3: {
                        this.readTimeline(skeletonInput, array, new Animation.TranslateYTimeline(n2, n18, n5), f5);
                        continue block83;
                    }
                    case 4: {
                        this.readTimeline(skeletonInput, array, new Animation.ScaleTimeline(n2, n18, n5), 1.0f);
                        continue block83;
                    }
                    case 5: {
                        this.readTimeline(skeletonInput, array, new Animation.ScaleXTimeline(n2, n18, n5), 1.0f);
                        continue block83;
                    }
                    case 6: {
                        this.readTimeline(skeletonInput, array, new Animation.ScaleYTimeline(n2, n18, n5), 1.0f);
                        continue block83;
                    }
                    case 7: {
                        this.readTimeline(skeletonInput, array, new Animation.ShearTimeline(n2, n18, n5), 1.0f);
                        continue block83;
                    }
                    case 8: {
                        this.readTimeline(skeletonInput, array, new Animation.ShearXTimeline(n2, n18, n5), 1.0f);
                        continue block83;
                    }
                    case 9: {
                        this.readTimeline(skeletonInput, array, new Animation.ShearYTimeline(n2, n18, n5), 1.0f);
                    }
                }
            }
        }
        n7 = skeletonInput.readInt(true);
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = skeletonInput.readInt(true);
            n3 = skeletonInput.readInt(true);
            n4 = n3 - 1;
            Animation.IkConstraintTimeline ikConstraintTimeline = new Animation.IkConstraintTimeline(n3, skeletonInput.readInt(true), n5);
            n2 = skeletonInput.read();
            float f39 = skeletonInput.readFloat();
            float f40 = (n2 & 1) != 0 ? ((n2 & 2) != 0 ? skeletonInput.readFloat() : 1.0f) : 0.0f;
            float f41 = (n2 & 4) != 0 ? skeletonInput.readFloat() * f5 : 0.0f;
            int n19 = 0;
            int n20 = 0;
            while (true) {
                float f42;
                ikConstraintTimeline.setFrame(n19, f39, f40, f41, (n2 & 8) != 0 ? 1 : -1, (n2 & 0x10) != 0, (n2 & 0x20) != 0);
                if (n19 == n4) break;
                n2 = skeletonInput.read();
                float f43 = skeletonInput.readFloat();
                f4 = (n2 & 1) != 0 ? ((n2 & 2) != 0 ? skeletonInput.readFloat() : 1.0f) : 0.0f;
                float f44 = f42 = (n2 & 4) != 0 ? skeletonInput.readFloat() * f5 : 0.0f;
                if ((n2 & 0x40) != 0) {
                    ikConstraintTimeline.setStepped(n19);
                } else if ((n2 & 0x80) != 0) {
                    this.setBezier(skeletonInput, ikConstraintTimeline, n20++, n19, 0, f39, f43, f40, f4, 1.0f);
                    this.setBezier(skeletonInput, ikConstraintTimeline, n20++, n19, 1, f39, f43, f41, f42, f5);
                }
                f39 = f43;
                f40 = f4;
                f41 = f42;
                ++n19;
            }
            array.add(ikConstraintTimeline);
        }
        n7 = skeletonInput.readInt(true);
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = skeletonInput.readInt(true);
            n3 = skeletonInput.readInt(true);
            n4 = n3 - 1;
            Animation.TransformConstraintTimeline transformConstraintTimeline = new Animation.TransformConstraintTimeline(n3, skeletonInput.readInt(true), n5);
            float f45 = skeletonInput.readFloat();
            float f46 = skeletonInput.readFloat();
            float f47 = skeletonInput.readFloat();
            float f48 = skeletonInput.readFloat();
            float f49 = skeletonInput.readFloat();
            float f50 = skeletonInput.readFloat();
            float f51 = skeletonInput.readFloat();
            int n21 = 0;
            int n22 = 0;
            while (true) {
                transformConstraintTimeline.setFrame(n21, f45, f46, f47, f48, f49, f50, f51);
                if (n21 == n4) break;
                float f52 = skeletonInput.readFloat();
                float f53 = skeletonInput.readFloat();
                float f54 = skeletonInput.readFloat();
                float f55 = skeletonInput.readFloat();
                f3 = skeletonInput.readFloat();
                f2 = skeletonInput.readFloat();
                f = skeletonInput.readFloat();
                switch (skeletonInput.readByte()) {
                    case 1: {
                        transformConstraintTimeline.setStepped(n21);
                        break;
                    }
                    case 2: {
                        this.setBezier(skeletonInput, transformConstraintTimeline, n22++, n21, 0, f45, f52, f46, f53, 1.0f);
                        this.setBezier(skeletonInput, transformConstraintTimeline, n22++, n21, 1, f45, f52, f47, f54, 1.0f);
                        this.setBezier(skeletonInput, transformConstraintTimeline, n22++, n21, 2, f45, f52, f48, f55, 1.0f);
                        this.setBezier(skeletonInput, transformConstraintTimeline, n22++, n21, 3, f45, f52, f49, f3, 1.0f);
                        this.setBezier(skeletonInput, transformConstraintTimeline, n22++, n21, 4, f45, f52, f50, f2, 1.0f);
                        this.setBezier(skeletonInput, transformConstraintTimeline, n22++, n21, 5, f45, f52, f51, f, 1.0f);
                    }
                }
                f45 = f52;
                f46 = f53;
                f47 = f54;
                f48 = f55;
                f49 = f3;
                f50 = f2;
                f51 = f;
                ++n21;
            }
            array.add(transformConstraintTimeline);
        }
        n7 = skeletonInput.readInt(true);
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = skeletonInput.readInt(true);
            PathConstraintData pathConstraintData = (PathConstraintData)((ConstraintData[])skeletonData.constraints.items)[n5];
            int n23 = skeletonInput.readInt(true);
            block90: for (n4 = 0; n4 < n23; ++n4) {
                byte by2 = skeletonInput.readByte();
                int n24 = skeletonInput.readInt(true);
                int n25 = skeletonInput.readInt(true);
                switch (by2) {
                    case 0: {
                        this.readTimeline(skeletonInput, array, new Animation.PathConstraintPositionTimeline(n24, n25, n5), pathConstraintData.positionMode == PathConstraintData.PositionMode.fixed ? f5 : 1.0f);
                        continue block90;
                    }
                    case 1: {
                        this.readTimeline(skeletonInput, array, new Animation.PathConstraintSpacingTimeline(n24, n25, n5), pathConstraintData.spacingMode == PathConstraintData.SpacingMode.length || pathConstraintData.spacingMode == PathConstraintData.SpacingMode.fixed ? f5 : 1.0f);
                        continue block90;
                    }
                    case 2: {
                        Animation.PathConstraintMixTimeline pathConstraintMixTimeline = new Animation.PathConstraintMixTimeline(n24, n25, n5);
                        float f56 = skeletonInput.readFloat();
                        float f57 = skeletonInput.readFloat();
                        float f58 = skeletonInput.readFloat();
                        float f59 = skeletonInput.readFloat();
                        int n26 = 0;
                        int n27 = 0;
                        int n28 = pathConstraintMixTimeline.getFrameCount() - 1;
                        while (true) {
                            pathConstraintMixTimeline.setFrame(n26, f56, f57, f58, f59);
                            if (n26 == n28) break;
                            float f60 = skeletonInput.readFloat();
                            float f61 = skeletonInput.readFloat();
                            f3 = skeletonInput.readFloat();
                            f2 = skeletonInput.readFloat();
                            switch (skeletonInput.readByte()) {
                                case 1: {
                                    pathConstraintMixTimeline.setStepped(n26);
                                    break;
                                }
                                case 2: {
                                    this.setBezier(skeletonInput, pathConstraintMixTimeline, n27++, n26, 0, f56, f60, f57, f61, 1.0f);
                                    this.setBezier(skeletonInput, pathConstraintMixTimeline, n27++, n26, 1, f56, f60, f58, f3, 1.0f);
                                    this.setBezier(skeletonInput, pathConstraintMixTimeline, n27++, n26, 2, f56, f60, f59, f2, 1.0f);
                                }
                            }
                            f56 = f60;
                            f57 = f61;
                            f58 = f3;
                            f59 = f2;
                            ++n26;
                        }
                        array.add(pathConstraintMixTimeline);
                    }
                }
            }
        }
        n7 = skeletonInput.readInt(true);
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = skeletonInput.readInt(true) - 1;
            n4 = skeletonInput.readInt(true);
            for (int i = 0; i < n4; ++i) {
                byte by3 = skeletonInput.readByte();
                int n29 = skeletonInput.readInt(true);
                if (by3 == 8) {
                    Animation.PhysicsConstraintResetTimeline physicsConstraintResetTimeline = new Animation.PhysicsConstraintResetTimeline(n29, n5);
                    for (int j = 0; j < n29; ++j) {
                        physicsConstraintResetTimeline.setFrame(j, skeletonInput.readFloat());
                    }
                    array.add(physicsConstraintResetTimeline);
                    continue;
                }
                int n30 = skeletonInput.readInt(true);
                this.readTimeline(skeletonInput, array, switch (by3) {
                    case 0 -> new Animation.PhysicsConstraintInertiaTimeline(n29, n30, n5);
                    case 1 -> new Animation.PhysicsConstraintStrengthTimeline(n29, n30, n5);
                    case 2 -> new Animation.PhysicsConstraintDampingTimeline(n29, n30, n5);
                    case 4 -> new Animation.PhysicsConstraintMassTimeline(n29, n30, n5);
                    case 5 -> new Animation.PhysicsConstraintWindTimeline(n29, n30, n5);
                    case 6 -> new Animation.PhysicsConstraintGravityTimeline(n29, n30, n5);
                    case 7 -> new Animation.PhysicsConstraintMixTimeline(n29, n30, n5);
                    default -> throw new SerializationException();
                }, 1.0f);
            }
        }
        n7 = skeletonInput.readInt(true);
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = skeletonInput.readInt(true);
            n4 = skeletonInput.readInt(true);
            for (int i = 0; i < n4; ++i) {
                byte by4 = skeletonInput.readByte();
                int n31 = skeletonInput.readInt(true);
                int n32 = skeletonInput.readInt(true);
                this.readTimeline(skeletonInput, array, switch (by4) {
                    case 0 -> new Animation.SliderTimeline(n31, n32, n5);
                    case 1 -> new Animation.SliderMixTimeline(n31, n32, n5);
                    default -> throw new SerializationException();
                }, 1.0f);
            }
        }
        n7 = skeletonInput.readInt(true);
        for (n6 = 0; n6 < n7; ++n6) {
            Skin skin = ((Skin[])skeletonData.skins.items)[skeletonInput.readInt(true)];
            n4 = skeletonInput.readInt(true);
            for (int i = 0; i < n4; ++i) {
                int n33 = skeletonInput.readInt(true);
                int n34 = skeletonInput.readInt(true);
                block99: for (int j = 0; j < n34; ++j) {
                    String string2 = skeletonInput.readStringRef();
                    Attachment attachment = skin.getAttachment(n33, string2);
                    if (attachment == null) {
                        throw new SerializationException("Timeline attachment not found: " + string2);
                    }
                    byte by5 = skeletonInput.readByte();
                    int n35 = skeletonInput.readInt(true);
                    int n36 = n35 - 1;
                    switch (by5) {
                        case 0: {
                            Object object = (VertexAttachment)attachment;
                            int n37 = ((VertexAttachment)object).getBones() != null ? 1 : 0;
                            float[] fArray = ((VertexAttachment)object).getVertices();
                            int n38 = n37 != 0 ? fArray.length / 3 << 1 : fArray.length;
                            Animation.DeformTimeline deformTimeline = new Animation.DeformTimeline(n35, skeletonInput.readInt(true), n33, (VertexAttachment)object);
                            float f62 = skeletonInput.readFloat();
                            int n39 = 0;
                            int n40 = 0;
                            while (true) {
                                float[] fArray2;
                                int n41;
                                if ((n41 = skeletonInput.readInt(true)) == 0) {
                                    fArray2 = n37 != 0 ? new float[n38] : fArray;
                                } else {
                                    int n42;
                                    fArray2 = new float[n38];
                                    int n43 = skeletonInput.readInt(true);
                                    n41 += n43;
                                    if (f5 == 1.0f) {
                                        for (n42 = n43; n42 < n41; ++n42) {
                                            fArray2[n42] = skeletonInput.readFloat();
                                        }
                                    } else {
                                        for (n42 = n43; n42 < n41; ++n42) {
                                            fArray2[n42] = skeletonInput.readFloat() * f5;
                                        }
                                    }
                                    if (n37 == 0) {
                                        int n44 = fArray2.length;
                                        for (n42 = 0; n42 < n44; ++n42) {
                                            int n45 = n42;
                                            fArray2[n45] = fArray2[n45] + fArray[n42];
                                        }
                                    }
                                }
                                deformTimeline.setFrame(n39, f62, fArray2);
                                if (n39 == n36) break;
                                float f63 = skeletonInput.readFloat();
                                switch (skeletonInput.readByte()) {
                                    case 1: {
                                        deformTimeline.setStepped(n39);
                                        break;
                                    }
                                    case 2: {
                                        this.setBezier(skeletonInput, deformTimeline, n40++, n39, 0, f62, f63, 0.0f, 1.0f, 1.0f);
                                    }
                                }
                                f62 = f63;
                                ++n39;
                            }
                            array.add(deformTimeline);
                            continue block99;
                        }
                        case 1: {
                            int n38;
                            int n37;
                            Object object = new Animation.SequenceTimeline(n35, n33, attachment);
                            for (n37 = 0; n37 < n35; ++n37) {
                                float f64 = skeletonInput.readFloat();
                                n38 = skeletonInput.readInt();
                                ((Animation.SequenceTimeline)object).setFrame(n37, f64, Sequence.SequenceMode.values[n38 & 0xF], n38 >> 4, skeletonInput.readFloat());
                            }
                            array.add((Animation.Timeline)object);
                        }
                    }
                }
            }
        }
        n6 = skeletonInput.readInt(true);
        if (n6 > 0) {
            Animation.DrawOrderTimeline drawOrderTimeline = new Animation.DrawOrderTimeline(n6);
            int n46 = skeletonData.slots.size;
            for (int i = 0; i < n6; ++i) {
                int n47;
                float f65 = skeletonInput.readFloat();
                int n48 = skeletonInput.readInt(true);
                int[] nArray = new int[n46];
                for (int j = n46 - 1; j >= 0; --j) {
                    nArray[j] = -1;
                }
                int[] nArray2 = new int[n46 - n48];
                int n49 = 0;
                int n50 = 0;
                for (n47 = 0; n47 < n48; ++n47) {
                    int n51 = skeletonInput.readInt(true);
                    while (n49 != n51) {
                        nArray2[n50++] = n49++;
                    }
                    nArray[n49 + skeletonInput.readInt((boolean)true)] = n49++;
                }
                while (n49 < n46) {
                    nArray2[n50++] = n49++;
                }
                for (n47 = n46 - 1; n47 >= 0; --n47) {
                    if (nArray[n47] != -1) continue;
                    nArray[n47] = nArray2[--n50];
                }
                drawOrderTimeline.setFrame(i, f65, nArray);
            }
            array.add(drawOrderTimeline);
        }
        if ((n = skeletonInput.readInt(true)) > 0) {
            Animation.EventTimeline eventTimeline = new Animation.EventTimeline(n);
            for (int i = 0; i < n; ++i) {
                float f66 = skeletonInput.readFloat();
                EventData eventData = ((EventData[])skeletonData.events.items)[skeletonInput.readInt(true)];
                Event event = new Event(f66, eventData);
                event.intValue = skeletonInput.readInt(false);
                event.floatValue = skeletonInput.readFloat();
                event.stringValue = skeletonInput.readString();
                if (event.stringValue == null) {
                    event.stringValue = eventData.stringValue;
                }
                if (event.data.audioPath != null) {
                    event.volume = skeletonInput.readFloat();
                    event.balance = skeletonInput.readFloat();
                }
                eventTimeline.setFrame(i, event);
            }
            array.add(eventTimeline);
        }
        float f67 = 0.0f;
        Animation.Timeline[] timelineArray = (Animation.Timeline[])array.items;
        int n52 = array.size;
        for (int i = 0; i < n52; ++i) {
            f67 = Math.max(f67, timelineArray[i].getDuration());
        }
        return new Animation(string, array, f67);
    }

    private void readTimeline(SkeletonInput skeletonInput, Array<Animation.Timeline> array, Animation.CurveTimeline1 curveTimeline1, float f) throws IOException {
        float f2 = skeletonInput.readFloat();
        float f3 = skeletonInput.readFloat() * f;
        int n = 0;
        int n2 = 0;
        int n3 = curveTimeline1.getFrameCount() - 1;
        while (true) {
            curveTimeline1.setFrame(n, f2, f3);
            if (n == n3) break;
            float f4 = skeletonInput.readFloat();
            float f5 = skeletonInput.readFloat() * f;
            switch (skeletonInput.readByte()) {
                case 1: {
                    curveTimeline1.setStepped(n);
                    break;
                }
                case 2: {
                    this.setBezier(skeletonInput, curveTimeline1, n2++, n, 0, f2, f4, f3, f5, f);
                }
            }
            f2 = f4;
            f3 = f5;
            ++n;
        }
        array.add(curveTimeline1);
    }

    private void readTimeline(SkeletonInput skeletonInput, Array<Animation.Timeline> array, Animation.BoneTimeline2 boneTimeline2, float f) throws IOException {
        float f2 = skeletonInput.readFloat();
        float f3 = skeletonInput.readFloat() * f;
        float f4 = skeletonInput.readFloat() * f;
        int n = 0;
        int n2 = 0;
        int n3 = boneTimeline2.getFrameCount() - 1;
        while (true) {
            boneTimeline2.setFrame(n, f2, f3, f4);
            if (n == n3) break;
            float f5 = skeletonInput.readFloat();
            float f6 = skeletonInput.readFloat() * f;
            float f7 = skeletonInput.readFloat() * f;
            switch (skeletonInput.readByte()) {
                case 1: {
                    boneTimeline2.setStepped(n);
                    break;
                }
                case 2: {
                    this.setBezier(skeletonInput, boneTimeline2, n2++, n, 0, f2, f5, f3, f6, f);
                    this.setBezier(skeletonInput, boneTimeline2, n2++, n, 1, f2, f5, f4, f7, f);
                }
            }
            f2 = f5;
            f3 = f6;
            f4 = f7;
            ++n;
        }
        array.add(boneTimeline2);
    }

    void setBezier(SkeletonInput skeletonInput, Animation.CurveTimeline curveTimeline, int n, int n2, int n3, float f, float f2, float f3, float f4, float f5) throws IOException {
        curveTimeline.setBezier(n, n2, n3, f, f3, skeletonInput.readFloat(), skeletonInput.readFloat() * f5, skeletonInput.readFloat(), skeletonInput.readFloat() * f5, f2, f4);
    }

    static class SkeletonInput
    extends DataInput {
        private char[] chars = new char[32];
        String[] strings;

        public SkeletonInput(InputStream inputStream) {
            super(inputStream);
        }

        public String readStringRef() throws IOException {
            int n = this.readInt(true);
            return n == 0 ? null : this.strings[n - 1];
        }

        @Override
        public String readString() throws IOException {
            int n = this.readInt(true);
            switch (n) {
                case 0: {
                    return null;
                }
                case 1: {
                    return "";
                }
            }
            if (this.chars.length < --n) {
                this.chars = new char[n];
            }
            char[] cArray = this.chars;
            int n2 = 0;
            int n3 = 0;
            block9: while (n3 < n) {
                int n4 = this.read();
                switch (n4 >> 4) {
                    case -1: {
                        throw new EOFException();
                    }
                    case 12: 
                    case 13: {
                        cArray[n2++] = (char)((n4 & 0x1F) << 6 | this.read() & 0x3F);
                        n3 += 2;
                        continue block9;
                    }
                    case 14: {
                        cArray[n2++] = (char)((n4 & 0xF) << 12 | (this.read() & 0x3F) << 6 | this.read() & 0x3F);
                        n3 += 3;
                        continue block9;
                    }
                }
                cArray[n2++] = (char)n4;
                ++n3;
            }
            return new String(cArray, 0, n2);
        }
    }

    static class LinkedMesh {
        String parent;
        int skinIndex;
        int slotIndex;
        MeshAttachment mesh;
        boolean inheritTimelines;

        public LinkedMesh(MeshAttachment meshAttachment, int n, int n2, String string, boolean bl) {
            this.mesh = meshAttachment;
            this.skinIndex = n;
            this.slotIndex = n2;
            this.parent = string;
            this.inheritTimelines = bl;
        }
    }

    static class Vertices {
        int length;
        int[] bones;
        float[] vertices;

        Vertices() {
        }
    }
}

