/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.esotericsoftware.spine.BonePose;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class PointAttachment
extends Attachment {
    float x;
    float y;
    float rotation;
    final Color color = new Color(0.9451f, 0.9451f, 0.0f, 1.0f);

    public PointAttachment(String string) {
        super(string);
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public void setRotation(float f) {
        this.rotation = f;
    }

    public Color getColor() {
        return this.color;
    }

    public Vector2 computeWorldPosition(BonePose bonePose, Vector2 vector2) {
        vector2.x = this.x * bonePose.getA() + this.y * bonePose.getB() + bonePose.getWorldX();
        vector2.y = this.x * bonePose.getC() + this.y * bonePose.getD() + bonePose.getWorldY();
        return vector2;
    }

    public float computeWorldRotation(BonePose bonePose) {
        float f = this.rotation * ((float)Math.PI / 180);
        float f2 = SpineUtils.cos(f);
        float f3 = SpineUtils.sin(f);
        float f4 = f2 * bonePose.getA() + f3 * bonePose.getB();
        float f5 = f2 * bonePose.getC() + f3 * bonePose.getD();
        return SpineUtils.atan2Deg(f5, f4);
    }
}

