/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;

public final class BufferUtils {
    private BufferUtils() {
    }

    public static ByteBuffer createByteBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
    }

    static int getAllocationSize(int elements, int elementShift) {
        APIUtil.apiCheckAllocation(elements, APIUtil.apiGetBytes(elements, elementShift), Integer.MAX_VALUE);
        return elements << elementShift;
    }

    public static IntBuffer createIntBuffer(int capacity) {
        return BufferUtils.createByteBuffer(BufferUtils.getAllocationSize(capacity, 2)).asIntBuffer();
    }

    public static FloatBuffer createFloatBuffer(int capacity) {
        return BufferUtils.createByteBuffer(BufferUtils.getAllocationSize(capacity, 2)).asFloatBuffer();
    }

    public static PointerBuffer createPointerBuffer(int capacity) {
        return PointerBuffer.allocateDirect(capacity);
    }
}

